% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_list_trials}
\alias{sagemaker_list_trials}
\title{Lists the trials in your account}
\usage{
sagemaker_list_trials(ExperimentName, TrialComponentName, CreatedAfter,
  CreatedBefore, SortBy, SortOrder, MaxResults, NextToken)
}
\arguments{
\item{ExperimentName}{A filter that returns only trials that are part of the specified
experiment.}

\item{TrialComponentName}{A filter that returns only trials that are associated with the specified
trial component.}

\item{CreatedAfter}{A filter that returns only trials created after the specified time.}

\item{CreatedBefore}{A filter that returns only trials created before the specified time.}

\item{SortBy}{The property used to sort results. The default value is \code{CreationTime}.}

\item{SortOrder}{The sort order. The default value is \code{Descending}.}

\item{MaxResults}{The maximum number of trials to return in the response. The default
value is 10.}

\item{NextToken}{If the previous call to \code{\link[=sagemaker_list_trials]{list_trials}} didn't
return the full set of trials, the call returns a token for getting the
next set of trials.}
}
\value{
A list with the following syntax:\preformatted{list(
  TrialSummaries = list(
    list(
      TrialArn = "string",
      TrialName = "string",
      DisplayName = "string",
      TrialSource = list(
        SourceArn = "string",
        SourceType = "string"
      ),
      CreationTime = as.POSIXct(
        "2015-01-01"
      ),
      LastModifiedTime = as.POSIXct(
        "2015-01-01"
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
Lists the trials in your account. Specify an experiment name to limit
the list to the trials that are part of that experiment. Specify a trial
component name to limit the list to the trials that associated with that
trial component. The list can be filtered to show only trials that were
created in a specific time range. The list can be sorted by trial name
or creation time.
}
\section{Request syntax}{
\preformatted{svc$list_trials(
  ExperimentName = "string",
  TrialComponentName = "string",
  CreatedAfter = as.POSIXct(
    "2015-01-01"
  ),
  CreatedBefore = as.POSIXct(
    "2015-01-01"
  ),
  SortBy = "Name"|"CreationTime",
  SortOrder = "Ascending"|"Descending",
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
