% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comprehendmedical_operations.R
\name{comprehendmedical_describe_icd10cm_inference_job}
\alias{comprehendmedical_describe_icd10cm_inference_job}
\title{Gets the properties associated with an InferICD10CM job}
\usage{
comprehendmedical_describe_icd10cm_inference_job(JobId)
}
\arguments{
\item{JobId}{[required] The identifier that Amazon Comprehend Medical generated for the job.
\verb{The StartICD10CMInferenceJob} operation returns this identifier in its
response.}
}
\value{
A list with the following syntax:\preformatted{list(
  ComprehendMedicalAsyncJobProperties = list(
    JobId = "string",
    JobName = "string",
    JobStatus = "SUBMITTED"|"IN_PROGRESS"|"COMPLETED"|"PARTIAL_SUCCESS"|"FAILED"|"STOP_REQUESTED"|"STOPPED",
    Message = "string",
    SubmitTime = as.POSIXct(
      "2015-01-01"
    ),
    EndTime = as.POSIXct(
      "2015-01-01"
    ),
    ExpirationTime = as.POSIXct(
      "2015-01-01"
    ),
    InputDataConfig = list(
      S3Bucket = "string",
      S3Key = "string"
    ),
    OutputDataConfig = list(
      S3Bucket = "string",
      S3Key = "string"
    ),
    LanguageCode = "en",
    DataAccessRoleArn = "string",
    ManifestFilePath = "string",
    KMSKey = "string",
    ModelVersion = "string"
  )
)
}
}
\description{
Gets the properties associated with an InferICD10CM job. Use this
operation to get the status of an inference job.
}
\section{Request syntax}{
\preformatted{svc$describe_icd10cm_inference_job(
  JobId = "string"
)
}
}

\keyword{internal}
