% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_create_pipeline}
\alias{sagemaker_create_pipeline}
\title{Creates a pipeline using a JSON pipeline definition}
\usage{
sagemaker_create_pipeline(PipelineName, PipelineDisplayName,
  PipelineDefinition, PipelineDescription, ClientRequestToken, RoleArn,
  Tags)
}
\arguments{
\item{PipelineName}{[required] The name of the pipeline.}

\item{PipelineDisplayName}{The display name of the pipeline.}

\item{PipelineDefinition}{[required] The JSON pipeline definition of the pipeline.}

\item{PipelineDescription}{A description of the pipeline.}

\item{ClientRequestToken}{[required] A unique, case-sensitive identifier that you provide to ensure the
idempotency of the operation. An idempotent operation completes no more
than one time.}

\item{RoleArn}{[required] The Amazon Resource Name (ARN) of the role used by the pipeline to
access and create resources.}

\item{Tags}{A list of tags to apply to the created pipeline.}
}
\description{
Creates a pipeline using a JSON pipeline definition.
}
\section{Request syntax}{
\preformatted{svc$create_pipeline(
  PipelineName = "string",
  PipelineDisplayName = "string",
  PipelineDefinition = "string",
  PipelineDescription = "string",
  ClientRequestToken = "string",
  RoleArn = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
