% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workmail_operations.R
\name{workmail_register_to_work_mail}
\alias{workmail_register_to_work_mail}
\title{Registers an existing and disabled user, group, or resource for WorkMail
use by associating a mailbox and calendaring capabilities}
\usage{
workmail_register_to_work_mail(OrganizationId, EntityId, Email)
}
\arguments{
\item{OrganizationId}{[required] The identifier for the organization under which the user, group, or
resource exists.}

\item{EntityId}{[required] The identifier for the user, group, or resource to be updated.

The identifier can accept \emph{UserId, ResourceId, or GroupId}, or
\emph{Username, Resourcename, or Groupname}. The following identity formats
are available:
\itemize{
\item Entity ID: 12345678-1234-1234-1234-123456789012,
r-0123456789a0123456789b0123456789, or
S-1-1-12-1234567890-123456789-123456789-1234
\item Entity name: entity
}}

\item{Email}{[required] The email for the user, group, or resource to be updated.}
}
\description{
Registers an existing and disabled user, group, or resource for WorkMail use by associating a mailbox and calendaring capabilities. It performs no change if the user, group, or resource is enabled and fails if the user, group, or resource is deleted. This operation results in the accumulation of costs. For more information, see \href{https://aws.amazon.com/workmail/pricing/}{Pricing}. The equivalent console functionality for this operation is \emph{Enable}.

See \url{https://www.paws-r-sdk.com/docs/workmail_register_to_work_mail/} for full documentation.
}
\keyword{internal}
