% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workdocs_operations.R
\name{workdocs_create_comment}
\alias{workdocs_create_comment}
\title{Adds a new comment to the specified document version}
\usage{
workdocs_create_comment(
  AuthenticationToken = NULL,
  DocumentId,
  VersionId,
  ParentId = NULL,
  ThreadId = NULL,
  Text,
  Visibility = NULL,
  NotifyCollaborators = NULL
)
}
\arguments{
\item{AuthenticationToken}{Amazon WorkDocs authentication token. Not required when using AWS
administrator credentials to access the API.}

\item{DocumentId}{[required] The ID of the document.}

\item{VersionId}{[required] The ID of the document version.}

\item{ParentId}{The ID of the parent comment.}

\item{ThreadId}{The ID of the root comment in the thread.}

\item{Text}{[required] The text of the comment.}

\item{Visibility}{The visibility of the comment. Options are either PRIVATE, where the
comment is visible only to the comment author and document owner and
co-owners, or PUBLIC, where the comment is visible to document owners,
co-owners, and contributors.}

\item{NotifyCollaborators}{Set this parameter to TRUE to send an email out to the document
collaborators after the comment is created.}
}
\description{
Adds a new comment to the specified document version.

See \url{https://paws-r.github.io/docs/workdocs/create_comment.html} for full documentation.
}
\keyword{internal}
