# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include ivschat_service.R
NULL

#' Creates an encrypted token that is used to establish an individual
#' WebSocket connection to a room
#'
#' @description
#' Creates an encrypted token that is used to establish an individual WebSocket connection to a room. The token is valid for one minute, and a connection (session) established with the token is valid for the specified duration.
#'
#' See [https://paws-r.github.io/docs/ivschat/create_chat_token.html](https://paws-r.github.io/docs/ivschat/create_chat_token.html) for full documentation.
#'
#' @param attributes Application-provided attributes to encode into the token and attach to a
#' chat session. Map keys and values can contain UTF-8 encoded text. The
#' maximum length of this field is 1 KB total.
#' @param capabilities Set of capabilities that the user is allowed to perform in the room.
#' Default: None (the capability to view messages is implicitly included in
#' all requests).
#' @param roomIdentifier &#91;required&#93; Identifier of the room that the client is trying to access. Currently
#' this must be an ARN.
#' @param sessionDurationInMinutes Session duration (in minutes), after which the session expires. Default:
#' 60 (1 hour).
#' @param userId &#91;required&#93; Application-provided ID that uniquely identifies the user associated
#' with this token. This can be any UTF-8 encoded text.
#'
#' @keywords internal
#'
#' @rdname ivschat_create_chat_token
ivschat_create_chat_token <- function(attributes = NULL, capabilities = NULL, roomIdentifier, sessionDurationInMinutes = NULL, userId) {
  op <- new_operation(
    name = "CreateChatToken",
    http_method = "POST",
    http_path = "/CreateChatToken",
    paginator = list()
  )
  input <- .ivschat$create_chat_token_input(attributes = attributes, capabilities = capabilities, roomIdentifier = roomIdentifier, sessionDurationInMinutes = sessionDurationInMinutes, userId = userId)
  output <- .ivschat$create_chat_token_output()
  config <- get_config()
  svc <- .ivschat$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivschat$operations$create_chat_token <- ivschat_create_chat_token

#' Creates a room that allows clients to connect and pass messages
#'
#' @description
#' Creates a room that allows clients to connect and pass messages.
#'
#' See [https://paws-r.github.io/docs/ivschat/create_room.html](https://paws-r.github.io/docs/ivschat/create_room.html) for full documentation.
#'
#' @param maximumMessageLength Maximum number of characters in a single message. Messages are expected
#' to be UTF-8 encoded and this limit applies specifically to
#' rune/code-point count, not number of bytes. Default: 500.
#' @param maximumMessageRatePerSecond Maximum number of messages per second that can be sent to the room (by
#' all clients). Default: 10.
#' @param messageReviewHandler Configuration information for optional review of messages.
#' @param name Room name. The value does not need to be unique.
#' @param tags Tags to attach to the resource. Array of maps, each of the form
#' `string:string (key:value)`.
#'
#' @keywords internal
#'
#' @rdname ivschat_create_room
ivschat_create_room <- function(maximumMessageLength = NULL, maximumMessageRatePerSecond = NULL, messageReviewHandler = NULL, name = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateRoom",
    http_method = "POST",
    http_path = "/CreateRoom",
    paginator = list()
  )
  input <- .ivschat$create_room_input(maximumMessageLength = maximumMessageLength, maximumMessageRatePerSecond = maximumMessageRatePerSecond, messageReviewHandler = messageReviewHandler, name = name, tags = tags)
  output <- .ivschat$create_room_output()
  config <- get_config()
  svc <- .ivschat$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivschat$operations$create_room <- ivschat_create_room

#' Sends an event to a specific room which directs clients to delete a
#' specific message; that is, unrender it from view and delete it from the
#' client’s chat history
#'
#' @description
#' Sends an event to a specific room which directs clients to delete a specific message; that is, unrender it from view and delete it from the client’s chat history. This event’s `EventName` is `aws:DELETE_MESSAGE`. This replicates the [DeleteMessage](https://docs.aws.amazon.com/ivs/latest/chatmsgapireference/actions-deletemessage-publish.html) WebSocket operation in the Amazon IVS Chat Messaging API.
#'
#' See [https://paws-r.github.io/docs/ivschat/delete_message.html](https://paws-r.github.io/docs/ivschat/delete_message.html) for full documentation.
#'
#' @param id &#91;required&#93; ID of the message to be deleted. This is the `Id` field in the received
#' message (see [Message
#' (Subscribe)](https://docs.aws.amazon.com/ivs/latest/chatmsgapireference/actions-message-subscribe.html)
#' in the Chat Messaging API).
#' @param reason Reason for deleting the message.
#' @param roomIdentifier &#91;required&#93; Identifier of the room where the message should be deleted. Currently
#' this must be an ARN.
#'
#' @keywords internal
#'
#' @rdname ivschat_delete_message
ivschat_delete_message <- function(id, reason = NULL, roomIdentifier) {
  op <- new_operation(
    name = "DeleteMessage",
    http_method = "POST",
    http_path = "/DeleteMessage",
    paginator = list()
  )
  input <- .ivschat$delete_message_input(id = id, reason = reason, roomIdentifier = roomIdentifier)
  output <- .ivschat$delete_message_output()
  config <- get_config()
  svc <- .ivschat$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivschat$operations$delete_message <- ivschat_delete_message

#' Deletes the specified room
#'
#' @description
#' Deletes the specified room.
#'
#' See [https://paws-r.github.io/docs/ivschat/delete_room.html](https://paws-r.github.io/docs/ivschat/delete_room.html) for full documentation.
#'
#' @param identifier &#91;required&#93; Identifier of the room to be deleted. Currently this must be an ARN.
#'
#' @keywords internal
#'
#' @rdname ivschat_delete_room
ivschat_delete_room <- function(identifier) {
  op <- new_operation(
    name = "DeleteRoom",
    http_method = "POST",
    http_path = "/DeleteRoom",
    paginator = list()
  )
  input <- .ivschat$delete_room_input(identifier = identifier)
  output <- .ivschat$delete_room_output()
  config <- get_config()
  svc <- .ivschat$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivschat$operations$delete_room <- ivschat_delete_room

#' Disconnects all connections using a specified user ID from a room
#'
#' @description
#' Disconnects all connections using a specified user ID from a room. This replicates the [DisconnectUser](https://docs.aws.amazon.com/ivs/latest/chatmsgapireference/actions-disconnectuser-publish.html) WebSocket operation in the Amazon IVS Chat Messaging API.
#'
#' See [https://paws-r.github.io/docs/ivschat/disconnect_user.html](https://paws-r.github.io/docs/ivschat/disconnect_user.html) for full documentation.
#'
#' @param reason Reason for disconnecting the user.
#' @param roomIdentifier &#91;required&#93; Identifier of the room from which the user's clients should be
#' disconnected. Currently this must be an ARN.
#' @param userId &#91;required&#93; ID of the user (connection) to disconnect from the room.
#'
#' @keywords internal
#'
#' @rdname ivschat_disconnect_user
ivschat_disconnect_user <- function(reason = NULL, roomIdentifier, userId) {
  op <- new_operation(
    name = "DisconnectUser",
    http_method = "POST",
    http_path = "/DisconnectUser",
    paginator = list()
  )
  input <- .ivschat$disconnect_user_input(reason = reason, roomIdentifier = roomIdentifier, userId = userId)
  output <- .ivschat$disconnect_user_output()
  config <- get_config()
  svc <- .ivschat$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivschat$operations$disconnect_user <- ivschat_disconnect_user

#' Gets the specified room
#'
#' @description
#' Gets the specified room.
#'
#' See [https://paws-r.github.io/docs/ivschat/get_room.html](https://paws-r.github.io/docs/ivschat/get_room.html) for full documentation.
#'
#' @param identifier &#91;required&#93; Identifier of the room for which the configuration is to be retrieved.
#' Currently this must be an ARN.
#'
#' @keywords internal
#'
#' @rdname ivschat_get_room
ivschat_get_room <- function(identifier) {
  op <- new_operation(
    name = "GetRoom",
    http_method = "POST",
    http_path = "/GetRoom",
    paginator = list()
  )
  input <- .ivschat$get_room_input(identifier = identifier)
  output <- .ivschat$get_room_output()
  config <- get_config()
  svc <- .ivschat$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivschat$operations$get_room <- ivschat_get_room

#' Gets summary information about all your rooms in the AWS region where
#' the API request is processed
#'
#' @description
#' Gets summary information about all your rooms in the AWS region where the API request is processed. Results are sorted in descending order of `updateTime`.
#'
#' See [https://paws-r.github.io/docs/ivschat/list_rooms.html](https://paws-r.github.io/docs/ivschat/list_rooms.html) for full documentation.
#'
#' @param maxResults Maximum number of rooms to return. Default: 50.
#' @param messageReviewHandlerUri Filters the list to match the specified message review handler URI.
#' @param name Filters the list to match the specified room name.
#' @param nextToken The first room to retrieve. This is used for pagination; see the
#' `nextToken` response field.
#'
#' @keywords internal
#'
#' @rdname ivschat_list_rooms
ivschat_list_rooms <- function(maxResults = NULL, messageReviewHandlerUri = NULL, name = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListRooms",
    http_method = "POST",
    http_path = "/ListRooms",
    paginator = list()
  )
  input <- .ivschat$list_rooms_input(maxResults = maxResults, messageReviewHandlerUri = messageReviewHandlerUri, name = name, nextToken = nextToken)
  output <- .ivschat$list_rooms_output()
  config <- get_config()
  svc <- .ivschat$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivschat$operations$list_rooms <- ivschat_list_rooms

#' Gets information about AWS tags for the specified ARN
#'
#' @description
#' Gets information about AWS tags for the specified ARN.
#'
#' See [https://paws-r.github.io/docs/ivschat/list_tags_for_resource.html](https://paws-r.github.io/docs/ivschat/list_tags_for_resource.html) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The ARN of the resource to be retrieved. The ARN must be URL-encoded.
#'
#' @keywords internal
#'
#' @rdname ivschat_list_tags_for_resource
ivschat_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .ivschat$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .ivschat$list_tags_for_resource_output()
  config <- get_config()
  svc <- .ivschat$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivschat$operations$list_tags_for_resource <- ivschat_list_tags_for_resource

#' Sends an event to a room
#'
#' @description
#' Sends an event to a room. Use this within your application’s business logic to send events to clients of a room; e.g., to notify clients to change the way the chat UI is rendered.
#'
#' See [https://paws-r.github.io/docs/ivschat/send_event.html](https://paws-r.github.io/docs/ivschat/send_event.html) for full documentation.
#'
#' @param attributes Application-defined metadata to attach to the event sent to clients. The
#' maximum length of the metadata is 1 KB total.
#' @param eventName &#91;required&#93; Application-defined name of the event to send to clients.
#' @param roomIdentifier &#91;required&#93; Identifier of the room to which the event will be sent. Currently this
#' must be an ARN.
#'
#' @keywords internal
#'
#' @rdname ivschat_send_event
ivschat_send_event <- function(attributes = NULL, eventName, roomIdentifier) {
  op <- new_operation(
    name = "SendEvent",
    http_method = "POST",
    http_path = "/SendEvent",
    paginator = list()
  )
  input <- .ivschat$send_event_input(attributes = attributes, eventName = eventName, roomIdentifier = roomIdentifier)
  output <- .ivschat$send_event_output()
  config <- get_config()
  svc <- .ivschat$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivschat$operations$send_event <- ivschat_send_event

#' Adds or updates tags for the AWS resource with the specified ARN
#'
#' @description
#' Adds or updates tags for the AWS resource with the specified ARN.
#'
#' See [https://paws-r.github.io/docs/ivschat/tag_resource.html](https://paws-r.github.io/docs/ivschat/tag_resource.html) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The ARN of the resource to be tagged. The ARN must be URL-encoded.
#' @param tags &#91;required&#93; Array of tags to be added or updated.
#'
#' @keywords internal
#'
#' @rdname ivschat_tag_resource
ivschat_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .ivschat$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .ivschat$tag_resource_output()
  config <- get_config()
  svc <- .ivschat$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivschat$operations$tag_resource <- ivschat_tag_resource

#' Removes tags from the resource with the specified ARN
#'
#' @description
#' Removes tags from the resource with the specified ARN.
#'
#' See [https://paws-r.github.io/docs/ivschat/untag_resource.html](https://paws-r.github.io/docs/ivschat/untag_resource.html) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The ARN of the resource to be untagged. The ARN must be URL-encoded.
#' @param tagKeys &#91;required&#93; Array of tags to be removed.
#'
#' @keywords internal
#'
#' @rdname ivschat_untag_resource
ivschat_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .ivschat$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .ivschat$untag_resource_output()
  config <- get_config()
  svc <- .ivschat$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivschat$operations$untag_resource <- ivschat_untag_resource

#' Updates a room’s configuration
#'
#' @description
#' Updates a room’s configuration.
#'
#' See [https://paws-r.github.io/docs/ivschat/update_room.html](https://paws-r.github.io/docs/ivschat/update_room.html) for full documentation.
#'
#' @param identifier &#91;required&#93; Identifier of the room to be updated. Currently this must be an ARN.
#' @param maximumMessageLength The maximum number of characters in a single message. Messages are
#' expected to be UTF-8 encoded and this limit applies specifically to
#' rune/code-point count, not number of bytes. Default: 500.
#' @param maximumMessageRatePerSecond Maximum number of messages per second that can be sent to the room (by
#' all clients). Default: 10.
#' @param messageReviewHandler Configuration information for optional review of messages. Specify an
#' empty `uri` string to disassociate a message review handler from the
#' specified room.
#' @param name Room name. The value does not need to be unique.
#'
#' @keywords internal
#'
#' @rdname ivschat_update_room
ivschat_update_room <- function(identifier, maximumMessageLength = NULL, maximumMessageRatePerSecond = NULL, messageReviewHandler = NULL, name = NULL) {
  op <- new_operation(
    name = "UpdateRoom",
    http_method = "POST",
    http_path = "/UpdateRoom",
    paginator = list()
  )
  input <- .ivschat$update_room_input(identifier = identifier, maximumMessageLength = maximumMessageLength, maximumMessageRatePerSecond = maximumMessageRatePerSecond, messageReviewHandler = messageReviewHandler, name = name)
  output <- .ivschat$update_room_output()
  config <- get_config()
  svc <- .ivschat$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivschat$operations$update_room <- ivschat_update_room
