% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appstream_operations.R
\name{appstream_describe_user_stack_associations}
\alias{appstream_describe_user_stack_associations}
\title{Retrieves a list that describes the UserStackAssociation objects}
\usage{
appstream_describe_user_stack_associations(StackName, UserName,
  AuthenticationType, MaxResults, NextToken)
}
\arguments{
\item{StackName}{The name of the stack that is associated with the user.}

\item{UserName}{The email address of the user who is associated with the stack.

Users' email addresses are case-sensitive.}

\item{AuthenticationType}{The authentication type for the user who is associated with the stack.
You must specify USERPOOL.}

\item{MaxResults}{The maximum size of each page of results.}

\item{NextToken}{The pagination token to use to retrieve the next page of results for
this operation. If this value is null, it retrieves the first page.}
}
\value{
A list with the following syntax:\preformatted{list(
  UserStackAssociations = list(
    list(
      StackName = "string",
      UserName = "string",
      AuthenticationType = "API"|"SAML"|"USERPOOL",
      SendEmailNotification = TRUE|FALSE
    )
  ),
  NextToken = "string"
)
}
}
\description{
Retrieves a list that describes the UserStackAssociation objects. You
must specify either or both of the following:
\itemize{
\item The stack name
\item The user name (email address of the user associated with the stack)
and the authentication type for the user
}
}
\section{Request syntax}{
\preformatted{svc$describe_user_stack_associations(
  StackName = "string",
  UserName = "string",
  AuthenticationType = "API"|"SAML"|"USERPOOL",
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
