% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_restore_db_instance_from_db_snapshot}
\alias{rds_restore_db_instance_from_db_snapshot}
\title{Creates a new DB instance from a DB snapshot}
\usage{
rds_restore_db_instance_from_db_snapshot(
  DBInstanceIdentifier,
  DBSnapshotIdentifier = NULL,
  DBInstanceClass = NULL,
  Port = NULL,
  AvailabilityZone = NULL,
  DBSubnetGroupName = NULL,
  MultiAZ = NULL,
  PubliclyAccessible = NULL,
  AutoMinorVersionUpgrade = NULL,
  LicenseModel = NULL,
  DBName = NULL,
  Engine = NULL,
  Iops = NULL,
  OptionGroupName = NULL,
  Tags = NULL,
  StorageType = NULL,
  TdeCredentialArn = NULL,
  TdeCredentialPassword = NULL,
  VpcSecurityGroupIds = NULL,
  Domain = NULL,
  DomainFqdn = NULL,
  DomainOu = NULL,
  DomainAuthSecretArn = NULL,
  DomainDnsIps = NULL,
  CopyTagsToSnapshot = NULL,
  DomainIAMRoleName = NULL,
  EnableIAMDatabaseAuthentication = NULL,
  EnableCloudwatchLogsExports = NULL,
  ProcessorFeatures = NULL,
  UseDefaultProcessorFeatures = NULL,
  DBParameterGroupName = NULL,
  DeletionProtection = NULL,
  EnableCustomerOwnedIp = NULL,
  CustomIamInstanceProfile = NULL,
  BackupTarget = NULL,
  NetworkType = NULL,
  StorageThroughput = NULL,
  DBClusterSnapshotIdentifier = NULL,
  AllocatedStorage = NULL,
  DedicatedLogVolume = NULL,
  CACertificateIdentifier = NULL,
  EngineLifecycleSupport = NULL
)
}
\arguments{
\item{DBInstanceIdentifier}{[required] The name of the DB instance to create from the DB snapshot. This
parameter isn't case-sensitive.

Constraints:
\itemize{
\item Must contain from 1 to 63 numbers, letters, or hyphens.
\item First character must be a letter.
\item Can't end with a hyphen or contain two consecutive hyphens.
}

Example: \code{my-snapshot-id}}

\item{DBSnapshotIdentifier}{The identifier for the DB snapshot to restore from.

Constraints:
\itemize{
\item Must match the identifier of an existing DB snapshot.
\item Can't be specified when \code{DBClusterSnapshotIdentifier} is specified.
\item Must be specified when \code{DBClusterSnapshotIdentifier} isn't
specified.
\item If you are restoring from a shared manual DB snapshot, the
\code{DBSnapshotIdentifier} must be the ARN of the shared DB snapshot.
}}

\item{DBInstanceClass}{The compute and memory capacity of the Amazon RDS DB instance, for
example db.m4.large. Not all DB instance classes are available in all
Amazon Web Services Regions, or for all database engines. For the full
list of DB instance classes, and availability for your engine, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html}{DB Instance Class}
in the \emph{Amazon RDS User Guide.}

Default: The same DBInstanceClass as the original DB instance.}

\item{Port}{The port number on which the database accepts connections.

Default: The same port as the original DB instance

Constraints: Value must be \code{1150-65535}}

\item{AvailabilityZone}{The Availability Zone (AZ) where the DB instance will be created.

Default: A random, system-chosen Availability Zone.

Constraint: You can't specify the \code{AvailabilityZone} parameter if the DB
instance is a Multi-AZ deployment.

Example: \verb{us-east-1a}}

\item{DBSubnetGroupName}{The name of the DB subnet group to use for the new instance.

Constraints:
\itemize{
\item If supplied, must match the name of an existing DB subnet group.
}

Example: \code{mydbsubnetgroup}}

\item{MultiAZ}{Specifies whether the DB instance is a Multi-AZ deployment.

This setting doesn't apply to RDS Custom.

Constraint: You can't specify the \code{AvailabilityZone} parameter if the DB
instance is a Multi-AZ deployment.}

\item{PubliclyAccessible}{Specifies whether the DB instance is publicly accessible.

When the DB instance is publicly accessible, its Domain Name System
(DNS) endpoint resolves to the private IP address from within the DB
instance's virtual private cloud (VPC). It resolves to the public IP
address from outside of the DB instance's VPC. Access to the DB instance
is ultimately controlled by the security group it uses. That public
access is not permitted if the security group assigned to the DB
instance doesn't permit it.

When the DB instance isn't publicly accessible, it is an internal DB
instance with a DNS name that resolves to a private IP address.

For more information, see
\code{\link[=rds_create_db_instance]{create_db_instance}}.}

\item{AutoMinorVersionUpgrade}{Specifies whether to automatically apply minor version upgrades to the
DB instance during the maintenance window.

If you restore an RDS Custom DB instance, you must disable this
parameter.}

\item{LicenseModel}{License model information for the restored DB instance.

License models for RDS for Db2 require additional configuration. The
Bring Your Own License (BYOL) model requires a custom parameter group.
The Db2 license through Amazon Web Services Marketplace model requires
an Amazon Web Services Marketplace subscription. For more information,
see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/db2-licensing.html}{RDS for Db2 licensing options}
in the \emph{Amazon RDS User Guide}.

This setting doesn't apply to Amazon Aurora or RDS Custom DB instances.

Valid Values:
\itemize{
\item RDS for Db2 - \code{bring-your-own-license | marketplace-license}
\item RDS for MariaDB - \code{general-public-license}
\item RDS for Microsoft SQL Server - \code{license-included}
\item RDS for MySQL - \code{general-public-license}
\item RDS for Oracle - \code{bring-your-own-license | license-included}
\item RDS for PostgreSQL - \code{postgresql-license}
}

Default: Same as the source.}

\item{DBName}{The name of the database for the restored DB instance.

This parameter only applies to RDS for Oracle and RDS for SQL Server DB
instances. It doesn't apply to the other engines or to RDS Custom DB
instances.}

\item{Engine}{The database engine to use for the new instance.

This setting doesn't apply to RDS Custom.

Default: The same as source

Constraint: Must be compatible with the engine of the source. For
example, you can restore a MariaDB 10.1 DB instance from a MySQL 5.6
snapshot.

Valid Values:
\itemize{
\item \code{db2-ae}
\item \code{db2-se}
\item \code{mariadb}
\item \code{mysql}
\item \code{oracle-ee}
\item \code{oracle-ee-cdb}
\item \code{oracle-se2}
\item \code{oracle-se2-cdb}
\item \code{postgres}
\item \code{sqlserver-ee}
\item \code{sqlserver-se}
\item \code{sqlserver-ex}
\item \code{sqlserver-web}
}}

\item{Iops}{Specifies the amount of provisioned IOPS for the DB instance, expressed
in I/O operations per second. If this parameter isn't specified, the
IOPS value is taken from the backup. If this parameter is set to 0, the
new instance is converted to a non-PIOPS instance. The conversion takes
additional time, though your DB instance is available for connections
before the conversion starts.

The provisioned IOPS value must follow the requirements for your
database engine. For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS}{Amazon RDS Provisioned IOPS storage}
in the \emph{Amazon RDS User Guide.}

Constraints: Must be an integer greater than 1000.}

\item{OptionGroupName}{The name of the option group to be used for the restored DB instance.

Permanent options, such as the TDE option for Oracle Advanced Security
TDE, can't be removed from an option group, and that option group can't
be removed from a DB instance after it is associated with a DB instance.

This setting doesn't apply to RDS Custom.}

\item{Tags}{}

\item{StorageType}{Specifies the storage type to be associated with the DB instance.

Valid Values: \code{gp2 | gp3 | io1 | io2 | standard}

If you specify \code{io1}, \code{io2}, or \code{gp3}, you must also include a value for
the \code{Iops} parameter.

Default: \code{io1} if the \code{Iops} parameter is specified, otherwise \code{gp2}}

\item{TdeCredentialArn}{The ARN from the key store with which to associate the instance for TDE
encryption.

This setting doesn't apply to RDS Custom.}

\item{TdeCredentialPassword}{The password for the given ARN from the key store in order to access the
device.

This setting doesn't apply to RDS Custom.}

\item{VpcSecurityGroupIds}{A list of EC2 VPC security groups to associate with this DB instance.

Default: The default EC2 VPC security group for the DB subnet group's
VPC.}

\item{Domain}{The Active Directory directory ID to restore the DB instance in. The
domain/ must be created prior to this operation. Currently, you can
create only Db2, MySQL, Microsoft SQL Server, Oracle, and PostgreSQL DB
instances in an Active Directory Domain.

For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/database-authentication.html}{Kerberos Authentication}
in the \emph{Amazon RDS User Guide}.

This setting doesn't apply to RDS Custom.}

\item{DomainFqdn}{The fully qualified domain name (FQDN) of an Active Directory domain.

Constraints:
\itemize{
\item Can't be longer than 64 characters.
}

Example: \code{mymanagedADtest.mymanagedAD.mydomain}}

\item{DomainOu}{The Active Directory organizational unit for your DB instance to join.

Constraints:
\itemize{
\item Must be in the distinguished name format.
\item Can't be longer than 64 characters.
}

Example:
\verb{OU=mymanagedADtestOU,DC=mymanagedADtest,DC=mymanagedAD,DC=mydomain}}

\item{DomainAuthSecretArn}{The ARN for the Secrets Manager secret with the credentials for the user
joining the domain.

Constraints:
\itemize{
\item Can't be longer than 64 characters.
}

Example:
\code{arn:aws:secretsmanager:region:account-number:secret:myselfmanagedADtestsecret-123456}}

\item{DomainDnsIps}{The IPv4 DNS IP addresses of your primary and secondary Active Directory
domain controllers.

Constraints:
\itemize{
\item Two IP addresses must be provided. If there isn't a secondary domain
controller, use the IP address of the primary domain controller for
both entries in the list.
}

Example: \verb{123.124.125.126,234.235.236.237}}

\item{CopyTagsToSnapshot}{Specifies whether to copy all tags from the restored DB instance to
snapshots of the DB instance.

In most cases, tags aren't copied by default. However, when you restore
a DB instance from a DB snapshot, RDS checks whether you specify new
tags. If yes, the new tags are added to the restored DB instance. If
there are no new tags, RDS looks for the tags from the source DB
instance for the DB snapshot, and then adds those tags to the restored
DB instance.

For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html#USER_Tagging.CopyTags}{Copying tags to DB instance snapshots}
in the \emph{Amazon RDS User Guide}.}

\item{DomainIAMRoleName}{The name of the IAM role to use when making API calls to the Directory
Service.

This setting doesn't apply to RDS Custom DB instances.}

\item{EnableIAMDatabaseAuthentication}{Specifies whether to enable mapping of Amazon Web Services Identity and
Access Management (IAM) accounts to database accounts. By default,
mapping is disabled.

For more information about IAM database authentication, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html}{IAM Database Authentication for MySQL and PostgreSQL}
in the \emph{Amazon RDS User Guide.}

This setting doesn't apply to RDS Custom.}

\item{EnableCloudwatchLogsExports}{The list of logs for the restored DB instance to export to CloudWatch
Logs. The values in the list depend on the DB engine. For more
information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch}{Publishing Database Logs to Amazon CloudWatch Logs}
in the \emph{Amazon RDS User Guide}.

This setting doesn't apply to RDS Custom.}

\item{ProcessorFeatures}{The number of CPU cores and the number of threads per core for the DB
instance class of the DB instance.

This setting doesn't apply to RDS Custom.}

\item{UseDefaultProcessorFeatures}{Specifies whether the DB instance class of the DB instance uses its
default processor features.

This setting doesn't apply to RDS Custom.}

\item{DBParameterGroupName}{The name of the DB parameter group to associate with this DB instance.

If you don't specify a value for \code{DBParameterGroupName}, then RDS uses
the default \code{DBParameterGroup} for the specified DB engine.

This setting doesn't apply to RDS Custom.

Constraints:
\itemize{
\item If supplied, must match the name of an existing DB parameter group.
\item Must be 1 to 255 letters, numbers, or hyphens.
\item First character must be a letter.
\item Can't end with a hyphen or contain two consecutive hyphens.
}}

\item{DeletionProtection}{Specifies whether to enable deletion protection for the DB instance. The
database can't be deleted when deletion protection is enabled. By
default, deletion protection isn't enabled. For more information, see
\href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html}{Deleting a DB Instance}.}

\item{EnableCustomerOwnedIp}{Specifies whether to enable a customer-owned IP address (CoIP) for an
RDS on Outposts DB instance.

A \emph{CoIP} provides local or external connectivity to resources in your
Outpost subnets through your on-premises network. For some use cases, a
CoIP can provide lower latency for connections to the DB instance from
outside of its virtual private cloud (VPC) on your local network.

This setting doesn't apply to RDS Custom.

For more information about RDS on Outposts, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html}{Working with Amazon RDS on Amazon Web Services Outposts}
in the \emph{Amazon RDS User Guide}.

For more information about CoIPs, see \href{https://docs.aws.amazon.com/outposts/latest/userguide/routing.html#ip-addressing}{Customer-owned IP addresses}
in the \emph{Amazon Web Services Outposts User Guide}.}

\item{CustomIamInstanceProfile}{The instance profile associated with the underlying Amazon EC2 instance
of an RDS Custom DB instance. The instance profile must meet the
following requirements:
\itemize{
\item The profile must exist in your account.
\item The profile must have an IAM role that Amazon EC2 has permissions to
assume.
\item The instance profile name and the associated IAM role name must
start with the prefix \code{AWSRDSCustom}.
}

For the list of permissions required for the IAM role, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-setup-orcl.html#custom-setup-orcl.iam-vpc}{Configure IAM and your VPC}
in the \emph{Amazon RDS User Guide}.

This setting is required for RDS Custom.}

\item{BackupTarget}{Specifies where automated backups and manual snapshots are stored for
the restored DB instance.

Possible values are \code{outposts} (Amazon Web Services Outposts) and
\code{region} (Amazon Web Services Region). The default is \code{region}.

For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html}{Working with Amazon RDS on Amazon Web Services Outposts}
in the \emph{Amazon RDS User Guide}.}

\item{NetworkType}{The network type of the DB instance.

Valid Values:
\itemize{
\item \code{IPV4}
\item \code{DUAL}
}

The network type is determined by the \code{DBSubnetGroup} specified for the
DB instance. A \code{DBSubnetGroup} can support only the IPv4 protocol or the
IPv4 and the IPv6 protocols (\code{DUAL}).

For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html}{Working with a DB instance in a VPC}
in the \emph{Amazon RDS User Guide.}}

\item{StorageThroughput}{Specifies the storage throughput value for the DB instance.

This setting doesn't apply to RDS Custom or Amazon Aurora.}

\item{DBClusterSnapshotIdentifier}{The identifier for the Multi-AZ DB cluster snapshot to restore from.

For more information on Multi-AZ DB clusters, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html}{Multi-AZ DB cluster deployments}
in the \emph{Amazon RDS User Guide}.

Constraints:
\itemize{
\item Must match the identifier of an existing Multi-AZ DB cluster
snapshot.
\item Can't be specified when \code{DBSnapshotIdentifier} is specified.
\item Must be specified when \code{DBSnapshotIdentifier} isn't specified.
\item If you are restoring from a shared manual Multi-AZ DB cluster
snapshot, the \code{DBClusterSnapshotIdentifier} must be the ARN of the
shared snapshot.
\item Can't be the identifier of an Aurora DB cluster snapshot.
}}

\item{AllocatedStorage}{The amount of storage (in gibibytes) to allocate initially for the DB
instance. Follow the allocation rules specified in CreateDBInstance.

Be sure to allocate enough storage for your new DB instance so that the
restore operation can succeed. You can also allocate additional storage
for future growth.}

\item{DedicatedLogVolume}{Specifies whether to enable a dedicated log volume (DLV) for the DB
instance.}

\item{CACertificateIdentifier}{The CA certificate identifier to use for the DB instance's server
certificate.

This setting doesn't apply to RDS Custom DB instances.

For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html}{Using SSL/TLS to encrypt a connection to a DB instance}
in the \emph{Amazon RDS User Guide} and \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL.html}{Using SSL/TLS to encrypt a connection to a DB cluster}
in the \emph{Amazon Aurora User Guide}.}

\item{EngineLifecycleSupport}{The life cycle type for this DB instance.

By default, this value is set to \code{open-source-rds-extended-support},
which enrolls your DB instance into Amazon RDS Extended Support. At the
end of standard support, you can avoid charges for Extended Support by
setting the value to \code{open-source-rds-extended-support-disabled}. In
this case, RDS automatically upgrades your restored DB instance to a
higher engine version, if the major engine version is past its end of
standard support date.

You can use this setting to enroll your DB instance into Amazon RDS
Extended Support. With RDS Extended Support, you can run the selected
major engine version on your DB instance past the end of standard
support for that engine version. For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/extended-support.html}{Using Amazon RDS Extended Support}
in the \emph{Amazon RDS User Guide}.

This setting applies only to RDS for MySQL and RDS for PostgreSQL. For
Amazon Aurora DB instances, the life cycle type is managed by the DB
cluster.

Valid Values:
\code{open-source-rds-extended-support | open-source-rds-extended-support-disabled}

Default: \code{open-source-rds-extended-support}}
}
\description{
Creates a new DB instance from a DB snapshot. The target database is created from the source database restore point with most of the source's original configuration, including the default security group and DB parameter group. By default, the new DB instance is created as a Single-AZ deployment, except when the instance is a SQL Server instance that has an option group associated with mirroring. In this case, the instance becomes a Multi-AZ deployment, not a Single-AZ deployment.

See \url{https://www.paws-r-sdk.com/docs/rds_restore_db_instance_from_db_snapshot/} for full documentation.
}
\keyword{internal}
