% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lakeformation_operations.R
\name{lakeformation_assume_decorated_role_with_saml}
\alias{lakeformation_assume_decorated_role_with_saml}
\title{Allows a caller to assume an IAM role decorated as the SAML user
specified in the SAML assertion included in the request}
\usage{
lakeformation_assume_decorated_role_with_saml(
  SAMLAssertion,
  RoleArn,
  PrincipalArn,
  DurationSeconds = NULL
)
}
\arguments{
\item{SAMLAssertion}{[required] A SAML assertion consisting of an assertion statement for the user who
needs temporary credentials. This must match the SAML assertion that was
issued to IAM. This must be Base64 encoded.}

\item{RoleArn}{[required] The role that represents an IAM principal whose scope down policy allows
it to call credential vending APIs such as
\code{GetTemporaryTableCredentials}. The caller must also have iam:PassRole
permission on this role.}

\item{PrincipalArn}{[required] The Amazon Resource Name (ARN) of the SAML provider in IAM that
describes the IdP.}

\item{DurationSeconds}{The time period, between 900 and 43,200 seconds, for the timeout of the
temporary credentials.}
}
\description{
Allows a caller to assume an IAM role decorated as the SAML user specified in the SAML assertion included in the request. This decoration allows Lake Formation to enforce access policies against the SAML users and groups. This API operation requires SAML federation setup in the caller’s account as it can only be called with valid SAML assertions. Lake Formation does not scope down the permission of the assumed role. All permissions attached to the role via the SAML federation setup will be included in the role session.

See \url{https://www.paws-r-sdk.com/docs/lakeformation_assume_decorated_role_with_saml/} for full documentation.
}
\keyword{internal}
