% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshift_operations.R
\name{redshift_describe_reserved_node_exchange_status}
\alias{redshift_describe_reserved_node_exchange_status}
\title{Returns exchange status details and associated metadata for a
reserved-node exchange}
\usage{
redshift_describe_reserved_node_exchange_status(
  ReservedNodeId = NULL,
  ReservedNodeExchangeRequestId = NULL,
  MaxRecords = NULL,
  Marker = NULL
)
}
\arguments{
\item{ReservedNodeId}{The identifier of the source reserved node in a reserved-node exchange
request.}

\item{ReservedNodeExchangeRequestId}{The identifier of the reserved-node exchange request.}

\item{MaxRecords}{The maximum number of response records to return in each call. If the
number of remaining response records exceeds the specified \code{MaxRecords}
value, a value is returned in a \code{Marker} field of the response. You can
retrieve the next set of records by retrying the command with the
returned marker value.}

\item{Marker}{An optional pagination token provided by a previous
\code{\link[=redshift_describe_reserved_node_exchange_status]{describe_reserved_node_exchange_status}}
request. If this parameter is specified, the response includes only
records beyond the marker, up to the value specified by the \code{MaxRecords}
parameter. You can retrieve the next set of response records by
providing the returned marker value in the \code{Marker} parameter and
retrying the request.}
}
\description{
Returns exchange status details and associated metadata for a reserved-node exchange. Statuses include such values as in progress and requested.

See \url{https://paws-r.github.io/docs/redshift/describe_reserved_node_exchange_status.html} for full documentation.
}
\keyword{internal}
