% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_modify_db_instance}
\alias{rds_modify_db_instance}
\title{Modifies settings for a DB instance}
\usage{
rds_modify_db_instance(
  DBInstanceIdentifier,
  AllocatedStorage = NULL,
  DBInstanceClass = NULL,
  DBSubnetGroupName = NULL,
  DBSecurityGroups = NULL,
  VpcSecurityGroupIds = NULL,
  ApplyImmediately = NULL,
  MasterUserPassword = NULL,
  DBParameterGroupName = NULL,
  BackupRetentionPeriod = NULL,
  PreferredBackupWindow = NULL,
  PreferredMaintenanceWindow = NULL,
  MultiAZ = NULL,
  EngineVersion = NULL,
  AllowMajorVersionUpgrade = NULL,
  AutoMinorVersionUpgrade = NULL,
  LicenseModel = NULL,
  Iops = NULL,
  OptionGroupName = NULL,
  NewDBInstanceIdentifier = NULL,
  StorageType = NULL,
  TdeCredentialArn = NULL,
  TdeCredentialPassword = NULL,
  CACertificateIdentifier = NULL,
  Domain = NULL,
  CopyTagsToSnapshot = NULL,
  MonitoringInterval = NULL,
  DBPortNumber = NULL,
  PubliclyAccessible = NULL,
  MonitoringRoleArn = NULL,
  DomainIAMRoleName = NULL,
  PromotionTier = NULL,
  EnableIAMDatabaseAuthentication = NULL,
  EnablePerformanceInsights = NULL,
  PerformanceInsightsKMSKeyId = NULL,
  PerformanceInsightsRetentionPeriod = NULL,
  CloudwatchLogsExportConfiguration = NULL,
  ProcessorFeatures = NULL,
  UseDefaultProcessorFeatures = NULL,
  DeletionProtection = NULL,
  MaxAllocatedStorage = NULL,
  CertificateRotationRestart = NULL,
  ReplicaMode = NULL,
  EnableCustomerOwnedIp = NULL,
  AwsBackupRecoveryPointArn = NULL,
  AutomationMode = NULL,
  ResumeFullAutomationModeMinutes = NULL,
  NetworkType = NULL
)
}
\arguments{
\item{DBInstanceIdentifier}{[required] The DB instance identifier. This value is stored as a lowercase string.

Constraints:
\itemize{
\item Must match the identifier of an existing DBInstance.
}}

\item{AllocatedStorage}{The new amount of storage in gibibytes (GiB) to allocate for the DB
instance.

For MariaDB, MySQL, Oracle, and PostgreSQL, the value supplied must be
at least 10\% greater than the current value. Values that are not at
least 10\% greater than the existing value are rounded up so that they
are 10\% greater than the current value.

For the valid values for allocated storage for each engine, see
\code{\link[=rds_create_db_instance]{create_db_instance}}.}

\item{DBInstanceClass}{The new compute and memory capacity of the DB instance, for example
db.m5.large. Not all DB instance classes are available in all Amazon Web
Services Regions, or for all database engines. For the full list of DB
instance classes, and availability for your engine, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html}{DB instance classes}
in the \emph{Amazon RDS User Guide} or \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Concepts.DBInstanceClass.html}{Aurora DB instance classes}
in the \emph{Amazon Aurora User Guide}.

If you modify the DB instance class, an outage occurs during the change.
The change is applied during the next maintenance window, unless
\code{ApplyImmediately} is enabled for this request.

This setting doesn't apply to RDS Custom for Oracle.

Default: Uses existing setting}

\item{DBSubnetGroupName}{The new DB subnet group for the DB instance. You can use this parameter
to move your DB instance to a different VPC. If your DB instance isn't
in a VPC, you can also use this parameter to move your DB instance into
a VPC. For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html#USER_VPC.Non-VPC2VPC}{Working with a DB instance in a VPC}
in the \emph{Amazon RDS User Guide}.

Changing the subnet group causes an outage during the change. The change
is applied during the next maintenance window, unless you enable
\code{ApplyImmediately}.

This parameter doesn't apply to RDS Custom.

Constraints: If supplied, must match the name of an existing
DBSubnetGroup.

Example: \code{mydbsubnetgroup}}

\item{DBSecurityGroups}{A list of DB security groups to authorize on this DB instance. Changing
this setting doesn't result in an outage and the change is
asynchronously applied as soon as possible.

This setting doesn't apply to RDS Custom.

Constraints:
\itemize{
\item If supplied, must match existing DBSecurityGroups.
}}

\item{VpcSecurityGroupIds}{A list of Amazon EC2 VPC security groups to authorize on this DB
instance. This change is asynchronously applied as soon as possible.

This setting doesn't apply to RDS Custom.

\strong{Amazon Aurora}

Not applicable. The associated list of EC2 VPC security groups is
managed by the DB cluster. For more information, see
\code{\link[=rds_modify_db_cluster]{modify_db_cluster}}.

Constraints:
\itemize{
\item If supplied, must match existing VpcSecurityGroupIds.
}}

\item{ApplyImmediately}{A value that indicates whether the modifications in this request and any
pending modifications are asynchronously applied as soon as possible,
regardless of the \code{PreferredMaintenanceWindow} setting for the DB
instance. By default, this parameter is disabled.

If this parameter is disabled, changes to the DB instance are applied
during the next maintenance window. Some parameter changes can cause an
outage and are applied on the next call to
\code{\link[=rds_reboot_db_instance]{reboot_db_instance}}, or the next failure
reboot. Review the table of parameters in \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.DBInstance.Modifying.html}{Modifying a DB Instance}
in the \emph{Amazon RDS User Guide} to see the impact of enabling or
disabling \code{ApplyImmediately} for each modified parameter and to
determine when the changes are applied.}

\item{MasterUserPassword}{The new password for the master user. The password can include any
printable ASCII character except "/", """, or "@".

Changing this parameter doesn't result in an outage and the change is
asynchronously applied as soon as possible. Between the time of the
request and the completion of the request, the \code{MasterUserPassword}
element exists in the \code{PendingModifiedValues} element of the operation
response.

This setting doesn't apply to RDS Custom.

\strong{Amazon Aurora}

Not applicable. The password for the master user is managed by the DB
cluster. For more information, see
\code{\link[=rds_modify_db_cluster]{modify_db_cluster}}.

Default: Uses existing setting

\strong{MariaDB}

Constraints: Must contain from 8 to 41 characters.

\strong{Microsoft SQL Server}

Constraints: Must contain from 8 to 128 characters.

\strong{MySQL}

Constraints: Must contain from 8 to 41 characters.

\strong{Oracle}

Constraints: Must contain from 8 to 30 characters.

\strong{PostgreSQL}

Constraints: Must contain from 8 to 128 characters.

Amazon RDS API operations never return the password, so this action
provides a way to regain access to a primary instance user if the
password is lost. This includes restoring privileges that might have
been accidentally revoked.}

\item{DBParameterGroupName}{The name of the DB parameter group to apply to the DB instance.

Changing this setting doesn't result in an outage. The parameter group
name itself is changed immediately, but the actual parameter changes are
not applied until you reboot the instance without failover. In this
case, the DB instance isn't rebooted automatically, and the parameter
changes aren't applied during the next maintenance window. However, if
you modify dynamic parameters in the newly associated DB parameter
group, these changes are applied immediately without a reboot.

This setting doesn't apply to RDS Custom.

Default: Uses existing setting

Constraints: The DB parameter group must be in the same DB parameter
group family as the DB instance.}

\item{BackupRetentionPeriod}{The number of days to retain automated backups. Setting this parameter
to a positive number enables backups. Setting this parameter to 0
disables automated backups.

Enabling and disabling backups can result in a brief I/O suspension that
lasts from a few seconds to a few minutes, depending on the size and
class of your DB instance.

These changes are applied during the next maintenance window unless the
\code{ApplyImmediately} parameter is enabled for this request. If you change
the parameter from one non-zero value to another non-zero value, the
change is asynchronously applied as soon as possible.

\strong{Amazon Aurora}

Not applicable. The retention period for automated backups is managed by
the DB cluster. For more information, see
\code{\link[=rds_modify_db_cluster]{modify_db_cluster}}.

Default: Uses existing setting

Constraints:
\itemize{
\item It must be a value from 0 to 35. It can't be set to 0 if the DB
instance is a source to read replicas. It can't be set to 0 for an
RDS Custom for Oracle DB instance.
\item It can be specified for a MySQL read replica only if the source is
running MySQL 5.6 or later.
\item It can be specified for a PostgreSQL read replica only if the source
is running PostgreSQL 9.3.5.
}}

\item{PreferredBackupWindow}{The daily time range during which automated backups are created if
automated backups are enabled, as determined by the
\code{BackupRetentionPeriod} parameter. Changing this parameter doesn't
result in an outage and the change is asynchronously applied as soon as
possible. The default is a 30-minute window selected at random from an
8-hour block of time for each Amazon Web Services Region. For more
information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow}{Backup window}
in the \emph{Amazon RDS User Guide.}

\strong{Amazon Aurora}

Not applicable. The daily time range for creating automated backups is
managed by the DB cluster. For more information, see
\code{\link[=rds_modify_db_cluster]{modify_db_cluster}}.

Constraints:
\itemize{
\item Must be in the format hh24:mi-hh24:mi
\item Must be in Universal Time Coordinated (UTC)
\item Must not conflict with the preferred maintenance window
\item Must be at least 30 minutes
}}

\item{PreferredMaintenanceWindow}{The weekly time range (in UTC) during which system maintenance can
occur, which might result in an outage. Changing this parameter doesn't
result in an outage, except in the following situation, and the change
is asynchronously applied as soon as possible. If there are pending
actions that cause a reboot, and the maintenance window is changed to
include the current time, then changing this parameter will cause a
reboot of the DB instance. If moving this window to the current time,
there must be at least 30 minutes between the current time and end of
the window to ensure pending changes are applied.

For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#Concepts.DBMaintenance}{Amazon RDS Maintenance Window}
in the \emph{Amazon RDS User Guide.}

Default: Uses existing setting

Format: ddd:hh24:mi-ddd:hh24:mi

Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun

Constraints: Must be at least 30 minutes}

\item{MultiAZ}{A value that indicates whether the DB instance is a Multi-AZ deployment.
Changing this parameter doesn't result in an outage. The change is
applied during the next maintenance window unless the \code{ApplyImmediately}
parameter is enabled for this request.

This setting doesn't apply to RDS Custom.}

\item{EngineVersion}{The version number of the database engine to upgrade to. Changing this
parameter results in an outage and the change is applied during the next
maintenance window unless the \code{ApplyImmediately} parameter is enabled
for this request.

For major version upgrades, if a nondefault DB parameter group is
currently in use, a new DB parameter group in the DB parameter group
family for the new engine version must be specified. The new DB
parameter group can be the default for that DB parameter group family.

If you specify only a major version, Amazon RDS will update the DB
instance to the default minor version if the current minor version is
lower. For information about valid engine versions, see
\code{\link[=rds_create_db_instance]{create_db_instance}}, or call
\code{\link[=rds_describe_db_engine_versions]{describe_db_engine_versions}}.

In RDS Custom for Oracle, this parameter is supported for read replicas
only if they are in the \code{PATCH_DB_FAILURE} lifecycle.}

\item{AllowMajorVersionUpgrade}{A value that indicates whether major version upgrades are allowed.
Changing this parameter doesn't result in an outage and the change is
asynchronously applied as soon as possible.

This setting doesn't apply to RDS Custom.

Constraints: Major version upgrades must be allowed when specifying a
value for the EngineVersion parameter that is a different major version
than the DB instance's current version.}

\item{AutoMinorVersionUpgrade}{A value that indicates whether minor version upgrades are applied
automatically to the DB instance during the maintenance window. An
outage occurs when all the following conditions are met:
\itemize{
\item The automatic upgrade is enabled for the maintenance window.
\item A newer minor version is available.
\item RDS has enabled automatic patching for the engine version.
}

If any of the preceding conditions isn't met, RDS applies the change as
soon as possible and doesn't cause an outage.

For an RDS Custom DB instance, set \code{AutoMinorVersionUpgrade} to \code{false}.
Otherwise, the operation returns an error.}

\item{LicenseModel}{The license model for the DB instance.

This setting doesn't apply to RDS Custom.

Valid values: \code{license-included} | \code{bring-your-own-license} |
\code{general-public-license}}

\item{Iops}{The new Provisioned IOPS (I/O operations per second) value for the RDS
instance.

Changing this setting doesn't result in an outage and the change is
applied during the next maintenance window unless the \code{ApplyImmediately}
parameter is enabled for this request. If you are migrating from
Provisioned IOPS to standard storage, set this value to 0. The DB
instance will require a reboot for the change in storage type to take
effect.

If you choose to migrate your DB instance from using standard storage to
using Provisioned IOPS, or from using Provisioned IOPS to using standard
storage, the process can take time. The duration of the migration
depends on several factors such as database load, storage size, storage
type (standard or Provisioned IOPS), amount of IOPS provisioned (if
any), and the number of prior scale storage operations. Typical
migration times are under 24 hours, but the process can take up to
several days in some cases. During the migration, the DB instance is
available for use, but might experience performance degradation. While
the migration takes place, nightly backups for the instance are
suspended. No other Amazon RDS operations can take place for the
instance, including modifying the instance, rebooting the instance,
deleting the instance, creating a read replica for the instance, and
creating a DB snapshot of the instance.

Constraints: For MariaDB, MySQL, Oracle, and PostgreSQL, the value
supplied must be at least 10\% greater than the current value. Values
that are not at least 10\% greater than the existing value are rounded up
so that they are 10\% greater than the current value.

Default: Uses existing setting}

\item{OptionGroupName}{A value that indicates the DB instance should be associated with the
specified option group.

Changing this parameter doesn't result in an outage, with one exception.
If the parameter change results in an option group that enables OEM, it
can cause a brief period, lasting less than a second, during which new
connections are rejected but existing connections aren't interrupted.

The change is applied during the next maintenance window unless the
\code{ApplyImmediately} parameter is enabled for this request.

Permanent options, such as the TDE option for Oracle Advanced Security
TDE, can't be removed from an option group, and that option group can't
be removed from a DB instance after it is associated with a DB instance.

This setting doesn't apply to RDS Custom.}

\item{NewDBInstanceIdentifier}{The new DB instance identifier for the DB instance when renaming a DB
instance. When you change the DB instance identifier, an instance reboot
occurs immediately if you enable \code{ApplyImmediately}, or will occur
during the next maintenance window if you disable Apply Immediately.
This value is stored as a lowercase string.

This setting doesn't apply to RDS Custom.

Constraints:
\itemize{
\item Must contain from 1 to 63 letters, numbers, or hyphens.
\item The first character must be a letter.
\item Can't end with a hyphen or contain two consecutive hyphens.
}

Example: \code{mydbinstance}}

\item{StorageType}{Specifies the storage type to be associated with the DB instance.

If you specify Provisioned IOPS (\code{io1}), you must also include a value
for the \code{Iops} parameter.

If you choose to migrate your DB instance from using standard storage to
using Provisioned IOPS, or from using Provisioned IOPS to using standard
storage, the process can take time. The duration of the migration
depends on several factors such as database load, storage size, storage
type (standard or Provisioned IOPS), amount of IOPS provisioned (if
any), and the number of prior scale storage operations. Typical
migration times are under 24 hours, but the process can take up to
several days in some cases. During the migration, the DB instance is
available for use, but might experience performance degradation. While
the migration takes place, nightly backups for the instance are
suspended. No other Amazon RDS operations can take place for the
instance, including modifying the instance, rebooting the instance,
deleting the instance, creating a read replica for the instance, and
creating a DB snapshot of the instance.

Valid values: \code{standard | gp2 | io1}

Default: \code{io1} if the \code{Iops} parameter is specified, otherwise \code{gp2}}

\item{TdeCredentialArn}{The ARN from the key store with which to associate the instance for TDE
encryption.

This setting doesn't apply to RDS Custom.}

\item{TdeCredentialPassword}{The password for the given ARN from the key store in order to access the
device.

This setting doesn't apply to RDS Custom.}

\item{CACertificateIdentifier}{Specifies the certificate to associate with the DB instance.

This setting doesn't apply to RDS Custom.}

\item{Domain}{The Active Directory directory ID to move the DB instance to. Specify
\code{none} to remove the instance from its current domain. You must create
the domain before this operation. Currently, you can create only MySQL,
Microsoft SQL Server, Oracle, and PostgreSQL DB instances in an Active
Directory Domain.

For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/database-authentication.html}{Kerberos Authentication}
in the \emph{Amazon RDS User Guide}.

This setting doesn't apply to RDS Custom.}

\item{CopyTagsToSnapshot}{A value that indicates whether to copy all tags from the DB instance to
snapshots of the DB instance. By default, tags are not copied.

\strong{Amazon Aurora}

Not applicable. Copying tags to snapshots is managed by the DB cluster.
Setting this value for an Aurora DB instance has no effect on the DB
cluster setting. For more information, see
\code{\link[=rds_modify_db_cluster]{modify_db_cluster}}.}

\item{MonitoringInterval}{The interval, in seconds, between points when Enhanced Monitoring
metrics are collected for the DB instance. To disable collecting
Enhanced Monitoring metrics, specify 0, which is the default.

If \code{MonitoringRoleArn} is specified, set \code{MonitoringInterval} to a value
other than 0.

This setting doesn't apply to RDS Custom.

Valid Values: \verb{0, 1, 5, 10, 15, 30, 60}}

\item{DBPortNumber}{The port number on which the database accepts connections.

The value of the \code{DBPortNumber} parameter must not match any of the port
values specified for options in the option group for the DB instance.

If you change the \code{DBPortNumber} value, your database restarts
regardless of the value of the \code{ApplyImmediately} parameter.

This setting doesn't apply to RDS Custom.

\strong{MySQL}

Default: \code{3306}

Valid values: \code{1150-65535}

\strong{MariaDB}

Default: \code{3306}

Valid values: \code{1150-65535}

\strong{PostgreSQL}

Default: \code{5432}

Valid values: \code{1150-65535}

Type: Integer

\strong{Oracle}

Default: \code{1521}

Valid values: \code{1150-65535}

\strong{SQL Server}

Default: \code{1433}

Valid values: \code{1150-65535} except \code{1234}, \code{1434}, \code{3260}, \code{3343},
\code{3389}, \code{47001}, and \code{49152-49156}.

\strong{Amazon Aurora}

Default: \code{3306}

Valid values: \code{1150-65535}}

\item{PubliclyAccessible}{A value that indicates whether the DB instance is publicly accessible.

When the DB cluster is publicly accessible, its Domain Name System (DNS)
endpoint resolves to the private IP address from within the DB cluster's
virtual private cloud (VPC). It resolves to the public IP address from
outside of the DB cluster's VPC. Access to the DB cluster is ultimately
controlled by the security group it uses. That public access isn't
permitted if the security group assigned to the DB cluster doesn't
permit it.

When the DB instance isn't publicly accessible, it is an internal DB
instance with a DNS name that resolves to a private IP address.

\code{PubliclyAccessible} only applies to DB instances in a VPC. The DB
instance must be part of a public subnet and \code{PubliclyAccessible} must
be enabled for it to be publicly accessible.

Changes to the \code{PubliclyAccessible} parameter are applied immediately
regardless of the value of the \code{ApplyImmediately} parameter.}

\item{MonitoringRoleArn}{The ARN for the IAM role that permits RDS to send enhanced monitoring
metrics to Amazon CloudWatch Logs. For example,
\code{arn:aws:iam:123456789012:role/emaccess}. For information on creating a
monitoring role, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.html#USER_Monitoring.OS.IAMRole}{To create an IAM role for Amazon RDS Enhanced Monitoring}
in the \emph{Amazon RDS User Guide.}

If \code{MonitoringInterval} is set to a value other than 0, supply a
\code{MonitoringRoleArn} value.

This setting doesn't apply to RDS Custom.}

\item{DomainIAMRoleName}{The name of the IAM role to use when making API calls to the Directory
Service.

This setting doesn't apply to RDS Custom.}

\item{PromotionTier}{A value that specifies the order in which an Aurora Replica is promoted
to the primary instance after a failure of the existing primary
instance. For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.FaultTolerance}{Fault Tolerance for an Aurora DB Cluster}
in the \emph{Amazon Aurora User Guide}.

This setting doesn't apply to RDS Custom.

Default: 1

Valid Values: 0 - 15}

\item{EnableIAMDatabaseAuthentication}{A value that indicates whether to enable mapping of Amazon Web Services
Identity and Access Management (IAM) accounts to database accounts. By
default, mapping isn't enabled.

This setting doesn't apply to Amazon Aurora. Mapping Amazon Web Services
IAM accounts to database accounts is managed by the DB cluster.

For more information about IAM database authentication, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html}{IAM Database Authentication for MySQL and PostgreSQL}
in the \emph{Amazon RDS User Guide.}

This setting doesn't apply to RDS Custom.}

\item{EnablePerformanceInsights}{A value that indicates whether to enable Performance Insights for the DB
instance.

For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html}{Using Amazon Performance Insights}
in the \emph{Amazon RDS User Guide}.

This setting doesn't apply to RDS Custom.}

\item{PerformanceInsightsKMSKeyId}{The Amazon Web Services KMS key identifier for encryption of Performance
Insights data.

The Amazon Web Services KMS key identifier is the key ARN, key ID, alias
ARN, or alias name for the KMS key.

If you do not specify a value for \code{PerformanceInsightsKMSKeyId}, then
Amazon RDS uses your default KMS key. There is a default KMS key for
your Amazon Web Services account. Your Amazon Web Services account has a
different default KMS key for each Amazon Web Services Region.

This setting doesn't apply to RDS Custom.}

\item{PerformanceInsightsRetentionPeriod}{The number of days to retain Performance Insights data. The default is 7
days. The following values are valid:
\itemize{
\item 7
\item \emph{month} * 31, where \emph{month} is a number of months from 1-23
\item 731
}

For example, the following values are valid:
\itemize{
\item 93 (3 months * 31)
\item 341 (11 months * 31)
\item 589 (19 months * 31)
\item 731
}

If you specify a retention period such as 94, which isn't a valid value,
RDS issues an error.

This setting doesn't apply to RDS Custom.}

\item{CloudwatchLogsExportConfiguration}{The configuration setting for the log types to be enabled for export to
CloudWatch Logs for a specific DB instance.

A change to the \code{CloudwatchLogsExportConfiguration} parameter is always
applied to the DB instance immediately. Therefore, the
\code{ApplyImmediately} parameter has no effect.

This setting doesn't apply to RDS Custom.}

\item{ProcessorFeatures}{The number of CPU cores and the number of threads per core for the DB
instance class of the DB instance.

This setting doesn't apply to RDS Custom.}

\item{UseDefaultProcessorFeatures}{A value that indicates whether the DB instance class of the DB instance
uses its default processor features.

This setting doesn't apply to RDS Custom.}

\item{DeletionProtection}{A value that indicates whether the DB instance has deletion protection
enabled. The database can't be deleted when deletion protection is
enabled. By default, deletion protection isn't enabled. For more
information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html}{Deleting a DB Instance}.}

\item{MaxAllocatedStorage}{The upper limit in gibibytes (GiB) to which Amazon RDS can automatically
scale the storage of the DB instance.

For more information about this setting, including limitations that
apply to it, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling}{Managing capacity automatically with Amazon RDS storage autoscaling}
in the \emph{Amazon RDS User Guide}.

This setting doesn't apply to RDS Custom.}

\item{CertificateRotationRestart}{A value that indicates whether the DB instance is restarted when you
rotate your SSL/TLS certificate.

By default, the DB instance is restarted when you rotate your SSL/TLS
certificate. The certificate is not updated until the DB instance is
restarted.

Set this parameter only if you are \emph{not} using SSL/TLS to connect to the
DB instance.

If you are using SSL/TLS to connect to the DB instance, follow the
appropriate instructions for your DB engine to rotate your SSL/TLS
certificate:
\itemize{
\item For more information about rotating your SSL/TLS certificate for RDS
DB engines, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL-certificate-rotation.html}{Rotating Your SSL/TLS Certificate.}
in the \emph{Amazon RDS User Guide.}
\item For more information about rotating your SSL/TLS certificate for
Aurora DB engines, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL-certificate-rotation.html}{Rotating Your SSL/TLS Certificate}
in the \emph{Amazon Aurora User Guide}.
}

This setting doesn't apply to RDS Custom.}

\item{ReplicaMode}{A value that sets the open mode of a replica database to either mounted
or read-only.

Currently, this parameter is only supported for Oracle DB instances.

Mounted DB replicas are included in Oracle Enterprise Edition. The main
use case for mounted replicas is cross-Region disaster recovery. The
primary database doesn't use Active Data Guard to transmit information
to the mounted replica. Because it doesn't accept user connections, a
mounted replica can't serve a read-only workload. For more information,
see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/oracle-read-replicas.html}{Working with Oracle Read Replicas for Amazon RDS}
in the \emph{Amazon RDS User Guide}.

This setting doesn't apply to RDS Custom.}

\item{EnableCustomerOwnedIp}{A value that indicates whether to enable a customer-owned IP address
(CoIP) for an RDS on Outposts DB instance.

A \emph{CoIP} provides local or external connectivity to resources in your
Outpost subnets through your on-premises network. For some use cases, a
CoIP can provide lower latency for connections to the DB instance from
outside of its virtual private cloud (VPC) on your local network.

For more information about RDS on Outposts, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html}{Working with Amazon RDS on Amazon Web Services Outposts}
in the \emph{Amazon RDS User Guide}.

For more information about CoIPs, see \href{https://docs.aws.amazon.com/outposts/latest/userguide/#ip-addressing}{Customer-owned IP addresses}
in the \emph{Amazon Web Services Outposts User Guide}.}

\item{AwsBackupRecoveryPointArn}{The Amazon Resource Name (ARN) of the recovery point in Amazon Web
Services Backup.

This setting doesn't apply to RDS Custom.}

\item{AutomationMode}{The automation mode of the RDS Custom DB instance: \code{full} or
\verb{all paused}. If \code{full}, the DB instance automates monitoring and
instance recovery. If \verb{all paused}, the instance pauses automation for
the duration set by \code{ResumeFullAutomationModeMinutes}.}

\item{ResumeFullAutomationModeMinutes}{The number of minutes to pause the automation. When the time period
ends, RDS Custom resumes full automation. The minimum value is \code{60}
(default). The maximum value is \verb{1,440}.}

\item{NetworkType}{The network type of the DB instance.

Valid values:
\itemize{
\item \code{IPV4}
\item \code{DUAL}
}

The network type is determined by the \code{DBSubnetGroup} specified for the
DB instance. A \code{DBSubnetGroup} can support only the IPv4 protocol or the
IPv4 and the IPv6 protocols (\code{DUAL}).

For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html}{Working with a DB instance in a VPC}
in the \emph{Amazon RDS User Guide.}}
}
\description{
Modifies settings for a DB instance. You can change one or more database configuration parameters by specifying these parameters and the new values in the request. To learn what modifications you can make to your DB instance, call \code{\link[=rds_describe_valid_db_instance_modifications]{describe_valid_db_instance_modifications}} before you call \code{\link[=rds_modify_db_instance]{modify_db_instance}}.

See \url{https://paws-r.github.io/docs/rds/modify_db_instance.html} for full documentation.
}
\keyword{internal}
