% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticache_operations.R
\name{elasticache_list_allowed_node_type_modifications}
\alias{elasticache_list_allowed_node_type_modifications}
\title{Lists all available node types that you can scale your Redis cluster's
or replication group's current node type}
\usage{
elasticache_list_allowed_node_type_modifications(
  CacheClusterId = NULL,
  ReplicationGroupId = NULL
)
}
\arguments{
\item{CacheClusterId}{The name of the cluster you want to scale up to a larger node instanced
type. ElastiCache uses the cluster id to identify the current node type
of this cluster and from that to create a list of node types you can
scale up to.

You must provide a value for either the \code{CacheClusterId} or the
\code{ReplicationGroupId}.}

\item{ReplicationGroupId}{The name of the replication group want to scale up to a larger node
type. ElastiCache uses the replication group id to identify the current
node type being used by this replication group, and from that to create
a list of node types you can scale up to.

You must provide a value for either the \code{CacheClusterId} or the
\code{ReplicationGroupId}.}
}
\description{
Lists all available node types that you can scale your Redis cluster's or replication group's current node type.

See \url{https://paws-r.github.io/docs/elasticache/list_allowed_node_type_modifications.html} for full documentation.
}
\keyword{internal}
