% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshift_operations.R
\name{redshift_modify_cluster_snapshot}
\alias{redshift_modify_cluster_snapshot}
\title{Modifies the settings for a snapshot}
\usage{
redshift_modify_cluster_snapshot(SnapshotIdentifier,
  ManualSnapshotRetentionPeriod, Force)
}
\arguments{
\item{SnapshotIdentifier}{[required] The identifier of the snapshot whose setting you want to modify.}

\item{ManualSnapshotRetentionPeriod}{The number of days that a manual snapshot is retained. If the value is
-1, the manual snapshot is retained indefinitely.

If the manual snapshot falls outside of the new retention period, you
can specify the force option to immediately delete the snapshot.

The value must be either -1 or an integer between 1 and 3,653.}

\item{Force}{A Boolean option to override an exception if the retention period has
already passed.}
}
\description{
Modifies the settings for a snapshot.
}
\details{
This exanmple modifies the manual retention period setting for a cluster
snapshot.
}
\section{Request syntax}{
\preformatted{svc$modify_cluster_snapshot(
  SnapshotIdentifier = "string",
  ManualSnapshotRetentionPeriod = 123,
  Force = TRUE|FALSE
)
}
}

\keyword{internal}
