% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticache_operations.R
\name{elasticache_decrease_node_groups_in_global_replication_group}
\alias{elasticache_decrease_node_groups_in_global_replication_group}
\title{Decreases the number of node groups in a Global Datastore}
\usage{
elasticache_decrease_node_groups_in_global_replication_group(
  GlobalReplicationGroupId, NodeGroupCount, GlobalNodeGroupsToRemove,
  GlobalNodeGroupsToRetain, ApplyImmediately)
}
\arguments{
\item{GlobalReplicationGroupId}{[required] The name of the Global Datastore}

\item{NodeGroupCount}{[required] The number of node groups (shards) that results from the modification of
the shard configuration}

\item{GlobalNodeGroupsToRemove}{If the value of NodeGroupCount is less than the current number of node
groups (shards), then either NodeGroupsToRemove or NodeGroupsToRetain is
required. NodeGroupsToRemove is a list of NodeGroupIds to remove from
the cluster. ElastiCache for Redis will attempt to remove all node
groups listed by NodeGroupsToRemove from the cluster.}

\item{GlobalNodeGroupsToRetain}{If the value of NodeGroupCount is less than the current number of node
groups (shards), then either NodeGroupsToRemove or NodeGroupsToRetain is
required. NodeGroupsToRemove is a list of NodeGroupIds to remove from
the cluster. ElastiCache for Redis will attempt to remove all node
groups listed by NodeGroupsToRemove from the cluster.}

\item{ApplyImmediately}{[required] Indicates that the shard reconfiguration process begins immediately. At
present, the only permitted value for this parameter is true.}
}
\description{
Decreases the number of node groups in a Global Datastore
}
\section{Request syntax}{
\preformatted{svc$decrease_node_groups_in_global_replication_group(
  GlobalReplicationGroupId = "string",
  NodeGroupCount = 123,
  GlobalNodeGroupsToRemove = list(
    "string"
  ),
  GlobalNodeGroupsToRetain = list(
    "string"
  ),
  ApplyImmediately = TRUE|FALSE
)
}
}

\keyword{internal}
