% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticache_operations.R
\name{elasticache_test_failover}
\alias{elasticache_test_failover}
\title{Represents the input of a TestFailover operation which test automatic
failover on a specified node group (called shard in the console) in a
replication group (called cluster in the console)}
\usage{
elasticache_test_failover(ReplicationGroupId, NodeGroupId)
}
\arguments{
\item{ReplicationGroupId}{[required] The name of the replication group (console: cluster) whose automatic
failover is being tested by this operation.}

\item{NodeGroupId}{[required] The name of the node group (called shard in the console) in this
replication group on which automatic failover is to be tested. You may
test automatic failover on up to 5 node groups in any rolling 24-hour
period.}
}
\description{
Represents the input of a \code{TestFailover} operation which test automatic
failover on a specified node group (called shard in the console) in a
replication group (called cluster in the console).
}
\details{
\strong{Note the following}
\itemize{
\item A customer can use this operation to test automatic failover on up
to 5 shards (called node groups in the ElastiCache API and AWS CLI)
in any rolling 24-hour period.
\item If calling this operation on shards in different clusters (called
replication groups in the API and CLI), the calls can be made
concurrently.
\item If calling this operation multiple times on different shards in the
same Redis (cluster mode enabled) replication group, the first node
replacement must complete before a subsequent call can be made.
\item To determine whether the node replacement is complete you can check
Events using the Amazon ElastiCache console, the AWS CLI, or the
ElastiCache API. Look for the following automatic failover related
events, listed here in order of occurrance:
}
\enumerate{
\item Replication group message:
\code{Test Failover API called for node group &lt;node-group-id&gt;}
\item Cache cluster message:
\code{Failover from master node &lt;primary-node-id&gt; to replica node &lt;node-id&gt; completed}
\item Replication group message:
\code{Failover from master node &lt;primary-node-id&gt; to replica node &lt;node-id&gt; completed}
\item Cache cluster message: \code{Recovering cache nodes &lt;node-id&gt;}
\item Cache cluster message:
\code{Finished recovery for cache nodes &lt;node-id&gt;}
}

For more information see:
\itemize{
\item \href{https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/ECEvents.Viewing.html}{Viewing ElastiCache Events}
in the \emph{ElastiCache User Guide}
\item \href{https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_DescribeEvents.html}{DescribeEvents}
in the ElastiCache API Reference
}

Also see, \href{https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/AutoFailover.html#auto-failover-test}{Testing Multi-AZ with Automatic Failover}
in the \emph{ElastiCache User Guide}.
}
\section{Request syntax}{
\preformatted{svc$test_failover(
  ReplicationGroupId = "string",
  NodeGroupId = "string"
)
}
}

\keyword{internal}
