% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticache_operations.R
\name{elasticache_increase_replica_count}
\alias{elasticache_increase_replica_count}
\title{Dynamically increases the number of replics in a Redis (cluster mode
disabled) replication group or the number of replica nodes in one or
more node groups (shards) of a Redis (cluster mode enabled) replication
group}
\usage{
elasticache_increase_replica_count(ReplicationGroupId, NewReplicaCount,
  ReplicaConfiguration, ApplyImmediately)
}
\arguments{
\item{ReplicationGroupId}{[required] The id of the replication group to which you want to add replica nodes.}

\item{NewReplicaCount}{The number of read replica nodes you want at the completion of this
operation. For Redis (cluster mode disabled) replication groups, this is
the number of replica nodes in the replication group. For Redis (cluster
mode enabled) replication groups, this is the number of replica nodes in
each of the replication group's node groups.}

\item{ReplicaConfiguration}{A list of \code{ConfigureShard} objects that can be used to configure each
shard in a Redis (cluster mode enabled) replication group. The
\code{ConfigureShard} has three members: \code{NewReplicaCount}, \code{NodeGroupId},
and \code{PreferredAvailabilityZones}.}

\item{ApplyImmediately}{[required] If \code{True}, the number of replica nodes is increased immediately.
\code{ApplyImmediately=False} is not currently supported.}
}
\description{
Dynamically increases the number of replics in a Redis (cluster mode
disabled) replication group or the number of replica nodes in one or
more node groups (shards) of a Redis (cluster mode enabled) replication
group. This operation is performed with no cluster down time.
}
\section{Request syntax}{
\preformatted{svc$increase_replica_count(
  ReplicationGroupId = "string",
  NewReplicaCount = 123,
  ReplicaConfiguration = list(
    list(
      NodeGroupId = "string",
      NewReplicaCount = 123,
      PreferredAvailabilityZones = list(
        "string"
      )
    )
  ),
  ApplyImmediately = TRUE|FALSE
)
}
}

\keyword{internal}
