% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticache_operations.R
\name{elasticache_copy_snapshot}
\alias{elasticache_copy_snapshot}
\title{Makes a copy of an existing snapshot}
\usage{
elasticache_copy_snapshot(SourceSnapshotName, TargetSnapshotName,
  TargetBucket)
}
\arguments{
\item{SourceSnapshotName}{[required] The name of an existing snapshot from which to make a copy.}

\item{TargetSnapshotName}{[required] A name for the snapshot copy. ElastiCache does not permit overwriting a
snapshot, therefore this name must be unique within its context -
ElastiCache or an Amazon S3 bucket if exporting.}

\item{TargetBucket}{The Amazon S3 bucket to which the snapshot is exported. This parameter
is used only when exporting a snapshot for external access.

When using this parameter to export a snapshot, be sure Amazon
ElastiCache has the needed permissions to this S3 bucket. For more
information, see \href{https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-grant-access}{Step 2: Grant ElastiCache Access to Your Amazon S3 Bucket}
in the \emph{Amazon ElastiCache User Guide}.

For more information, see \href{https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Snapshots.Exporting.html}{Exporting a Snapshot}
in the \emph{Amazon ElastiCache User Guide}.}
}
\description{
Makes a copy of an existing snapshot.
}
\details{
This operation is valid for Redis only.

Users or groups that have permissions to use the \code{CopySnapshot}
operation can create their own Amazon S3 buckets and copy snapshots to
it. To control access to your snapshots, use an IAM policy to control
who has the ability to use the \code{CopySnapshot} operation. For more
information about using IAM to control the use of ElastiCache
operations, see \href{https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html}{Exporting Snapshots}
and \href{https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/IAM.html}{Authentication & Access Control}.

You could receive the following error messages.

\strong{Error Messages}
\itemize{
\item \strong{Error Message:} The S3 bucket \%s is outside of the region.
}

\strong{Solution:} Create an Amazon S3 bucket in the same region as your
snapshot. For more information, see \href{https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-create-s3-bucket}{Step 1: Create an Amazon S3 Bucket}
in the ElastiCache User Guide.
\itemize{
\item \strong{Error Message:} The S3 bucket \%s does not exist.
}

\strong{Solution:} Create an Amazon S3 bucket in the same region as your
snapshot. For more information, see \href{https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-create-s3-bucket}{Step 1: Create an Amazon S3 Bucket}
in the ElastiCache User Guide.
\itemize{
\item \strong{Error Message:} The S3 bucket \%s is not owned by the
authenticated user.
}

\strong{Solution:} Create an Amazon S3 bucket in the same region as your
snapshot. For more information, see \href{https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-create-s3-bucket}{Step 1: Create an Amazon S3 Bucket}
in the ElastiCache User Guide.
\itemize{
\item \strong{Error Message:} The authenticated user does not have sufficient
permissions to perform the desired activity.
}

\strong{Solution:} Contact your system administrator to get the needed
permissions.
\itemize{
\item \strong{Error Message:} The S3 bucket \%s already contains an object with
key \%s.
}

\strong{Solution:} Give the \code{TargetSnapshotName} a new and unique value.
If exporting a snapshot, you could alternatively create a new Amazon
S3 bucket and use this same value for \code{TargetSnapshotName}.
\itemize{
\item \strong{Error Message:} ElastiCache has not been granted READ permissions
\%s on the S3 Bucket.
}

\strong{Solution:} Add List and Read permissions on the bucket. For more
information, see \href{https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-grant-access}{Step 2: Grant ElastiCache Access to Your Amazon S3 Bucket}
in the ElastiCache User Guide.
\itemize{
\item \strong{Error Message:} ElastiCache has not been granted WRITE
permissions \%s on the S3 Bucket.
}

\strong{Solution:} Add Upload/Delete permissions on the bucket. For more
information, see \href{https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-grant-access}{Step 2: Grant ElastiCache Access to Your Amazon S3 Bucket}
in the ElastiCache User Guide.
\itemize{
\item \strong{Error Message:} ElastiCache has not been granted READ\_ACP
permissions \%s on the S3 Bucket.
}

\strong{Solution:} Add View Permissions on the bucket. For more
information, see \href{https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-grant-access}{Step 2: Grant ElastiCache Access to Your Amazon S3 Bucket}
in the ElastiCache User Guide.
}
\section{Request syntax}{
\preformatted{svc$copy_snapshot(
  SourceSnapshotName = "string",
  TargetSnapshotName = "string",
  TargetBucket = "string"
)
}
}

\keyword{internal}
