% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshift_operations.R
\name{redshift_authorize_snapshot_access}
\alias{redshift_authorize_snapshot_access}
\title{Authorizes the specified AWS customer account to restore the specified
snapshot}
\usage{
redshift_authorize_snapshot_access(SnapshotIdentifier,
  SnapshotClusterIdentifier, AccountWithRestoreAccess)
}
\arguments{
\item{SnapshotIdentifier}{[required] The identifier of the snapshot the account is authorized to restore.}

\item{SnapshotClusterIdentifier}{The identifier of the cluster the snapshot was created from. This
parameter is required if your IAM user has a policy containing a
snapshot resource element that specifies anything other than * for the
cluster name.}

\item{AccountWithRestoreAccess}{[required] The identifier of the AWS customer account authorized to restore the
specified snapshot.

To share a snapshot with AWS support, specify amazon-redshift-support.}
}
\value{
A list with the following syntax:\preformatted{list(
  Snapshot = list(
    SnapshotIdentifier = "string",
    ClusterIdentifier = "string",
    SnapshotCreateTime = as.POSIXct(
      "2015-01-01"
    ),
    Status = "string",
    Port = 123,
    AvailabilityZone = "string",
    ClusterCreateTime = as.POSIXct(
      "2015-01-01"
    ),
    MasterUsername = "string",
    ClusterVersion = "string",
    EngineFullVersion = "string",
    SnapshotType = "string",
    NodeType = "string",
    NumberOfNodes = 123,
    DBName = "string",
    VpcId = "string",
    Encrypted = TRUE|FALSE,
    KmsKeyId = "string",
    EncryptedWithHSM = TRUE|FALSE,
    AccountsWithRestoreAccess = list(
      list(
        AccountId = "string",
        AccountAlias = "string"
      )
    ),
    OwnerAccount = "string",
    TotalBackupSizeInMegaBytes = 123.0,
    ActualIncrementalBackupSizeInMegaBytes = 123.0,
    BackupProgressInMegaBytes = 123.0,
    CurrentBackupRateInMegaBytesPerSecond = 123.0,
    EstimatedSecondsToCompletion = 123,
    ElapsedTimeInSeconds = 123,
    SourceRegion = "string",
    Tags = list(
      list(
        Key = "string",
        Value = "string"
      )
    ),
    RestorableNodeTypes = list(
      "string"
    ),
    EnhancedVpcRouting = TRUE|FALSE,
    MaintenanceTrackName = "string",
    ManualSnapshotRetentionPeriod = 123,
    ManualSnapshotRemainingDays = 123,
    SnapshotRetentionStartTime = as.POSIXct(
      "2015-01-01"
    )
  )
)
}
}
\description{
Authorizes the specified AWS customer account to restore the specified
snapshot.

For more information about working with snapshots, go to \href{https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html}{Amazon Redshift Snapshots}
in the \emph{Amazon Redshift Cluster Management Guide}.
}
\section{Request syntax}{
\preformatted{svc$authorize_snapshot_access(
  SnapshotIdentifier = "string",
  SnapshotClusterIdentifier = "string",
  AccountWithRestoreAccess = "string"
)
}
}

\keyword{internal}
