% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neptune_operations.R
\name{neptune_remove_tags_from_resource}
\alias{neptune_remove_tags_from_resource}
\title{Removes metadata tags from an Amazon Neptune resource}
\usage{
neptune_remove_tags_from_resource(ResourceName, TagKeys)
}
\arguments{
\item{ResourceName}{[required] The Amazon Neptune resource that the tags are removed from. This value
is an Amazon Resource Name (ARN). For information about creating an ARN,
see \href{https://docs.aws.amazon.com/neptune/latest/userguide/#tagging.ARN.Constructing}{Constructing an Amazon Resource Name (ARN)}.}

\item{TagKeys}{[required] The tag key (name) of the tag to be removed.}
}
\value{
An empty list.
}
\description{
Removes metadata tags from an Amazon Neptune resource.
}
\section{Request syntax}{
\preformatted{svc$remove_tags_from_resource(
  ResourceName = "string",
  TagKeys = list(
    "string"
  )
)
}
}

\keyword{internal}
