% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_restore_db_cluster_from_snapshot}
\alias{rds_restore_db_cluster_from_snapshot}
\title{Creates a new DB cluster from a DB snapshot or DB cluster snapshot}
\usage{
rds_restore_db_cluster_from_snapshot(AvailabilityZones,
  DBClusterIdentifier, SnapshotIdentifier, Engine, EngineVersion, Port,
  DBSubnetGroupName, DatabaseName, OptionGroupName, VpcSecurityGroupIds,
  Tags, KmsKeyId, EnableIAMDatabaseAuthentication, BacktrackWindow,
  EnableCloudwatchLogsExports, EngineMode, ScalingConfiguration,
  DBClusterParameterGroupName, DeletionProtection, CopyTagsToSnapshot)
}
\arguments{
\item{AvailabilityZones}{Provides the list of Amazon EC2 Availability Zones that instances in the
restored DB cluster can be created in.}

\item{DBClusterIdentifier}{[required] The name of the DB cluster to create from the DB snapshot or DB cluster
snapshot. This parameter isn't case-sensitive.

Constraints:
\itemize{
\item Must contain from 1 to 63 letters, numbers, or hyphens
\item First character must be a letter
\item Can't end with a hyphen or contain two consecutive hyphens
}

Example: \code{my-snapshot-id}}

\item{SnapshotIdentifier}{[required] The identifier for the DB snapshot or DB cluster snapshot to restore
from.

You can use either the name or the Amazon Resource Name (ARN) to specify
a DB cluster snapshot. However, you can use only the ARN to specify a DB
snapshot.

Constraints:
\itemize{
\item Must match the identifier of an existing Snapshot.
}}

\item{Engine}{[required] The database engine to use for the new DB cluster.

Default: The same as source

Constraint: Must be compatible with the engine of the source}

\item{EngineVersion}{The version of the database engine to use for the new DB cluster.}

\item{Port}{The port number on which the new DB cluster accepts connections.

Constraints: This value must be \code{1150-65535}

Default: The same port as the original DB cluster.}

\item{DBSubnetGroupName}{The name of the DB subnet group to use for the new DB cluster.

Constraints: If supplied, must match the name of an existing DB subnet
group.

Example: \code{mySubnetgroup}}

\item{DatabaseName}{The database name for the restored DB cluster.}

\item{OptionGroupName}{The name of the option group to use for the restored DB cluster.}

\item{VpcSecurityGroupIds}{A list of VPC security groups that the new DB cluster will belong to.}

\item{Tags}{The tags to be assigned to the restored DB cluster.}

\item{KmsKeyId}{The AWS KMS key identifier to use when restoring an encrypted DB cluster
from a DB snapshot or DB cluster snapshot.

The KMS key identifier is the Amazon Resource Name (ARN) for the KMS
encryption key. If you are restoring a DB cluster with the same AWS
account that owns the KMS encryption key used to encrypt the new DB
cluster, then you can use the KMS key alias instead of the ARN for the
KMS encryption key.

If you don't specify a value for the \code{KmsKeyId} parameter, then the
following occurs:
\itemize{
\item If the DB snapshot or DB cluster snapshot in \code{SnapshotIdentifier} is
encrypted, then the restored DB cluster is encrypted using the KMS
key that was used to encrypt the DB snapshot or DB cluster snapshot.
\item If the DB snapshot or DB cluster snapshot in \code{SnapshotIdentifier} is
not encrypted, then the restored DB cluster is not encrypted.
}}

\item{EnableIAMDatabaseAuthentication}{True to enable mapping of AWS Identity and Access Management (IAM)
accounts to database accounts, and otherwise false.

Default: \code{false}}

\item{BacktrackWindow}{The target backtrack window, in seconds. To disable backtracking, set
this value to 0.

Default: 0

Constraints:
\itemize{
\item If specified, this value must be set to a number from 0 to 259,200
(72 hours).
}}

\item{EnableCloudwatchLogsExports}{The list of logs that the restored DB cluster is to export to Amazon
CloudWatch Logs. The values in the list depend on the DB engine being
used. For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch}{Publishing Database Logs to Amazon CloudWatch Logs}
in the \emph{Amazon Aurora User Guide}.}

\item{EngineMode}{The DB engine mode of the DB cluster, either \code{provisioned},
\code{serverless}, or \code{parallelquery}.}

\item{ScalingConfiguration}{For DB clusters in \code{serverless} DB engine mode, the scaling properties
of the DB cluster.}

\item{DBClusterParameterGroupName}{The name of the DB cluster parameter group to associate with this DB
cluster. If this argument is omitted, the default DB cluster parameter
group for the specified engine is used.

Constraints:
\itemize{
\item If supplied, must match the name of an existing default DB cluster
parameter group.
\item Must be 1 to 255 letters, numbers, or hyphens.
\item First character must be a letter.
\item Can't end with a hyphen or contain two consecutive hyphens.
}}

\item{DeletionProtection}{Indicates if the DB cluster should have deletion protection enabled. The
database can't be deleted when this value is set to true. The default
is false.}

\item{CopyTagsToSnapshot}{True to copy all tags from the restored DB cluster to snapshots of the
restored DB cluster, and otherwise false. The default is false.}
}
\description{
Creates a new DB cluster from a DB snapshot or DB cluster snapshot.
}
\details{
If a DB snapshot is specified, the target DB cluster is created from the
source DB snapshot with a default configuration and default security
group.

If a DB cluster snapshot is specified, the target DB cluster is created
from the source DB cluster restore point with the same configuration as
the original source DB cluster, except that the new DB cluster is
created with the default security group.

For more information on Amazon Aurora, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html}{What Is Amazon Aurora?}
in the \emph{Amazon Aurora User Guide.}

This action only applies to Aurora DB clusters.
}
\section{Request syntax}{
\preformatted{svc$restore_db_cluster_from_snapshot(
  AvailabilityZones = list(
    "string"
  ),
  DBClusterIdentifier = "string",
  SnapshotIdentifier = "string",
  Engine = "string",
  EngineVersion = "string",
  Port = 123,
  DBSubnetGroupName = "string",
  DatabaseName = "string",
  OptionGroupName = "string",
  VpcSecurityGroupIds = list(
    "string"
  ),
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  ),
  KmsKeyId = "string",
  EnableIAMDatabaseAuthentication = TRUE|FALSE,
  BacktrackWindow = 123,
  EnableCloudwatchLogsExports = list(
    "string"
  ),
  EngineMode = "string",
  ScalingConfiguration = list(
    MinCapacity = 123,
    MaxCapacity = 123,
    AutoPause = TRUE|FALSE,
    SecondsUntilAutoPause = 123
  ),
  DBClusterParameterGroupName = "string",
  DeletionProtection = TRUE|FALSE,
  CopyTagsToSnapshot = TRUE|FALSE
)
}
}

\keyword{internal}
