% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_reset_db_cluster_parameter_group}
\alias{rds_reset_db_cluster_parameter_group}
\title{Modifies the parameters of a DB cluster parameter group to the default
value}
\usage{
rds_reset_db_cluster_parameter_group(DBClusterParameterGroupName,
  ResetAllParameters, Parameters)
}
\arguments{
\item{DBClusterParameterGroupName}{[required] The name of the DB cluster parameter group to reset.}

\item{ResetAllParameters}{A value that is set to \code{true} to reset all parameters in the DB cluster
parameter group to their default values, and \code{false} otherwise. You
can't use this parameter if there is a list of parameter names
specified for the \code{Parameters} parameter.}

\item{Parameters}{A list of parameter names in the DB cluster parameter group to reset to
the default values. You can't use this parameter if the
\code{ResetAllParameters} parameter is set to \code{true}.}
}
\description{
Modifies the parameters of a DB cluster parameter group to the default
value. To reset specific parameters submit a list of the following:
\code{ParameterName} and \code{ApplyMethod}. To reset the entire DB cluster
parameter group, specify the \code{DBClusterParameterGroupName} and
\code{ResetAllParameters} parameters.
}
\details{
When resetting the entire group, dynamic parameters are updated
immediately and static parameters are set to \code{pending-reboot} to take
effect on the next DB instance restart or RebootDBInstance request. You
must call RebootDBInstance for every DB instance in your DB cluster that
you want the updated static parameter to apply to.

For more information on Amazon Aurora, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html}{What Is Amazon Aurora?}
in the \emph{Amazon Aurora User Guide.}

This action only applies to Aurora DB clusters.
}
\section{Request syntax}{
\preformatted{svc$reset_db_cluster_parameter_group(
  DBClusterParameterGroupName = "string",
  ResetAllParameters = TRUE|FALSE,
  Parameters = list(
    list(
      ParameterName = "string",
      ParameterValue = "string",
      Description = "string",
      Source = "string",
      ApplyType = "string",
      DataType = "string",
      AllowedValues = "string",
      IsModifiable = TRUE|FALSE,
      MinimumEngineVersion = "string",
      ApplyMethod = "immediate"|"pending-reboot",
      SupportedEngineModes = list(
        "string"
      )
    )
  )
)
}
}

\keyword{internal}
