% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sesv2_operations.R
\name{sesv2_put_account_details}
\alias{sesv2_put_account_details}
\title{Update your Amazon SES account details}
\usage{
sesv2_put_account_details(
  MailType,
  WebsiteURL,
  ContactLanguage = NULL,
  UseCaseDescription,
  AdditionalContactEmailAddresses = NULL,
  ProductionAccessEnabled = NULL
)
}
\arguments{
\item{MailType}{[required] The type of email your account will send.}

\item{WebsiteURL}{[required] The URL of your website. This information helps us better understand the
type of content that you plan to send.}

\item{ContactLanguage}{The language you would prefer to be contacted with.}

\item{UseCaseDescription}{[required] A description of the types of email that you plan to send.}

\item{AdditionalContactEmailAddresses}{Additional email addresses that you would like to be notified regarding
Amazon SES matters.}

\item{ProductionAccessEnabled}{Indicates whether or not your account should have production access in
the current Amazon Web Services Region.

If the value is \code{false}, then your account is in the \emph{sandbox}. When
your account is in the sandbox, you can only send email to verified
identities.

If the value is \code{true}, then your account has production access. When
your account has production access, you can send email to any address.
The sending quota and maximum sending rate for your account vary based
on your specific use case.}
}
\description{
Update your Amazon SES account details.

See \url{https://www.paws-r-sdk.com/docs/sesv2_put_account_details/} for full documentation.
}
\keyword{internal}
