# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include connect_service.R
NULL

#' Activates an evaluation form in the specified Amazon Connect instance
#'
#' @description
#' Activates an evaluation form in the specified Amazon Connect instance. After the evaluation form is activated, it is available to start new evaluations based on the form.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_activate_evaluation_form/](https://www.paws-r-sdk.com/docs/connect_activate_evaluation_form/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param EvaluationFormId &#91;required&#93; The unique identifier for the evaluation form.
#' @param EvaluationFormVersion &#91;required&#93; The version of the evaluation form to activate. If the version property
#' is not provided, the latest version of the evaluation form is activated.
#'
#' @keywords internal
#'
#' @rdname connect_activate_evaluation_form
connect_activate_evaluation_form <- function(InstanceId, EvaluationFormId, EvaluationFormVersion) {
  op <- new_operation(
    name = "ActivateEvaluationForm",
    http_method = "POST",
    http_path = "/evaluation-forms/{InstanceId}/{EvaluationFormId}/activate",
    paginator = list()
  )
  input <- .connect$activate_evaluation_form_input(InstanceId = InstanceId, EvaluationFormId = EvaluationFormId, EvaluationFormVersion = EvaluationFormVersion)
  output <- .connect$activate_evaluation_form_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$activate_evaluation_form <- connect_activate_evaluation_form

#' This API is in preview release for Amazon Connect and is subject to
#' change
#'
#' @description
#' This API is in preview release for Amazon Connect and is subject to change.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_associate_analytics_data_set/](https://www.paws-r-sdk.com/docs/connect_associate_analytics_data_set/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param DataSetId &#91;required&#93; The identifier of the dataset to associate with the target account.
#' @param TargetAccountId The identifier of the target account. Use to associate a dataset to a
#' different account than the one containing the Amazon Connect instance.
#' If not specified, by default this value is the Amazon Web Services
#' account that has the Amazon Connect instance.
#'
#' @keywords internal
#'
#' @rdname connect_associate_analytics_data_set
connect_associate_analytics_data_set <- function(InstanceId, DataSetId, TargetAccountId = NULL) {
  op <- new_operation(
    name = "AssociateAnalyticsDataSet",
    http_method = "PUT",
    http_path = "/analytics-data/instance/{InstanceId}/association",
    paginator = list()
  )
  input <- .connect$associate_analytics_data_set_input(InstanceId = InstanceId, DataSetId = DataSetId, TargetAccountId = TargetAccountId)
  output <- .connect$associate_analytics_data_set_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$associate_analytics_data_set <- connect_associate_analytics_data_set

#' This API is in preview release for Amazon Connect and is subject to
#' change
#'
#' @description
#' This API is in preview release for Amazon Connect and is subject to change.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_associate_approved_origin/](https://www.paws-r-sdk.com/docs/connect_associate_approved_origin/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param Origin &#91;required&#93; The domain to add to your allow list.
#'
#' @keywords internal
#'
#' @rdname connect_associate_approved_origin
connect_associate_approved_origin <- function(InstanceId, Origin) {
  op <- new_operation(
    name = "AssociateApprovedOrigin",
    http_method = "PUT",
    http_path = "/instance/{InstanceId}/approved-origin",
    paginator = list()
  )
  input <- .connect$associate_approved_origin_input(InstanceId = InstanceId, Origin = Origin)
  output <- .connect$associate_approved_origin_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$associate_approved_origin <- connect_associate_approved_origin

#' This API is in preview release for Amazon Connect and is subject to
#' change
#'
#' @description
#' This API is in preview release for Amazon Connect and is subject to change.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_associate_bot/](https://www.paws-r-sdk.com/docs/connect_associate_bot/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param LexBot 
#' @param LexV2Bot The Amazon Lex V2 bot to associate with the instance.
#'
#' @keywords internal
#'
#' @rdname connect_associate_bot
connect_associate_bot <- function(InstanceId, LexBot = NULL, LexV2Bot = NULL) {
  op <- new_operation(
    name = "AssociateBot",
    http_method = "PUT",
    http_path = "/instance/{InstanceId}/bot",
    paginator = list()
  )
  input <- .connect$associate_bot_input(InstanceId = InstanceId, LexBot = LexBot, LexV2Bot = LexV2Bot)
  output <- .connect$associate_bot_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$associate_bot <- connect_associate_bot

#' Associates an existing vocabulary as the default
#'
#' @description
#' Associates an existing vocabulary as the default. Contact Lens for Amazon Connect uses the vocabulary in post-call and real-time analysis sessions for the given language.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_associate_default_vocabulary/](https://www.paws-r-sdk.com/docs/connect_associate_default_vocabulary/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param LanguageCode &#91;required&#93; The language code of the vocabulary entries. For a list of languages and
#' their corresponding language codes, see [What is Amazon
#' Transcribe?](https://docs.aws.amazon.com/transcribe/latest/dg/what-is.html)
#' @param VocabularyId The identifier of the custom vocabulary. If this is empty, the default
#' is set to none.
#'
#' @keywords internal
#'
#' @rdname connect_associate_default_vocabulary
connect_associate_default_vocabulary <- function(InstanceId, LanguageCode, VocabularyId = NULL) {
  op <- new_operation(
    name = "AssociateDefaultVocabulary",
    http_method = "PUT",
    http_path = "/default-vocabulary/{InstanceId}/{LanguageCode}",
    paginator = list()
  )
  input <- .connect$associate_default_vocabulary_input(InstanceId = InstanceId, LanguageCode = LanguageCode, VocabularyId = VocabularyId)
  output <- .connect$associate_default_vocabulary_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$associate_default_vocabulary <- connect_associate_default_vocabulary

#' Associates a connect resource to a flow
#'
#' @description
#' Associates a connect resource to a flow.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_associate_flow/](https://www.paws-r-sdk.com/docs/connect_associate_flow/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param ResourceId &#91;required&#93; The identifier of the resource.
#' @param FlowId &#91;required&#93; The identifier of the flow.
#' @param ResourceType &#91;required&#93; A valid resource type.
#'
#' @keywords internal
#'
#' @rdname connect_associate_flow
connect_associate_flow <- function(InstanceId, ResourceId, FlowId, ResourceType) {
  op <- new_operation(
    name = "AssociateFlow",
    http_method = "PUT",
    http_path = "/flow-associations/{InstanceId}",
    paginator = list()
  )
  input <- .connect$associate_flow_input(InstanceId = InstanceId, ResourceId = ResourceId, FlowId = FlowId, ResourceType = ResourceType)
  output <- .connect$associate_flow_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$associate_flow <- connect_associate_flow

#' This API is in preview release for Amazon Connect and is subject to
#' change
#'
#' @description
#' This API is in preview release for Amazon Connect and is subject to change.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_associate_instance_storage_config/](https://www.paws-r-sdk.com/docs/connect_associate_instance_storage_config/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param ResourceType &#91;required&#93; A valid resource type. To [enable streaming for real-time analysis of
#' contacts](https://docs.aws.amazon.com/connect/latest/adminguide/enable-contact-analysis-segment-streams.html),
#' use the following types:
#' 
#' -   For chat contacts, use `REAL_TIME_CONTACT_ANALYSIS_CHAT_SEGMENTS`.
#' 
#' -   For voice contacts, use `REAL_TIME_CONTACT_ANALYSIS_VOICE_SEGMENTS`.
#' 
#' `REAL_TIME_CONTACT_ANALYSIS_SEGMENTS` is deprecated, but it is still
#' supported and will apply only to VOICE channel contacts. Use
#' `REAL_TIME_CONTACT_ANALYSIS_VOICE_SEGMENTS` for voice contacts moving
#' forward.
#' 
#' If you have previously associated a stream with
#' `REAL_TIME_CONTACT_ANALYSIS_SEGMENTS`, no action is needed to update the
#' stream to `REAL_TIME_CONTACT_ANALYSIS_VOICE_SEGMENTS`.
#' @param StorageConfig &#91;required&#93; A valid storage type.
#'
#' @keywords internal
#'
#' @rdname connect_associate_instance_storage_config
connect_associate_instance_storage_config <- function(InstanceId, ResourceType, StorageConfig) {
  op <- new_operation(
    name = "AssociateInstanceStorageConfig",
    http_method = "PUT",
    http_path = "/instance/{InstanceId}/storage-config",
    paginator = list()
  )
  input <- .connect$associate_instance_storage_config_input(InstanceId = InstanceId, ResourceType = ResourceType, StorageConfig = StorageConfig)
  output <- .connect$associate_instance_storage_config_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$associate_instance_storage_config <- connect_associate_instance_storage_config

#' This API is in preview release for Amazon Connect and is subject to
#' change
#'
#' @description
#' This API is in preview release for Amazon Connect and is subject to change.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_associate_lambda_function/](https://www.paws-r-sdk.com/docs/connect_associate_lambda_function/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param FunctionArn &#91;required&#93; The Amazon Resource Name (ARN) for the Lambda function being associated.
#' Maximum number of characters allowed is 140.
#'
#' @keywords internal
#'
#' @rdname connect_associate_lambda_function
connect_associate_lambda_function <- function(InstanceId, FunctionArn) {
  op <- new_operation(
    name = "AssociateLambdaFunction",
    http_method = "PUT",
    http_path = "/instance/{InstanceId}/lambda-function",
    paginator = list()
  )
  input <- .connect$associate_lambda_function_input(InstanceId = InstanceId, FunctionArn = FunctionArn)
  output <- .connect$associate_lambda_function_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$associate_lambda_function <- connect_associate_lambda_function

#' This API is in preview release for Amazon Connect and is subject to
#' change
#'
#' @description
#' This API is in preview release for Amazon Connect and is subject to change.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_associate_lex_bot/](https://www.paws-r-sdk.com/docs/connect_associate_lex_bot/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param LexBot &#91;required&#93; The Amazon Lex bot to associate with the instance.
#'
#' @keywords internal
#'
#' @rdname connect_associate_lex_bot
connect_associate_lex_bot <- function(InstanceId, LexBot) {
  op <- new_operation(
    name = "AssociateLexBot",
    http_method = "PUT",
    http_path = "/instance/{InstanceId}/lex-bot",
    paginator = list()
  )
  input <- .connect$associate_lex_bot_input(InstanceId = InstanceId, LexBot = LexBot)
  output <- .connect$associate_lex_bot_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$associate_lex_bot <- connect_associate_lex_bot

#' Associates a flow with a phone number claimed to your Amazon Connect
#' instance
#'
#' @description
#' Associates a flow with a phone number claimed to your Amazon Connect instance.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_associate_phone_number_contact_flow/](https://www.paws-r-sdk.com/docs/connect_associate_phone_number_contact_flow/) for full documentation.
#'
#' @param PhoneNumberId &#91;required&#93; A unique identifier for the phone number.
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param ContactFlowId &#91;required&#93; The identifier of the flow.
#'
#' @keywords internal
#'
#' @rdname connect_associate_phone_number_contact_flow
connect_associate_phone_number_contact_flow <- function(PhoneNumberId, InstanceId, ContactFlowId) {
  op <- new_operation(
    name = "AssociatePhoneNumberContactFlow",
    http_method = "PUT",
    http_path = "/phone-number/{PhoneNumberId}/contact-flow",
    paginator = list()
  )
  input <- .connect$associate_phone_number_contact_flow_input(PhoneNumberId = PhoneNumberId, InstanceId = InstanceId, ContactFlowId = ContactFlowId)
  output <- .connect$associate_phone_number_contact_flow_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$associate_phone_number_contact_flow <- connect_associate_phone_number_contact_flow

#' This API is in preview release for Amazon Connect and is subject to
#' change
#'
#' @description
#' This API is in preview release for Amazon Connect and is subject to change.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_associate_queue_quick_connects/](https://www.paws-r-sdk.com/docs/connect_associate_queue_quick_connects/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param QueueId &#91;required&#93; The identifier for the queue.
#' @param QuickConnectIds &#91;required&#93; The quick connects to associate with this queue.
#'
#' @keywords internal
#'
#' @rdname connect_associate_queue_quick_connects
connect_associate_queue_quick_connects <- function(InstanceId, QueueId, QuickConnectIds) {
  op <- new_operation(
    name = "AssociateQueueQuickConnects",
    http_method = "POST",
    http_path = "/queues/{InstanceId}/{QueueId}/associate-quick-connects",
    paginator = list()
  )
  input <- .connect$associate_queue_quick_connects_input(InstanceId = InstanceId, QueueId = QueueId, QuickConnectIds = QuickConnectIds)
  output <- .connect$associate_queue_quick_connects_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$associate_queue_quick_connects <- connect_associate_queue_quick_connects

#' Associates a set of queues with a routing profile
#'
#' @description
#' Associates a set of queues with a routing profile.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_associate_routing_profile_queues/](https://www.paws-r-sdk.com/docs/connect_associate_routing_profile_queues/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param RoutingProfileId &#91;required&#93; The identifier of the routing profile.
#' @param QueueConfigs &#91;required&#93; The queues to associate with this routing profile.
#'
#' @keywords internal
#'
#' @rdname connect_associate_routing_profile_queues
connect_associate_routing_profile_queues <- function(InstanceId, RoutingProfileId, QueueConfigs) {
  op <- new_operation(
    name = "AssociateRoutingProfileQueues",
    http_method = "POST",
    http_path = "/routing-profiles/{InstanceId}/{RoutingProfileId}/associate-queues",
    paginator = list()
  )
  input <- .connect$associate_routing_profile_queues_input(InstanceId = InstanceId, RoutingProfileId = RoutingProfileId, QueueConfigs = QueueConfigs)
  output <- .connect$associate_routing_profile_queues_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$associate_routing_profile_queues <- connect_associate_routing_profile_queues

#' This API is in preview release for Amazon Connect and is subject to
#' change
#'
#' @description
#' This API is in preview release for Amazon Connect and is subject to change.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_associate_security_key/](https://www.paws-r-sdk.com/docs/connect_associate_security_key/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param Key &#91;required&#93; A valid security key in PEM format.
#'
#' @keywords internal
#'
#' @rdname connect_associate_security_key
connect_associate_security_key <- function(InstanceId, Key) {
  op <- new_operation(
    name = "AssociateSecurityKey",
    http_method = "PUT",
    http_path = "/instance/{InstanceId}/security-key",
    paginator = list()
  )
  input <- .connect$associate_security_key_input(InstanceId = InstanceId, Key = Key)
  output <- .connect$associate_security_key_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$associate_security_key <- connect_associate_security_key

#' Associates an agent with a traffic distribution group
#'
#' @description
#' Associates an agent with a traffic distribution group.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_associate_traffic_distribution_group_user/](https://www.paws-r-sdk.com/docs/connect_associate_traffic_distribution_group_user/) for full documentation.
#'
#' @param TrafficDistributionGroupId &#91;required&#93; The identifier of the traffic distribution group. This can be the ID or
#' the ARN if the API is being called in the Region where the traffic
#' distribution group was created. The ARN must be provided if the call is
#' from the replicated Region.
#' @param UserId &#91;required&#93; The identifier of the user account. This can be the ID or the ARN of the
#' user.
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#'
#' @keywords internal
#'
#' @rdname connect_associate_traffic_distribution_group_user
connect_associate_traffic_distribution_group_user <- function(TrafficDistributionGroupId, UserId, InstanceId) {
  op <- new_operation(
    name = "AssociateTrafficDistributionGroupUser",
    http_method = "PUT",
    http_path = "/traffic-distribution-group/{TrafficDistributionGroupId}/user",
    paginator = list()
  )
  input <- .connect$associate_traffic_distribution_group_user_input(TrafficDistributionGroupId = TrafficDistributionGroupId, UserId = UserId, InstanceId = InstanceId)
  output <- .connect$associate_traffic_distribution_group_user_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$associate_traffic_distribution_group_user <- connect_associate_traffic_distribution_group_user

#' >Associates a set of proficiencies with a user
#'
#' @description
#' \>Associates a set of proficiencies with a user.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_associate_user_proficiencies/](https://www.paws-r-sdk.com/docs/connect_associate_user_proficiencies/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can find the instance
#' ID in the Amazon Resource Name (ARN of the instance).
#' @param UserId &#91;required&#93; The identifier of the user account.
#' @param UserProficiencies &#91;required&#93; The proficiencies to associate with the user.
#'
#' @keywords internal
#'
#' @rdname connect_associate_user_proficiencies
connect_associate_user_proficiencies <- function(InstanceId, UserId, UserProficiencies) {
  op <- new_operation(
    name = "AssociateUserProficiencies",
    http_method = "POST",
    http_path = "/users/{InstanceId}/{UserId}/associate-proficiencies",
    paginator = list()
  )
  input <- .connect$associate_user_proficiencies_input(InstanceId = InstanceId, UserId = UserId, UserProficiencies = UserProficiencies)
  output <- .connect$associate_user_proficiencies_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$associate_user_proficiencies <- connect_associate_user_proficiencies

#' This API is in preview release for Amazon Connect and is subject to
#' change
#'
#' @description
#' This API is in preview release for Amazon Connect and is subject to change.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_batch_associate_analytics_data_set/](https://www.paws-r-sdk.com/docs/connect_batch_associate_analytics_data_set/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param DataSetIds &#91;required&#93; An array of dataset identifiers to associate.
#' @param TargetAccountId The identifier of the target account. Use to associate a dataset to a
#' different account than the one containing the Amazon Connect instance.
#' If not specified, by default this value is the Amazon Web Services
#' account that has the Amazon Connect instance.
#'
#' @keywords internal
#'
#' @rdname connect_batch_associate_analytics_data_set
connect_batch_associate_analytics_data_set <- function(InstanceId, DataSetIds, TargetAccountId = NULL) {
  op <- new_operation(
    name = "BatchAssociateAnalyticsDataSet",
    http_method = "PUT",
    http_path = "/analytics-data/instance/{InstanceId}/associations",
    paginator = list()
  )
  input <- .connect$batch_associate_analytics_data_set_input(InstanceId = InstanceId, DataSetIds = DataSetIds, TargetAccountId = TargetAccountId)
  output <- .connect$batch_associate_analytics_data_set_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$batch_associate_analytics_data_set <- connect_batch_associate_analytics_data_set

#' This API is in preview release for Amazon Connect and is subject to
#' change
#'
#' @description
#' This API is in preview release for Amazon Connect and is subject to change.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_batch_disassociate_analytics_data_set/](https://www.paws-r-sdk.com/docs/connect_batch_disassociate_analytics_data_set/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param DataSetIds &#91;required&#93; An array of associated dataset identifiers to remove.
#' @param TargetAccountId The identifier of the target account. Use to disassociate a dataset from
#' a different account than the one containing the Amazon Connect instance.
#' If not specified, by default this value is the Amazon Web Services
#' account that has the Amazon Connect instance.
#'
#' @keywords internal
#'
#' @rdname connect_batch_disassociate_analytics_data_set
connect_batch_disassociate_analytics_data_set <- function(InstanceId, DataSetIds, TargetAccountId = NULL) {
  op <- new_operation(
    name = "BatchDisassociateAnalyticsDataSet",
    http_method = "POST",
    http_path = "/analytics-data/instance/{InstanceId}/associations",
    paginator = list()
  )
  input <- .connect$batch_disassociate_analytics_data_set_input(InstanceId = InstanceId, DataSetIds = DataSetIds, TargetAccountId = TargetAccountId)
  output <- .connect$batch_disassociate_analytics_data_set_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$batch_disassociate_analytics_data_set <- connect_batch_disassociate_analytics_data_set

#' Retrieve the flow associations for the given resources
#'
#' @description
#' Retrieve the flow associations for the given resources.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_batch_get_flow_association/](https://www.paws-r-sdk.com/docs/connect_batch_get_flow_association/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param ResourceIds &#91;required&#93; A list of resource identifiers to retrieve flow associations.
#' @param ResourceType The type of resource association.
#'
#' @keywords internal
#'
#' @rdname connect_batch_get_flow_association
connect_batch_get_flow_association <- function(InstanceId, ResourceIds, ResourceType = NULL) {
  op <- new_operation(
    name = "BatchGetFlowAssociation",
    http_method = "POST",
    http_path = "/flow-associations-batch/{InstanceId}",
    paginator = list()
  )
  input <- .connect$batch_get_flow_association_input(InstanceId = InstanceId, ResourceIds = ResourceIds, ResourceType = ResourceType)
  output <- .connect$batch_get_flow_association_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$batch_get_flow_association <- connect_batch_get_flow_association

#' Only the Amazon Connect outbound campaigns service principal is allowed
#' to assume a role in your account and call this API
#'
#' @description
#' Only the Amazon Connect outbound campaigns service principal is allowed to assume a role in your account and call this API.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_batch_put_contact/](https://www.paws-r-sdk.com/docs/connect_batch_put_contact/) for full documentation.
#'
#' @param ClientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If not provided, the Amazon Web Services SDK
#' populates this field. For more information about idempotency, see
#' [Making retries safe with idempotent
#' APIs](https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param ContactDataRequestList &#91;required&#93; List of individual contact requests.
#'
#' @keywords internal
#'
#' @rdname connect_batch_put_contact
connect_batch_put_contact <- function(ClientToken = NULL, InstanceId, ContactDataRequestList) {
  op <- new_operation(
    name = "BatchPutContact",
    http_method = "PUT",
    http_path = "/contact/batch/{InstanceId}",
    paginator = list()
  )
  input <- .connect$batch_put_contact_input(ClientToken = ClientToken, InstanceId = InstanceId, ContactDataRequestList = ContactDataRequestList)
  output <- .connect$batch_put_contact_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$batch_put_contact <- connect_batch_put_contact

#' Claims an available phone number to your Amazon Connect instance or
#' traffic distribution group
#'
#' @description
#' Claims an available phone number to your Amazon Connect instance or traffic distribution group. You can call this API only in the same Amazon Web Services Region where the Amazon Connect instance or traffic distribution group was created.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_claim_phone_number/](https://www.paws-r-sdk.com/docs/connect_claim_phone_number/) for full documentation.
#'
#' @param TargetArn The Amazon Resource Name (ARN) for Amazon Connect instances or traffic
#' distribution groups that phone number inbound traffic is routed through.
#' You must enter `InstanceId` or `TargetArn`.
#' @param InstanceId The identifier of the Amazon Connect instance that phone numbers are
#' claimed to. You can [find the instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance. You must enter
#' `InstanceId` or `TargetArn`.
#' @param PhoneNumber &#91;required&#93; The phone number you want to claim. Phone numbers are formatted
#' `[+] [country code] [subscriber number including area code]`.
#' @param PhoneNumberDescription The description of the phone number.
#' @param Tags The tags used to organize, track, or control access for this resource.
#' For example, \{ "Tags": \{"key1":"value1", "key2":"value2"\} \}.
#' @param ClientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If not provided, the Amazon Web Services SDK
#' populates this field. For more information about idempotency, see
#' [Making retries safe with idempotent
#' APIs](https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
#' 
#' Pattern:
#' `^[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}$`
#'
#' @keywords internal
#'
#' @rdname connect_claim_phone_number
connect_claim_phone_number <- function(TargetArn = NULL, InstanceId = NULL, PhoneNumber, PhoneNumberDescription = NULL, Tags = NULL, ClientToken = NULL) {
  op <- new_operation(
    name = "ClaimPhoneNumber",
    http_method = "POST",
    http_path = "/phone-number/claim",
    paginator = list()
  )
  input <- .connect$claim_phone_number_input(TargetArn = TargetArn, InstanceId = InstanceId, PhoneNumber = PhoneNumber, PhoneNumberDescription = PhoneNumberDescription, Tags = Tags, ClientToken = ClientToken)
  output <- .connect$claim_phone_number_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$claim_phone_number <- connect_claim_phone_number

#' This API is in preview release for Amazon Connect and is subject to
#' change
#'
#' @description
#' This API is in preview release for Amazon Connect and is subject to change.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_create_agent_status/](https://www.paws-r-sdk.com/docs/connect_create_agent_status/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param Name &#91;required&#93; The name of the status.
#' @param Description The description of the status.
#' @param State &#91;required&#93; The state of the status.
#' @param DisplayOrder The display order of the status.
#' @param Tags The tags used to organize, track, or control access for this resource.
#' For example, \{ "Tags": \{"key1":"value1", "key2":"value2"\} \}.
#'
#' @keywords internal
#'
#' @rdname connect_create_agent_status
connect_create_agent_status <- function(InstanceId, Name, Description = NULL, State, DisplayOrder = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateAgentStatus",
    http_method = "PUT",
    http_path = "/agent-status/{InstanceId}",
    paginator = list()
  )
  input <- .connect$create_agent_status_input(InstanceId = InstanceId, Name = Name, Description = Description, State = State, DisplayOrder = DisplayOrder, Tags = Tags)
  output <- .connect$create_agent_status_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$create_agent_status <- connect_create_agent_status

#' Creates a flow for the specified Amazon Connect instance
#'
#' @description
#' Creates a flow for the specified Amazon Connect instance.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_create_contact_flow/](https://www.paws-r-sdk.com/docs/connect_create_contact_flow/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance.
#' @param Name &#91;required&#93; The name of the flow.
#' @param Type &#91;required&#93; The type of the flow. For descriptions of the available types, see
#' [Choose a flow
#' type](https://docs.aws.amazon.com/connect/latest/adminguide/create-contact-flow.html#contact-flow-types)
#' in the *Amazon Connect Administrator Guide*.
#' @param Description The description of the flow.
#' @param Content &#91;required&#93; The JSON string that represents the content of the flow. For an example,
#' see [Example flow in Amazon Connect Flow
#' language](https://docs.aws.amazon.com/connect/latest/APIReference/flow-language-example.html).
#' 
#' Length Constraints: Minimum length of 1. Maximum length of 256000.
#' @param Tags The tags used to organize, track, or control access for this resource.
#' For example, \{ "Tags": \{"key1":"value1", "key2":"value2"\} \}.
#'
#' @keywords internal
#'
#' @rdname connect_create_contact_flow
connect_create_contact_flow <- function(InstanceId, Name, Type, Description = NULL, Content, Tags = NULL) {
  op <- new_operation(
    name = "CreateContactFlow",
    http_method = "PUT",
    http_path = "/contact-flows/{InstanceId}",
    paginator = list()
  )
  input <- .connect$create_contact_flow_input(InstanceId = InstanceId, Name = Name, Type = Type, Description = Description, Content = Content, Tags = Tags)
  output <- .connect$create_contact_flow_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$create_contact_flow <- connect_create_contact_flow

#' Creates a flow module for the specified Amazon Connect instance
#'
#' @description
#' Creates a flow module for the specified Amazon Connect instance.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_create_contact_flow_module/](https://www.paws-r-sdk.com/docs/connect_create_contact_flow_module/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param Name &#91;required&#93; The name of the flow module.
#' @param Description The description of the flow module.
#' @param Content &#91;required&#93; The JSON string that represents the content of the flow. For an example,
#' see [Example flow in Amazon Connect Flow
#' language](https://docs.aws.amazon.com/connect/latest/APIReference/flow-language-example.html).
#' @param Tags The tags used to organize, track, or control access for this resource.
#' For example, \{ "Tags": \{"key1":"value1", "key2":"value2"\} \}.
#' @param ClientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If not provided, the Amazon Web Services SDK
#' populates this field. For more information about idempotency, see
#' [Making retries safe with idempotent
#' APIs](https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
#'
#' @keywords internal
#'
#' @rdname connect_create_contact_flow_module
connect_create_contact_flow_module <- function(InstanceId, Name, Description = NULL, Content, Tags = NULL, ClientToken = NULL) {
  op <- new_operation(
    name = "CreateContactFlowModule",
    http_method = "PUT",
    http_path = "/contact-flow-modules/{InstanceId}",
    paginator = list()
  )
  input <- .connect$create_contact_flow_module_input(InstanceId = InstanceId, Name = Name, Description = Description, Content = Content, Tags = Tags, ClientToken = ClientToken)
  output <- .connect$create_contact_flow_module_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$create_contact_flow_module <- connect_create_contact_flow_module

#' Creates an evaluation form in the specified Amazon Connect instance
#'
#' @description
#' Creates an evaluation form in the specified Amazon Connect instance. The form can be used to define questions related to agent performance, and create sections to organize such questions. Question and section identifiers cannot be duplicated within the same evaluation form.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_create_evaluation_form/](https://www.paws-r-sdk.com/docs/connect_create_evaluation_form/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param Title &#91;required&#93; A title of the evaluation form.
#' @param Description The description of the evaluation form.
#' @param Items &#91;required&#93; Items that are part of the evaluation form. The total number of sections
#' and questions must not exceed 100 each. Questions must be contained in a
#' section.
#' @param ScoringStrategy A scoring strategy of the evaluation form.
#' @param ClientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If not provided, the Amazon Web Services SDK
#' populates this field. For more information about idempotency, see
#' [Making retries safe with idempotent
#' APIs](https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
#'
#' @keywords internal
#'
#' @rdname connect_create_evaluation_form
connect_create_evaluation_form <- function(InstanceId, Title, Description = NULL, Items, ScoringStrategy = NULL, ClientToken = NULL) {
  op <- new_operation(
    name = "CreateEvaluationForm",
    http_method = "PUT",
    http_path = "/evaluation-forms/{InstanceId}",
    paginator = list()
  )
  input <- .connect$create_evaluation_form_input(InstanceId = InstanceId, Title = Title, Description = Description, Items = Items, ScoringStrategy = ScoringStrategy, ClientToken = ClientToken)
  output <- .connect$create_evaluation_form_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$create_evaluation_form <- connect_create_evaluation_form

#' This API is in preview release for Amazon Connect and is subject to
#' change
#'
#' @description
#' This API is in preview release for Amazon Connect and is subject to change.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_create_hours_of_operation/](https://www.paws-r-sdk.com/docs/connect_create_hours_of_operation/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param Name &#91;required&#93; The name of the hours of operation.
#' @param Description The description of the hours of operation.
#' @param TimeZone &#91;required&#93; The time zone of the hours of operation.
#' @param Config &#91;required&#93; Configuration information for the hours of operation: day, start time,
#' and end time.
#' @param Tags The tags used to organize, track, or control access for this resource.
#' For example, \{ "Tags": \{"key1":"value1", "key2":"value2"\} \}.
#'
#' @keywords internal
#'
#' @rdname connect_create_hours_of_operation
connect_create_hours_of_operation <- function(InstanceId, Name, Description = NULL, TimeZone, Config, Tags = NULL) {
  op <- new_operation(
    name = "CreateHoursOfOperation",
    http_method = "PUT",
    http_path = "/hours-of-operations/{InstanceId}",
    paginator = list()
  )
  input <- .connect$create_hours_of_operation_input(InstanceId = InstanceId, Name = Name, Description = Description, TimeZone = TimeZone, Config = Config, Tags = Tags)
  output <- .connect$create_hours_of_operation_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$create_hours_of_operation <- connect_create_hours_of_operation

#' This API is in preview release for Amazon Connect and is subject to
#' change
#'
#' @description
#' This API is in preview release for Amazon Connect and is subject to change.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_create_instance/](https://www.paws-r-sdk.com/docs/connect_create_instance/) for full documentation.
#'
#' @param ClientToken The idempotency token.
#' @param IdentityManagementType &#91;required&#93; The type of identity management for your Amazon Connect users.
#' @param InstanceAlias The name for your instance.
#' @param DirectoryId The identifier for the directory.
#' @param InboundCallsEnabled &#91;required&#93; Your contact center handles incoming contacts.
#' @param OutboundCallsEnabled &#91;required&#93; Your contact center allows outbound calls.
#' @param Tags The tags used to organize, track, or control access for this resource.
#' For example, `{ "tags": {"key1":"value1", "key2":"value2"} }`.
#'
#' @keywords internal
#'
#' @rdname connect_create_instance
connect_create_instance <- function(ClientToken = NULL, IdentityManagementType, InstanceAlias = NULL, DirectoryId = NULL, InboundCallsEnabled, OutboundCallsEnabled, Tags = NULL) {
  op <- new_operation(
    name = "CreateInstance",
    http_method = "PUT",
    http_path = "/instance",
    paginator = list()
  )
  input <- .connect$create_instance_input(ClientToken = ClientToken, IdentityManagementType = IdentityManagementType, InstanceAlias = InstanceAlias, DirectoryId = DirectoryId, InboundCallsEnabled = InboundCallsEnabled, OutboundCallsEnabled = OutboundCallsEnabled, Tags = Tags)
  output <- .connect$create_instance_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$create_instance <- connect_create_instance

#' Creates an Amazon Web Services resource association with an Amazon
#' Connect instance
#'
#' @description
#' Creates an Amazon Web Services resource association with an Amazon Connect instance.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_create_integration_association/](https://www.paws-r-sdk.com/docs/connect_create_integration_association/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param IntegrationType &#91;required&#93; The type of information to be ingested.
#' @param IntegrationArn &#91;required&#93; The Amazon Resource Name (ARN) of the integration.
#' 
#' When integrating with Amazon Pinpoint, the Amazon Connect and Amazon
#' Pinpoint instances must be in the same account.
#' @param SourceApplicationUrl The URL for the external application. This field is only required for
#' the EVENT integration type.
#' @param SourceApplicationName The name of the external application. This field is only required for
#' the EVENT integration type.
#' @param SourceType The type of the data source. This field is only required for the EVENT
#' integration type.
#' @param Tags The tags used to organize, track, or control access for this resource.
#' For example, \{ "Tags": \{"key1":"value1", "key2":"value2"\} \}.
#'
#' @keywords internal
#'
#' @rdname connect_create_integration_association
connect_create_integration_association <- function(InstanceId, IntegrationType, IntegrationArn, SourceApplicationUrl = NULL, SourceApplicationName = NULL, SourceType = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateIntegrationAssociation",
    http_method = "PUT",
    http_path = "/instance/{InstanceId}/integration-associations",
    paginator = list()
  )
  input <- .connect$create_integration_association_input(InstanceId = InstanceId, IntegrationType = IntegrationType, IntegrationArn = IntegrationArn, SourceApplicationUrl = SourceApplicationUrl, SourceApplicationName = SourceApplicationName, SourceType = SourceType, Tags = Tags)
  output <- .connect$create_integration_association_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$create_integration_association <- connect_create_integration_association

#' Adds a new participant into an on-going chat contact
#'
#' @description
#' Adds a new participant into an on-going chat contact. For more information, see [Customize chat flow experiences by integrating custom participants](https://docs.aws.amazon.com/connect/latest/adminguide/chat-customize-flow.html).
#'
#' See [https://www.paws-r-sdk.com/docs/connect_create_participant/](https://www.paws-r-sdk.com/docs/connect_create_participant/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param ContactId &#91;required&#93; The identifier of the contact in this instance of Amazon Connect. Only
#' contacts in the CHAT channel are supported.
#' @param ClientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If not provided, the Amazon Web Services SDK
#' populates this field. For more information about idempotency, see
#' [Making retries safe with idempotent
#' APIs](https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
#' @param ParticipantDetails &#91;required&#93; Information identifying the participant.
#' 
#' The only Valid value for `ParticipantRole` is `CUSTOM_BOT`.
#' 
#' `DisplayName` is **Required**.
#'
#' @keywords internal
#'
#' @rdname connect_create_participant
connect_create_participant <- function(InstanceId, ContactId, ClientToken = NULL, ParticipantDetails) {
  op <- new_operation(
    name = "CreateParticipant",
    http_method = "POST",
    http_path = "/contact/create-participant",
    paginator = list()
  )
  input <- .connect$create_participant_input(InstanceId = InstanceId, ContactId = ContactId, ClientToken = ClientToken, ParticipantDetails = ParticipantDetails)
  output <- .connect$create_participant_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$create_participant <- connect_create_participant

#' Enables rehydration of chats for the lifespan of a contact
#'
#' @description
#' Enables rehydration of chats for the lifespan of a contact. For more information about chat rehydration, see [Enable persistent chat](https://docs.aws.amazon.com/connect/latest/adminguide/chat-persistence.html) in the *Amazon Connect Administrator Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_create_persistent_contact_association/](https://www.paws-r-sdk.com/docs/connect_create_persistent_contact_association/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param InitialContactId &#91;required&#93; This is the contactId of the current contact that the
#' [`create_persistent_contact_association`][connect_create_persistent_contact_association]
#' API is being called from.
#' @param RehydrationType &#91;required&#93; The contactId chosen for rehydration depends on the type chosen.
#' 
#' -   `ENTIRE_PAST_SESSION`: Rehydrates a chat from the most recently
#'     terminated past chat contact of the specified past ended chat
#'     session. To use this type, provide the `initialContactId` of the
#'     past ended chat session in the `sourceContactId` field. In this
#'     type, Amazon Connect determines what the most recent chat contact on
#'     the past ended chat session and uses it to start a persistent chat.
#' 
#' -   `FROM_SEGMENT`: Rehydrates a chat from the specified past chat
#'     contact provided in the `sourceContactId` field.
#' 
#' The actual contactId used for rehydration is provided in the response of
#' this API.
#' 
#' To illustrate how to use rehydration type, consider the following
#' example: A customer starts a chat session. Agent a1 accepts the chat and
#' a conversation starts between the customer and Agent a1. This first
#' contact creates a contact ID **C1**. Agent a1 then transfers the chat to
#' Agent a2. This creates another contact ID **C2**. At this point Agent a2
#' ends the chat. The customer is forwarded to the disconnect flow for a
#' post chat survey that creates another contact ID **C3**. After the chat
#' survey, the chat session ends. Later, the customer returns and wants to
#' resume their past chat session. At this point, the customer can have
#' following use cases:
#' 
#' -   **Use Case 1**: The customer wants to continue the past chat session
#'     but they want to hide the post chat survey. For this they will use
#'     the following configuration:
#' 
#'     -   **Configuration**
#' 
#'         -   SourceContactId = "C2"
#' 
#'         -   RehydrationType = "FROM_SEGMENT"
#' 
#'     -   **Expected behavior**
#' 
#'         -   This starts a persistent chat session from the specified
#'             past ended contact (C2). Transcripts of past chat sessions
#'             C2 and C1 are accessible in the current persistent chat
#'             session. Note that chat segment C3 is dropped from the
#'             persistent chat session.
#' 
#' -   **Use Case 2**: The customer wants to continue the past chat session
#'     and see the transcript of the entire past engagement, including the
#'     post chat survey. For this they will use the following
#'     configuration:
#' 
#'     -   **Configuration**
#' 
#'         -   SourceContactId = "C1"
#' 
#'         -   RehydrationType = "ENTIRE_PAST_SESSION"
#' 
#'     -   **Expected behavior**
#' 
#'         -   This starts a persistent chat session from the most recently
#'             ended chat contact (C3). Transcripts of past chat sessions
#'             C3, C2 and C1 are accessible in the current persistent chat
#'             session.
#' @param SourceContactId &#91;required&#93; The contactId from which a persistent chat session must be started.
#' @param ClientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If not provided, the Amazon Web Services SDK
#' populates this field. For more information about idempotency, see
#' [Making retries safe with idempotent
#' APIs](https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
#'
#' @keywords internal
#'
#' @rdname connect_create_persistent_contact_association
connect_create_persistent_contact_association <- function(InstanceId, InitialContactId, RehydrationType, SourceContactId, ClientToken = NULL) {
  op <- new_operation(
    name = "CreatePersistentContactAssociation",
    http_method = "POST",
    http_path = "/contact/persistent-contact-association/{InstanceId}/{InitialContactId}",
    paginator = list()
  )
  input <- .connect$create_persistent_contact_association_input(InstanceId = InstanceId, InitialContactId = InitialContactId, RehydrationType = RehydrationType, SourceContactId = SourceContactId, ClientToken = ClientToken)
  output <- .connect$create_persistent_contact_association_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$create_persistent_contact_association <- connect_create_persistent_contact_association

#' Creates a new predefined attribute for the specified Amazon Connect
#' instance
#'
#' @description
#' Creates a new predefined attribute for the specified Amazon Connect instance.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_create_predefined_attribute/](https://www.paws-r-sdk.com/docs/connect_create_predefined_attribute/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can find the instance
#' ID in the Amazon Resource Name (ARN) of the instance.
#' @param Name &#91;required&#93; The name of the predefined attribute.
#' @param Values &#91;required&#93; The values of the predefined attribute.
#'
#' @keywords internal
#'
#' @rdname connect_create_predefined_attribute
connect_create_predefined_attribute <- function(InstanceId, Name, Values) {
  op <- new_operation(
    name = "CreatePredefinedAttribute",
    http_method = "PUT",
    http_path = "/predefined-attributes/{InstanceId}",
    paginator = list()
  )
  input <- .connect$create_predefined_attribute_input(InstanceId = InstanceId, Name = Name, Values = Values)
  output <- .connect$create_predefined_attribute_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$create_predefined_attribute <- connect_create_predefined_attribute

#' Creates a prompt
#'
#' @description
#' Creates a prompt. For more information about prompts, such as supported file types and maximum length, see [Create prompts](https://docs.aws.amazon.com/connect/latest/adminguide/prompts.html) in the *Amazon Connect Administrator's Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_create_prompt/](https://www.paws-r-sdk.com/docs/connect_create_prompt/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param Name &#91;required&#93; The name of the prompt.
#' @param Description The description of the prompt.
#' @param S3Uri &#91;required&#93; The URI for the S3 bucket where the prompt is stored. You can provide S3
#' pre-signed URLs returned by the
#' [`get_prompt_file`][connect_get_prompt_file] API instead of providing S3
#' URIs.
#' @param Tags The tags used to organize, track, or control access for this resource.
#' For example, \{ "Tags": \{"key1":"value1", "key2":"value2"\} \}.
#'
#' @keywords internal
#'
#' @rdname connect_create_prompt
connect_create_prompt <- function(InstanceId, Name, Description = NULL, S3Uri, Tags = NULL) {
  op <- new_operation(
    name = "CreatePrompt",
    http_method = "PUT",
    http_path = "/prompts/{InstanceId}",
    paginator = list()
  )
  input <- .connect$create_prompt_input(InstanceId = InstanceId, Name = Name, Description = Description, S3Uri = S3Uri, Tags = Tags)
  output <- .connect$create_prompt_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$create_prompt <- connect_create_prompt

#' This API is in preview release for Amazon Connect and is subject to
#' change
#'
#' @description
#' This API is in preview release for Amazon Connect and is subject to change.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_create_queue/](https://www.paws-r-sdk.com/docs/connect_create_queue/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param Name &#91;required&#93; The name of the queue.
#' @param Description The description of the queue.
#' @param OutboundCallerConfig The outbound caller ID name, number, and outbound whisper flow.
#' @param HoursOfOperationId &#91;required&#93; The identifier for the hours of operation.
#' @param MaxContacts The maximum number of contacts that can be in the queue before it is
#' considered full.
#' @param QuickConnectIds The quick connects available to agents who are working the queue.
#' @param Tags The tags used to organize, track, or control access for this resource.
#' For example, \{ "Tags": \{"key1":"value1", "key2":"value2"\} \}.
#'
#' @keywords internal
#'
#' @rdname connect_create_queue
connect_create_queue <- function(InstanceId, Name, Description = NULL, OutboundCallerConfig = NULL, HoursOfOperationId, MaxContacts = NULL, QuickConnectIds = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateQueue",
    http_method = "PUT",
    http_path = "/queues/{InstanceId}",
    paginator = list()
  )
  input <- .connect$create_queue_input(InstanceId = InstanceId, Name = Name, Description = Description, OutboundCallerConfig = OutboundCallerConfig, HoursOfOperationId = HoursOfOperationId, MaxContacts = MaxContacts, QuickConnectIds = QuickConnectIds, Tags = Tags)
  output <- .connect$create_queue_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$create_queue <- connect_create_queue

#' Creates a quick connect for the specified Amazon Connect instance
#'
#' @description
#' Creates a quick connect for the specified Amazon Connect instance.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_create_quick_connect/](https://www.paws-r-sdk.com/docs/connect_create_quick_connect/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param Name &#91;required&#93; A unique name of the quick connect.
#' @param Description The description of the quick connect.
#' @param QuickConnectConfig &#91;required&#93; Configuration settings for the quick connect.
#' @param Tags The tags used to organize, track, or control access for this resource.
#' For example, \{ "Tags": \{"key1":"value1", "key2":"value2"\} \}.
#'
#' @keywords internal
#'
#' @rdname connect_create_quick_connect
connect_create_quick_connect <- function(InstanceId, Name, Description = NULL, QuickConnectConfig, Tags = NULL) {
  op <- new_operation(
    name = "CreateQuickConnect",
    http_method = "PUT",
    http_path = "/quick-connects/{InstanceId}",
    paginator = list()
  )
  input <- .connect$create_quick_connect_input(InstanceId = InstanceId, Name = Name, Description = Description, QuickConnectConfig = QuickConnectConfig, Tags = Tags)
  output <- .connect$create_quick_connect_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$create_quick_connect <- connect_create_quick_connect

#' Creates a new routing profile
#'
#' @description
#' Creates a new routing profile.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_create_routing_profile/](https://www.paws-r-sdk.com/docs/connect_create_routing_profile/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param Name &#91;required&#93; The name of the routing profile. Must not be more than 127 characters.
#' @param Description &#91;required&#93; Description of the routing profile. Must not be more than 250
#' characters.
#' @param DefaultOutboundQueueId &#91;required&#93; The default outbound queue for the routing profile.
#' @param QueueConfigs The inbound queues associated with the routing profile. If no queue is
#' added, the agent can make only outbound calls.
#' 
#' The limit of 10 array members applies to the maximum number of
#' `RoutingProfileQueueConfig` objects that can be passed during a
#' CreateRoutingProfile API request. It is different from the quota of 50
#' queues per routing profile per instance that is listed in [Amazon
#' Connect service
#' quotas](https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html).
#' @param MediaConcurrencies &#91;required&#93; The channels that agents can handle in the Contact Control Panel (CCP)
#' for this routing profile.
#' @param Tags The tags used to organize, track, or control access for this resource.
#' For example, \{ "Tags": \{"key1":"value1", "key2":"value2"\} \}.
#' @param AgentAvailabilityTimer Whether agents with this routing profile will have their routing order
#' calculated based on *longest idle time* or *time since their last
#' inbound contact*.
#'
#' @keywords internal
#'
#' @rdname connect_create_routing_profile
connect_create_routing_profile <- function(InstanceId, Name, Description, DefaultOutboundQueueId, QueueConfigs = NULL, MediaConcurrencies, Tags = NULL, AgentAvailabilityTimer = NULL) {
  op <- new_operation(
    name = "CreateRoutingProfile",
    http_method = "PUT",
    http_path = "/routing-profiles/{InstanceId}",
    paginator = list()
  )
  input <- .connect$create_routing_profile_input(InstanceId = InstanceId, Name = Name, Description = Description, DefaultOutboundQueueId = DefaultOutboundQueueId, QueueConfigs = QueueConfigs, MediaConcurrencies = MediaConcurrencies, Tags = Tags, AgentAvailabilityTimer = AgentAvailabilityTimer)
  output <- .connect$create_routing_profile_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$create_routing_profile <- connect_create_routing_profile

#' Creates a rule for the specified Amazon Connect instance
#'
#' @description
#' Creates a rule for the specified Amazon Connect instance.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_create_rule/](https://www.paws-r-sdk.com/docs/connect_create_rule/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param Name &#91;required&#93; A unique name for the rule.
#' @param TriggerEventSource &#91;required&#93; The event source to trigger the rule.
#' @param Function &#91;required&#93; The conditions of the rule.
#' @param Actions &#91;required&#93; A list of actions to be run when the rule is triggered.
#' @param PublishStatus &#91;required&#93; The publish status of the rule.
#' @param ClientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If not provided, the Amazon Web Services SDK
#' populates this field. For more information about idempotency, see
#' [Making retries safe with idempotent
#' APIs](https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
#'
#' @keywords internal
#'
#' @rdname connect_create_rule
connect_create_rule <- function(InstanceId, Name, TriggerEventSource, Function, Actions, PublishStatus, ClientToken = NULL) {
  op <- new_operation(
    name = "CreateRule",
    http_method = "POST",
    http_path = "/rules/{InstanceId}",
    paginator = list()
  )
  input <- .connect$create_rule_input(InstanceId = InstanceId, Name = Name, TriggerEventSource = TriggerEventSource, Function = Function, Actions = Actions, PublishStatus = PublishStatus, ClientToken = ClientToken)
  output <- .connect$create_rule_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$create_rule <- connect_create_rule

#' Creates a security profile
#'
#' @description
#' Creates a security profile.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_create_security_profile/](https://www.paws-r-sdk.com/docs/connect_create_security_profile/) for full documentation.
#'
#' @param SecurityProfileName &#91;required&#93; The name of the security profile.
#' @param Description The description of the security profile.
#' @param Permissions Permissions assigned to the security profile. For a list of valid
#' permissions, see [List of security profile
#' permissions](https://docs.aws.amazon.com/connect/latest/adminguide/security-profile-list.html).
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param Tags The tags used to organize, track, or control access for this resource.
#' For example, \{ "Tags": \{"key1":"value1", "key2":"value2"\} \}.
#' @param AllowedAccessControlTags The list of tags that a security profile uses to restrict access to
#' resources in Amazon Connect.
#' @param TagRestrictedResources The list of resources that a security profile applies tag restrictions
#' to in Amazon Connect. Following are acceptable ResourceNames: `User` |
#' `SecurityProfile` | `Queue` | `RoutingProfile`
#' @param Applications A list of third-party applications that the security profile will give
#' access to.
#' @param HierarchyRestrictedResources The list of resources that a security profile applies hierarchy
#' restrictions to in Amazon Connect. Following are acceptable
#' ResourceNames: `User`.
#' @param AllowedAccessControlHierarchyGroupId The identifier of the hierarchy group that a security profile uses to
#' restrict access to resources in Amazon Connect.
#'
#' @keywords internal
#'
#' @rdname connect_create_security_profile
connect_create_security_profile <- function(SecurityProfileName, Description = NULL, Permissions = NULL, InstanceId, Tags = NULL, AllowedAccessControlTags = NULL, TagRestrictedResources = NULL, Applications = NULL, HierarchyRestrictedResources = NULL, AllowedAccessControlHierarchyGroupId = NULL) {
  op <- new_operation(
    name = "CreateSecurityProfile",
    http_method = "PUT",
    http_path = "/security-profiles/{InstanceId}",
    paginator = list()
  )
  input <- .connect$create_security_profile_input(SecurityProfileName = SecurityProfileName, Description = Description, Permissions = Permissions, InstanceId = InstanceId, Tags = Tags, AllowedAccessControlTags = AllowedAccessControlTags, TagRestrictedResources = TagRestrictedResources, Applications = Applications, HierarchyRestrictedResources = HierarchyRestrictedResources, AllowedAccessControlHierarchyGroupId = AllowedAccessControlHierarchyGroupId)
  output <- .connect$create_security_profile_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$create_security_profile <- connect_create_security_profile

#' Creates a new task template in the specified Amazon Connect instance
#'
#' @description
#' Creates a new task template in the specified Amazon Connect instance.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_create_task_template/](https://www.paws-r-sdk.com/docs/connect_create_task_template/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param Name &#91;required&#93; The name of the task template.
#' @param Description The description of the task template.
#' @param ContactFlowId The identifier of the flow that runs by default when a task is created
#' by referencing this template.
#' @param Constraints Constraints that are applicable to the fields listed.
#' @param Defaults The default values for fields when a task is created by referencing this
#' template.
#' @param Status Marks a template as `ACTIVE` or `INACTIVE` for a task to refer to it.
#' Tasks can only be created from `ACTIVE` templates. If a template is
#' marked as `INACTIVE`, then a task that refers to this template cannot be
#' created.
#' @param Fields &#91;required&#93; Fields that are part of the template.
#' @param ClientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If not provided, the Amazon Web Services SDK
#' populates this field. For more information about idempotency, see
#' [Making retries safe with idempotent
#' APIs](https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
#'
#' @keywords internal
#'
#' @rdname connect_create_task_template
connect_create_task_template <- function(InstanceId, Name, Description = NULL, ContactFlowId = NULL, Constraints = NULL, Defaults = NULL, Status = NULL, Fields, ClientToken = NULL) {
  op <- new_operation(
    name = "CreateTaskTemplate",
    http_method = "PUT",
    http_path = "/instance/{InstanceId}/task/template",
    paginator = list()
  )
  input <- .connect$create_task_template_input(InstanceId = InstanceId, Name = Name, Description = Description, ContactFlowId = ContactFlowId, Constraints = Constraints, Defaults = Defaults, Status = Status, Fields = Fields, ClientToken = ClientToken)
  output <- .connect$create_task_template_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$create_task_template <- connect_create_task_template

#' Creates a traffic distribution group given an Amazon Connect instance
#' that has been replicated
#'
#' @description
#' Creates a traffic distribution group given an Amazon Connect instance that has been replicated.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_create_traffic_distribution_group/](https://www.paws-r-sdk.com/docs/connect_create_traffic_distribution_group/) for full documentation.
#'
#' @param Name &#91;required&#93; The name for the traffic distribution group.
#' @param Description A description for the traffic distribution group.
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance that has been replicated.
#' You can find the `instanceId` in the ARN of the instance.
#' @param ClientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If not provided, the Amazon Web Services SDK
#' populates this field. For more information about idempotency, see
#' [Making retries safe with idempotent
#' APIs](https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
#' @param Tags The tags used to organize, track, or control access for this resource.
#' For example, \{ "Tags": \{"key1":"value1", "key2":"value2"\} \}.
#'
#' @keywords internal
#'
#' @rdname connect_create_traffic_distribution_group
connect_create_traffic_distribution_group <- function(Name, Description = NULL, InstanceId, ClientToken = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateTrafficDistributionGroup",
    http_method = "PUT",
    http_path = "/traffic-distribution-group",
    paginator = list()
  )
  input <- .connect$create_traffic_distribution_group_input(Name = Name, Description = Description, InstanceId = InstanceId, ClientToken = ClientToken, Tags = Tags)
  output <- .connect$create_traffic_distribution_group_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$create_traffic_distribution_group <- connect_create_traffic_distribution_group

#' Creates a use case for an integration association
#'
#' @description
#' Creates a use case for an integration association.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_create_use_case/](https://www.paws-r-sdk.com/docs/connect_create_use_case/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param IntegrationAssociationId &#91;required&#93; The identifier for the integration association.
#' @param UseCaseType &#91;required&#93; The type of use case to associate to the integration association. Each
#' integration association can have only one of each use case type.
#' @param Tags The tags used to organize, track, or control access for this resource.
#' For example, \{ "Tags": \{"key1":"value1", "key2":"value2"\} \}.
#'
#' @keywords internal
#'
#' @rdname connect_create_use_case
connect_create_use_case <- function(InstanceId, IntegrationAssociationId, UseCaseType, Tags = NULL) {
  op <- new_operation(
    name = "CreateUseCase",
    http_method = "PUT",
    http_path = "/instance/{InstanceId}/integration-associations/{IntegrationAssociationId}/use-cases",
    paginator = list()
  )
  input <- .connect$create_use_case_input(InstanceId = InstanceId, IntegrationAssociationId = IntegrationAssociationId, UseCaseType = UseCaseType, Tags = Tags)
  output <- .connect$create_use_case_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$create_use_case <- connect_create_use_case

#' Creates a user account for the specified Amazon Connect instance
#'
#' @description
#' Creates a user account for the specified Amazon Connect instance.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_create_user/](https://www.paws-r-sdk.com/docs/connect_create_user/) for full documentation.
#'
#' @param Username &#91;required&#93; The user name for the account. For instances not using SAML for identity
#' management, the user name can include up to 20 characters. If you are
#' using SAML for identity management, the user name can include up to 64
#' characters from \[a-zA-Z0-9_-.\\@@\]+.
#' 
#' Username can include @@ only if used in an email format. For example:
#' 
#' -   Correct: testuser
#' 
#' -   Correct: testuser@@example.com
#' 
#' -   Incorrect: testuser@@example
#' @param Password The password for the user account. A password is required if you are
#' using Amazon Connect for identity management. Otherwise, it is an error
#' to include a password.
#' @param IdentityInfo The information about the identity of the user.
#' @param PhoneConfig &#91;required&#93; The phone settings for the user.
#' @param DirectoryUserId The identifier of the user account in the directory used for identity
#' management. If Amazon Connect cannot access the directory, you can
#' specify this identifier to authenticate users. If you include the
#' identifier, we assume that Amazon Connect cannot access the directory.
#' Otherwise, the identity information is used to authenticate users from
#' your directory.
#' 
#' This parameter is required if you are using an existing directory for
#' identity management in Amazon Connect when Amazon Connect cannot access
#' your directory to authenticate users. If you are using SAML for identity
#' management and include this parameter, an error is returned.
#' @param SecurityProfileIds &#91;required&#93; The identifier of the security profile for the user.
#' @param RoutingProfileId &#91;required&#93; The identifier of the routing profile for the user.
#' @param HierarchyGroupId The identifier of the hierarchy group for the user.
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param Tags The tags used to organize, track, or control access for this resource.
#' For example, \{ "Tags": \{"key1":"value1", "key2":"value2"\} \}.
#'
#' @keywords internal
#'
#' @rdname connect_create_user
connect_create_user <- function(Username, Password = NULL, IdentityInfo = NULL, PhoneConfig, DirectoryUserId = NULL, SecurityProfileIds, RoutingProfileId, HierarchyGroupId = NULL, InstanceId, Tags = NULL) {
  op <- new_operation(
    name = "CreateUser",
    http_method = "PUT",
    http_path = "/users/{InstanceId}",
    paginator = list()
  )
  input <- .connect$create_user_input(Username = Username, Password = Password, IdentityInfo = IdentityInfo, PhoneConfig = PhoneConfig, DirectoryUserId = DirectoryUserId, SecurityProfileIds = SecurityProfileIds, RoutingProfileId = RoutingProfileId, HierarchyGroupId = HierarchyGroupId, InstanceId = InstanceId, Tags = Tags)
  output <- .connect$create_user_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$create_user <- connect_create_user

#' Creates a new user hierarchy group
#'
#' @description
#' Creates a new user hierarchy group.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_create_user_hierarchy_group/](https://www.paws-r-sdk.com/docs/connect_create_user_hierarchy_group/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the user hierarchy group. Must not be more than 100
#' characters.
#' @param ParentGroupId The identifier for the parent hierarchy group. The user hierarchy is
#' created at level one if the parent group ID is null.
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param Tags The tags used to organize, track, or control access for this resource.
#' For example, \{ "Tags": \{"key1":"value1", "key2":"value2"\} \}.
#'
#' @keywords internal
#'
#' @rdname connect_create_user_hierarchy_group
connect_create_user_hierarchy_group <- function(Name, ParentGroupId = NULL, InstanceId, Tags = NULL) {
  op <- new_operation(
    name = "CreateUserHierarchyGroup",
    http_method = "PUT",
    http_path = "/user-hierarchy-groups/{InstanceId}",
    paginator = list()
  )
  input <- .connect$create_user_hierarchy_group_input(Name = Name, ParentGroupId = ParentGroupId, InstanceId = InstanceId, Tags = Tags)
  output <- .connect$create_user_hierarchy_group_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$create_user_hierarchy_group <- connect_create_user_hierarchy_group

#' Creates a new view with the possible status of SAVED or PUBLISHED
#'
#' @description
#' Creates a new view with the possible status of `SAVED` or `PUBLISHED`.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_create_view/](https://www.paws-r-sdk.com/docs/connect_create_view/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can find the
#' instanceId in the ARN of the instance.
#' @param ClientToken A unique Id for each create view request to avoid duplicate view
#' creation. For example, the view is idempotent ClientToken is provided.
#' @param Status &#91;required&#93; Indicates the view status as either `SAVED` or `PUBLISHED`. The
#' `PUBLISHED` status will initiate validation on the content.
#' @param Content &#91;required&#93; View content containing all content necessary to render a view except
#' for runtime input data.
#' 
#' The total uncompressed content has a maximum file size of 400kB.
#' @param Description The description of the view.
#' @param Name &#91;required&#93; The name of the view.
#' @param Tags The tags associated with the view resource (not specific to view
#' version).These tags can be used to organize, track, or control access
#' for this resource. For example, \{ "tags": \{"key1":"value1",
#' "key2":"value2"\} \}.
#'
#' @keywords internal
#'
#' @rdname connect_create_view
connect_create_view <- function(InstanceId, ClientToken = NULL, Status, Content, Description = NULL, Name, Tags = NULL) {
  op <- new_operation(
    name = "CreateView",
    http_method = "PUT",
    http_path = "/views/{InstanceId}",
    paginator = list()
  )
  input <- .connect$create_view_input(InstanceId = InstanceId, ClientToken = ClientToken, Status = Status, Content = Content, Description = Description, Name = Name, Tags = Tags)
  output <- .connect$create_view_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$create_view <- connect_create_view

#' Publishes a new version of the view identifier
#'
#' @description
#' Publishes a new version of the view identifier.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_create_view_version/](https://www.paws-r-sdk.com/docs/connect_create_view_version/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can find the
#' instanceId in the ARN of the instance.
#' @param ViewId &#91;required&#93; The identifier of the view. Both `ViewArn` and `ViewId` can be used.
#' @param VersionDescription The description for the version being published.
#' @param ViewContentSha256 Indicates the checksum value of the latest published view content.
#'
#' @keywords internal
#'
#' @rdname connect_create_view_version
connect_create_view_version <- function(InstanceId, ViewId, VersionDescription = NULL, ViewContentSha256 = NULL) {
  op <- new_operation(
    name = "CreateViewVersion",
    http_method = "PUT",
    http_path = "/views/{InstanceId}/{ViewId}/versions",
    paginator = list()
  )
  input <- .connect$create_view_version_input(InstanceId = InstanceId, ViewId = ViewId, VersionDescription = VersionDescription, ViewContentSha256 = ViewContentSha256)
  output <- .connect$create_view_version_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$create_view_version <- connect_create_view_version

#' Creates a custom vocabulary associated with your Amazon Connect instance
#'
#' @description
#' Creates a custom vocabulary associated with your Amazon Connect instance. You can set a custom vocabulary to be your default vocabulary for a given language. Contact Lens for Amazon Connect uses the default vocabulary in post-call and real-time contact analysis sessions for that language.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_create_vocabulary/](https://www.paws-r-sdk.com/docs/connect_create_vocabulary/) for full documentation.
#'
#' @param ClientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If not provided, the Amazon Web Services SDK
#' populates this field. For more information about idempotency, see
#' [Making retries safe with idempotent
#' APIs](https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
#' If a create request is received more than once with same client token,
#' subsequent requests return the previous response without creating a
#' vocabulary again.
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param VocabularyName &#91;required&#93; A unique name of the custom vocabulary.
#' @param LanguageCode &#91;required&#93; The language code of the vocabulary entries. For a list of languages and
#' their corresponding language codes, see [What is Amazon
#' Transcribe?](https://docs.aws.amazon.com/transcribe/latest/dg/what-is.html)
#' @param Content &#91;required&#93; The content of the custom vocabulary in plain-text format with a table
#' of values. Each row in the table represents a word or a phrase,
#' described with `Phrase`, `IPA`, `SoundsLike`, and `DisplayAs` fields.
#' Separate the fields with TAB characters. The size limit is 50KB. For
#' more information, see [Create a custom vocabulary using a
#' table](https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html#create-vocabulary-table).
#' @param Tags The tags used to organize, track, or control access for this resource.
#' For example, \{ "Tags": \{"key1":"value1", "key2":"value2"\} \}.
#'
#' @keywords internal
#'
#' @rdname connect_create_vocabulary
connect_create_vocabulary <- function(ClientToken = NULL, InstanceId, VocabularyName, LanguageCode, Content, Tags = NULL) {
  op <- new_operation(
    name = "CreateVocabulary",
    http_method = "POST",
    http_path = "/vocabulary/{InstanceId}",
    paginator = list()
  )
  input <- .connect$create_vocabulary_input(ClientToken = ClientToken, InstanceId = InstanceId, VocabularyName = VocabularyName, LanguageCode = LanguageCode, Content = Content, Tags = Tags)
  output <- .connect$create_vocabulary_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$create_vocabulary <- connect_create_vocabulary

#' Deactivates an evaluation form in the specified Amazon Connect instance
#'
#' @description
#' Deactivates an evaluation form in the specified Amazon Connect instance. After a form is deactivated, it is no longer available for users to start new evaluations based on the form.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_deactivate_evaluation_form/](https://www.paws-r-sdk.com/docs/connect_deactivate_evaluation_form/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param EvaluationFormId &#91;required&#93; The unique identifier for the evaluation form.
#' @param EvaluationFormVersion &#91;required&#93; A version of the evaluation form. If the version property is not
#' provided, the latest version of the evaluation form is deactivated.
#'
#' @keywords internal
#'
#' @rdname connect_deactivate_evaluation_form
connect_deactivate_evaluation_form <- function(InstanceId, EvaluationFormId, EvaluationFormVersion) {
  op <- new_operation(
    name = "DeactivateEvaluationForm",
    http_method = "POST",
    http_path = "/evaluation-forms/{InstanceId}/{EvaluationFormId}/deactivate",
    paginator = list()
  )
  input <- .connect$deactivate_evaluation_form_input(InstanceId = InstanceId, EvaluationFormId = EvaluationFormId, EvaluationFormVersion = EvaluationFormVersion)
  output <- .connect$deactivate_evaluation_form_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$deactivate_evaluation_form <- connect_deactivate_evaluation_form

#' Deletes a contact evaluation in the specified Amazon Connect instance
#'
#' @description
#' Deletes a contact evaluation in the specified Amazon Connect instance.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_delete_contact_evaluation/](https://www.paws-r-sdk.com/docs/connect_delete_contact_evaluation/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param EvaluationId &#91;required&#93; A unique identifier for the contact evaluation.
#'
#' @keywords internal
#'
#' @rdname connect_delete_contact_evaluation
connect_delete_contact_evaluation <- function(InstanceId, EvaluationId) {
  op <- new_operation(
    name = "DeleteContactEvaluation",
    http_method = "DELETE",
    http_path = "/contact-evaluations/{InstanceId}/{EvaluationId}",
    paginator = list()
  )
  input <- .connect$delete_contact_evaluation_input(InstanceId = InstanceId, EvaluationId = EvaluationId)
  output <- .connect$delete_contact_evaluation_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$delete_contact_evaluation <- connect_delete_contact_evaluation

#' Deletes a flow for the specified Amazon Connect instance
#'
#' @description
#' Deletes a flow for the specified Amazon Connect instance.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_delete_contact_flow/](https://www.paws-r-sdk.com/docs/connect_delete_contact_flow/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param ContactFlowId &#91;required&#93; The identifier of the flow.
#'
#' @keywords internal
#'
#' @rdname connect_delete_contact_flow
connect_delete_contact_flow <- function(InstanceId, ContactFlowId) {
  op <- new_operation(
    name = "DeleteContactFlow",
    http_method = "DELETE",
    http_path = "/contact-flows/{InstanceId}/{ContactFlowId}",
    paginator = list()
  )
  input <- .connect$delete_contact_flow_input(InstanceId = InstanceId, ContactFlowId = ContactFlowId)
  output <- .connect$delete_contact_flow_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$delete_contact_flow <- connect_delete_contact_flow

#' Deletes the specified flow module
#'
#' @description
#' Deletes the specified flow module.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_delete_contact_flow_module/](https://www.paws-r-sdk.com/docs/connect_delete_contact_flow_module/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param ContactFlowModuleId &#91;required&#93; The identifier of the flow module.
#'
#' @keywords internal
#'
#' @rdname connect_delete_contact_flow_module
connect_delete_contact_flow_module <- function(InstanceId, ContactFlowModuleId) {
  op <- new_operation(
    name = "DeleteContactFlowModule",
    http_method = "DELETE",
    http_path = "/contact-flow-modules/{InstanceId}/{ContactFlowModuleId}",
    paginator = list()
  )
  input <- .connect$delete_contact_flow_module_input(InstanceId = InstanceId, ContactFlowModuleId = ContactFlowModuleId)
  output <- .connect$delete_contact_flow_module_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$delete_contact_flow_module <- connect_delete_contact_flow_module

#' Deletes an evaluation form in the specified Amazon Connect instance
#'
#' @description
#' Deletes an evaluation form in the specified Amazon Connect instance.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_delete_evaluation_form/](https://www.paws-r-sdk.com/docs/connect_delete_evaluation_form/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param EvaluationFormId &#91;required&#93; The unique identifier for the evaluation form.
#' @param EvaluationFormVersion The unique identifier for the evaluation form.
#'
#' @keywords internal
#'
#' @rdname connect_delete_evaluation_form
connect_delete_evaluation_form <- function(InstanceId, EvaluationFormId, EvaluationFormVersion = NULL) {
  op <- new_operation(
    name = "DeleteEvaluationForm",
    http_method = "DELETE",
    http_path = "/evaluation-forms/{InstanceId}/{EvaluationFormId}",
    paginator = list()
  )
  input <- .connect$delete_evaluation_form_input(InstanceId = InstanceId, EvaluationFormId = EvaluationFormId, EvaluationFormVersion = EvaluationFormVersion)
  output <- .connect$delete_evaluation_form_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$delete_evaluation_form <- connect_delete_evaluation_form

#' This API is in preview release for Amazon Connect and is subject to
#' change
#'
#' @description
#' This API is in preview release for Amazon Connect and is subject to change.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_delete_hours_of_operation/](https://www.paws-r-sdk.com/docs/connect_delete_hours_of_operation/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param HoursOfOperationId &#91;required&#93; The identifier for the hours of operation.
#'
#' @keywords internal
#'
#' @rdname connect_delete_hours_of_operation
connect_delete_hours_of_operation <- function(InstanceId, HoursOfOperationId) {
  op <- new_operation(
    name = "DeleteHoursOfOperation",
    http_method = "DELETE",
    http_path = "/hours-of-operations/{InstanceId}/{HoursOfOperationId}",
    paginator = list()
  )
  input <- .connect$delete_hours_of_operation_input(InstanceId = InstanceId, HoursOfOperationId = HoursOfOperationId)
  output <- .connect$delete_hours_of_operation_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$delete_hours_of_operation <- connect_delete_hours_of_operation

#' This API is in preview release for Amazon Connect and is subject to
#' change
#'
#' @description
#' This API is in preview release for Amazon Connect and is subject to change.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_delete_instance/](https://www.paws-r-sdk.com/docs/connect_delete_instance/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#'
#' @keywords internal
#'
#' @rdname connect_delete_instance
connect_delete_instance <- function(InstanceId) {
  op <- new_operation(
    name = "DeleteInstance",
    http_method = "DELETE",
    http_path = "/instance/{InstanceId}",
    paginator = list()
  )
  input <- .connect$delete_instance_input(InstanceId = InstanceId)
  output <- .connect$delete_instance_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$delete_instance <- connect_delete_instance

#' Deletes an Amazon Web Services resource association from an Amazon
#' Connect instance
#'
#' @description
#' Deletes an Amazon Web Services resource association from an Amazon Connect instance. The association must not have any use cases associated with it.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_delete_integration_association/](https://www.paws-r-sdk.com/docs/connect_delete_integration_association/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param IntegrationAssociationId &#91;required&#93; The identifier for the integration association.
#'
#' @keywords internal
#'
#' @rdname connect_delete_integration_association
connect_delete_integration_association <- function(InstanceId, IntegrationAssociationId) {
  op <- new_operation(
    name = "DeleteIntegrationAssociation",
    http_method = "DELETE",
    http_path = "/instance/{InstanceId}/integration-associations/{IntegrationAssociationId}",
    paginator = list()
  )
  input <- .connect$delete_integration_association_input(InstanceId = InstanceId, IntegrationAssociationId = IntegrationAssociationId)
  output <- .connect$delete_integration_association_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$delete_integration_association <- connect_delete_integration_association

#' Deletes a predefined attribute from the specified Amazon Connect
#' instance
#'
#' @description
#' Deletes a predefined attribute from the specified Amazon Connect instance.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_delete_predefined_attribute/](https://www.paws-r-sdk.com/docs/connect_delete_predefined_attribute/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can find the instance
#' ID in the Amazon Resource Name (ARN) of the instance.
#' @param Name &#91;required&#93; The name of the predefined attribute.
#'
#' @keywords internal
#'
#' @rdname connect_delete_predefined_attribute
connect_delete_predefined_attribute <- function(InstanceId, Name) {
  op <- new_operation(
    name = "DeletePredefinedAttribute",
    http_method = "DELETE",
    http_path = "/predefined-attributes/{InstanceId}/{Name}",
    paginator = list()
  )
  input <- .connect$delete_predefined_attribute_input(InstanceId = InstanceId, Name = Name)
  output <- .connect$delete_predefined_attribute_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$delete_predefined_attribute <- connect_delete_predefined_attribute

#' Deletes a prompt
#'
#' @description
#' Deletes a prompt.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_delete_prompt/](https://www.paws-r-sdk.com/docs/connect_delete_prompt/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param PromptId &#91;required&#93; A unique identifier for the prompt.
#'
#' @keywords internal
#'
#' @rdname connect_delete_prompt
connect_delete_prompt <- function(InstanceId, PromptId) {
  op <- new_operation(
    name = "DeletePrompt",
    http_method = "DELETE",
    http_path = "/prompts/{InstanceId}/{PromptId}",
    paginator = list()
  )
  input <- .connect$delete_prompt_input(InstanceId = InstanceId, PromptId = PromptId)
  output <- .connect$delete_prompt_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$delete_prompt <- connect_delete_prompt

#' Deletes a queue
#'
#' @description
#' Deletes a queue.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_delete_queue/](https://www.paws-r-sdk.com/docs/connect_delete_queue/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param QueueId &#91;required&#93; The identifier for the queue.
#'
#' @keywords internal
#'
#' @rdname connect_delete_queue
connect_delete_queue <- function(InstanceId, QueueId) {
  op <- new_operation(
    name = "DeleteQueue",
    http_method = "DELETE",
    http_path = "/queues/{InstanceId}/{QueueId}",
    paginator = list()
  )
  input <- .connect$delete_queue_input(InstanceId = InstanceId, QueueId = QueueId)
  output <- .connect$delete_queue_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$delete_queue <- connect_delete_queue

#' Deletes a quick connect
#'
#' @description
#' Deletes a quick connect.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_delete_quick_connect/](https://www.paws-r-sdk.com/docs/connect_delete_quick_connect/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param QuickConnectId &#91;required&#93; The identifier for the quick connect.
#'
#' @keywords internal
#'
#' @rdname connect_delete_quick_connect
connect_delete_quick_connect <- function(InstanceId, QuickConnectId) {
  op <- new_operation(
    name = "DeleteQuickConnect",
    http_method = "DELETE",
    http_path = "/quick-connects/{InstanceId}/{QuickConnectId}",
    paginator = list()
  )
  input <- .connect$delete_quick_connect_input(InstanceId = InstanceId, QuickConnectId = QuickConnectId)
  output <- .connect$delete_quick_connect_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$delete_quick_connect <- connect_delete_quick_connect

#' Deletes a routing profile
#'
#' @description
#' Deletes a routing profile.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_delete_routing_profile/](https://www.paws-r-sdk.com/docs/connect_delete_routing_profile/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param RoutingProfileId &#91;required&#93; The identifier of the routing profile.
#'
#' @keywords internal
#'
#' @rdname connect_delete_routing_profile
connect_delete_routing_profile <- function(InstanceId, RoutingProfileId) {
  op <- new_operation(
    name = "DeleteRoutingProfile",
    http_method = "DELETE",
    http_path = "/routing-profiles/{InstanceId}/{RoutingProfileId}",
    paginator = list()
  )
  input <- .connect$delete_routing_profile_input(InstanceId = InstanceId, RoutingProfileId = RoutingProfileId)
  output <- .connect$delete_routing_profile_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$delete_routing_profile <- connect_delete_routing_profile

#' Deletes a rule for the specified Amazon Connect instance
#'
#' @description
#' Deletes a rule for the specified Amazon Connect instance.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_delete_rule/](https://www.paws-r-sdk.com/docs/connect_delete_rule/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param RuleId &#91;required&#93; A unique identifier for the rule.
#'
#' @keywords internal
#'
#' @rdname connect_delete_rule
connect_delete_rule <- function(InstanceId, RuleId) {
  op <- new_operation(
    name = "DeleteRule",
    http_method = "DELETE",
    http_path = "/rules/{InstanceId}/{RuleId}",
    paginator = list()
  )
  input <- .connect$delete_rule_input(InstanceId = InstanceId, RuleId = RuleId)
  output <- .connect$delete_rule_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$delete_rule <- connect_delete_rule

#' Deletes a security profile
#'
#' @description
#' Deletes a security profile.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_delete_security_profile/](https://www.paws-r-sdk.com/docs/connect_delete_security_profile/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param SecurityProfileId &#91;required&#93; The identifier for the security profle.
#'
#' @keywords internal
#'
#' @rdname connect_delete_security_profile
connect_delete_security_profile <- function(InstanceId, SecurityProfileId) {
  op <- new_operation(
    name = "DeleteSecurityProfile",
    http_method = "DELETE",
    http_path = "/security-profiles/{InstanceId}/{SecurityProfileId}",
    paginator = list()
  )
  input <- .connect$delete_security_profile_input(InstanceId = InstanceId, SecurityProfileId = SecurityProfileId)
  output <- .connect$delete_security_profile_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$delete_security_profile <- connect_delete_security_profile

#' Deletes the task template
#'
#' @description
#' Deletes the task template.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_delete_task_template/](https://www.paws-r-sdk.com/docs/connect_delete_task_template/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param TaskTemplateId &#91;required&#93; A unique identifier for the task template.
#'
#' @keywords internal
#'
#' @rdname connect_delete_task_template
connect_delete_task_template <- function(InstanceId, TaskTemplateId) {
  op <- new_operation(
    name = "DeleteTaskTemplate",
    http_method = "DELETE",
    http_path = "/instance/{InstanceId}/task/template/{TaskTemplateId}",
    paginator = list()
  )
  input <- .connect$delete_task_template_input(InstanceId = InstanceId, TaskTemplateId = TaskTemplateId)
  output <- .connect$delete_task_template_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$delete_task_template <- connect_delete_task_template

#' Deletes a traffic distribution group
#'
#' @description
#' Deletes a traffic distribution group. This API can be called only in the Region where the traffic distribution group is created.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_delete_traffic_distribution_group/](https://www.paws-r-sdk.com/docs/connect_delete_traffic_distribution_group/) for full documentation.
#'
#' @param TrafficDistributionGroupId &#91;required&#93; The identifier of the traffic distribution group. This can be the ID or
#' the ARN if the API is being called in the Region where the traffic
#' distribution group was created. The ARN must be provided if the call is
#' from the replicated Region.
#'
#' @keywords internal
#'
#' @rdname connect_delete_traffic_distribution_group
connect_delete_traffic_distribution_group <- function(TrafficDistributionGroupId) {
  op <- new_operation(
    name = "DeleteTrafficDistributionGroup",
    http_method = "DELETE",
    http_path = "/traffic-distribution-group/{TrafficDistributionGroupId}",
    paginator = list()
  )
  input <- .connect$delete_traffic_distribution_group_input(TrafficDistributionGroupId = TrafficDistributionGroupId)
  output <- .connect$delete_traffic_distribution_group_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$delete_traffic_distribution_group <- connect_delete_traffic_distribution_group

#' Deletes a use case from an integration association
#'
#' @description
#' Deletes a use case from an integration association.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_delete_use_case/](https://www.paws-r-sdk.com/docs/connect_delete_use_case/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param IntegrationAssociationId &#91;required&#93; The identifier for the integration association.
#' @param UseCaseId &#91;required&#93; The identifier for the use case.
#'
#' @keywords internal
#'
#' @rdname connect_delete_use_case
connect_delete_use_case <- function(InstanceId, IntegrationAssociationId, UseCaseId) {
  op <- new_operation(
    name = "DeleteUseCase",
    http_method = "DELETE",
    http_path = "/instance/{InstanceId}/integration-associations/{IntegrationAssociationId}/use-cases/{UseCaseId}",
    paginator = list()
  )
  input <- .connect$delete_use_case_input(InstanceId = InstanceId, IntegrationAssociationId = IntegrationAssociationId, UseCaseId = UseCaseId)
  output <- .connect$delete_use_case_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$delete_use_case <- connect_delete_use_case

#' Deletes a user account from the specified Amazon Connect instance
#'
#' @description
#' Deletes a user account from the specified Amazon Connect instance.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_delete_user/](https://www.paws-r-sdk.com/docs/connect_delete_user/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param UserId &#91;required&#93; The identifier of the user.
#'
#' @keywords internal
#'
#' @rdname connect_delete_user
connect_delete_user <- function(InstanceId, UserId) {
  op <- new_operation(
    name = "DeleteUser",
    http_method = "DELETE",
    http_path = "/users/{InstanceId}/{UserId}",
    paginator = list()
  )
  input <- .connect$delete_user_input(InstanceId = InstanceId, UserId = UserId)
  output <- .connect$delete_user_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$delete_user <- connect_delete_user

#' Deletes an existing user hierarchy group
#'
#' @description
#' Deletes an existing user hierarchy group. It must not be associated with any agents or have any active child groups.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_delete_user_hierarchy_group/](https://www.paws-r-sdk.com/docs/connect_delete_user_hierarchy_group/) for full documentation.
#'
#' @param HierarchyGroupId &#91;required&#93; The identifier of the hierarchy group.
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#'
#' @keywords internal
#'
#' @rdname connect_delete_user_hierarchy_group
connect_delete_user_hierarchy_group <- function(HierarchyGroupId, InstanceId) {
  op <- new_operation(
    name = "DeleteUserHierarchyGroup",
    http_method = "DELETE",
    http_path = "/user-hierarchy-groups/{InstanceId}/{HierarchyGroupId}",
    paginator = list()
  )
  input <- .connect$delete_user_hierarchy_group_input(HierarchyGroupId = HierarchyGroupId, InstanceId = InstanceId)
  output <- .connect$delete_user_hierarchy_group_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$delete_user_hierarchy_group <- connect_delete_user_hierarchy_group

#' Deletes the view entirely
#'
#' @description
#' Deletes the view entirely. It deletes the view and all associated qualifiers (versions and aliases).
#'
#' See [https://www.paws-r-sdk.com/docs/connect_delete_view/](https://www.paws-r-sdk.com/docs/connect_delete_view/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can find the
#' instanceId in the ARN of the instance.
#' @param ViewId &#91;required&#93; The identifier of the view. Both `ViewArn` and `ViewId` can be used.
#'
#' @keywords internal
#'
#' @rdname connect_delete_view
connect_delete_view <- function(InstanceId, ViewId) {
  op <- new_operation(
    name = "DeleteView",
    http_method = "DELETE",
    http_path = "/views/{InstanceId}/{ViewId}",
    paginator = list()
  )
  input <- .connect$delete_view_input(InstanceId = InstanceId, ViewId = ViewId)
  output <- .connect$delete_view_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$delete_view <- connect_delete_view

#' Deletes the particular version specified in ViewVersion identifier
#'
#' @description
#' Deletes the particular version specified in `ViewVersion` identifier.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_delete_view_version/](https://www.paws-r-sdk.com/docs/connect_delete_view_version/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can find the
#' instanceId in the ARN of the instance.
#' @param ViewId &#91;required&#93; The identifier of the view. Both `ViewArn` and `ViewId` can be used.
#' @param ViewVersion &#91;required&#93; The version number of the view.
#'
#' @keywords internal
#'
#' @rdname connect_delete_view_version
connect_delete_view_version <- function(InstanceId, ViewId, ViewVersion) {
  op <- new_operation(
    name = "DeleteViewVersion",
    http_method = "DELETE",
    http_path = "/views/{InstanceId}/{ViewId}/versions/{ViewVersion}",
    paginator = list()
  )
  input <- .connect$delete_view_version_input(InstanceId = InstanceId, ViewId = ViewId, ViewVersion = ViewVersion)
  output <- .connect$delete_view_version_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$delete_view_version <- connect_delete_view_version

#' Deletes the vocabulary that has the given identifier
#'
#' @description
#' Deletes the vocabulary that has the given identifier.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_delete_vocabulary/](https://www.paws-r-sdk.com/docs/connect_delete_vocabulary/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param VocabularyId &#91;required&#93; The identifier of the custom vocabulary.
#'
#' @keywords internal
#'
#' @rdname connect_delete_vocabulary
connect_delete_vocabulary <- function(InstanceId, VocabularyId) {
  op <- new_operation(
    name = "DeleteVocabulary",
    http_method = "POST",
    http_path = "/vocabulary-remove/{InstanceId}/{VocabularyId}",
    paginator = list()
  )
  input <- .connect$delete_vocabulary_input(InstanceId = InstanceId, VocabularyId = VocabularyId)
  output <- .connect$delete_vocabulary_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$delete_vocabulary <- connect_delete_vocabulary

#' This API is in preview release for Amazon Connect and is subject to
#' change
#'
#' @description
#' This API is in preview release for Amazon Connect and is subject to change.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_describe_agent_status/](https://www.paws-r-sdk.com/docs/connect_describe_agent_status/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param AgentStatusId &#91;required&#93; The identifier for the agent status.
#'
#' @keywords internal
#'
#' @rdname connect_describe_agent_status
connect_describe_agent_status <- function(InstanceId, AgentStatusId) {
  op <- new_operation(
    name = "DescribeAgentStatus",
    http_method = "GET",
    http_path = "/agent-status/{InstanceId}/{AgentStatusId}",
    paginator = list()
  )
  input <- .connect$describe_agent_status_input(InstanceId = InstanceId, AgentStatusId = AgentStatusId)
  output <- .connect$describe_agent_status_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$describe_agent_status <- connect_describe_agent_status

#' This API is in preview release for Amazon Connect and is subject to
#' change
#'
#' @description
#' This API is in preview release for Amazon Connect and is subject to change.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_describe_contact/](https://www.paws-r-sdk.com/docs/connect_describe_contact/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param ContactId &#91;required&#93; The identifier of the contact.
#'
#' @keywords internal
#'
#' @rdname connect_describe_contact
connect_describe_contact <- function(InstanceId, ContactId) {
  op <- new_operation(
    name = "DescribeContact",
    http_method = "GET",
    http_path = "/contacts/{InstanceId}/{ContactId}",
    paginator = list()
  )
  input <- .connect$describe_contact_input(InstanceId = InstanceId, ContactId = ContactId)
  output <- .connect$describe_contact_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$describe_contact <- connect_describe_contact

#' Describes a contact evaluation in the specified Amazon Connect instance
#'
#' @description
#' Describes a contact evaluation in the specified Amazon Connect instance.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_describe_contact_evaluation/](https://www.paws-r-sdk.com/docs/connect_describe_contact_evaluation/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param EvaluationId &#91;required&#93; A unique identifier for the contact evaluation.
#'
#' @keywords internal
#'
#' @rdname connect_describe_contact_evaluation
connect_describe_contact_evaluation <- function(InstanceId, EvaluationId) {
  op <- new_operation(
    name = "DescribeContactEvaluation",
    http_method = "GET",
    http_path = "/contact-evaluations/{InstanceId}/{EvaluationId}",
    paginator = list()
  )
  input <- .connect$describe_contact_evaluation_input(InstanceId = InstanceId, EvaluationId = EvaluationId)
  output <- .connect$describe_contact_evaluation_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$describe_contact_evaluation <- connect_describe_contact_evaluation

#' Describes the specified flow
#'
#' @description
#' Describes the specified flow.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_describe_contact_flow/](https://www.paws-r-sdk.com/docs/connect_describe_contact_flow/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance.
#' @param ContactFlowId &#91;required&#93; The identifier of the flow.
#'
#' @keywords internal
#'
#' @rdname connect_describe_contact_flow
connect_describe_contact_flow <- function(InstanceId, ContactFlowId) {
  op <- new_operation(
    name = "DescribeContactFlow",
    http_method = "GET",
    http_path = "/contact-flows/{InstanceId}/{ContactFlowId}",
    paginator = list()
  )
  input <- .connect$describe_contact_flow_input(InstanceId = InstanceId, ContactFlowId = ContactFlowId)
  output <- .connect$describe_contact_flow_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$describe_contact_flow <- connect_describe_contact_flow

#' Describes the specified flow module
#'
#' @description
#' Describes the specified flow module.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_describe_contact_flow_module/](https://www.paws-r-sdk.com/docs/connect_describe_contact_flow_module/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param ContactFlowModuleId &#91;required&#93; The identifier of the flow module.
#'
#' @keywords internal
#'
#' @rdname connect_describe_contact_flow_module
connect_describe_contact_flow_module <- function(InstanceId, ContactFlowModuleId) {
  op <- new_operation(
    name = "DescribeContactFlowModule",
    http_method = "GET",
    http_path = "/contact-flow-modules/{InstanceId}/{ContactFlowModuleId}",
    paginator = list()
  )
  input <- .connect$describe_contact_flow_module_input(InstanceId = InstanceId, ContactFlowModuleId = ContactFlowModuleId)
  output <- .connect$describe_contact_flow_module_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$describe_contact_flow_module <- connect_describe_contact_flow_module

#' Describes an evaluation form in the specified Amazon Connect instance
#'
#' @description
#' Describes an evaluation form in the specified Amazon Connect instance. If the version property is not provided, the latest version of the evaluation form is described.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_describe_evaluation_form/](https://www.paws-r-sdk.com/docs/connect_describe_evaluation_form/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param EvaluationFormId &#91;required&#93; A unique identifier for the contact evaluation.
#' @param EvaluationFormVersion A version of the evaluation form.
#'
#' @keywords internal
#'
#' @rdname connect_describe_evaluation_form
connect_describe_evaluation_form <- function(InstanceId, EvaluationFormId, EvaluationFormVersion = NULL) {
  op <- new_operation(
    name = "DescribeEvaluationForm",
    http_method = "GET",
    http_path = "/evaluation-forms/{InstanceId}/{EvaluationFormId}",
    paginator = list()
  )
  input <- .connect$describe_evaluation_form_input(InstanceId = InstanceId, EvaluationFormId = EvaluationFormId, EvaluationFormVersion = EvaluationFormVersion)
  output <- .connect$describe_evaluation_form_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$describe_evaluation_form <- connect_describe_evaluation_form

#' This API is in preview release for Amazon Connect and is subject to
#' change
#'
#' @description
#' This API is in preview release for Amazon Connect and is subject to change.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_describe_hours_of_operation/](https://www.paws-r-sdk.com/docs/connect_describe_hours_of_operation/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param HoursOfOperationId &#91;required&#93; The identifier for the hours of operation.
#'
#' @keywords internal
#'
#' @rdname connect_describe_hours_of_operation
connect_describe_hours_of_operation <- function(InstanceId, HoursOfOperationId) {
  op <- new_operation(
    name = "DescribeHoursOfOperation",
    http_method = "GET",
    http_path = "/hours-of-operations/{InstanceId}/{HoursOfOperationId}",
    paginator = list()
  )
  input <- .connect$describe_hours_of_operation_input(InstanceId = InstanceId, HoursOfOperationId = HoursOfOperationId)
  output <- .connect$describe_hours_of_operation_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$describe_hours_of_operation <- connect_describe_hours_of_operation

#' This API is in preview release for Amazon Connect and is subject to
#' change
#'
#' @description
#' This API is in preview release for Amazon Connect and is subject to change.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_describe_instance/](https://www.paws-r-sdk.com/docs/connect_describe_instance/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#'
#' @keywords internal
#'
#' @rdname connect_describe_instance
connect_describe_instance <- function(InstanceId) {
  op <- new_operation(
    name = "DescribeInstance",
    http_method = "GET",
    http_path = "/instance/{InstanceId}",
    paginator = list()
  )
  input <- .connect$describe_instance_input(InstanceId = InstanceId)
  output <- .connect$describe_instance_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$describe_instance <- connect_describe_instance

#' This API is in preview release for Amazon Connect and is subject to
#' change
#'
#' @description
#' This API is in preview release for Amazon Connect and is subject to change.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_describe_instance_attribute/](https://www.paws-r-sdk.com/docs/connect_describe_instance_attribute/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param AttributeType &#91;required&#93; The type of attribute.
#'
#' @keywords internal
#'
#' @rdname connect_describe_instance_attribute
connect_describe_instance_attribute <- function(InstanceId, AttributeType) {
  op <- new_operation(
    name = "DescribeInstanceAttribute",
    http_method = "GET",
    http_path = "/instance/{InstanceId}/attribute/{AttributeType}",
    paginator = list()
  )
  input <- .connect$describe_instance_attribute_input(InstanceId = InstanceId, AttributeType = AttributeType)
  output <- .connect$describe_instance_attribute_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$describe_instance_attribute <- connect_describe_instance_attribute

#' This API is in preview release for Amazon Connect and is subject to
#' change
#'
#' @description
#' This API is in preview release for Amazon Connect and is subject to change.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_describe_instance_storage_config/](https://www.paws-r-sdk.com/docs/connect_describe_instance_storage_config/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param AssociationId &#91;required&#93; The existing association identifier that uniquely identifies the
#' resource type and storage config for the given instance ID.
#' @param ResourceType &#91;required&#93; A valid resource type.
#'
#' @keywords internal
#'
#' @rdname connect_describe_instance_storage_config
connect_describe_instance_storage_config <- function(InstanceId, AssociationId, ResourceType) {
  op <- new_operation(
    name = "DescribeInstanceStorageConfig",
    http_method = "GET",
    http_path = "/instance/{InstanceId}/storage-config/{AssociationId}",
    paginator = list()
  )
  input <- .connect$describe_instance_storage_config_input(InstanceId = InstanceId, AssociationId = AssociationId, ResourceType = ResourceType)
  output <- .connect$describe_instance_storage_config_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$describe_instance_storage_config <- connect_describe_instance_storage_config

#' Gets details and status of a phone number that’s claimed to your Amazon
#' Connect instance or traffic distribution group
#'
#' @description
#' Gets details and status of a phone number that’s claimed to your Amazon Connect instance or traffic distribution group.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_describe_phone_number/](https://www.paws-r-sdk.com/docs/connect_describe_phone_number/) for full documentation.
#'
#' @param PhoneNumberId &#91;required&#93; A unique identifier for the phone number.
#'
#' @keywords internal
#'
#' @rdname connect_describe_phone_number
connect_describe_phone_number <- function(PhoneNumberId) {
  op <- new_operation(
    name = "DescribePhoneNumber",
    http_method = "GET",
    http_path = "/phone-number/{PhoneNumberId}",
    paginator = list()
  )
  input <- .connect$describe_phone_number_input(PhoneNumberId = PhoneNumberId)
  output <- .connect$describe_phone_number_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$describe_phone_number <- connect_describe_phone_number

#' Describes a predefined attribute for the specified Amazon Connect
#' instance
#'
#' @description
#' Describes a predefined attribute for the specified Amazon Connect instance.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_describe_predefined_attribute/](https://www.paws-r-sdk.com/docs/connect_describe_predefined_attribute/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can find the instance
#' ID in the Amazon Resource Name (ARN) of the instance.
#' @param Name &#91;required&#93; The name of the predefined attribute.
#'
#' @keywords internal
#'
#' @rdname connect_describe_predefined_attribute
connect_describe_predefined_attribute <- function(InstanceId, Name) {
  op <- new_operation(
    name = "DescribePredefinedAttribute",
    http_method = "GET",
    http_path = "/predefined-attributes/{InstanceId}/{Name}",
    paginator = list()
  )
  input <- .connect$describe_predefined_attribute_input(InstanceId = InstanceId, Name = Name)
  output <- .connect$describe_predefined_attribute_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$describe_predefined_attribute <- connect_describe_predefined_attribute

#' Describes the prompt
#'
#' @description
#' Describes the prompt.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_describe_prompt/](https://www.paws-r-sdk.com/docs/connect_describe_prompt/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param PromptId &#91;required&#93; A unique identifier for the prompt.
#'
#' @keywords internal
#'
#' @rdname connect_describe_prompt
connect_describe_prompt <- function(InstanceId, PromptId) {
  op <- new_operation(
    name = "DescribePrompt",
    http_method = "GET",
    http_path = "/prompts/{InstanceId}/{PromptId}",
    paginator = list()
  )
  input <- .connect$describe_prompt_input(InstanceId = InstanceId, PromptId = PromptId)
  output <- .connect$describe_prompt_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$describe_prompt <- connect_describe_prompt

#' This API is in preview release for Amazon Connect and is subject to
#' change
#'
#' @description
#' This API is in preview release for Amazon Connect and is subject to change.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_describe_queue/](https://www.paws-r-sdk.com/docs/connect_describe_queue/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param QueueId &#91;required&#93; The identifier for the queue.
#'
#' @keywords internal
#'
#' @rdname connect_describe_queue
connect_describe_queue <- function(InstanceId, QueueId) {
  op <- new_operation(
    name = "DescribeQueue",
    http_method = "GET",
    http_path = "/queues/{InstanceId}/{QueueId}",
    paginator = list()
  )
  input <- .connect$describe_queue_input(InstanceId = InstanceId, QueueId = QueueId)
  output <- .connect$describe_queue_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$describe_queue <- connect_describe_queue

#' Describes the quick connect
#'
#' @description
#' Describes the quick connect.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_describe_quick_connect/](https://www.paws-r-sdk.com/docs/connect_describe_quick_connect/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param QuickConnectId &#91;required&#93; The identifier for the quick connect.
#'
#' @keywords internal
#'
#' @rdname connect_describe_quick_connect
connect_describe_quick_connect <- function(InstanceId, QuickConnectId) {
  op <- new_operation(
    name = "DescribeQuickConnect",
    http_method = "GET",
    http_path = "/quick-connects/{InstanceId}/{QuickConnectId}",
    paginator = list()
  )
  input <- .connect$describe_quick_connect_input(InstanceId = InstanceId, QuickConnectId = QuickConnectId)
  output <- .connect$describe_quick_connect_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$describe_quick_connect <- connect_describe_quick_connect

#' Describes the specified routing profile
#'
#' @description
#' Describes the specified routing profile.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_describe_routing_profile/](https://www.paws-r-sdk.com/docs/connect_describe_routing_profile/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param RoutingProfileId &#91;required&#93; The identifier of the routing profile.
#'
#' @keywords internal
#'
#' @rdname connect_describe_routing_profile
connect_describe_routing_profile <- function(InstanceId, RoutingProfileId) {
  op <- new_operation(
    name = "DescribeRoutingProfile",
    http_method = "GET",
    http_path = "/routing-profiles/{InstanceId}/{RoutingProfileId}",
    paginator = list()
  )
  input <- .connect$describe_routing_profile_input(InstanceId = InstanceId, RoutingProfileId = RoutingProfileId)
  output <- .connect$describe_routing_profile_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$describe_routing_profile <- connect_describe_routing_profile

#' Describes a rule for the specified Amazon Connect instance
#'
#' @description
#' Describes a rule for the specified Amazon Connect instance.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_describe_rule/](https://www.paws-r-sdk.com/docs/connect_describe_rule/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param RuleId &#91;required&#93; A unique identifier for the rule.
#'
#' @keywords internal
#'
#' @rdname connect_describe_rule
connect_describe_rule <- function(InstanceId, RuleId) {
  op <- new_operation(
    name = "DescribeRule",
    http_method = "GET",
    http_path = "/rules/{InstanceId}/{RuleId}",
    paginator = list()
  )
  input <- .connect$describe_rule_input(InstanceId = InstanceId, RuleId = RuleId)
  output <- .connect$describe_rule_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$describe_rule <- connect_describe_rule

#' Gets basic information about the security profle
#'
#' @description
#' Gets basic information about the security profle.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_describe_security_profile/](https://www.paws-r-sdk.com/docs/connect_describe_security_profile/) for full documentation.
#'
#' @param SecurityProfileId &#91;required&#93; The identifier for the security profle.
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#'
#' @keywords internal
#'
#' @rdname connect_describe_security_profile
connect_describe_security_profile <- function(SecurityProfileId, InstanceId) {
  op <- new_operation(
    name = "DescribeSecurityProfile",
    http_method = "GET",
    http_path = "/security-profiles/{InstanceId}/{SecurityProfileId}",
    paginator = list()
  )
  input <- .connect$describe_security_profile_input(SecurityProfileId = SecurityProfileId, InstanceId = InstanceId)
  output <- .connect$describe_security_profile_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$describe_security_profile <- connect_describe_security_profile

#' Gets details and status of a traffic distribution group
#'
#' @description
#' Gets details and status of a traffic distribution group.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_describe_traffic_distribution_group/](https://www.paws-r-sdk.com/docs/connect_describe_traffic_distribution_group/) for full documentation.
#'
#' @param TrafficDistributionGroupId &#91;required&#93; The identifier of the traffic distribution group. This can be the ID or
#' the ARN if the API is being called in the Region where the traffic
#' distribution group was created. The ARN must be provided if the call is
#' from the replicated Region.
#'
#' @keywords internal
#'
#' @rdname connect_describe_traffic_distribution_group
connect_describe_traffic_distribution_group <- function(TrafficDistributionGroupId) {
  op <- new_operation(
    name = "DescribeTrafficDistributionGroup",
    http_method = "GET",
    http_path = "/traffic-distribution-group/{TrafficDistributionGroupId}",
    paginator = list()
  )
  input <- .connect$describe_traffic_distribution_group_input(TrafficDistributionGroupId = TrafficDistributionGroupId)
  output <- .connect$describe_traffic_distribution_group_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$describe_traffic_distribution_group <- connect_describe_traffic_distribution_group

#' Describes the specified user
#'
#' @description
#' Describes the specified user. You can [find the instance ID in the Amazon Connect console](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html) (it’s the final part of the ARN). The console does not display the user IDs. Instead, list the users and note the IDs provided in the output.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_describe_user/](https://www.paws-r-sdk.com/docs/connect_describe_user/) for full documentation.
#'
#' @param UserId &#91;required&#93; The identifier of the user account.
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#'
#' @keywords internal
#'
#' @rdname connect_describe_user
connect_describe_user <- function(UserId, InstanceId) {
  op <- new_operation(
    name = "DescribeUser",
    http_method = "GET",
    http_path = "/users/{InstanceId}/{UserId}",
    paginator = list()
  )
  input <- .connect$describe_user_input(UserId = UserId, InstanceId = InstanceId)
  output <- .connect$describe_user_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$describe_user <- connect_describe_user

#' Describes the specified hierarchy group
#'
#' @description
#' Describes the specified hierarchy group.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_describe_user_hierarchy_group/](https://www.paws-r-sdk.com/docs/connect_describe_user_hierarchy_group/) for full documentation.
#'
#' @param HierarchyGroupId &#91;required&#93; The identifier of the hierarchy group.
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#'
#' @keywords internal
#'
#' @rdname connect_describe_user_hierarchy_group
connect_describe_user_hierarchy_group <- function(HierarchyGroupId, InstanceId) {
  op <- new_operation(
    name = "DescribeUserHierarchyGroup",
    http_method = "GET",
    http_path = "/user-hierarchy-groups/{InstanceId}/{HierarchyGroupId}",
    paginator = list()
  )
  input <- .connect$describe_user_hierarchy_group_input(HierarchyGroupId = HierarchyGroupId, InstanceId = InstanceId)
  output <- .connect$describe_user_hierarchy_group_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$describe_user_hierarchy_group <- connect_describe_user_hierarchy_group

#' Describes the hierarchy structure of the specified Amazon Connect
#' instance
#'
#' @description
#' Describes the hierarchy structure of the specified Amazon Connect instance.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_describe_user_hierarchy_structure/](https://www.paws-r-sdk.com/docs/connect_describe_user_hierarchy_structure/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#'
#' @keywords internal
#'
#' @rdname connect_describe_user_hierarchy_structure
connect_describe_user_hierarchy_structure <- function(InstanceId) {
  op <- new_operation(
    name = "DescribeUserHierarchyStructure",
    http_method = "GET",
    http_path = "/user-hierarchy-structure/{InstanceId}",
    paginator = list()
  )
  input <- .connect$describe_user_hierarchy_structure_input(InstanceId = InstanceId)
  output <- .connect$describe_user_hierarchy_structure_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$describe_user_hierarchy_structure <- connect_describe_user_hierarchy_structure

#' Retrieves the view for the specified Amazon Connect instance and view
#' identifier
#'
#' @description
#' Retrieves the view for the specified Amazon Connect instance and view identifier.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_describe_view/](https://www.paws-r-sdk.com/docs/connect_describe_view/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can find the
#' instanceId in the ARN of the instance.
#' @param ViewId &#91;required&#93; The ViewId of the view. This must be an ARN for Amazon Web Services
#' managed views.
#'
#' @keywords internal
#'
#' @rdname connect_describe_view
connect_describe_view <- function(InstanceId, ViewId) {
  op <- new_operation(
    name = "DescribeView",
    http_method = "GET",
    http_path = "/views/{InstanceId}/{ViewId}",
    paginator = list()
  )
  input <- .connect$describe_view_input(InstanceId = InstanceId, ViewId = ViewId)
  output <- .connect$describe_view_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$describe_view <- connect_describe_view

#' Describes the specified vocabulary
#'
#' @description
#' Describes the specified vocabulary.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_describe_vocabulary/](https://www.paws-r-sdk.com/docs/connect_describe_vocabulary/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param VocabularyId &#91;required&#93; The identifier of the custom vocabulary.
#'
#' @keywords internal
#'
#' @rdname connect_describe_vocabulary
connect_describe_vocabulary <- function(InstanceId, VocabularyId) {
  op <- new_operation(
    name = "DescribeVocabulary",
    http_method = "GET",
    http_path = "/vocabulary/{InstanceId}/{VocabularyId}",
    paginator = list()
  )
  input <- .connect$describe_vocabulary_input(InstanceId = InstanceId, VocabularyId = VocabularyId)
  output <- .connect$describe_vocabulary_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$describe_vocabulary <- connect_describe_vocabulary

#' This API is in preview release for Amazon Connect and is subject to
#' change
#'
#' @description
#' This API is in preview release for Amazon Connect and is subject to change.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_disassociate_analytics_data_set/](https://www.paws-r-sdk.com/docs/connect_disassociate_analytics_data_set/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param DataSetId &#91;required&#93; The identifier of the dataset to remove.
#' @param TargetAccountId The identifier of the target account. Use to associate a dataset to a
#' different account than the one containing the Amazon Connect instance.
#' If not specified, by default this value is the Amazon Web Services
#' account that has the Amazon Connect instance.
#'
#' @keywords internal
#'
#' @rdname connect_disassociate_analytics_data_set
connect_disassociate_analytics_data_set <- function(InstanceId, DataSetId, TargetAccountId = NULL) {
  op <- new_operation(
    name = "DisassociateAnalyticsDataSet",
    http_method = "POST",
    http_path = "/analytics-data/instance/{InstanceId}/association",
    paginator = list()
  )
  input <- .connect$disassociate_analytics_data_set_input(InstanceId = InstanceId, DataSetId = DataSetId, TargetAccountId = TargetAccountId)
  output <- .connect$disassociate_analytics_data_set_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$disassociate_analytics_data_set <- connect_disassociate_analytics_data_set

#' This API is in preview release for Amazon Connect and is subject to
#' change
#'
#' @description
#' This API is in preview release for Amazon Connect and is subject to change.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_disassociate_approved_origin/](https://www.paws-r-sdk.com/docs/connect_disassociate_approved_origin/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param Origin &#91;required&#93; The domain URL of the integrated application.
#'
#' @keywords internal
#'
#' @rdname connect_disassociate_approved_origin
connect_disassociate_approved_origin <- function(InstanceId, Origin) {
  op <- new_operation(
    name = "DisassociateApprovedOrigin",
    http_method = "DELETE",
    http_path = "/instance/{InstanceId}/approved-origin",
    paginator = list()
  )
  input <- .connect$disassociate_approved_origin_input(InstanceId = InstanceId, Origin = Origin)
  output <- .connect$disassociate_approved_origin_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$disassociate_approved_origin <- connect_disassociate_approved_origin

#' This API is in preview release for Amazon Connect and is subject to
#' change
#'
#' @description
#' This API is in preview release for Amazon Connect and is subject to change.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_disassociate_bot/](https://www.paws-r-sdk.com/docs/connect_disassociate_bot/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param LexBot 
#' @param LexV2Bot The Amazon Lex V2 bot to disassociate from the instance.
#'
#' @keywords internal
#'
#' @rdname connect_disassociate_bot
connect_disassociate_bot <- function(InstanceId, LexBot = NULL, LexV2Bot = NULL) {
  op <- new_operation(
    name = "DisassociateBot",
    http_method = "POST",
    http_path = "/instance/{InstanceId}/bot",
    paginator = list()
  )
  input <- .connect$disassociate_bot_input(InstanceId = InstanceId, LexBot = LexBot, LexV2Bot = LexV2Bot)
  output <- .connect$disassociate_bot_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$disassociate_bot <- connect_disassociate_bot

#' Disassociates a connect resource from a flow
#'
#' @description
#' Disassociates a connect resource from a flow.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_disassociate_flow/](https://www.paws-r-sdk.com/docs/connect_disassociate_flow/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param ResourceId &#91;required&#93; The identifier of the resource.
#' @param ResourceType &#91;required&#93; A valid resource type.
#'
#' @keywords internal
#'
#' @rdname connect_disassociate_flow
connect_disassociate_flow <- function(InstanceId, ResourceId, ResourceType) {
  op <- new_operation(
    name = "DisassociateFlow",
    http_method = "DELETE",
    http_path = "/flow-associations/{InstanceId}/{ResourceId}/{ResourceType}",
    paginator = list()
  )
  input <- .connect$disassociate_flow_input(InstanceId = InstanceId, ResourceId = ResourceId, ResourceType = ResourceType)
  output <- .connect$disassociate_flow_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$disassociate_flow <- connect_disassociate_flow

#' This API is in preview release for Amazon Connect and is subject to
#' change
#'
#' @description
#' This API is in preview release for Amazon Connect and is subject to change.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_disassociate_instance_storage_config/](https://www.paws-r-sdk.com/docs/connect_disassociate_instance_storage_config/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param AssociationId &#91;required&#93; The existing association identifier that uniquely identifies the
#' resource type and storage config for the given instance ID.
#' @param ResourceType &#91;required&#93; A valid resource type.
#'
#' @keywords internal
#'
#' @rdname connect_disassociate_instance_storage_config
connect_disassociate_instance_storage_config <- function(InstanceId, AssociationId, ResourceType) {
  op <- new_operation(
    name = "DisassociateInstanceStorageConfig",
    http_method = "DELETE",
    http_path = "/instance/{InstanceId}/storage-config/{AssociationId}",
    paginator = list()
  )
  input <- .connect$disassociate_instance_storage_config_input(InstanceId = InstanceId, AssociationId = AssociationId, ResourceType = ResourceType)
  output <- .connect$disassociate_instance_storage_config_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$disassociate_instance_storage_config <- connect_disassociate_instance_storage_config

#' This API is in preview release for Amazon Connect and is subject to
#' change
#'
#' @description
#' This API is in preview release for Amazon Connect and is subject to change.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_disassociate_lambda_function/](https://www.paws-r-sdk.com/docs/connect_disassociate_lambda_function/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance..
#' @param FunctionArn &#91;required&#93; The Amazon Resource Name (ARN) of the Lambda function being
#' disassociated.
#'
#' @keywords internal
#'
#' @rdname connect_disassociate_lambda_function
connect_disassociate_lambda_function <- function(InstanceId, FunctionArn) {
  op <- new_operation(
    name = "DisassociateLambdaFunction",
    http_method = "DELETE",
    http_path = "/instance/{InstanceId}/lambda-function",
    paginator = list()
  )
  input <- .connect$disassociate_lambda_function_input(InstanceId = InstanceId, FunctionArn = FunctionArn)
  output <- .connect$disassociate_lambda_function_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$disassociate_lambda_function <- connect_disassociate_lambda_function

#' This API is in preview release for Amazon Connect and is subject to
#' change
#'
#' @description
#' This API is in preview release for Amazon Connect and is subject to change.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_disassociate_lex_bot/](https://www.paws-r-sdk.com/docs/connect_disassociate_lex_bot/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param BotName &#91;required&#93; The name of the Amazon Lex bot. Maximum character limit of 50.
#' @param LexRegion &#91;required&#93; The Amazon Web Services Region in which the Amazon Lex bot has been
#' created.
#'
#' @keywords internal
#'
#' @rdname connect_disassociate_lex_bot
connect_disassociate_lex_bot <- function(InstanceId, BotName, LexRegion) {
  op <- new_operation(
    name = "DisassociateLexBot",
    http_method = "DELETE",
    http_path = "/instance/{InstanceId}/lex-bot",
    paginator = list()
  )
  input <- .connect$disassociate_lex_bot_input(InstanceId = InstanceId, BotName = BotName, LexRegion = LexRegion)
  output <- .connect$disassociate_lex_bot_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$disassociate_lex_bot <- connect_disassociate_lex_bot

#' Removes the flow association from a phone number claimed to your Amazon
#' Connect instance
#'
#' @description
#' Removes the flow association from a phone number claimed to your Amazon Connect instance.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_disassociate_phone_number_contact_flow/](https://www.paws-r-sdk.com/docs/connect_disassociate_phone_number_contact_flow/) for full documentation.
#'
#' @param PhoneNumberId &#91;required&#93; A unique identifier for the phone number.
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#'
#' @keywords internal
#'
#' @rdname connect_disassociate_phone_number_contact_flow
connect_disassociate_phone_number_contact_flow <- function(PhoneNumberId, InstanceId) {
  op <- new_operation(
    name = "DisassociatePhoneNumberContactFlow",
    http_method = "DELETE",
    http_path = "/phone-number/{PhoneNumberId}/contact-flow",
    paginator = list()
  )
  input <- .connect$disassociate_phone_number_contact_flow_input(PhoneNumberId = PhoneNumberId, InstanceId = InstanceId)
  output <- .connect$disassociate_phone_number_contact_flow_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$disassociate_phone_number_contact_flow <- connect_disassociate_phone_number_contact_flow

#' This API is in preview release for Amazon Connect and is subject to
#' change
#'
#' @description
#' This API is in preview release for Amazon Connect and is subject to change.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_disassociate_queue_quick_connects/](https://www.paws-r-sdk.com/docs/connect_disassociate_queue_quick_connects/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param QueueId &#91;required&#93; The identifier for the queue.
#' @param QuickConnectIds &#91;required&#93; The quick connects to disassociate from the queue.
#'
#' @keywords internal
#'
#' @rdname connect_disassociate_queue_quick_connects
connect_disassociate_queue_quick_connects <- function(InstanceId, QueueId, QuickConnectIds) {
  op <- new_operation(
    name = "DisassociateQueueQuickConnects",
    http_method = "POST",
    http_path = "/queues/{InstanceId}/{QueueId}/disassociate-quick-connects",
    paginator = list()
  )
  input <- .connect$disassociate_queue_quick_connects_input(InstanceId = InstanceId, QueueId = QueueId, QuickConnectIds = QuickConnectIds)
  output <- .connect$disassociate_queue_quick_connects_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$disassociate_queue_quick_connects <- connect_disassociate_queue_quick_connects

#' Disassociates a set of queues from a routing profile
#'
#' @description
#' Disassociates a set of queues from a routing profile.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_disassociate_routing_profile_queues/](https://www.paws-r-sdk.com/docs/connect_disassociate_routing_profile_queues/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param RoutingProfileId &#91;required&#93; The identifier of the routing profile.
#' @param QueueReferences &#91;required&#93; The queues to disassociate from this routing profile.
#'
#' @keywords internal
#'
#' @rdname connect_disassociate_routing_profile_queues
connect_disassociate_routing_profile_queues <- function(InstanceId, RoutingProfileId, QueueReferences) {
  op <- new_operation(
    name = "DisassociateRoutingProfileQueues",
    http_method = "POST",
    http_path = "/routing-profiles/{InstanceId}/{RoutingProfileId}/disassociate-queues",
    paginator = list()
  )
  input <- .connect$disassociate_routing_profile_queues_input(InstanceId = InstanceId, RoutingProfileId = RoutingProfileId, QueueReferences = QueueReferences)
  output <- .connect$disassociate_routing_profile_queues_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$disassociate_routing_profile_queues <- connect_disassociate_routing_profile_queues

#' This API is in preview release for Amazon Connect and is subject to
#' change
#'
#' @description
#' This API is in preview release for Amazon Connect and is subject to change.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_disassociate_security_key/](https://www.paws-r-sdk.com/docs/connect_disassociate_security_key/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param AssociationId &#91;required&#93; The existing association identifier that uniquely identifies the
#' resource type and storage config for the given instance ID.
#'
#' @keywords internal
#'
#' @rdname connect_disassociate_security_key
connect_disassociate_security_key <- function(InstanceId, AssociationId) {
  op <- new_operation(
    name = "DisassociateSecurityKey",
    http_method = "DELETE",
    http_path = "/instance/{InstanceId}/security-key/{AssociationId}",
    paginator = list()
  )
  input <- .connect$disassociate_security_key_input(InstanceId = InstanceId, AssociationId = AssociationId)
  output <- .connect$disassociate_security_key_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$disassociate_security_key <- connect_disassociate_security_key

#' Disassociates an agent from a traffic distribution group
#'
#' @description
#' Disassociates an agent from a traffic distribution group.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_disassociate_traffic_distribution_group_user/](https://www.paws-r-sdk.com/docs/connect_disassociate_traffic_distribution_group_user/) for full documentation.
#'
#' @param TrafficDistributionGroupId &#91;required&#93; The identifier of the traffic distribution group. This can be the ID or
#' the ARN if the API is being called in the Region where the traffic
#' distribution group was created. The ARN must be provided if the call is
#' from the replicated Region.
#' @param UserId &#91;required&#93; The identifier for the user. This can be the ID or the ARN of the user.
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#'
#' @keywords internal
#'
#' @rdname connect_disassociate_traffic_distribution_group_user
connect_disassociate_traffic_distribution_group_user <- function(TrafficDistributionGroupId, UserId, InstanceId) {
  op <- new_operation(
    name = "DisassociateTrafficDistributionGroupUser",
    http_method = "DELETE",
    http_path = "/traffic-distribution-group/{TrafficDistributionGroupId}/user",
    paginator = list()
  )
  input <- .connect$disassociate_traffic_distribution_group_user_input(TrafficDistributionGroupId = TrafficDistributionGroupId, UserId = UserId, InstanceId = InstanceId)
  output <- .connect$disassociate_traffic_distribution_group_user_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$disassociate_traffic_distribution_group_user <- connect_disassociate_traffic_distribution_group_user

#' Disassociates a set of proficiencies from a user
#'
#' @description
#' Disassociates a set of proficiencies from a user.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_disassociate_user_proficiencies/](https://www.paws-r-sdk.com/docs/connect_disassociate_user_proficiencies/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can find the instance
#' ID in the Amazon Resource Name (ARN) of the instance.
#' @param UserId &#91;required&#93; The identifier of the user account.
#' @param UserProficiencies &#91;required&#93; The proficiencies to disassociate from the user.
#'
#' @keywords internal
#'
#' @rdname connect_disassociate_user_proficiencies
connect_disassociate_user_proficiencies <- function(InstanceId, UserId, UserProficiencies) {
  op <- new_operation(
    name = "DisassociateUserProficiencies",
    http_method = "POST",
    http_path = "/users/{InstanceId}/{UserId}/disassociate-proficiencies",
    paginator = list()
  )
  input <- .connect$disassociate_user_proficiencies_input(InstanceId = InstanceId, UserId = UserId, UserProficiencies = UserProficiencies)
  output <- .connect$disassociate_user_proficiencies_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$disassociate_user_proficiencies <- connect_disassociate_user_proficiencies

#' Dismisses contacts from an agent’s CCP and returns the agent to an
#' available state, which allows the agent to receive a new routed contact
#'
#' @description
#' Dismisses contacts from an agent’s CCP and returns the agent to an available state, which allows the agent to receive a new routed contact. Contacts can only be dismissed if they are in a `MISSED`, `ERROR`, `ENDED`, or `REJECTED` state in the [Agent Event Stream](https://docs.aws.amazon.com/connect/latest/adminguide/about-contact-states.html).
#'
#' See [https://www.paws-r-sdk.com/docs/connect_dismiss_user_contact/](https://www.paws-r-sdk.com/docs/connect_dismiss_user_contact/) for full documentation.
#'
#' @param UserId &#91;required&#93; The identifier of the user account.
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can find the
#' instanceId in the ARN of the instance.
#' @param ContactId &#91;required&#93; The identifier of the contact.
#'
#' @keywords internal
#'
#' @rdname connect_dismiss_user_contact
connect_dismiss_user_contact <- function(UserId, InstanceId, ContactId) {
  op <- new_operation(
    name = "DismissUserContact",
    http_method = "POST",
    http_path = "/users/{InstanceId}/{UserId}/contact",
    paginator = list()
  )
  input <- .connect$dismiss_user_contact_input(UserId = UserId, InstanceId = InstanceId, ContactId = ContactId)
  output <- .connect$dismiss_user_contact_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$dismiss_user_contact <- connect_dismiss_user_contact

#' Retrieves the contact attributes for the specified contact
#'
#' @description
#' Retrieves the contact attributes for the specified contact.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_get_contact_attributes/](https://www.paws-r-sdk.com/docs/connect_get_contact_attributes/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance.
#' @param InitialContactId &#91;required&#93; The identifier of the initial contact.
#'
#' @keywords internal
#'
#' @rdname connect_get_contact_attributes
connect_get_contact_attributes <- function(InstanceId, InitialContactId) {
  op <- new_operation(
    name = "GetContactAttributes",
    http_method = "GET",
    http_path = "/contact/attributes/{InstanceId}/{InitialContactId}",
    paginator = list()
  )
  input <- .connect$get_contact_attributes_input(InstanceId = InstanceId, InitialContactId = InitialContactId)
  output <- .connect$get_contact_attributes_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$get_contact_attributes <- connect_get_contact_attributes

#' Gets the real-time metric data from the specified Amazon Connect
#' instance
#'
#' @description
#' Gets the real-time metric data from the specified Amazon Connect instance.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_get_current_metric_data/](https://www.paws-r-sdk.com/docs/connect_get_current_metric_data/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param Filters &#91;required&#93; The filters to apply to returned metrics. You can filter up to the
#' following limits:
#' 
#' -   Queues: 100
#' 
#' -   Routing profiles: 100
#' 
#' -   Channels: 3 (VOICE, CHAT, and TASK channels are supported.)
#' 
#' -   RoutingStepExpressions: 50
#' 
#' Metric data is retrieved only for the resources associated with the
#' queues or routing profiles, and by any channels included in the filter.
#' (You cannot filter by both queue AND routing profile.) You can include
#' both resource IDs and resource ARNs in the same request.
#' 
#' When using the `RoutingStepExpression` filter, you need to pass exactly
#' one `QueueId`. The filter is also case sensitive so when using the
#' `RoutingStepExpression` filter, grouping by `ROUTING_STEP_EXPRESSION` is
#' required.
#' 
#' Currently tagging is only supported on the resources that are passed in
#' the filter.
#' @param Groupings The grouping applied to the metrics returned. For example, when grouped
#' by `QUEUE`, the metrics returned apply to each queue rather than
#' aggregated for all queues.
#' 
#' -   If you group by `CHANNEL`, you should include a Channels filter.
#'     VOICE, CHAT, and TASK channels are supported.
#' 
#' -   If you group by `ROUTING_PROFILE`, you must include either a queue
#'     or routing profile filter. In addition, a routing profile filter is
#'     required for metrics `CONTACTS_SCHEDULED`, `CONTACTS_IN_QUEUE`, and
#'     ` OLDEST_CONTACT_AGE`.
#' 
#' -   If no `Grouping` is included in the request, a summary of metrics is
#'     returned.
#' 
#' -   When using the `RoutingStepExpression` filter, group by
#'     `ROUTING_STEP_EXPRESSION` is required.
#' @param CurrentMetrics &#91;required&#93; The metrics to retrieve. Specify the name and unit for each metric. The
#' following metrics are available. For a description of all the metrics,
#' see [Real-time Metrics
#' Definitions](https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html)
#' in the *Amazon Connect Administrator Guide*.
#' 
#' **AGENTS_AFTER_CONTACT_WORK**
#' 
#' Unit: COUNT
#' 
#' Name in real-time metrics report:
#' [ACW](https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#aftercallwork-real-time)
#' 
#' **AGENTS_AVAILABLE**
#' 
#' Unit: COUNT
#' 
#' Name in real-time metrics report:
#' [Available](https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#available-real-time)
#' 
#' **AGENTS_ERROR**
#' 
#' Unit: COUNT
#' 
#' Name in real-time metrics report:
#' [Error](https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#error-real-time)
#' 
#' **AGENTS_NON_PRODUCTIVE**
#' 
#' Unit: COUNT
#' 
#' Name in real-time metrics report: [NPT (Non-Productive
#' Time)](https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#non-productive-time-real-time)
#' 
#' **AGENTS_ON_CALL**
#' 
#' Unit: COUNT
#' 
#' Name in real-time metrics report: [On
#' contact](https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#on-call-real-time)
#' 
#' **AGENTS_ON_CONTACT**
#' 
#' Unit: COUNT
#' 
#' Name in real-time metrics report: [On
#' contact](https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#on-call-real-time)
#' 
#' **AGENTS_ONLINE**
#' 
#' Unit: COUNT
#' 
#' Name in real-time metrics report:
#' [Online](https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#online-real-time)
#' 
#' **AGENTS_STAFFED**
#' 
#' Unit: COUNT
#' 
#' Name in real-time metrics report:
#' [Staffed](https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#staffed-real-time)
#' 
#' **CONTACTS_IN_QUEUE**
#' 
#' Unit: COUNT
#' 
#' Name in real-time metrics report: [In
#' queue](https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#in-queue-real-time)
#' 
#' **CONTACTS_SCHEDULED**
#' 
#' Unit: COUNT
#' 
#' Name in real-time metrics report:
#' [Scheduled](https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#scheduled-real-time)
#' 
#' **OLDEST_CONTACT_AGE**
#' 
#' Unit: SECONDS
#' 
#' When you use groupings, Unit says SECONDS and the Value is returned in
#' SECONDS.
#' 
#' When you do not use groupings, Unit says SECONDS but the Value is
#' returned in MILLISECONDS. For example, if you get a response like this:
#' 
#' `\{ "Metric": \{ "Name": "OLDEST_CONTACT_AGE", "Unit": "SECONDS" \}, "Value": 24113.0 `\}
#' 
#' The actual OLDEST_CONTACT_AGE is 24 seconds.
#' 
#' When the filter `RoutingStepExpression` is used, this metric is still
#' calculated from enqueue time. For example, if a contact that has been
#' queued under `<Expression 1>` for 10 seconds has expired and
#' `<Expression 2>` becomes active, then `OLDEST_CONTACT_AGE` for this
#' queue will be counted starting from 10, not 0.
#' 
#' Name in real-time metrics report:
#' [Oldest](https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#oldest-real-time)
#' 
#' **SLOTS_ACTIVE**
#' 
#' Unit: COUNT
#' 
#' Name in real-time metrics report:
#' [Active](https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#active-real-time)
#' 
#' **SLOTS_AVAILABLE**
#' 
#' Unit: COUNT
#' 
#' Name in real-time metrics report:
#' [Availability](https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#availability-real-time)
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' 
#' The token expires after 5 minutes from the time it is created.
#' Subsequent requests that use the token must use the same request
#' parameters as the request that generated the token.
#' @param MaxResults The maximum number of results to return per page.
#' @param SortCriteria The way to sort the resulting response based on metrics. You can enter
#' one sort criteria. By default resources are sorted based on
#' `AGENTS_ONLINE`, `DESCENDING`. The metric collection is sorted based on
#' the input metrics.
#' 
#' Note the following:
#' 
#' -   Sorting on `SLOTS_ACTIVE` and `SLOTS_AVAILABLE` is not supported.
#'
#' @keywords internal
#'
#' @rdname connect_get_current_metric_data
connect_get_current_metric_data <- function(InstanceId, Filters, Groupings = NULL, CurrentMetrics, NextToken = NULL, MaxResults = NULL, SortCriteria = NULL) {
  op <- new_operation(
    name = "GetCurrentMetricData",
    http_method = "POST",
    http_path = "/metrics/current/{InstanceId}",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .connect$get_current_metric_data_input(InstanceId = InstanceId, Filters = Filters, Groupings = Groupings, CurrentMetrics = CurrentMetrics, NextToken = NextToken, MaxResults = MaxResults, SortCriteria = SortCriteria)
  output <- .connect$get_current_metric_data_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$get_current_metric_data <- connect_get_current_metric_data

#' Gets the real-time active user data from the specified Amazon Connect
#' instance
#'
#' @description
#' Gets the real-time active user data from the specified Amazon Connect instance.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_get_current_user_data/](https://www.paws-r-sdk.com/docs/connect_get_current_user_data/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param Filters &#91;required&#93; The filters to apply to returned user data. You can filter up to the
#' following limits:
#' 
#' -   Queues: 100
#' 
#' -   Routing profiles: 100
#' 
#' -   Agents: 100
#' 
#' -   Contact states: 9
#' 
#' -   User hierarchy groups: 1
#' 
#' The user data is retrieved for only the specified values/resources in
#' the filter. A maximum of one filter can be passed from queues, routing
#' profiles, agents, and user hierarchy groups.
#' 
#' Currently tagging is only supported on the resources that are passed in
#' the filter.
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param MaxResults The maximum number of results to return per page.
#'
#' @keywords internal
#'
#' @rdname connect_get_current_user_data
connect_get_current_user_data <- function(InstanceId, Filters, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetCurrentUserData",
    http_method = "POST",
    http_path = "/metrics/userdata/{InstanceId}",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .connect$get_current_user_data_input(InstanceId = InstanceId, Filters = Filters, NextToken = NextToken, MaxResults = MaxResults)
  output <- .connect$get_current_user_data_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$get_current_user_data <- connect_get_current_user_data

#' Supports SAML sign-in for Amazon Connect
#'
#' @description
#' Supports SAML sign-in for Amazon Connect. Retrieves a token for federation. The token is for the Amazon Connect user which corresponds to the IAM credentials that were used to invoke this action.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_get_federation_token/](https://www.paws-r-sdk.com/docs/connect_get_federation_token/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#'
#' @keywords internal
#'
#' @rdname connect_get_federation_token
connect_get_federation_token <- function(InstanceId) {
  op <- new_operation(
    name = "GetFederationToken",
    http_method = "GET",
    http_path = "/user/federate/{InstanceId}",
    paginator = list()
  )
  input <- .connect$get_federation_token_input(InstanceId = InstanceId)
  output <- .connect$get_federation_token_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$get_federation_token <- connect_get_federation_token

#' Retrieves the flow associated for a given resource
#'
#' @description
#' Retrieves the flow associated for a given resource.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_get_flow_association/](https://www.paws-r-sdk.com/docs/connect_get_flow_association/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param ResourceId &#91;required&#93; The identifier of the resource.
#' @param ResourceType &#91;required&#93; A valid resource type.
#'
#' @keywords internal
#'
#' @rdname connect_get_flow_association
connect_get_flow_association <- function(InstanceId, ResourceId, ResourceType) {
  op <- new_operation(
    name = "GetFlowAssociation",
    http_method = "GET",
    http_path = "/flow-associations/{InstanceId}/{ResourceId}/{ResourceType}",
    paginator = list()
  )
  input <- .connect$get_flow_association_input(InstanceId = InstanceId, ResourceId = ResourceId, ResourceType = ResourceType)
  output <- .connect$get_flow_association_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$get_flow_association <- connect_get_flow_association

#' Gets historical metric data from the specified Amazon Connect instance
#'
#' @description
#' Gets historical metric data from the specified Amazon Connect instance.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_get_metric_data/](https://www.paws-r-sdk.com/docs/connect_get_metric_data/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param StartTime &#91;required&#93; The timestamp, in UNIX Epoch time format, at which to start the
#' reporting interval for the retrieval of historical metrics data. The
#' time must be specified using a multiple of 5 minutes, such as 10:05,
#' 10:10, 10:15.
#' 
#' The start time cannot be earlier than 24 hours before the time of the
#' request. Historical metrics are available only for 24 hours.
#' @param EndTime &#91;required&#93; The timestamp, in UNIX Epoch time format, at which to end the reporting
#' interval for the retrieval of historical metrics data. The time must be
#' specified using an interval of 5 minutes, such as 11:00, 11:05, 11:10,
#' and must be later than the start time timestamp.
#' 
#' The time range between the start and end time must be less than 24
#' hours.
#' @param Filters &#91;required&#93; The queues, up to 100, or channels, to use to filter the metrics
#' returned. Metric data is retrieved only for the resources associated
#' with the queues or channels included in the filter. You can include both
#' queue IDs and queue ARNs in the same request. VOICE, CHAT, and TASK
#' channels are supported.
#' 
#' RoutingStepExpression is not a valid filter for GetMetricData and we
#' recommend switching to GetMetricDataV2 for more up-to-date features.
#' 
#' To filter by `Queues`, enter the queue ID/ARN, not the name of the
#' queue.
#' @param Groupings The grouping applied to the metrics returned. For example, when results
#' are grouped by queue, the metrics returned are grouped by queue. The
#' values returned apply to the metrics for each queue rather than
#' aggregated for all queues.
#' 
#' If no grouping is specified, a summary of metrics for all queues is
#' returned.
#' 
#' RoutingStepExpression is not a valid filter for GetMetricData and we
#' recommend switching to GetMetricDataV2 for more up-to-date features.
#' @param HistoricalMetrics &#91;required&#93; The metrics to retrieve. Specify the name, unit, and statistic for each
#' metric. The following historical metrics are available. For a
#' description of each metric, see [Historical Metrics
#' Definitions](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html)
#' in the *Amazon Connect Administrator Guide*.
#' 
#' This API does not support a contacts incoming metric (there's no
#' CONTACTS_INCOMING metric missing from the documented list).
#' 
#' **ABANDON_TIME**
#' 
#' Unit: SECONDS
#' 
#' Statistic: AVG
#' 
#' **AFTER_CONTACT_WORK_TIME**
#' 
#' Unit: SECONDS
#' 
#' Statistic: AVG
#' 
#' **API_CONTACTS_HANDLED**
#' 
#' Unit: COUNT
#' 
#' Statistic: SUM
#' 
#' **CALLBACK_CONTACTS_HANDLED**
#' 
#' Unit: COUNT
#' 
#' Statistic: SUM
#' 
#' **CONTACTS_ABANDONED**
#' 
#' Unit: COUNT
#' 
#' Statistic: SUM
#' 
#' **CONTACTS_AGENT_HUNG_UP_FIRST**
#' 
#' Unit: COUNT
#' 
#' Statistic: SUM
#' 
#' **CONTACTS_CONSULTED**
#' 
#' Unit: COUNT
#' 
#' Statistic: SUM
#' 
#' **CONTACTS_HANDLED**
#' 
#' Unit: COUNT
#' 
#' Statistic: SUM
#' 
#' **CONTACTS_HANDLED_INCOMING**
#' 
#' Unit: COUNT
#' 
#' Statistic: SUM
#' 
#' **CONTACTS_HANDLED_OUTBOUND**
#' 
#' Unit: COUNT
#' 
#' Statistic: SUM
#' 
#' **CONTACTS_HOLD_ABANDONS**
#' 
#' Unit: COUNT
#' 
#' Statistic: SUM
#' 
#' **CONTACTS_MISSED**
#' 
#' Unit: COUNT
#' 
#' Statistic: SUM
#' 
#' **CONTACTS_QUEUED**
#' 
#' Unit: COUNT
#' 
#' Statistic: SUM
#' 
#' **CONTACTS_TRANSFERRED_IN**
#' 
#' Unit: COUNT
#' 
#' Statistic: SUM
#' 
#' **CONTACTS_TRANSFERRED_IN_FROM_QUEUE**
#' 
#' Unit: COUNT
#' 
#' Statistic: SUM
#' 
#' **CONTACTS_TRANSFERRED_OUT**
#' 
#' Unit: COUNT
#' 
#' Statistic: SUM
#' 
#' **CONTACTS_TRANSFERRED_OUT_FROM_QUEUE**
#' 
#' Unit: COUNT
#' 
#' Statistic: SUM
#' 
#' **HANDLE_TIME**
#' 
#' Unit: SECONDS
#' 
#' Statistic: AVG
#' 
#' **HOLD_TIME**
#' 
#' Unit: SECONDS
#' 
#' Statistic: AVG
#' 
#' **INTERACTION_AND_HOLD_TIME**
#' 
#' Unit: SECONDS
#' 
#' Statistic: AVG
#' 
#' **INTERACTION_TIME**
#' 
#' Unit: SECONDS
#' 
#' Statistic: AVG
#' 
#' **OCCUPANCY**
#' 
#' Unit: PERCENT
#' 
#' Statistic: AVG
#' 
#' **QUEUE_ANSWER_TIME**
#' 
#' Unit: SECONDS
#' 
#' Statistic: AVG
#' 
#' **QUEUED_TIME**
#' 
#' Unit: SECONDS
#' 
#' Statistic: MAX
#' 
#' **SERVICE_LEVEL**
#' 
#' You can include up to 20 SERVICE_LEVEL metrics in a request.
#' 
#' Unit: PERCENT
#' 
#' Statistic: AVG
#' 
#' Threshold: For `ThresholdValue`, enter any whole number from 1 to 604800
#' (inclusive), in seconds. For `Comparison`, you must enter `LT` (for
#' "Less than").
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param MaxResults The maximum number of results to return per page.
#'
#' @keywords internal
#'
#' @rdname connect_get_metric_data
connect_get_metric_data <- function(InstanceId, StartTime, EndTime, Filters, Groupings = NULL, HistoricalMetrics, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetMetricData",
    http_method = "POST",
    http_path = "/metrics/historical/{InstanceId}",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .connect$get_metric_data_input(InstanceId = InstanceId, StartTime = StartTime, EndTime = EndTime, Filters = Filters, Groupings = Groupings, HistoricalMetrics = HistoricalMetrics, NextToken = NextToken, MaxResults = MaxResults)
  output <- .connect$get_metric_data_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$get_metric_data <- connect_get_metric_data

#' Gets metric data from the specified Amazon Connect instance
#'
#' @description
#' Gets metric data from the specified Amazon Connect instance.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_get_metric_data_v2/](https://www.paws-r-sdk.com/docs/connect_get_metric_data_v2/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource. This includes the
#' `instanceId` an Amazon Connect instance.
#' @param StartTime &#91;required&#93; The timestamp, in UNIX Epoch time format, at which to start the
#' reporting interval for the retrieval of historical metrics data. The
#' time must be before the end time timestamp. The start and end time
#' depends on the `IntervalPeriod` selected. By default the time range
#' between start and end time is 35 days. Historical metrics are available
#' for 3 months.
#' @param EndTime &#91;required&#93; The timestamp, in UNIX Epoch time format, at which to end the reporting
#' interval for the retrieval of historical metrics data. The time must be
#' later than the start time timestamp. It cannot be later than the current
#' timestamp.
#' @param Interval The interval period and timezone to apply to returned metrics.
#' 
#' -   `IntervalPeriod`: An aggregated grouping applied to request metrics.
#'     Valid `IntervalPeriod` values are: `FIFTEEN_MIN` | `THIRTY_MIN` |
#'     `HOUR` | `DAY` | `WEEK` | `TOTAL`.
#' 
#'     For example, if `IntervalPeriod` is selected `THIRTY_MIN`,
#'     `StartTime` and `EndTime` differs by 1 day, then Amazon Connect
#'     returns 48 results in the response. Each result is aggregated by the
#'     THIRTY_MIN period. By default Amazon Connect aggregates results
#'     based on the `TOTAL` interval period.
#' 
#'     The following list describes restrictions on `StartTime` and
#'     `EndTime` based on which `IntervalPeriod` is requested.
#' 
#'     -   `FIFTEEN_MIN`: The difference between `StartTime` and `EndTime`
#'         must be less than 3 days.
#' 
#'     -   `THIRTY_MIN`: The difference between `StartTime` and `EndTime`
#'         must be less than 3 days.
#' 
#'     -   `HOUR`: The difference between `StartTime` and `EndTime` must be
#'         less than 3 days.
#' 
#'     -   `DAY`: The difference between `StartTime` and `EndTime` must be
#'         less than 35 days.
#' 
#'     -   `WEEK`: The difference between `StartTime` and `EndTime` must be
#'         less than 35 days.
#' 
#'     -   `TOTAL`: The difference between `StartTime` and `EndTime` must
#'         be less than 35 days.
#' 
#' -   `TimeZone`: The timezone applied to requested metrics.
#' @param Filters &#91;required&#93; The filters to apply to returned metrics. You can filter on the
#' following resources:
#' 
#' -   Queues
#' 
#' -   Routing profiles
#' 
#' -   Agents
#' 
#' -   Channels
#' 
#' -   User hierarchy groups
#' 
#' -   Feature
#' 
#' -   Routing step expression
#' 
#' At least one filter must be passed from queues, routing profiles,
#' agents, or user hierarchy groups.
#' 
#' To filter by phone number, see [Create a historical metrics
#' report](https://docs.aws.amazon.com/connect/latest/adminguide/create-historical-metrics-report.html)
#' in the *Amazon Connect Administrator's Guide*.
#' 
#' Note the following limits:
#' 
#' -   **Filter keys**: A maximum of 5 filter keys are supported in a
#'     single request. Valid filter keys: `QUEUE` | `ROUTING_PROFILE` |
#'     `AGENT` | `CHANNEL` | `AGENT_HIERARCHY_LEVEL_ONE` |
#'     `AGENT_HIERARCHY_LEVEL_TWO` | `AGENT_HIERARCHY_LEVEL_THREE` |
#'     `AGENT_HIERARCHY_LEVEL_FOUR` | `AGENT_HIERARCHY_LEVEL_FIVE` |
#'     `FEATURE` | `CASE_TEMPLATE_ARN` | `CASE_STATUS` |
#'     `contact/segmentAttributes/connect:Subtype` |
#'     `ROUTING_STEP_EXPRESSION`
#' 
#' -   **Filter values**: A maximum of 100 filter values are supported in a
#'     single request. VOICE, CHAT, and TASK are valid `filterValue` for
#'     the CHANNEL filter key. They do not count towards limitation of 100
#'     filter values. For example, a GetMetricDataV2 request can filter by
#'     50 queues, 35 agents, and 15 routing profiles for a total of 100
#'     filter values, along with 3 channel filters.
#' 
#'     `contact_lens_conversational_analytics` is a valid filterValue for
#'     the `FEATURE` filter key. It is available only to contacts analyzed
#'     by Contact Lens conversational analytics.
#' 
#'     `connect:Chat`, `connect:SMS`, `connect:Telephony`, and
#'     `connect:WebRTC` are valid `filterValue` examples (not exhaustive)
#'     for the `contact/segmentAttributes/connect:Subtype filter` key.
#' 
#'     `ROUTING_STEP_EXPRESSION` is a valid filter key with a filter value
#'     up to 3000 length. This filter is case and order sensitive. JSON
#'     string fields must be sorted in ascending order and JSON array order
#'     should be kept as is.
#' @param Groupings The grouping applied to the metrics that are returned. For example, when
#' results are grouped by queue, the metrics returned are grouped by queue.
#' The values that are returned apply to the metrics for each queue. They
#' are not aggregated for all queues.
#' 
#' If no grouping is specified, a summary of all metrics is returned.
#' 
#' Valid grouping keys: `QUEUE` | `ROUTING_PROFILE` | `AGENT` | `CHANNEL` |
#' `AGENT_HIERARCHY_LEVEL_ONE` | `AGENT_HIERARCHY_LEVEL_TWO` |
#' `AGENT_HIERARCHY_LEVEL_THREE` | `AGENT_HIERARCHY_LEVEL_FOUR` |
#' `AGENT_HIERARCHY_LEVEL_FIVE` | `CASE_TEMPLATE_ARN` | `CASE_STATUS` |
#' `contact/segmentAttributes/connect:Subtype` | `ROUTING_STEP_EXPRESSION`
#' @param Metrics &#91;required&#93; The metrics to retrieve. Specify the name, groupings, and filters for
#' each metric. The following historical metrics are available. For a
#' description of each metric, see [Historical metrics
#' definitions](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html)
#' in the *Amazon Connect Administrator's Guide*.
#' 
#' **ABANDONMENT_RATE**
#' 
#' Unit: Percent
#' 
#' Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
#' Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype
#' 
#' UI name: [Abandonment
#' rate](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#abandonment-rate-historical)
#' 
#' **AGENT_ADHERENT_TIME**
#' 
#' This metric is available only in Amazon Web Services Regions where
#' [Forecasting, capacity planning, and
#' scheduling](https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region)
#' is available.
#' 
#' Unit: Seconds
#' 
#' Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
#' Agent Hierarchy
#' 
#' UI name: [Adherent
#' time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#adherent-time-historical)
#' 
#' **AGENT_ANSWER_RATE**
#' 
#' Unit: Percent
#' 
#' Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
#' Agent Hierarchy
#' 
#' UI name: [Agent answer
#' rate](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-answer-rate-historical)
#' 
#' **AGENT_NON_ADHERENT_TIME**
#' 
#' Unit: Seconds
#' 
#' Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
#' Agent Hierarchy
#' 
#' UI name: [Non-adherent
#' time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#non-adherent-time)
#' 
#' **AGENT_NON_RESPONSE**
#' 
#' Unit: Count
#' 
#' Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
#' Agent Hierarchy
#' 
#' UI name: [Agent
#' non-response](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-non-response)
#' 
#' **AGENT_NON_RESPONSE_WITHOUT_CUSTOMER_ABANDONS**
#' 
#' Unit: Count
#' 
#' Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
#' Agent Hierarchy
#' 
#' Data for this metric is available starting from October 1, 2023 0:00:00
#' GMT.
#' 
#' UI name: [Agent non-response without customer
#' abandons](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-nonresponse-no-abandon-historical)
#' 
#' **AGENT_OCCUPANCY**
#' 
#' Unit: Percentage
#' 
#' Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
#' 
#' UI name:
#' [Occupancy](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#occupancy-historical)
#' 
#' **AGENT_SCHEDULE_ADHERENCE**
#' 
#' This metric is available only in Amazon Web Services Regions where
#' [Forecasting, capacity planning, and
#' scheduling](https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region)
#' is available.
#' 
#' Unit: Percent
#' 
#' Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
#' Agent Hierarchy
#' 
#' UI name:
#' [Adherence](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#adherence-historical)
#' 
#' **AGENT_SCHEDULED_TIME**
#' 
#' This metric is available only in Amazon Web Services Regions where
#' [Forecasting, capacity planning, and
#' scheduling](https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region)
#' is available.
#' 
#' Unit: Seconds
#' 
#' Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
#' Agent Hierarchy
#' 
#' UI name: [Scheduled
#' time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#scheduled-time-historical)
#' 
#' **AVG_ABANDON_TIME**
#' 
#' Unit: Seconds
#' 
#' Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
#' Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype
#' 
#' UI name: [Average queue abandon
#' time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-queue-abandon-time-historical)
#' 
#' **AVG_ACTIVE_TIME**
#' 
#' Unit: Seconds
#' 
#' Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
#' Agent Hierarchy
#' 
#' UI name: [Average active
#' time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-active-time-historical)
#' 
#' **AVG_AFTER_CONTACT_WORK_TIME**
#' 
#' Unit: Seconds
#' 
#' Valid metric filter key: `INITIATION_METHOD`
#' 
#' Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
#' Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype
#' 
#' UI name: [Average after contact work
#' time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-acw-time-historical)
#' 
#' Feature is a valid filter but not a valid grouping.
#' 
#' **AVG_AGENT_CONNECTING_TIME**
#' 
#' Unit: Seconds
#' 
#' Valid metric filter key: `INITIATION_METHOD`. For now, this metric only
#' supports the following as `INITIATION_METHOD`: `INBOUND` | `OUTBOUND` |
#' `CALLBACK` | `API`
#' 
#' Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
#' Agent Hierarchy
#' 
#' UI name: [Average agent API connecting
#' time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#htm-avg-agent-api-connecting-time)
#' 
#' The `Negate` key in Metric Level Filters is not applicable for this
#' metric.
#' 
#' **AVG_AGENT_PAUSE_TIME**
#' 
#' Unit: Seconds
#' 
#' Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
#' Agent Hierarchy
#' 
#' UI name: [Average agent pause
#' time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-agent-pause-time-historical)
#' 
#' **AVG_CASE_RELATED_CONTACTS**
#' 
#' Unit: Count
#' 
#' Required filter key: CASE_TEMPLATE_ARN
#' 
#' Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
#' 
#' UI name: [Average contacts per
#' case](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-contacts-case-historical)
#' 
#' **AVG_CASE_RESOLUTION_TIME**
#' 
#' Unit: Seconds
#' 
#' Required filter key: CASE_TEMPLATE_ARN
#' 
#' Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
#' 
#' UI name: [Average case resolution
#' time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-case-resolution-time-historical)
#' 
#' **AVG_CONTACT_DURATION**
#' 
#' Unit: Seconds
#' 
#' Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
#' Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype
#' 
#' UI name: [Average contact
#' duration](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-contact-duration-historical)
#' 
#' Feature is a valid filter but not a valid grouping.
#' 
#' **AVG_CONVERSATION_DURATION**
#' 
#' Unit: Seconds
#' 
#' Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
#' Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype
#' 
#' UI name: [Average conversation
#' duration](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-conversation-duration-historical)
#' 
#' **AVG_GREETING_TIME_AGENT**
#' 
#' This metric is available only for contacts analyzed by Contact Lens
#' conversational analytics.
#' 
#' Unit: Seconds
#' 
#' Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
#' Agent Hierarchy, contact/segmentAttributes/connect:Subtype
#' 
#' UI name: [Average greeting time
#' agent](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-greeting-time-agent-historical)
#' 
#' **AVG_HANDLE_TIME**
#' 
#' Unit: Seconds
#' 
#' Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
#' Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype,
#' RoutingStepExpression
#' 
#' UI name: [Average handle
#' time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-handle-time-historical)
#' 
#' Feature is a valid filter but not a valid grouping.
#' 
#' **AVG_HOLD_TIME**
#' 
#' Unit: Seconds
#' 
#' Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
#' Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype
#' 
#' UI name: [Average customer hold
#' time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-customer-hold-time-historical)
#' 
#' Feature is a valid filter but not a valid grouping.
#' 
#' **AVG_HOLD_TIME_ALL_CONTACTS**
#' 
#' Unit: Seconds
#' 
#' Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
#' Agent Hierarchy, contact/segmentAttributes/connect:Subtype
#' 
#' UI name: [Average customer hold time all
#' contacts](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#avg-customer-hold-time-all-contacts-historical)
#' 
#' **AVG_HOLDS**
#' 
#' Unit: Count
#' 
#' Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
#' Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype
#' 
#' UI name: [Average
#' holds](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-holds-historical)
#' 
#' Feature is a valid filter but not a valid grouping.
#' 
#' **AVG_INTERACTION_AND_HOLD_TIME**
#' 
#' Unit: Seconds
#' 
#' Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
#' Agent Hierarchy, contact/segmentAttributes/connect:Subtype
#' 
#' UI name: [Average agent interaction and customer hold
#' time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-agent-interaction-customer-hold-time-historical)
#' 
#' **AVG_INTERACTION_TIME**
#' 
#' Unit: Seconds
#' 
#' Valid metric filter key: `INITIATION_METHOD`
#' 
#' Valid groupings and filters: Queue, Channel, Routing Profile, Feature,
#' contact/segmentAttributes/connect:Subtype
#' 
#' UI name: [Average agent interaction
#' time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-agent-interaction-time-historical)
#' 
#' Feature is a valid filter but not a valid grouping.
#' 
#' **AVG_INTERRUPTIONS_AGENT**
#' 
#' This metric is available only for contacts analyzed by Contact Lens
#' conversational analytics.
#' 
#' Unit: Count
#' 
#' Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
#' Agent Hierarchy, contact/segmentAttributes/connect:Subtype
#' 
#' UI name: [Average interruptions
#' agent](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-interruptions-agent-historical)
#' 
#' **AVG_INTERRUPTION_TIME_AGENT**
#' 
#' This metric is available only for contacts analyzed by Contact Lens
#' conversational analytics.
#' 
#' Unit: Seconds
#' 
#' Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
#' Agent Hierarchy, contact/segmentAttributes/connect:Subtype
#' 
#' UI name: [Average interruption time
#' agent](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-interruptions-time-agent-historical)
#' 
#' **AVG_NON_TALK_TIME**
#' 
#' This metric is available only for contacts analyzed by Contact Lens
#' conversational analytics.
#' 
#' Unit: Seconds
#' 
#' Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
#' Agent Hierarchy, contact/segmentAttributes/connect:Subtype
#' 
#' UI name: [Average non-talk
#' time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html##average-non-talk-time-historical)
#' 
#' **AVG_QUEUE_ANSWER_TIME**
#' 
#' Unit: Seconds
#' 
#' Valid groupings and filters: Queue, Channel, Routing Profile, Feature,
#' contact/segmentAttributes/connect:Subtype
#' 
#' UI name: [Average queue answer
#' time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-queue-answer-time-historical)
#' 
#' Feature is a valid filter but not a valid grouping.
#' 
#' **AVG_RESOLUTION_TIME**
#' 
#' Unit: Seconds
#' 
#' Valid groupings and filters: Queue, Channel, Routing Profile,
#' contact/segmentAttributes/connect:Subtype
#' 
#' UI name: [Average resolution
#' time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-resolution-time-historical)
#' 
#' **AVG_TALK_TIME**
#' 
#' This metric is available only for contacts analyzed by Contact Lens
#' conversational analytics.
#' 
#' Unit: Seconds
#' 
#' Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
#' Agent Hierarchy, contact/segmentAttributes/connect:Subtype
#' 
#' UI name: [Average talk
#' time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-talk-time-historical)
#' 
#' **AVG_TALK_TIME_AGENT**
#' 
#' This metric is available only for contacts analyzed by Contact Lens
#' conversational analytics.
#' 
#' Unit: Seconds
#' 
#' Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
#' Agent Hierarchy, contact/segmentAttributes/connect:Subtype
#' 
#' UI name: [Average talk time
#' agent](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-talk-time-agent-historical)
#' 
#' **AVG_TALK_TIME_CUSTOMER**
#' 
#' This metric is available only for contacts analyzed by Contact Lens
#' conversational analytics.
#' 
#' Unit: Seconds
#' 
#' Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
#' Agent Hierarchy, contact/segmentAttributes/connect:Subtype
#' 
#' UI name: [Average talk time
#' customer](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-talk-time-customer-historical)
#' 
#' **CASES_CREATED**
#' 
#' Unit: Count
#' 
#' Required filter key: CASE_TEMPLATE_ARN
#' 
#' Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
#' 
#' UI name: [Cases
#' created](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html##cases-created-historical)
#' 
#' **CONTACTS_ABANDONED**
#' 
#' Unit: Count
#' 
#' Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
#' Agent Hierarchy, contact/segmentAttributes/connect:Subtype,
#' RoutingStepExpression
#' 
#' UI name: [Contact
#' abandoned](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-abandoned-historical)
#' 
#' **CONTACTS_CREATED**
#' 
#' Unit: Count
#' 
#' Valid metric filter key: `INITIATION_METHOD`
#' 
#' Valid groupings and filters: Queue, Channel, Routing Profile, Feature,
#' contact/segmentAttributes/connect:Subtype
#' 
#' UI name: [Contacts
#' created](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-created-historical)
#' 
#' Feature is a valid filter but not a valid grouping.
#' 
#' **CONTACTS_HANDLED**
#' 
#' Unit: Count
#' 
#' Valid metric filter key: `INITIATION_METHOD`, `DISCONNECT_REASON`
#' 
#' Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
#' Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype,
#' RoutingStepExpression
#' 
#' UI name: [API contacts
#' handled](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#api-contacts-handled-historical)
#' 
#' Feature is a valid filter but not a valid grouping.
#' 
#' **CONTACTS_HANDLED_BY_CONNECTED_TO_AGENT**
#' 
#' Unit: Count
#' 
#' Valid metric filter key: `INITIATION_METHOD`
#' 
#' Valid groupings and filters: Queue, Channel, Agent, Agent Hierarchy,
#' contact/segmentAttributes/connect:Subtype
#' 
#' UI name: [Contacts handled by Connected to
#' agent](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-handled-by-connected-to-agent-historical)
#' 
#' **CONTACTS_HOLD_ABANDONS**
#' 
#' Unit: Count
#' 
#' Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
#' Agent Hierarchy, contact/segmentAttributes/connect:Subtype
#' 
#' UI name: [Contacts hold
#' disconnect](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-handled-by-connected-to-agent-historical)
#' 
#' **CONTACTS_ON_HOLD_AGENT_DISCONNECT**
#' 
#' Unit: Count
#' 
#' Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
#' Agent Hierarchy
#' 
#' UI name: [Contacts hold agent
#' disconnect](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-hold-agent-disconnect-historical)
#' 
#' **CONTACTS_ON_HOLD_CUSTOMER_DISCONNECT**
#' 
#' Unit: Count
#' 
#' Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
#' Agent Hierarchy
#' 
#' UI name: [Contacts hold customer
#' disconnect](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-hold-customer-disconnect-historical)
#' 
#' **CONTACTS_PUT_ON_HOLD**
#' 
#' Unit: Count
#' 
#' Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
#' Agent Hierarchy
#' 
#' UI name: [Contacts put on
#' hold](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-hold-customer-disconnect-historical)
#' 
#' **CONTACTS_TRANSFERRED_OUT_EXTERNAL**
#' 
#' Unit: Count
#' 
#' Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
#' Agent Hierarchy
#' 
#' UI name: [Contacts transferred out
#' external](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-transferred-out-external-historical)
#' 
#' **CONTACTS_TRANSFERRED_OUT_INTERNAL**
#' 
#' Unit: Percent
#' 
#' Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
#' Agent Hierarchy
#' 
#' UI name: [Contacts transferred out
#' internal](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-transferred-out-internal-historical)
#' 
#' **CONTACTS_QUEUED**
#' 
#' Unit: Count
#' 
#' Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
#' Agent Hierarchy, contact/segmentAttributes/connect:Subtype
#' 
#' UI name: [Contacts
#' queued](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-queued-historical)
#' 
#' **CONTACTS_QUEUED_BY_ENQUEUE**
#' 
#' Unit: Count
#' 
#' Valid groupings and filters: Queue, Channel, Agent, Agent Hierarchy,
#' contact/segmentAttributes/connect:Subtype
#' 
#' UI name: [Contacts queued by
#' Enqueue](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-queued-by-enqueue-historical)
#' 
#' **CONTACTS_RESOLVED_IN_X**
#' 
#' Unit: Count
#' 
#' Valid groupings and filters: Queue, Channel, Routing Profile,
#' contact/segmentAttributes/connect:Subtype
#' 
#' Threshold: For `ThresholdValue` enter any whole number from 1 to 604800
#' (inclusive), in seconds. For `Comparison`, you must enter `LT` (for
#' "Less than").
#' 
#' UI name: [Contacts resolved in
#' X](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-resolved-historical)
#' 
#' **CONTACTS_TRANSFERRED_OUT**
#' 
#' Unit: Count
#' 
#' Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
#' Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype
#' 
#' UI name: [Contacts transferred
#' out](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-transferred-out-historical)
#' 
#' Feature is a valid filter but not a valid grouping.
#' 
#' **CONTACTS_TRANSFERRED_OUT_BY_AGENT**
#' 
#' Unit: Count
#' 
#' Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
#' Agent Hierarchy, contact/segmentAttributes/connect:Subtype
#' 
#' UI name: [Contacts transferred out by
#' agent](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-transferred-out-by-agent-historical)
#' 
#' **CONTACTS_TRANSFERRED_OUT_FROM_QUEUE**
#' 
#' Unit: Count
#' 
#' Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
#' Agent Hierarchy, contact/segmentAttributes/connect:Subtype
#' 
#' UI name: [Contacts transferred out
#' queue](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-transferred-out-by-agent-historical)
#' 
#' **CURRENT_CASES**
#' 
#' Unit: Count
#' 
#' Required filter key: CASE_TEMPLATE_ARN
#' 
#' Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
#' 
#' UI name: [Current
#' cases](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#current-cases-historical)
#' 
#' **MAX_QUEUED_TIME**
#' 
#' Unit: Seconds
#' 
#' Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
#' Agent Hierarchy, contact/segmentAttributes/connect:Subtype
#' 
#' UI name: [Maximum queued
#' time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#maximum-queued-time-historical)
#' 
#' **PERCENT_CASES_FIRST_CONTACT_RESOLVED**
#' 
#' Unit: Percent
#' 
#' Required filter key: CASE_TEMPLATE_ARN
#' 
#' Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
#' 
#' UI name: [Cases resolved on first
#' contact](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#cases-resolved-first-contact-historical)
#' 
#' **PERCENT_CONTACTS_STEP_EXPIRED**
#' 
#' Unit: Percent
#' 
#' Valid groupings and filters: Queue, RoutingStepExpression
#' 
#' UI name: Not available
#' 
#' **PERCENT_CONTACTS_STEP_JOINED**
#' 
#' Unit: Percent
#' 
#' Valid groupings and filters: Queue, RoutingStepExpression
#' 
#' UI name: Not available
#' 
#' **PERCENT_NON_TALK_TIME**
#' 
#' This metric is available only for contacts analyzed by Contact Lens
#' conversational analytics.
#' 
#' Unit: Percentage
#' 
#' Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
#' Agent Hierarchy, contact/segmentAttributes/connect:Subtype
#' 
#' UI name: [Non-talk time
#' percent](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#ntt-historical)
#' 
#' **PERCENT_TALK_TIME**
#' 
#' This metric is available only for contacts analyzed by Contact Lens
#' conversational analytics.
#' 
#' Unit: Percentage
#' 
#' Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
#' Agent Hierarchy, contact/segmentAttributes/connect:Subtype
#' 
#' UI name: [Talk time
#' percent](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#tt-historical)
#' 
#' **PERCENT_TALK_TIME_AGENT**
#' 
#' This metric is available only for contacts analyzed by Contact Lens
#' conversational analytics.
#' 
#' Unit: Percentage
#' 
#' Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
#' Agent Hierarchy, contact/segmentAttributes/connect:Subtype
#' 
#' UI name: [Talk time agent
#' percent](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#ttagent-historical)
#' 
#' **PERCENT_TALK_TIME_CUSTOMER**
#' 
#' This metric is available only for contacts analyzed by Contact Lens
#' conversational analytics.
#' 
#' Unit: Percentage
#' 
#' Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
#' Agent Hierarchy, contact/segmentAttributes/connect:Subtype
#' 
#' UI name: [Talk time customer
#' percent](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#ttcustomer-historical)
#' 
#' **REOPENED_CASE_ACTIONS**
#' 
#' Unit: Count
#' 
#' Required filter key: CASE_TEMPLATE_ARN
#' 
#' Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
#' 
#' UI name: [Cases
#' reopened](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#cases-reopened-historical)
#' 
#' **RESOLVED_CASE_ACTIONS**
#' 
#' Unit: Count
#' 
#' Required filter key: CASE_TEMPLATE_ARN
#' 
#' Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS
#' 
#' UI name: [Cases
#' resolved](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#cases-resolved-historicall)
#' 
#' **SERVICE_LEVEL**
#' 
#' You can include up to 20 SERVICE_LEVEL metrics in a request.
#' 
#' Unit: Percent
#' 
#' Valid groupings and filters: Queue, Channel, Routing Profile
#' 
#' Threshold: For `ThresholdValue`, enter any whole number from 1 to 604800
#' (inclusive), in seconds. For `Comparison`, you must enter `LT` (for
#' "Less than").
#' 
#' UI name: [Service level
#' X](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#service-level-historical)
#' 
#' **STEP_CONTACTS_QUEUED**
#' 
#' Unit: Count
#' 
#' Valid groupings and filters: Queue, RoutingStepExpression
#' 
#' UI name: Not available
#' 
#' **SUM_AFTER_CONTACT_WORK_TIME**
#' 
#' Unit: Seconds
#' 
#' Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
#' Agent Hierarchy
#' 
#' UI name: [After contact work
#' time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#acw-historical)
#' 
#' **SUM_CONNECTING_TIME_AGENT**
#' 
#' Unit: Seconds
#' 
#' Valid metric filter key: `INITIATION_METHOD`. This metric only supports
#' the following filter keys as `INITIATION_METHOD`: `INBOUND` | `OUTBOUND`
#' | `CALLBACK` | `API`
#' 
#' Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
#' Agent Hierarchy
#' 
#' UI name: [Agent API connecting
#' time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#htm-agent-api-connecting-time)
#' 
#' The `Negate` key in Metric Level Filters is not applicable for this
#' metric.
#' 
#' **SUM_CONTACT_FLOW_TIME**
#' 
#' Unit: Seconds
#' 
#' Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
#' Agent Hierarchy
#' 
#' UI name: [Contact flow
#' time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contact-flow-time-historical)
#' 
#' **SUM_CONTACT_TIME_AGENT**
#' 
#' Unit: Seconds
#' 
#' Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
#' Agent Hierarchy
#' 
#' UI name: [Agent on contact
#' time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-on-contact-time-historical)
#' 
#' **SUM_CONTACTS_ANSWERED_IN_X**
#' 
#' Unit: Count
#' 
#' Valid groupings and filters: Queue, Channel, Routing Profile,
#' contact/segmentAttributes/connect:Subtype
#' 
#' Threshold: For `ThresholdValue`, enter any whole number from 1 to 604800
#' (inclusive), in seconds. For `Comparison`, you must enter `LT` (for
#' "Less than").
#' 
#' UI name: [Contacts answered in X
#' seconds](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-answered-x-historical)
#' 
#' **SUM_CONTACTS_ABANDONED_IN_X**
#' 
#' Unit: Count
#' 
#' Valid groupings and filters: Queue, Channel, Routing Profile,
#' contact/segmentAttributes/connect:Subtype
#' 
#' Threshold: For `ThresholdValue`, enter any whole number from 1 to 604800
#' (inclusive), in seconds. For `Comparison`, you must enter `LT` (for
#' "Less than").
#' 
#' UI name: [Contacts abandoned in X
#' seconds](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-abandoned-x-historical)
#' 
#' **SUM_CONTACTS_DISCONNECTED**
#' 
#' Valid metric filter key: `DISCONNECT_REASON`
#' 
#' Unit: Count
#' 
#' Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
#' Agent Hierarchy, contact/segmentAttributes/connect:Subtype
#' 
#' UI name: [Contact
#' disconnected](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contact-disconnected-historical)
#' 
#' **SUM_ERROR_STATUS_TIME_AGENT**
#' 
#' Unit: Seconds
#' 
#' Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
#' Agent Hierarchy
#' 
#' UI name: [Error status
#' time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#error-status-time-historical)
#' 
#' **SUM_HANDLE_TIME**
#' 
#' Unit: Seconds
#' 
#' Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
#' Agent Hierarchy
#' 
#' UI name: [Contact handle
#' time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contact-handle-time-historical)
#' 
#' **SUM_HOLD_TIME**
#' 
#' Unit: Count
#' 
#' Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
#' Agent Hierarchy
#' 
#' UI name: [Customer hold
#' time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#customer-hold-time-historical)
#' 
#' **SUM_IDLE_TIME_AGENT**
#' 
#' Unit: Seconds
#' 
#' Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
#' 
#' UI name: [Agent idle
#' time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-idle-time-historica)
#' 
#' **SUM_INTERACTION_AND_HOLD_TIME**
#' 
#' Unit: Seconds
#' 
#' Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
#' Agent Hierarchy
#' 
#' UI name: [Agent interaction and hold
#' time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-interaction-hold-time-historical)
#' 
#' **SUM_INTERACTION_TIME**
#' 
#' Unit: Seconds
#' 
#' Valid groupings and filters: Queue, Channel, Routing Profile, Agent,
#' Agent Hierarchy
#' 
#' UI name: [Agent interaction
#' time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-interaction-time-historical)
#' 
#' **SUM_NON_PRODUCTIVE_TIME_AGENT**
#' 
#' Unit: Seconds
#' 
#' Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
#' 
#' UI name: [Non-Productive
#' Time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#npt-historical)
#' 
#' **SUM_ONLINE_TIME_AGENT**
#' 
#' Unit: Seconds
#' 
#' Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy
#' 
#' UI name: [Online
#' time](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#online-time-historical)
#' 
#' **SUM_RETRY_CALLBACK_ATTEMPTS**
#' 
#' Unit: Count
#' 
#' Valid groupings and filters: Queue, Channel, Routing Profile,
#' contact/segmentAttributes/connect:Subtype
#' 
#' UI name: [Callback
#' attempts](https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#callback-attempts-historical)
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param MaxResults The maximum number of results to return per page.
#'
#' @keywords internal
#'
#' @rdname connect_get_metric_data_v2
connect_get_metric_data_v2 <- function(ResourceArn, StartTime, EndTime, Interval = NULL, Filters, Groupings = NULL, Metrics, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetMetricDataV2",
    http_method = "POST",
    http_path = "/metrics/data",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .connect$get_metric_data_v2_input(ResourceArn = ResourceArn, StartTime = StartTime, EndTime = EndTime, Interval = Interval, Filters = Filters, Groupings = Groupings, Metrics = Metrics, NextToken = NextToken, MaxResults = MaxResults)
  output <- .connect$get_metric_data_v2_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$get_metric_data_v2 <- connect_get_metric_data_v2

#' Gets the prompt file
#'
#' @description
#' Gets the prompt file.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_get_prompt_file/](https://www.paws-r-sdk.com/docs/connect_get_prompt_file/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param PromptId &#91;required&#93; A unique identifier for the prompt.
#'
#' @keywords internal
#'
#' @rdname connect_get_prompt_file
connect_get_prompt_file <- function(InstanceId, PromptId) {
  op <- new_operation(
    name = "GetPromptFile",
    http_method = "GET",
    http_path = "/prompts/{InstanceId}/{PromptId}/file",
    paginator = list()
  )
  input <- .connect$get_prompt_file_input(InstanceId = InstanceId, PromptId = PromptId)
  output <- .connect$get_prompt_file_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$get_prompt_file <- connect_get_prompt_file

#' Gets details about a specific task template in the specified Amazon
#' Connect instance
#'
#' @description
#' Gets details about a specific task template in the specified Amazon Connect instance.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_get_task_template/](https://www.paws-r-sdk.com/docs/connect_get_task_template/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param TaskTemplateId &#91;required&#93; A unique identifier for the task template.
#' @param SnapshotVersion The system generated version of a task template that is associated with
#' a task, when the task is created.
#'
#' @keywords internal
#'
#' @rdname connect_get_task_template
connect_get_task_template <- function(InstanceId, TaskTemplateId, SnapshotVersion = NULL) {
  op <- new_operation(
    name = "GetTaskTemplate",
    http_method = "GET",
    http_path = "/instance/{InstanceId}/task/template/{TaskTemplateId}",
    paginator = list()
  )
  input <- .connect$get_task_template_input(InstanceId = InstanceId, TaskTemplateId = TaskTemplateId, SnapshotVersion = SnapshotVersion)
  output <- .connect$get_task_template_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$get_task_template <- connect_get_task_template

#' Retrieves the current traffic distribution for a given traffic
#' distribution group
#'
#' @description
#' Retrieves the current traffic distribution for a given traffic distribution group.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_get_traffic_distribution/](https://www.paws-r-sdk.com/docs/connect_get_traffic_distribution/) for full documentation.
#'
#' @param Id &#91;required&#93; The identifier of the traffic distribution group. This can be the ID or
#' the ARN if the API is being called in the Region where the traffic
#' distribution group was created. The ARN must be provided if the call is
#' from the replicated Region.
#'
#' @keywords internal
#'
#' @rdname connect_get_traffic_distribution
connect_get_traffic_distribution <- function(Id) {
  op <- new_operation(
    name = "GetTrafficDistribution",
    http_method = "GET",
    http_path = "/traffic-distribution/{Id}",
    paginator = list()
  )
  input <- .connect$get_traffic_distribution_input(Id = Id)
  output <- .connect$get_traffic_distribution_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$get_traffic_distribution <- connect_get_traffic_distribution

#' Imports a claimed phone number from an external service, such as Amazon
#' Pinpoint, into an Amazon Connect instance
#'
#' @description
#' Imports a claimed phone number from an external service, such as Amazon Pinpoint, into an Amazon Connect instance. You can call this API only in the same Amazon Web Services Region where the Amazon Connect instance was created.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_import_phone_number/](https://www.paws-r-sdk.com/docs/connect_import_phone_number/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param SourcePhoneNumberArn &#91;required&#93; The claimed phone number ARN being imported from the external service,
#' such as Amazon Pinpoint. If it is from Amazon Pinpoint, it looks like
#' the ARN of the phone number to import from Amazon Pinpoint.
#' @param PhoneNumberDescription The description of the phone number.
#' @param Tags The tags used to organize, track, or control access for this resource.
#' For example, \{ "Tags": \{"key1":"value1", "key2":"value2"\} \}.
#' @param ClientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If not provided, the Amazon Web Services SDK
#' populates this field. For more information about idempotency, see
#' [Making retries safe with idempotent
#' APIs](https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
#'
#' @keywords internal
#'
#' @rdname connect_import_phone_number
connect_import_phone_number <- function(InstanceId, SourcePhoneNumberArn, PhoneNumberDescription = NULL, Tags = NULL, ClientToken = NULL) {
  op <- new_operation(
    name = "ImportPhoneNumber",
    http_method = "POST",
    http_path = "/phone-number/import",
    paginator = list()
  )
  input <- .connect$import_phone_number_input(InstanceId = InstanceId, SourcePhoneNumberArn = SourcePhoneNumberArn, PhoneNumberDescription = PhoneNumberDescription, Tags = Tags, ClientToken = ClientToken)
  output <- .connect$import_phone_number_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$import_phone_number <- connect_import_phone_number

#' This API is in preview release for Amazon Connect and is subject to
#' change
#'
#' @description
#' This API is in preview release for Amazon Connect and is subject to change.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_list_agent_statuses/](https://www.paws-r-sdk.com/docs/connect_list_agent_statuses/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param MaxResults The maximum number of results to return per page.
#' @param AgentStatusTypes Available agent status types.
#'
#' @keywords internal
#'
#' @rdname connect_list_agent_statuses
connect_list_agent_statuses <- function(InstanceId, NextToken = NULL, MaxResults = NULL, AgentStatusTypes = NULL) {
  op <- new_operation(
    name = "ListAgentStatuses",
    http_method = "GET",
    http_path = "/agent-status/{InstanceId}",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "AgentStatusSummaryList")
  )
  input <- .connect$list_agent_statuses_input(InstanceId = InstanceId, NextToken = NextToken, MaxResults = MaxResults, AgentStatusTypes = AgentStatusTypes)
  output <- .connect$list_agent_statuses_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$list_agent_statuses <- connect_list_agent_statuses

#' This API is in preview release for Amazon Connect and is subject to
#' change
#'
#' @description
#' This API is in preview release for Amazon Connect and is subject to change.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_list_analytics_data_associations/](https://www.paws-r-sdk.com/docs/connect_list_analytics_data_associations/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param DataSetId The identifier of the dataset to get the association status.
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param MaxResults The maximum number of results to return per page.
#'
#' @keywords internal
#'
#' @rdname connect_list_analytics_data_associations
connect_list_analytics_data_associations <- function(InstanceId, DataSetId = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListAnalyticsDataAssociations",
    http_method = "GET",
    http_path = "/analytics-data/instance/{InstanceId}/association",
    paginator = list()
  )
  input <- .connect$list_analytics_data_associations_input(InstanceId = InstanceId, DataSetId = DataSetId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .connect$list_analytics_data_associations_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$list_analytics_data_associations <- connect_list_analytics_data_associations

#' This API is in preview release for Amazon Connect and is subject to
#' change
#'
#' @description
#' This API is in preview release for Amazon Connect and is subject to change.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_list_approved_origins/](https://www.paws-r-sdk.com/docs/connect_list_approved_origins/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param MaxResults The maximum number of results to return per page.
#'
#' @keywords internal
#'
#' @rdname connect_list_approved_origins
connect_list_approved_origins <- function(InstanceId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListApprovedOrigins",
    http_method = "GET",
    http_path = "/instance/{InstanceId}/approved-origins",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Origins")
  )
  input <- .connect$list_approved_origins_input(InstanceId = InstanceId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .connect$list_approved_origins_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$list_approved_origins <- connect_list_approved_origins

#' This API is in preview release for Amazon Connect and is subject to
#' change
#'
#' @description
#' This API is in preview release for Amazon Connect and is subject to change.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_list_bots/](https://www.paws-r-sdk.com/docs/connect_list_bots/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param MaxResults The maximum number of results to return per page.
#' @param LexVersion &#91;required&#93; The version of Amazon Lex or Amazon Lex V2.
#'
#' @keywords internal
#'
#' @rdname connect_list_bots
connect_list_bots <- function(InstanceId, NextToken = NULL, MaxResults = NULL, LexVersion) {
  op <- new_operation(
    name = "ListBots",
    http_method = "GET",
    http_path = "/instance/{InstanceId}/bots",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "LexBots")
  )
  input <- .connect$list_bots_input(InstanceId = InstanceId, NextToken = NextToken, MaxResults = MaxResults, LexVersion = LexVersion)
  output <- .connect$list_bots_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$list_bots <- connect_list_bots

#' Lists contact evaluations in the specified Amazon Connect instance
#'
#' @description
#' Lists contact evaluations in the specified Amazon Connect instance.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_list_contact_evaluations/](https://www.paws-r-sdk.com/docs/connect_list_contact_evaluations/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param ContactId &#91;required&#93; The identifier of the contact in this instance of Amazon Connect.
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' 
#' This is not expected to be set because the value returned in the
#' previous response is always null.
#'
#' @keywords internal
#'
#' @rdname connect_list_contact_evaluations
connect_list_contact_evaluations <- function(InstanceId, ContactId, NextToken = NULL) {
  op <- new_operation(
    name = "ListContactEvaluations",
    http_method = "GET",
    http_path = "/contact-evaluations/{InstanceId}",
    paginator = list(input_token = "NextToken", output_token = "NextToken", result_key = "EvaluationSummaryList")
  )
  input <- .connect$list_contact_evaluations_input(InstanceId = InstanceId, ContactId = ContactId, NextToken = NextToken)
  output <- .connect$list_contact_evaluations_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$list_contact_evaluations <- connect_list_contact_evaluations

#' Provides information about the flow modules for the specified Amazon
#' Connect instance
#'
#' @description
#' Provides information about the flow modules for the specified Amazon Connect instance.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_list_contact_flow_modules/](https://www.paws-r-sdk.com/docs/connect_list_contact_flow_modules/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param MaxResults The maximum number of results to return per page.
#' @param ContactFlowModuleState The state of the flow module.
#'
#' @keywords internal
#'
#' @rdname connect_list_contact_flow_modules
connect_list_contact_flow_modules <- function(InstanceId, NextToken = NULL, MaxResults = NULL, ContactFlowModuleState = NULL) {
  op <- new_operation(
    name = "ListContactFlowModules",
    http_method = "GET",
    http_path = "/contact-flow-modules-summary/{InstanceId}",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "ContactFlowModulesSummaryList")
  )
  input <- .connect$list_contact_flow_modules_input(InstanceId = InstanceId, NextToken = NextToken, MaxResults = MaxResults, ContactFlowModuleState = ContactFlowModuleState)
  output <- .connect$list_contact_flow_modules_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$list_contact_flow_modules <- connect_list_contact_flow_modules

#' Provides information about the flows for the specified Amazon Connect
#' instance
#'
#' @description
#' Provides information about the flows for the specified Amazon Connect instance.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_list_contact_flows/](https://www.paws-r-sdk.com/docs/connect_list_contact_flows/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param ContactFlowTypes The type of flow.
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param MaxResults The maximum number of results to return per page. The default MaxResult
#' size is 100.
#'
#' @keywords internal
#'
#' @rdname connect_list_contact_flows
connect_list_contact_flows <- function(InstanceId, ContactFlowTypes = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListContactFlows",
    http_method = "GET",
    http_path = "/contact-flows-summary/{InstanceId}",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "ContactFlowSummaryList")
  )
  input <- .connect$list_contact_flows_input(InstanceId = InstanceId, ContactFlowTypes = ContactFlowTypes, NextToken = NextToken, MaxResults = MaxResults)
  output <- .connect$list_contact_flows_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$list_contact_flows <- connect_list_contact_flows

#' This API is in preview release for Amazon Connect and is subject to
#' change
#'
#' @description
#' This API is in preview release for Amazon Connect and is subject to change.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_list_contact_references/](https://www.paws-r-sdk.com/docs/connect_list_contact_references/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param ContactId &#91;required&#93; The identifier of the initial contact.
#' @param ReferenceTypes &#91;required&#93; The type of reference.
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' 
#' This is not expected to be set, because the value returned in the
#' previous response is always null.
#'
#' @keywords internal
#'
#' @rdname connect_list_contact_references
connect_list_contact_references <- function(InstanceId, ContactId, ReferenceTypes, NextToken = NULL) {
  op <- new_operation(
    name = "ListContactReferences",
    http_method = "GET",
    http_path = "/contact/references/{InstanceId}/{ContactId}",
    paginator = list(input_token = "NextToken", output_token = "NextToken", result_key = "ReferenceSummaryList")
  )
  input <- .connect$list_contact_references_input(InstanceId = InstanceId, ContactId = ContactId, ReferenceTypes = ReferenceTypes, NextToken = NextToken)
  output <- .connect$list_contact_references_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$list_contact_references <- connect_list_contact_references

#' Lists the default vocabularies for the specified Amazon Connect instance
#'
#' @description
#' Lists the default vocabularies for the specified Amazon Connect instance.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_list_default_vocabularies/](https://www.paws-r-sdk.com/docs/connect_list_default_vocabularies/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param LanguageCode The language code of the vocabulary entries. For a list of languages and
#' their corresponding language codes, see [What is Amazon
#' Transcribe?](https://docs.aws.amazon.com/transcribe/latest/dg/what-is.html)
#' @param MaxResults The maximum number of results to return per page.
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#'
#' @keywords internal
#'
#' @rdname connect_list_default_vocabularies
connect_list_default_vocabularies <- function(InstanceId, LanguageCode = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListDefaultVocabularies",
    http_method = "POST",
    http_path = "/default-vocabulary-summary/{InstanceId}",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "DefaultVocabularyList")
  )
  input <- .connect$list_default_vocabularies_input(InstanceId = InstanceId, LanguageCode = LanguageCode, MaxResults = MaxResults, NextToken = NextToken)
  output <- .connect$list_default_vocabularies_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$list_default_vocabularies <- connect_list_default_vocabularies

#' Lists versions of an evaluation form in the specified Amazon Connect
#' instance
#'
#' @description
#' Lists versions of an evaluation form in the specified Amazon Connect instance.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_list_evaluation_form_versions/](https://www.paws-r-sdk.com/docs/connect_list_evaluation_form_versions/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param EvaluationFormId &#91;required&#93; The unique identifier for the evaluation form.
#' @param MaxResults The maximum number of results to return per page.
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#'
#' @keywords internal
#'
#' @rdname connect_list_evaluation_form_versions
connect_list_evaluation_form_versions <- function(InstanceId, EvaluationFormId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListEvaluationFormVersions",
    http_method = "GET",
    http_path = "/evaluation-forms/{InstanceId}/{EvaluationFormId}/versions",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "EvaluationFormVersionSummaryList")
  )
  input <- .connect$list_evaluation_form_versions_input(InstanceId = InstanceId, EvaluationFormId = EvaluationFormId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .connect$list_evaluation_form_versions_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$list_evaluation_form_versions <- connect_list_evaluation_form_versions

#' Lists evaluation forms in the specified Amazon Connect instance
#'
#' @description
#' Lists evaluation forms in the specified Amazon Connect instance.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_list_evaluation_forms/](https://www.paws-r-sdk.com/docs/connect_list_evaluation_forms/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param MaxResults The maximum number of results to return per page.
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#'
#' @keywords internal
#'
#' @rdname connect_list_evaluation_forms
connect_list_evaluation_forms <- function(InstanceId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListEvaluationForms",
    http_method = "GET",
    http_path = "/evaluation-forms/{InstanceId}",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "EvaluationFormSummaryList")
  )
  input <- .connect$list_evaluation_forms_input(InstanceId = InstanceId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .connect$list_evaluation_forms_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$list_evaluation_forms <- connect_list_evaluation_forms

#' List the flow association based on the filters
#'
#' @description
#' List the flow association based on the filters.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_list_flow_associations/](https://www.paws-r-sdk.com/docs/connect_list_flow_associations/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param ResourceType A valid resource type.
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param MaxResults The maximum number of results to return per page.
#'
#' @keywords internal
#'
#' @rdname connect_list_flow_associations
connect_list_flow_associations <- function(InstanceId, ResourceType = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListFlowAssociations",
    http_method = "GET",
    http_path = "/flow-associations-summary/{InstanceId}",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "FlowAssociationSummaryList")
  )
  input <- .connect$list_flow_associations_input(InstanceId = InstanceId, ResourceType = ResourceType, NextToken = NextToken, MaxResults = MaxResults)
  output <- .connect$list_flow_associations_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$list_flow_associations <- connect_list_flow_associations

#' Provides information about the hours of operation for the specified
#' Amazon Connect instance
#'
#' @description
#' Provides information about the hours of operation for the specified Amazon Connect instance.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_list_hours_of_operations/](https://www.paws-r-sdk.com/docs/connect_list_hours_of_operations/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param MaxResults The maximum number of results to return per page. The default MaxResult
#' size is 100.
#'
#' @keywords internal
#'
#' @rdname connect_list_hours_of_operations
connect_list_hours_of_operations <- function(InstanceId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListHoursOfOperations",
    http_method = "GET",
    http_path = "/hours-of-operations-summary/{InstanceId}",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "HoursOfOperationSummaryList")
  )
  input <- .connect$list_hours_of_operations_input(InstanceId = InstanceId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .connect$list_hours_of_operations_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$list_hours_of_operations <- connect_list_hours_of_operations

#' This API is in preview release for Amazon Connect and is subject to
#' change
#'
#' @description
#' This API is in preview release for Amazon Connect and is subject to change.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_list_instance_attributes/](https://www.paws-r-sdk.com/docs/connect_list_instance_attributes/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param MaxResults The maximum number of results to return per page.
#'
#' @keywords internal
#'
#' @rdname connect_list_instance_attributes
connect_list_instance_attributes <- function(InstanceId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListInstanceAttributes",
    http_method = "GET",
    http_path = "/instance/{InstanceId}/attributes",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Attributes")
  )
  input <- .connect$list_instance_attributes_input(InstanceId = InstanceId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .connect$list_instance_attributes_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$list_instance_attributes <- connect_list_instance_attributes

#' This API is in preview release for Amazon Connect and is subject to
#' change
#'
#' @description
#' This API is in preview release for Amazon Connect and is subject to change.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_list_instance_storage_configs/](https://www.paws-r-sdk.com/docs/connect_list_instance_storage_configs/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param ResourceType &#91;required&#93; A valid resource type.
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param MaxResults The maximum number of results to return per page.
#'
#' @keywords internal
#'
#' @rdname connect_list_instance_storage_configs
connect_list_instance_storage_configs <- function(InstanceId, ResourceType, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListInstanceStorageConfigs",
    http_method = "GET",
    http_path = "/instance/{InstanceId}/storage-configs",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "StorageConfigs")
  )
  input <- .connect$list_instance_storage_configs_input(InstanceId = InstanceId, ResourceType = ResourceType, NextToken = NextToken, MaxResults = MaxResults)
  output <- .connect$list_instance_storage_configs_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$list_instance_storage_configs <- connect_list_instance_storage_configs

#' This API is in preview release for Amazon Connect and is subject to
#' change
#'
#' @description
#' This API is in preview release for Amazon Connect and is subject to change.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_list_instances/](https://www.paws-r-sdk.com/docs/connect_list_instances/) for full documentation.
#'
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param MaxResults The maximum number of results to return per page.
#'
#' @keywords internal
#'
#' @rdname connect_list_instances
connect_list_instances <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListInstances",
    http_method = "GET",
    http_path = "/instance",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "InstanceSummaryList")
  )
  input <- .connect$list_instances_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .connect$list_instances_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$list_instances <- connect_list_instances

#' Provides summary information about the Amazon Web Services resource
#' associations for the specified Amazon Connect instance
#'
#' @description
#' Provides summary information about the Amazon Web Services resource associations for the specified Amazon Connect instance.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_list_integration_associations/](https://www.paws-r-sdk.com/docs/connect_list_integration_associations/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param IntegrationType The integration type.
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param MaxResults The maximum number of results to return per page.
#' @param IntegrationArn The Amazon Resource Name (ARN) of the integration.
#'
#' @keywords internal
#'
#' @rdname connect_list_integration_associations
connect_list_integration_associations <- function(InstanceId, IntegrationType = NULL, NextToken = NULL, MaxResults = NULL, IntegrationArn = NULL) {
  op <- new_operation(
    name = "ListIntegrationAssociations",
    http_method = "GET",
    http_path = "/instance/{InstanceId}/integration-associations",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "IntegrationAssociationSummaryList")
  )
  input <- .connect$list_integration_associations_input(InstanceId = InstanceId, IntegrationType = IntegrationType, NextToken = NextToken, MaxResults = MaxResults, IntegrationArn = IntegrationArn)
  output <- .connect$list_integration_associations_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$list_integration_associations <- connect_list_integration_associations

#' This API is in preview release for Amazon Connect and is subject to
#' change
#'
#' @description
#' This API is in preview release for Amazon Connect and is subject to change.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_list_lambda_functions/](https://www.paws-r-sdk.com/docs/connect_list_lambda_functions/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param MaxResults The maximum number of results to return per page.
#'
#' @keywords internal
#'
#' @rdname connect_list_lambda_functions
connect_list_lambda_functions <- function(InstanceId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListLambdaFunctions",
    http_method = "GET",
    http_path = "/instance/{InstanceId}/lambda-functions",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "LambdaFunctions")
  )
  input <- .connect$list_lambda_functions_input(InstanceId = InstanceId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .connect$list_lambda_functions_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$list_lambda_functions <- connect_list_lambda_functions

#' This API is in preview release for Amazon Connect and is subject to
#' change
#'
#' @description
#' This API is in preview release for Amazon Connect and is subject to change.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_list_lex_bots/](https://www.paws-r-sdk.com/docs/connect_list_lex_bots/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param MaxResults The maximum number of results to return per page. If no value is
#' specified, the default is 10.
#'
#' @keywords internal
#'
#' @rdname connect_list_lex_bots
connect_list_lex_bots <- function(InstanceId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListLexBots",
    http_method = "GET",
    http_path = "/instance/{InstanceId}/lex-bots",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "LexBots")
  )
  input <- .connect$list_lex_bots_input(InstanceId = InstanceId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .connect$list_lex_bots_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$list_lex_bots <- connect_list_lex_bots

#' Provides information about the phone numbers for the specified Amazon
#' Connect instance
#'
#' @description
#' Provides information about the phone numbers for the specified Amazon Connect instance.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_list_phone_numbers/](https://www.paws-r-sdk.com/docs/connect_list_phone_numbers/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param PhoneNumberTypes The type of phone number.
#' 
#' We recommend using
#' [`list_phone_numbers_v2`][connect_list_phone_numbers_v2] to return phone
#' number types. While ListPhoneNumbers returns number types `UIFN`,
#' `SHARED`, `THIRD_PARTY_TF`, and `THIRD_PARTY_DID`, it incorrectly lists
#' them as `TOLL_FREE` or `DID`.
#' @param PhoneNumberCountryCodes The ISO country code.
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param MaxResults The maximum number of results to return per page. The default MaxResult
#' size is 100.
#'
#' @keywords internal
#'
#' @rdname connect_list_phone_numbers
connect_list_phone_numbers <- function(InstanceId, PhoneNumberTypes = NULL, PhoneNumberCountryCodes = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListPhoneNumbers",
    http_method = "GET",
    http_path = "/phone-numbers-summary/{InstanceId}",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "PhoneNumberSummaryList")
  )
  input <- .connect$list_phone_numbers_input(InstanceId = InstanceId, PhoneNumberTypes = PhoneNumberTypes, PhoneNumberCountryCodes = PhoneNumberCountryCodes, NextToken = NextToken, MaxResults = MaxResults)
  output <- .connect$list_phone_numbers_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$list_phone_numbers <- connect_list_phone_numbers

#' Lists phone numbers claimed to your Amazon Connect instance or traffic
#' distribution group
#'
#' @description
#' Lists phone numbers claimed to your Amazon Connect instance or traffic distribution group. If the provided `TargetArn` is a traffic distribution group, you can call this API in both Amazon Web Services Regions associated with traffic distribution group.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_list_phone_numbers_v2/](https://www.paws-r-sdk.com/docs/connect_list_phone_numbers_v2/) for full documentation.
#'
#' @param TargetArn The Amazon Resource Name (ARN) for Amazon Connect instances or traffic
#' distribution groups that phone number inbound traffic is routed through.
#' If both `TargetArn` and `InstanceId` input are not provided, this API
#' lists numbers claimed to all the Amazon Connect instances belonging to
#' your account in the same Amazon Web Services Region as the request.
#' @param InstanceId The identifier of the Amazon Connect instance that phone numbers are
#' claimed to. You can [find the instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance. If both `TargetArn`
#' and `InstanceId` are not provided, this API lists numbers claimed to all
#' the Amazon Connect instances belonging to your account in the same AWS
#' Region as the request.
#' @param MaxResults The maximum number of results to return per page.
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param PhoneNumberCountryCodes The ISO country code.
#' @param PhoneNumberTypes The type of phone number.
#' @param PhoneNumberPrefix The prefix of the phone number. If provided, it must contain `+` as part
#' of the country code.
#'
#' @keywords internal
#'
#' @rdname connect_list_phone_numbers_v2
connect_list_phone_numbers_v2 <- function(TargetArn = NULL, InstanceId = NULL, MaxResults = NULL, NextToken = NULL, PhoneNumberCountryCodes = NULL, PhoneNumberTypes = NULL, PhoneNumberPrefix = NULL) {
  op <- new_operation(
    name = "ListPhoneNumbersV2",
    http_method = "POST",
    http_path = "/phone-number/list",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "ListPhoneNumbersSummaryList")
  )
  input <- .connect$list_phone_numbers_v2_input(TargetArn = TargetArn, InstanceId = InstanceId, MaxResults = MaxResults, NextToken = NextToken, PhoneNumberCountryCodes = PhoneNumberCountryCodes, PhoneNumberTypes = PhoneNumberTypes, PhoneNumberPrefix = PhoneNumberPrefix)
  output <- .connect$list_phone_numbers_v2_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$list_phone_numbers_v2 <- connect_list_phone_numbers_v2

#' Lists predefined attributes for the specified Amazon Connect instance
#'
#' @description
#' Lists predefined attributes for the specified Amazon Connect instance.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_list_predefined_attributes/](https://www.paws-r-sdk.com/docs/connect_list_predefined_attributes/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can find the instance
#' ID in the Amazon Resource Name (ARN) of the instance.
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param MaxResults The maximum number of results to return per page.
#'
#' @keywords internal
#'
#' @rdname connect_list_predefined_attributes
connect_list_predefined_attributes <- function(InstanceId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListPredefinedAttributes",
    http_method = "GET",
    http_path = "/predefined-attributes/{InstanceId}",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "PredefinedAttributeSummaryList")
  )
  input <- .connect$list_predefined_attributes_input(InstanceId = InstanceId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .connect$list_predefined_attributes_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$list_predefined_attributes <- connect_list_predefined_attributes

#' Provides information about the prompts for the specified Amazon Connect
#' instance
#'
#' @description
#' Provides information about the prompts for the specified Amazon Connect instance.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_list_prompts/](https://www.paws-r-sdk.com/docs/connect_list_prompts/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance.
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param MaxResults The maximum number of results to return per page. The default MaxResult
#' size is 100.
#'
#' @keywords internal
#'
#' @rdname connect_list_prompts
connect_list_prompts <- function(InstanceId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListPrompts",
    http_method = "GET",
    http_path = "/prompts-summary/{InstanceId}",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "PromptSummaryList")
  )
  input <- .connect$list_prompts_input(InstanceId = InstanceId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .connect$list_prompts_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$list_prompts <- connect_list_prompts

#' This API is in preview release for Amazon Connect and is subject to
#' change
#'
#' @description
#' This API is in preview release for Amazon Connect and is subject to change.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_list_queue_quick_connects/](https://www.paws-r-sdk.com/docs/connect_list_queue_quick_connects/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param QueueId &#91;required&#93; The identifier for the queue.
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param MaxResults The maximum number of results to return per page. The default MaxResult
#' size is 100.
#'
#' @keywords internal
#'
#' @rdname connect_list_queue_quick_connects
connect_list_queue_quick_connects <- function(InstanceId, QueueId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListQueueQuickConnects",
    http_method = "GET",
    http_path = "/queues/{InstanceId}/{QueueId}/quick-connects",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", non_aggregate_keys = list( "LastModifiedRegion", "LastModifiedTime"), output_token = "NextToken", result_key = "QuickConnectSummaryList")
  )
  input <- .connect$list_queue_quick_connects_input(InstanceId = InstanceId, QueueId = QueueId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .connect$list_queue_quick_connects_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$list_queue_quick_connects <- connect_list_queue_quick_connects

#' Provides information about the queues for the specified Amazon Connect
#' instance
#'
#' @description
#' Provides information about the queues for the specified Amazon Connect instance.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_list_queues/](https://www.paws-r-sdk.com/docs/connect_list_queues/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param QueueTypes The type of queue.
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param MaxResults The maximum number of results to return per page. The default MaxResult
#' size is 100.
#'
#' @keywords internal
#'
#' @rdname connect_list_queues
connect_list_queues <- function(InstanceId, QueueTypes = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListQueues",
    http_method = "GET",
    http_path = "/queues-summary/{InstanceId}",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "QueueSummaryList")
  )
  input <- .connect$list_queues_input(InstanceId = InstanceId, QueueTypes = QueueTypes, NextToken = NextToken, MaxResults = MaxResults)
  output <- .connect$list_queues_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$list_queues <- connect_list_queues

#' Provides information about the quick connects for the specified Amazon
#' Connect instance
#'
#' @description
#' Provides information about the quick connects for the specified Amazon Connect instance.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_list_quick_connects/](https://www.paws-r-sdk.com/docs/connect_list_quick_connects/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param MaxResults The maximum number of results to return per page. The default MaxResult
#' size is 100.
#' @param QuickConnectTypes The type of quick connect. In the Amazon Connect admin website, when you
#' create a quick connect, you are prompted to assign one of the following
#' types: Agent (USER), External (PHONE_NUMBER), or Queue (QUEUE).
#'
#' @keywords internal
#'
#' @rdname connect_list_quick_connects
connect_list_quick_connects <- function(InstanceId, NextToken = NULL, MaxResults = NULL, QuickConnectTypes = NULL) {
  op <- new_operation(
    name = "ListQuickConnects",
    http_method = "GET",
    http_path = "/quick-connects/{InstanceId}",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "QuickConnectSummaryList")
  )
  input <- .connect$list_quick_connects_input(InstanceId = InstanceId, NextToken = NextToken, MaxResults = MaxResults, QuickConnectTypes = QuickConnectTypes)
  output <- .connect$list_quick_connects_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$list_quick_connects <- connect_list_quick_connects

#' Provides a list of analysis segments for a real-time analysis session
#'
#' @description
#' Provides a list of analysis segments for a real-time analysis session.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_list_realtime_contact_analysis_segments_v2/](https://www.paws-r-sdk.com/docs/connect_list_realtime_contact_analysis_segments_v2/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param ContactId &#91;required&#93; The identifier of the contact in this instance of Amazon Connect.
#' @param MaxResults The maximum number of results to return per page.
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param OutputType &#91;required&#93; The Contact Lens output type to be returned.
#' @param SegmentTypes &#91;required&#93; Enum with segment types . Each value corresponds to a segment type
#' returned in the segments list of the API. Each segment type has its own
#' structure. Different channels may have different sets of supported
#' segment types.
#'
#' @keywords internal
#'
#' @rdname connect_list_realtime_contact_analysis_segments_v2
connect_list_realtime_contact_analysis_segments_v2 <- function(InstanceId, ContactId, MaxResults = NULL, NextToken = NULL, OutputType, SegmentTypes) {
  op <- new_operation(
    name = "ListRealtimeContactAnalysisSegmentsV2",
    http_method = "POST",
    http_path = "/contact/list-real-time-analysis-segments-v2/{InstanceId}/{ContactId}",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .connect$list_realtime_contact_analysis_segments_v2_input(InstanceId = InstanceId, ContactId = ContactId, MaxResults = MaxResults, NextToken = NextToken, OutputType = OutputType, SegmentTypes = SegmentTypes)
  output <- .connect$list_realtime_contact_analysis_segments_v2_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$list_realtime_contact_analysis_segments_v2 <- connect_list_realtime_contact_analysis_segments_v2

#' Lists the queues associated with a routing profile
#'
#' @description
#' Lists the queues associated with a routing profile.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_list_routing_profile_queues/](https://www.paws-r-sdk.com/docs/connect_list_routing_profile_queues/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param RoutingProfileId &#91;required&#93; The identifier of the routing profile.
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param MaxResults The maximum number of results to return per page. The default MaxResult
#' size is 100.
#'
#' @keywords internal
#'
#' @rdname connect_list_routing_profile_queues
connect_list_routing_profile_queues <- function(InstanceId, RoutingProfileId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListRoutingProfileQueues",
    http_method = "GET",
    http_path = "/routing-profiles/{InstanceId}/{RoutingProfileId}/queues",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", non_aggregate_keys = list( "LastModifiedRegion", "LastModifiedTime"), output_token = "NextToken", result_key = "RoutingProfileQueueConfigSummaryList")
  )
  input <- .connect$list_routing_profile_queues_input(InstanceId = InstanceId, RoutingProfileId = RoutingProfileId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .connect$list_routing_profile_queues_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$list_routing_profile_queues <- connect_list_routing_profile_queues

#' Provides summary information about the routing profiles for the
#' specified Amazon Connect instance
#'
#' @description
#' Provides summary information about the routing profiles for the specified Amazon Connect instance.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_list_routing_profiles/](https://www.paws-r-sdk.com/docs/connect_list_routing_profiles/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param MaxResults The maximum number of results to return per page. The default MaxResult
#' size is 100.
#'
#' @keywords internal
#'
#' @rdname connect_list_routing_profiles
connect_list_routing_profiles <- function(InstanceId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListRoutingProfiles",
    http_method = "GET",
    http_path = "/routing-profiles-summary/{InstanceId}",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "RoutingProfileSummaryList")
  )
  input <- .connect$list_routing_profiles_input(InstanceId = InstanceId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .connect$list_routing_profiles_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$list_routing_profiles <- connect_list_routing_profiles

#' List all rules for the specified Amazon Connect instance
#'
#' @description
#' List all rules for the specified Amazon Connect instance.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_list_rules/](https://www.paws-r-sdk.com/docs/connect_list_rules/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param PublishStatus The publish status of the rule.
#' @param EventSourceName The name of the event source.
#' @param MaxResults The maximum number of results to return per page.
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#'
#' @keywords internal
#'
#' @rdname connect_list_rules
connect_list_rules <- function(InstanceId, PublishStatus = NULL, EventSourceName = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListRules",
    http_method = "GET",
    http_path = "/rules/{InstanceId}",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "RuleSummaryList")
  )
  input <- .connect$list_rules_input(InstanceId = InstanceId, PublishStatus = PublishStatus, EventSourceName = EventSourceName, MaxResults = MaxResults, NextToken = NextToken)
  output <- .connect$list_rules_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$list_rules <- connect_list_rules

#' This API is in preview release for Amazon Connect and is subject to
#' change
#'
#' @description
#' This API is in preview release for Amazon Connect and is subject to change.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_list_security_keys/](https://www.paws-r-sdk.com/docs/connect_list_security_keys/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param MaxResults The maximum number of results to return per page.
#'
#' @keywords internal
#'
#' @rdname connect_list_security_keys
connect_list_security_keys <- function(InstanceId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListSecurityKeys",
    http_method = "GET",
    http_path = "/instance/{InstanceId}/security-keys",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "SecurityKeys")
  )
  input <- .connect$list_security_keys_input(InstanceId = InstanceId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .connect$list_security_keys_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$list_security_keys <- connect_list_security_keys

#' Returns a list of third-party applications in a specific security
#' profile
#'
#' @description
#' Returns a list of third-party applications in a specific security profile.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_list_security_profile_applications/](https://www.paws-r-sdk.com/docs/connect_list_security_profile_applications/) for full documentation.
#'
#' @param SecurityProfileId &#91;required&#93; The identifier for the security profle.
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param MaxResults The maximum number of results to return per page.
#'
#' @keywords internal
#'
#' @rdname connect_list_security_profile_applications
connect_list_security_profile_applications <- function(SecurityProfileId, InstanceId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListSecurityProfileApplications",
    http_method = "GET",
    http_path = "/security-profiles-applications/{InstanceId}/{SecurityProfileId}",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", non_aggregate_keys = list( "LastModifiedRegion", "LastModifiedTime"), output_token = "NextToken", result_key = "Applications")
  )
  input <- .connect$list_security_profile_applications_input(SecurityProfileId = SecurityProfileId, InstanceId = InstanceId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .connect$list_security_profile_applications_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$list_security_profile_applications <- connect_list_security_profile_applications

#' Lists the permissions granted to a security profile
#'
#' @description
#' Lists the permissions granted to a security profile.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_list_security_profile_permissions/](https://www.paws-r-sdk.com/docs/connect_list_security_profile_permissions/) for full documentation.
#'
#' @param SecurityProfileId &#91;required&#93; The identifier for the security profle.
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param MaxResults The maximum number of results to return per page.
#'
#' @keywords internal
#'
#' @rdname connect_list_security_profile_permissions
connect_list_security_profile_permissions <- function(SecurityProfileId, InstanceId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListSecurityProfilePermissions",
    http_method = "GET",
    http_path = "/security-profiles-permissions/{InstanceId}/{SecurityProfileId}",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", non_aggregate_keys = list( "LastModifiedRegion", "LastModifiedTime"), output_token = "NextToken", result_key = "Permissions")
  )
  input <- .connect$list_security_profile_permissions_input(SecurityProfileId = SecurityProfileId, InstanceId = InstanceId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .connect$list_security_profile_permissions_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$list_security_profile_permissions <- connect_list_security_profile_permissions

#' Provides summary information about the security profiles for the
#' specified Amazon Connect instance
#'
#' @description
#' Provides summary information about the security profiles for the specified Amazon Connect instance.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_list_security_profiles/](https://www.paws-r-sdk.com/docs/connect_list_security_profiles/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param MaxResults The maximum number of results to return per page. The default MaxResult
#' size is 100.
#'
#' @keywords internal
#'
#' @rdname connect_list_security_profiles
connect_list_security_profiles <- function(InstanceId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListSecurityProfiles",
    http_method = "GET",
    http_path = "/security-profiles-summary/{InstanceId}",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "SecurityProfileSummaryList")
  )
  input <- .connect$list_security_profiles_input(InstanceId = InstanceId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .connect$list_security_profiles_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$list_security_profiles <- connect_list_security_profiles

#' Lists the tags for the specified resource
#'
#' @description
#' Lists the tags for the specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/connect_list_tags_for_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource. All Amazon Connect
#' resources (instances, queues, flows, routing profiles, etc) have an ARN.
#' To locate the ARN for an instance, for example, see [Find your Amazon
#' Connect instance
#' ID/ARN](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html).
#'
#' @keywords internal
#'
#' @rdname connect_list_tags_for_resource
connect_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .connect$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .connect$list_tags_for_resource_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$list_tags_for_resource <- connect_list_tags_for_resource

#' Lists task templates for the specified Amazon Connect instance
#'
#' @description
#' Lists task templates for the specified Amazon Connect instance.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_list_task_templates/](https://www.paws-r-sdk.com/docs/connect_list_task_templates/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' 
#' It is not expected that you set this because the value returned in the
#' previous response is always null.
#' @param MaxResults The maximum number of results to return per page.
#' 
#' It is not expected that you set this.
#' @param Status Marks a template as `ACTIVE` or `INACTIVE` for a task to refer to it.
#' Tasks can only be created from `ACTIVE` templates. If a template is
#' marked as `INACTIVE`, then a task that refers to this template cannot be
#' created.
#' @param Name The name of the task template.
#'
#' @keywords internal
#'
#' @rdname connect_list_task_templates
connect_list_task_templates <- function(InstanceId, NextToken = NULL, MaxResults = NULL, Status = NULL, Name = NULL) {
  op <- new_operation(
    name = "ListTaskTemplates",
    http_method = "GET",
    http_path = "/instance/{InstanceId}/task/template",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "TaskTemplates")
  )
  input <- .connect$list_task_templates_input(InstanceId = InstanceId, NextToken = NextToken, MaxResults = MaxResults, Status = Status, Name = Name)
  output <- .connect$list_task_templates_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$list_task_templates <- connect_list_task_templates

#' Lists traffic distribution group users
#'
#' @description
#' Lists traffic distribution group users.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_list_traffic_distribution_group_users/](https://www.paws-r-sdk.com/docs/connect_list_traffic_distribution_group_users/) for full documentation.
#'
#' @param TrafficDistributionGroupId &#91;required&#93; The identifier of the traffic distribution group. This can be the ID or
#' the ARN if the API is being called in the Region where the traffic
#' distribution group was created. The ARN must be provided if the call is
#' from the replicated Region.
#' @param MaxResults The maximum number of results to return per page.
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#'
#' @keywords internal
#'
#' @rdname connect_list_traffic_distribution_group_users
connect_list_traffic_distribution_group_users <- function(TrafficDistributionGroupId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListTrafficDistributionGroupUsers",
    http_method = "GET",
    http_path = "/traffic-distribution-group/{TrafficDistributionGroupId}/user",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "TrafficDistributionGroupUserSummaryList")
  )
  input <- .connect$list_traffic_distribution_group_users_input(TrafficDistributionGroupId = TrafficDistributionGroupId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .connect$list_traffic_distribution_group_users_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$list_traffic_distribution_group_users <- connect_list_traffic_distribution_group_users

#' Lists traffic distribution groups
#'
#' @description
#' Lists traffic distribution groups.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_list_traffic_distribution_groups/](https://www.paws-r-sdk.com/docs/connect_list_traffic_distribution_groups/) for full documentation.
#'
#' @param MaxResults The maximum number of results to return per page.
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param InstanceId The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#'
#' @keywords internal
#'
#' @rdname connect_list_traffic_distribution_groups
connect_list_traffic_distribution_groups <- function(MaxResults = NULL, NextToken = NULL, InstanceId = NULL) {
  op <- new_operation(
    name = "ListTrafficDistributionGroups",
    http_method = "GET",
    http_path = "/traffic-distribution-groups",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "TrafficDistributionGroupSummaryList")
  )
  input <- .connect$list_traffic_distribution_groups_input(MaxResults = MaxResults, NextToken = NextToken, InstanceId = InstanceId)
  output <- .connect$list_traffic_distribution_groups_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$list_traffic_distribution_groups <- connect_list_traffic_distribution_groups

#' Lists the use cases for the integration association
#'
#' @description
#' Lists the use cases for the integration association.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_list_use_cases/](https://www.paws-r-sdk.com/docs/connect_list_use_cases/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param IntegrationAssociationId &#91;required&#93; The identifier for the integration association.
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param MaxResults The maximum number of results to return per page.
#'
#' @keywords internal
#'
#' @rdname connect_list_use_cases
connect_list_use_cases <- function(InstanceId, IntegrationAssociationId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListUseCases",
    http_method = "GET",
    http_path = "/instance/{InstanceId}/integration-associations/{IntegrationAssociationId}/use-cases",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "UseCaseSummaryList")
  )
  input <- .connect$list_use_cases_input(InstanceId = InstanceId, IntegrationAssociationId = IntegrationAssociationId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .connect$list_use_cases_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$list_use_cases <- connect_list_use_cases

#' Provides summary information about the hierarchy groups for the
#' specified Amazon Connect instance
#'
#' @description
#' Provides summary information about the hierarchy groups for the specified Amazon Connect instance.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_list_user_hierarchy_groups/](https://www.paws-r-sdk.com/docs/connect_list_user_hierarchy_groups/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param MaxResults The maximum number of results to return per page. The default MaxResult
#' size is 100.
#'
#' @keywords internal
#'
#' @rdname connect_list_user_hierarchy_groups
connect_list_user_hierarchy_groups <- function(InstanceId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListUserHierarchyGroups",
    http_method = "GET",
    http_path = "/user-hierarchy-groups-summary/{InstanceId}",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "UserHierarchyGroupSummaryList")
  )
  input <- .connect$list_user_hierarchy_groups_input(InstanceId = InstanceId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .connect$list_user_hierarchy_groups_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$list_user_hierarchy_groups <- connect_list_user_hierarchy_groups

#' Lists proficiencies associated with a user
#'
#' @description
#' Lists proficiencies associated with a user.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_list_user_proficiencies/](https://www.paws-r-sdk.com/docs/connect_list_user_proficiencies/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can find the instance
#' ID in the Amazon Resource Name (ARN) of the instance.
#' @param UserId &#91;required&#93; The identifier of the user account.
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param MaxResults The maximum number of results to return per page.
#'
#' @keywords internal
#'
#' @rdname connect_list_user_proficiencies
connect_list_user_proficiencies <- function(InstanceId, UserId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListUserProficiencies",
    http_method = "GET",
    http_path = "/users/{InstanceId}/{UserId}/proficiencies",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", non_aggregate_keys = list( "LastModifiedTime", "LastModifiedRegion"), output_token = "NextToken", result_key = "UserProficiencyList")
  )
  input <- .connect$list_user_proficiencies_input(InstanceId = InstanceId, UserId = UserId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .connect$list_user_proficiencies_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$list_user_proficiencies <- connect_list_user_proficiencies

#' Provides summary information about the users for the specified Amazon
#' Connect instance
#'
#' @description
#' Provides summary information about the users for the specified Amazon Connect instance.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_list_users/](https://www.paws-r-sdk.com/docs/connect_list_users/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param MaxResults The maximum number of results to return per page. The default MaxResult
#' size is 100.
#'
#' @keywords internal
#'
#' @rdname connect_list_users
connect_list_users <- function(InstanceId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListUsers",
    http_method = "GET",
    http_path = "/users-summary/{InstanceId}",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "UserSummaryList")
  )
  input <- .connect$list_users_input(InstanceId = InstanceId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .connect$list_users_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$list_users <- connect_list_users

#' Returns all the available versions for the specified Amazon Connect
#' instance and view identifier
#'
#' @description
#' Returns all the available versions for the specified Amazon Connect instance and view identifier.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_list_view_versions/](https://www.paws-r-sdk.com/docs/connect_list_view_versions/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can find the
#' instanceId in the ARN of the instance.
#' @param ViewId &#91;required&#93; The identifier of the view. Both `ViewArn` and `ViewId` can be used.
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param MaxResults The maximum number of results to return per page. The default MaxResult
#' size is 100.
#'
#' @keywords internal
#'
#' @rdname connect_list_view_versions
connect_list_view_versions <- function(InstanceId, ViewId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListViewVersions",
    http_method = "GET",
    http_path = "/views/{InstanceId}/{ViewId}/versions",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "ViewVersionSummaryList")
  )
  input <- .connect$list_view_versions_input(InstanceId = InstanceId, ViewId = ViewId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .connect$list_view_versions_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$list_view_versions <- connect_list_view_versions

#' Returns views in the given instance
#'
#' @description
#' Returns views in the given instance.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_list_views/](https://www.paws-r-sdk.com/docs/connect_list_views/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can find the
#' instanceId in the ARN of the instance.
#' @param Type The type of the view.
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param MaxResults The maximum number of results to return per page. The default MaxResult
#' size is 100.
#'
#' @keywords internal
#'
#' @rdname connect_list_views
connect_list_views <- function(InstanceId, Type = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListViews",
    http_method = "GET",
    http_path = "/views/{InstanceId}",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "ViewsSummaryList")
  )
  input <- .connect$list_views_input(InstanceId = InstanceId, Type = Type, NextToken = NextToken, MaxResults = MaxResults)
  output <- .connect$list_views_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$list_views <- connect_list_views

#' Initiates silent monitoring of a contact
#'
#' @description
#' Initiates silent monitoring of a contact. The Contact Control Panel (CCP) of the user specified by *userId* will be set to silent monitoring mode on the contact.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_monitor_contact/](https://www.paws-r-sdk.com/docs/connect_monitor_contact/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can find the
#' instanceId in the ARN of the instance.
#' @param ContactId &#91;required&#93; The identifier of the contact.
#' @param UserId &#91;required&#93; The identifier of the user account.
#' @param AllowedMonitorCapabilities Specify which monitoring actions the user is allowed to take. For
#' example, whether the user is allowed to escalate from silent monitoring
#' to barge. AllowedMonitorCapabilities is required if barge is enabled.
#' @param ClientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If not provided, the Amazon Web Services SDK
#' populates this field. For more information about idempotency, see
#' [Making retries safe with idempotent
#' APIs](https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
#'
#' @keywords internal
#'
#' @rdname connect_monitor_contact
connect_monitor_contact <- function(InstanceId, ContactId, UserId, AllowedMonitorCapabilities = NULL, ClientToken = NULL) {
  op <- new_operation(
    name = "MonitorContact",
    http_method = "POST",
    http_path = "/contact/monitor",
    paginator = list()
  )
  input <- .connect$monitor_contact_input(InstanceId = InstanceId, ContactId = ContactId, UserId = UserId, AllowedMonitorCapabilities = AllowedMonitorCapabilities, ClientToken = ClientToken)
  output <- .connect$monitor_contact_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$monitor_contact <- connect_monitor_contact

#' Allows pausing an ongoing task contact
#'
#' @description
#' Allows pausing an ongoing task contact.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_pause_contact/](https://www.paws-r-sdk.com/docs/connect_pause_contact/) for full documentation.
#'
#' @param ContactId &#91;required&#93; The identifier of the contact.
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can find the
#' `instanceId` in the ARN of the instance.
#' @param ContactFlowId The identifier of the flow.
#'
#' @keywords internal
#'
#' @rdname connect_pause_contact
connect_pause_contact <- function(ContactId, InstanceId, ContactFlowId = NULL) {
  op <- new_operation(
    name = "PauseContact",
    http_method = "POST",
    http_path = "/contact/pause",
    paginator = list()
  )
  input <- .connect$pause_contact_input(ContactId = ContactId, InstanceId = InstanceId, ContactFlowId = ContactFlowId)
  output <- .connect$pause_contact_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$pause_contact <- connect_pause_contact

#' Changes the current status of a user or agent in Amazon Connect
#'
#' @description
#' Changes the current status of a user or agent in Amazon Connect. If the agent is currently handling a contact, this sets the agent's next status.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_put_user_status/](https://www.paws-r-sdk.com/docs/connect_put_user_status/) for full documentation.
#'
#' @param UserId &#91;required&#93; The identifier of the user.
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param AgentStatusId &#91;required&#93; The identifier of the agent status.
#'
#' @keywords internal
#'
#' @rdname connect_put_user_status
connect_put_user_status <- function(UserId, InstanceId, AgentStatusId) {
  op <- new_operation(
    name = "PutUserStatus",
    http_method = "PUT",
    http_path = "/users/{InstanceId}/{UserId}/status",
    paginator = list()
  )
  input <- .connect$put_user_status_input(UserId = UserId, InstanceId = InstanceId, AgentStatusId = AgentStatusId)
  output <- .connect$put_user_status_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$put_user_status <- connect_put_user_status

#' Releases a phone number previously claimed to an Amazon Connect instance
#' or traffic distribution group
#'
#' @description
#' Releases a phone number previously claimed to an Amazon Connect instance or traffic distribution group. You can call this API only in the Amazon Web Services Region where the number was claimed.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_release_phone_number/](https://www.paws-r-sdk.com/docs/connect_release_phone_number/) for full documentation.
#'
#' @param PhoneNumberId &#91;required&#93; A unique identifier for the phone number.
#' @param ClientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If not provided, the Amazon Web Services SDK
#' populates this field. For more information about idempotency, see
#' [Making retries safe with idempotent
#' APIs](https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
#'
#' @keywords internal
#'
#' @rdname connect_release_phone_number
connect_release_phone_number <- function(PhoneNumberId, ClientToken = NULL) {
  op <- new_operation(
    name = "ReleasePhoneNumber",
    http_method = "DELETE",
    http_path = "/phone-number/{PhoneNumberId}",
    paginator = list()
  )
  input <- .connect$release_phone_number_input(PhoneNumberId = PhoneNumberId, ClientToken = ClientToken)
  output <- .connect$release_phone_number_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$release_phone_number <- connect_release_phone_number

#' Replicates an Amazon Connect instance in the specified Amazon Web
#' Services Region and copies configuration information for Amazon Connect
#' resources across Amazon Web Services Regions
#'
#' @description
#' Replicates an Amazon Connect instance in the specified Amazon Web Services Region and copies configuration information for Amazon Connect resources across Amazon Web Services Regions.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_replicate_instance/](https://www.paws-r-sdk.com/docs/connect_replicate_instance/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance. You can provide the
#' `InstanceId`, or the entire ARN.
#' @param ReplicaRegion &#91;required&#93; The Amazon Web Services Region where to replicate the Amazon Connect
#' instance.
#' @param ClientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If not provided, the Amazon Web Services SDK
#' populates this field. For more information about idempotency, see
#' [Making retries safe with idempotent
#' APIs](https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
#' @param ReplicaAlias &#91;required&#93; The alias for the replicated instance. The `ReplicaAlias` must be
#' unique.
#'
#' @keywords internal
#'
#' @rdname connect_replicate_instance
connect_replicate_instance <- function(InstanceId, ReplicaRegion, ClientToken = NULL, ReplicaAlias) {
  op <- new_operation(
    name = "ReplicateInstance",
    http_method = "POST",
    http_path = "/instance/{InstanceId}/replicate",
    paginator = list()
  )
  input <- .connect$replicate_instance_input(InstanceId = InstanceId, ReplicaRegion = ReplicaRegion, ClientToken = ClientToken, ReplicaAlias = ReplicaAlias)
  output <- .connect$replicate_instance_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$replicate_instance <- connect_replicate_instance

#' Allows resuming a task contact in a paused state
#'
#' @description
#' Allows resuming a task contact in a paused state.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_resume_contact/](https://www.paws-r-sdk.com/docs/connect_resume_contact/) for full documentation.
#'
#' @param ContactId &#91;required&#93; The identifier of the contact.
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can find the
#' `instanceId` in the ARN of the instance.
#' @param ContactFlowId The identifier of the flow.
#'
#' @keywords internal
#'
#' @rdname connect_resume_contact
connect_resume_contact <- function(ContactId, InstanceId, ContactFlowId = NULL) {
  op <- new_operation(
    name = "ResumeContact",
    http_method = "POST",
    http_path = "/contact/resume",
    paginator = list()
  )
  input <- .connect$resume_contact_input(ContactId = ContactId, InstanceId = InstanceId, ContactFlowId = ContactFlowId)
  output <- .connect$resume_contact_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$resume_contact <- connect_resume_contact

#' When a contact is being recorded, and the recording has been suspended
#' using SuspendContactRecording, this API resumes recording whatever
#' recording is selected in the flow configuration: call, screen, or both
#'
#' @description
#' When a contact is being recorded, and the recording has been suspended using SuspendContactRecording, this API resumes recording whatever recording is selected in the flow configuration: call, screen, or both. If only call recording or only screen recording is enabled, then it would resume.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_resume_contact_recording/](https://www.paws-r-sdk.com/docs/connect_resume_contact_recording/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param ContactId &#91;required&#93; The identifier of the contact.
#' @param InitialContactId &#91;required&#93; The identifier of the contact. This is the identifier of the contact
#' associated with the first interaction with the contact center.
#'
#' @keywords internal
#'
#' @rdname connect_resume_contact_recording
connect_resume_contact_recording <- function(InstanceId, ContactId, InitialContactId) {
  op <- new_operation(
    name = "ResumeContactRecording",
    http_method = "POST",
    http_path = "/contact/resume-recording",
    paginator = list()
  )
  input <- .connect$resume_contact_recording_input(InstanceId = InstanceId, ContactId = ContactId, InitialContactId = InitialContactId)
  output <- .connect$resume_contact_recording_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$resume_contact_recording <- connect_resume_contact_recording

#' Searches for available phone numbers that you can claim to your Amazon
#' Connect instance or traffic distribution group
#'
#' @description
#' Searches for available phone numbers that you can claim to your Amazon Connect instance or traffic distribution group. If the provided `TargetArn` is a traffic distribution group, you can call this API in both Amazon Web Services Regions associated with the traffic distribution group.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_search_available_phone_numbers/](https://www.paws-r-sdk.com/docs/connect_search_available_phone_numbers/) for full documentation.
#'
#' @param TargetArn The Amazon Resource Name (ARN) for Amazon Connect instances or traffic
#' distribution groups that phone number inbound traffic is routed through.
#' You must enter `InstanceId` or `TargetArn`.
#' @param InstanceId The identifier of the Amazon Connect instance that phone numbers are
#' claimed to. You can [find the instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance. You must enter
#' `InstanceId` or `TargetArn`.
#' @param PhoneNumberCountryCode &#91;required&#93; The ISO country code.
#' @param PhoneNumberType &#91;required&#93; The type of phone number.
#' @param PhoneNumberPrefix The prefix of the phone number. If provided, it must contain `+` as part
#' of the country code.
#' @param MaxResults The maximum number of results to return per page.
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#'
#' @keywords internal
#'
#' @rdname connect_search_available_phone_numbers
connect_search_available_phone_numbers <- function(TargetArn = NULL, InstanceId = NULL, PhoneNumberCountryCode, PhoneNumberType, PhoneNumberPrefix = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "SearchAvailablePhoneNumbers",
    http_method = "POST",
    http_path = "/phone-number/search-available",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "AvailableNumbersList")
  )
  input <- .connect$search_available_phone_numbers_input(TargetArn = TargetArn, InstanceId = InstanceId, PhoneNumberCountryCode = PhoneNumberCountryCode, PhoneNumberType = PhoneNumberType, PhoneNumberPrefix = PhoneNumberPrefix, MaxResults = MaxResults, NextToken = NextToken)
  output <- .connect$search_available_phone_numbers_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$search_available_phone_numbers <- connect_search_available_phone_numbers

#' Searches contacts in an Amazon Connect instance
#'
#' @description
#' Searches contacts in an Amazon Connect instance.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_search_contacts/](https://www.paws-r-sdk.com/docs/connect_search_contacts/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of Amazon Connect instance. You can find the instance ID
#' in the Amazon Resource Name (ARN) of the instance.
#' @param TimeRange &#91;required&#93; Time range that you want to search results.
#' @param SearchCriteria The search criteria to be used to return contacts.
#' @param MaxResults The maximum number of results to return per page.
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param Sort Specifies a field to sort by and a sort order.
#'
#' @keywords internal
#'
#' @rdname connect_search_contacts
connect_search_contacts <- function(InstanceId, TimeRange, SearchCriteria = NULL, MaxResults = NULL, NextToken = NULL, Sort = NULL) {
  op <- new_operation(
    name = "SearchContacts",
    http_method = "POST",
    http_path = "/search-contacts",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", non_aggregate_keys = list( "TotalCount"), output_token = "NextToken", result_key = "Contacts")
  )
  input <- .connect$search_contacts_input(InstanceId = InstanceId, TimeRange = TimeRange, SearchCriteria = SearchCriteria, MaxResults = MaxResults, NextToken = NextToken, Sort = Sort)
  output <- .connect$search_contacts_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$search_contacts <- connect_search_contacts

#' Searches the hours of operation in an Amazon Connect instance, with
#' optional filtering
#'
#' @description
#' Searches the hours of operation in an Amazon Connect instance, with optional filtering.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_search_hours_of_operations/](https://www.paws-r-sdk.com/docs/connect_search_hours_of_operations/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param MaxResults The maximum number of results to return per page.
#' @param SearchFilter Filters to be applied to search results.
#' @param SearchCriteria The search criteria to be used to return hours of operations.
#'
#' @keywords internal
#'
#' @rdname connect_search_hours_of_operations
connect_search_hours_of_operations <- function(InstanceId, NextToken = NULL, MaxResults = NULL, SearchFilter = NULL, SearchCriteria = NULL) {
  op <- new_operation(
    name = "SearchHoursOfOperations",
    http_method = "POST",
    http_path = "/search-hours-of-operations",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", non_aggregate_keys = list( "ApproximateTotalCount"), output_token = "NextToken", result_key = "HoursOfOperations")
  )
  input <- .connect$search_hours_of_operations_input(InstanceId = InstanceId, NextToken = NextToken, MaxResults = MaxResults, SearchFilter = SearchFilter, SearchCriteria = SearchCriteria)
  output <- .connect$search_hours_of_operations_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$search_hours_of_operations <- connect_search_hours_of_operations

#' Predefined attributes that meet certain criteria
#'
#' @description
#' Predefined attributes that meet certain criteria.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_search_predefined_attributes/](https://www.paws-r-sdk.com/docs/connect_search_predefined_attributes/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can find the instance
#' ID in the Amazon Resource Name (ARN) of the instance.
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param MaxResults The maximum number of results to return per page.
#' @param SearchCriteria The search criteria to be used to return predefined attributes.
#'
#' @keywords internal
#'
#' @rdname connect_search_predefined_attributes
connect_search_predefined_attributes <- function(InstanceId, NextToken = NULL, MaxResults = NULL, SearchCriteria = NULL) {
  op <- new_operation(
    name = "SearchPredefinedAttributes",
    http_method = "POST",
    http_path = "/search-predefined-attributes",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", non_aggregate_keys = list( "ApproximateTotalCount"), output_token = "NextToken", result_key = "PredefinedAttributes")
  )
  input <- .connect$search_predefined_attributes_input(InstanceId = InstanceId, NextToken = NextToken, MaxResults = MaxResults, SearchCriteria = SearchCriteria)
  output <- .connect$search_predefined_attributes_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$search_predefined_attributes <- connect_search_predefined_attributes

#' Searches prompts in an Amazon Connect instance, with optional filtering
#'
#' @description
#' Searches prompts in an Amazon Connect instance, with optional filtering.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_search_prompts/](https://www.paws-r-sdk.com/docs/connect_search_prompts/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param MaxResults The maximum number of results to return per page.
#' @param SearchFilter Filters to be applied to search results.
#' @param SearchCriteria The search criteria to be used to return prompts.
#'
#' @keywords internal
#'
#' @rdname connect_search_prompts
connect_search_prompts <- function(InstanceId, NextToken = NULL, MaxResults = NULL, SearchFilter = NULL, SearchCriteria = NULL) {
  op <- new_operation(
    name = "SearchPrompts",
    http_method = "POST",
    http_path = "/search-prompts",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", non_aggregate_keys = list( "ApproximateTotalCount"), output_token = "NextToken", result_key = "Prompts")
  )
  input <- .connect$search_prompts_input(InstanceId = InstanceId, NextToken = NextToken, MaxResults = MaxResults, SearchFilter = SearchFilter, SearchCriteria = SearchCriteria)
  output <- .connect$search_prompts_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$search_prompts <- connect_search_prompts

#' Searches queues in an Amazon Connect instance, with optional filtering
#'
#' @description
#' Searches queues in an Amazon Connect instance, with optional filtering.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_search_queues/](https://www.paws-r-sdk.com/docs/connect_search_queues/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param MaxResults The maximum number of results to return per page.
#' @param SearchFilter Filters to be applied to search results.
#' @param SearchCriteria The search criteria to be used to return queues.
#' 
#' The `name` and `description` fields support "contains" queries with a
#' minimum of 2 characters and a maximum of 25 characters. Any queries with
#' character lengths outside of this range will throw invalid results.
#'
#' @keywords internal
#'
#' @rdname connect_search_queues
connect_search_queues <- function(InstanceId, NextToken = NULL, MaxResults = NULL, SearchFilter = NULL, SearchCriteria = NULL) {
  op <- new_operation(
    name = "SearchQueues",
    http_method = "POST",
    http_path = "/search-queues",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", non_aggregate_keys = list( "ApproximateTotalCount"), output_token = "NextToken", result_key = "Queues")
  )
  input <- .connect$search_queues_input(InstanceId = InstanceId, NextToken = NextToken, MaxResults = MaxResults, SearchFilter = SearchFilter, SearchCriteria = SearchCriteria)
  output <- .connect$search_queues_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$search_queues <- connect_search_queues

#' Searches quick connects in an Amazon Connect instance, with optional
#' filtering
#'
#' @description
#' Searches quick connects in an Amazon Connect instance, with optional filtering.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_search_quick_connects/](https://www.paws-r-sdk.com/docs/connect_search_quick_connects/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param MaxResults The maximum number of results to return per page.
#' @param SearchFilter Filters to be applied to search results.
#' @param SearchCriteria The search criteria to be used to return quick connects.
#'
#' @keywords internal
#'
#' @rdname connect_search_quick_connects
connect_search_quick_connects <- function(InstanceId, NextToken = NULL, MaxResults = NULL, SearchFilter = NULL, SearchCriteria = NULL) {
  op <- new_operation(
    name = "SearchQuickConnects",
    http_method = "POST",
    http_path = "/search-quick-connects",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", non_aggregate_keys = list( "ApproximateTotalCount"), output_token = "NextToken", result_key = "QuickConnects")
  )
  input <- .connect$search_quick_connects_input(InstanceId = InstanceId, NextToken = NextToken, MaxResults = MaxResults, SearchFilter = SearchFilter, SearchCriteria = SearchCriteria)
  output <- .connect$search_quick_connects_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$search_quick_connects <- connect_search_quick_connects

#' Searches tags used in an Amazon Connect instance using optional search
#' criteria
#'
#' @description
#' Searches tags used in an Amazon Connect instance using optional search criteria.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_search_resource_tags/](https://www.paws-r-sdk.com/docs/connect_search_resource_tags/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can find the
#' instanceId in the Amazon Resource Name (ARN) of the instance.
#' @param ResourceTypes The list of resource types to be used to search tags from. If not
#' provided or if any empty list is provided, this API will search from all
#' supported resource types.
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param MaxResults The maximum number of results to return per page.
#' @param SearchCriteria The search criteria to be used to return tags.
#'
#' @keywords internal
#'
#' @rdname connect_search_resource_tags
connect_search_resource_tags <- function(InstanceId, ResourceTypes = NULL, NextToken = NULL, MaxResults = NULL, SearchCriteria = NULL) {
  op <- new_operation(
    name = "SearchResourceTags",
    http_method = "POST",
    http_path = "/search-resource-tags",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "Tags")
  )
  input <- .connect$search_resource_tags_input(InstanceId = InstanceId, ResourceTypes = ResourceTypes, NextToken = NextToken, MaxResults = MaxResults, SearchCriteria = SearchCriteria)
  output <- .connect$search_resource_tags_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$search_resource_tags <- connect_search_resource_tags

#' Searches routing profiles in an Amazon Connect instance, with optional
#' filtering
#'
#' @description
#' Searches routing profiles in an Amazon Connect instance, with optional filtering.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_search_routing_profiles/](https://www.paws-r-sdk.com/docs/connect_search_routing_profiles/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param MaxResults The maximum number of results to return per page.
#' @param SearchFilter Filters to be applied to search results.
#' @param SearchCriteria The search criteria to be used to return routing profiles.
#' 
#' The `name` and `description` fields support "contains" queries with a
#' minimum of 2 characters and a maximum of 25 characters. Any queries with
#' character lengths outside of this range will throw invalid results.
#'
#' @keywords internal
#'
#' @rdname connect_search_routing_profiles
connect_search_routing_profiles <- function(InstanceId, NextToken = NULL, MaxResults = NULL, SearchFilter = NULL, SearchCriteria = NULL) {
  op <- new_operation(
    name = "SearchRoutingProfiles",
    http_method = "POST",
    http_path = "/search-routing-profiles",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", non_aggregate_keys = list( "ApproximateTotalCount"), output_token = "NextToken", result_key = "RoutingProfiles")
  )
  input <- .connect$search_routing_profiles_input(InstanceId = InstanceId, NextToken = NextToken, MaxResults = MaxResults, SearchFilter = SearchFilter, SearchCriteria = SearchCriteria)
  output <- .connect$search_routing_profiles_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$search_routing_profiles <- connect_search_routing_profiles

#' Searches security profiles in an Amazon Connect instance, with optional
#' filtering
#'
#' @description
#' Searches security profiles in an Amazon Connect instance, with optional filtering.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_search_security_profiles/](https://www.paws-r-sdk.com/docs/connect_search_security_profiles/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param MaxResults The maximum number of results to return per page.
#' @param SearchCriteria The search criteria to be used to return security profiles.
#' 
#' The `name` field support "contains" queries with a minimum of 2
#' characters and maximum of 25 characters. Any queries with character
#' lengths outside of this range will throw invalid results.
#' 
#' The currently supported value for `FieldName`: `name`
#' @param SearchFilter Filters to be applied to search results.
#'
#' @keywords internal
#'
#' @rdname connect_search_security_profiles
connect_search_security_profiles <- function(InstanceId, NextToken = NULL, MaxResults = NULL, SearchCriteria = NULL, SearchFilter = NULL) {
  op <- new_operation(
    name = "SearchSecurityProfiles",
    http_method = "POST",
    http_path = "/search-security-profiles",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", non_aggregate_keys = list( "ApproximateTotalCount"), output_token = "NextToken", result_key = "SecurityProfiles")
  )
  input <- .connect$search_security_profiles_input(InstanceId = InstanceId, NextToken = NextToken, MaxResults = MaxResults, SearchCriteria = SearchCriteria, SearchFilter = SearchFilter)
  output <- .connect$search_security_profiles_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$search_security_profiles <- connect_search_security_profiles

#' Searches users in an Amazon Connect instance, with optional filtering
#'
#' @description
#' Searches users in an Amazon Connect instance, with optional filtering.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_search_users/](https://www.paws-r-sdk.com/docs/connect_search_users/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' 
#' InstanceID is a required field. The "Required: No" below is incorrect.
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param MaxResults The maximum number of results to return per page.
#' @param SearchFilter Filters to be applied to search results.
#' @param SearchCriteria 
#'
#' @keywords internal
#'
#' @rdname connect_search_users
connect_search_users <- function(InstanceId, NextToken = NULL, MaxResults = NULL, SearchFilter = NULL, SearchCriteria = NULL) {
  op <- new_operation(
    name = "SearchUsers",
    http_method = "POST",
    http_path = "/search-users",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", non_aggregate_keys = list( "ApproximateTotalCount"), output_token = "NextToken", result_key = "Users")
  )
  input <- .connect$search_users_input(InstanceId = InstanceId, NextToken = NextToken, MaxResults = MaxResults, SearchFilter = SearchFilter, SearchCriteria = SearchCriteria)
  output <- .connect$search_users_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$search_users <- connect_search_users

#' Searches for vocabularies within a specific Amazon Connect instance
#' using State, NameStartsWith, and LanguageCode
#'
#' @description
#' Searches for vocabularies within a specific Amazon Connect instance using `State`, `NameStartsWith`, and `LanguageCode`.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_search_vocabularies/](https://www.paws-r-sdk.com/docs/connect_search_vocabularies/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param MaxResults The maximum number of results to return per page.
#' @param NextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param State The current state of the custom vocabulary.
#' @param NameStartsWith The starting pattern of the name of the vocabulary.
#' @param LanguageCode The language code of the vocabulary entries. For a list of languages and
#' their corresponding language codes, see [What is Amazon
#' Transcribe?](https://docs.aws.amazon.com/transcribe/latest/dg/what-is.html)
#'
#' @keywords internal
#'
#' @rdname connect_search_vocabularies
connect_search_vocabularies <- function(InstanceId, MaxResults = NULL, NextToken = NULL, State = NULL, NameStartsWith = NULL, LanguageCode = NULL) {
  op <- new_operation(
    name = "SearchVocabularies",
    http_method = "POST",
    http_path = "/vocabulary-summary/{InstanceId}",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "VocabularySummaryList")
  )
  input <- .connect$search_vocabularies_input(InstanceId = InstanceId, MaxResults = MaxResults, NextToken = NextToken, State = State, NameStartsWith = NameStartsWith, LanguageCode = LanguageCode)
  output <- .connect$search_vocabularies_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$search_vocabularies <- connect_search_vocabularies

#' Processes chat integration events from Amazon Web Services or external
#' integrations to Amazon Connect
#'
#' @description
#' Processes chat integration events from Amazon Web Services or external integrations to Amazon Connect. A chat integration event includes:
#'
#' See [https://www.paws-r-sdk.com/docs/connect_send_chat_integration_event/](https://www.paws-r-sdk.com/docs/connect_send_chat_integration_event/) for full documentation.
#'
#' @param SourceId &#91;required&#93; External identifier of chat customer participant, used in part to
#' uniquely identify a chat. For SMS, this is the E164 phone number of the
#' chat customer participant.
#' @param DestinationId &#91;required&#93; Chat system identifier, used in part to uniquely identify chat. This is
#' associated with the Amazon Connect instance and flow to be used to start
#' chats. For SMS, this is the phone number destination of inbound SMS
#' messages represented by an Amazon Pinpoint phone number ARN.
#' @param Subtype Classification of a channel. This is used in part to uniquely identify
#' chat.
#' 
#' Valid value: `["connect:sms"]`
#' @param Event &#91;required&#93; Chat integration event payload
#' @param NewSessionDetails Contact properties to apply when starting a new chat. If the integration
#' event is handled with an existing chat, this is ignored.
#'
#' @keywords internal
#'
#' @rdname connect_send_chat_integration_event
connect_send_chat_integration_event <- function(SourceId, DestinationId, Subtype = NULL, Event, NewSessionDetails = NULL) {
  op <- new_operation(
    name = "SendChatIntegrationEvent",
    http_method = "POST",
    http_path = "/chat-integration-event",
    paginator = list()
  )
  input <- .connect$send_chat_integration_event_input(SourceId = SourceId, DestinationId = DestinationId, Subtype = Subtype, Event = Event, NewSessionDetails = NewSessionDetails)
  output <- .connect$send_chat_integration_event_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$send_chat_integration_event <- connect_send_chat_integration_event

#' Initiates a flow to start a new chat for the customer
#'
#' @description
#' Initiates a flow to start a new chat for the customer. Response of this API provides a token required to obtain credentials from the [CreateParticipantConnection](https://docs.aws.amazon.com/connect/latest/APIReference/API_connect-participant_CreateParticipantConnection.html) API in the Amazon Connect Participant Service.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_start_chat_contact/](https://www.paws-r-sdk.com/docs/connect_start_chat_contact/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param ContactFlowId &#91;required&#93; The identifier of the flow for initiating the chat. To see the
#' ContactFlowId in the Amazon Connect admin website, on the navigation
#' menu go to **Routing**, **Contact Flows**. Choose the flow. On the flow
#' page, under the name of the flow, choose **Show additional flow
#' information**. The ContactFlowId is the last part of the ARN, shown here
#' in bold:
#' 
#' arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/**846ec553-a005-41c0-8341-xxxxxxxxxxxx**
#' @param Attributes A custom key-value pair using an attribute map. The attributes are
#' standard Amazon Connect attributes. They can be accessed in flows just
#' like any other contact attributes.
#' 
#' There can be up to 32,768 UTF-8 bytes across all key-value pairs per
#' contact. Attribute keys can include only alphanumeric, dash, and
#' underscore characters.
#' @param ParticipantDetails &#91;required&#93; Information identifying the participant.
#' @param InitialMessage The initial message to be sent to the newly created chat. If you have a
#' Lex bot in your flow, the initial message is not delivered to the Lex
#' bot.
#' @param ClientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If not provided, the Amazon Web Services SDK
#' populates this field. For more information about idempotency, see
#' [Making retries safe with idempotent
#' APIs](https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
#' @param ChatDurationInMinutes The total duration of the newly started chat session. If not specified,
#' the chat session duration defaults to 25 hour. The minimum configurable
#' time is 60 minutes. The maximum configurable time is 10,080 minutes (7
#' days).
#' @param SupportedMessagingContentTypes The supported chat message content types. Supported types are
#' `text/plain`, `text/markdown`, `application/json`,
#' `application/vnd.amazonaws.connect.message.interactive`, and
#' `application/vnd.amazonaws.connect.message.interactive.response`.
#' 
#' Content types must always contain `text/plain`. You can then put any
#' other supported type in the list. For example, all the following lists
#' are valid because they contain `text/plain`:
#' `[text/plain, text/markdown, application/json]`,
#' `[text/markdown, text/plain]`,
#' `[text/plain, application/json, application/vnd.amazonaws.connect.message.interactive.response]`.
#' 
#' The type `application/vnd.amazonaws.connect.message.interactive` is
#' required to use the [Show
#' view](https://docs.aws.amazon.com/connect/latest/adminguide/show-view-block.html)
#' flow block.
#' @param PersistentChat Enable persistent chats. For more information about enabling persistent
#' chat, and for example use cases and how to configure for them, see
#' [Enable persistent
#' chat](https://docs.aws.amazon.com/connect/latest/adminguide/chat-persistence.html).
#' @param RelatedContactId The unique identifier for an Amazon Connect contact. This identifier is
#' related to the chat starting.
#' 
#' You cannot provide data for both RelatedContactId and PersistentChat.
#' @param SegmentAttributes A set of system defined key-value pairs stored on individual contact
#' segments using an attribute map. The attributes are standard Amazon
#' Connect attributes. They can be accessed in flows.
#' 
#' Attribute keys can include only alphanumeric, -, and _.
#' 
#' This field can be used to show channel subtype, such as `connect:Guide`.
#' 
#' The types `application/vnd.amazonaws.connect.message.interactive` and
#' `application/vnd.amazonaws.connect.message.interactive.response` must be
#' present in the SupportedMessagingContentTypes field of this API in order
#' to set `SegmentAttributes` as
#' \{` "connect:Subtype": \{"valueString" : "connect:Guide" \}\}`.
#'
#' @keywords internal
#'
#' @rdname connect_start_chat_contact
connect_start_chat_contact <- function(InstanceId, ContactFlowId, Attributes = NULL, ParticipantDetails, InitialMessage = NULL, ClientToken = NULL, ChatDurationInMinutes = NULL, SupportedMessagingContentTypes = NULL, PersistentChat = NULL, RelatedContactId = NULL, SegmentAttributes = NULL) {
  op <- new_operation(
    name = "StartChatContact",
    http_method = "PUT",
    http_path = "/contact/chat",
    paginator = list()
  )
  input <- .connect$start_chat_contact_input(InstanceId = InstanceId, ContactFlowId = ContactFlowId, Attributes = Attributes, ParticipantDetails = ParticipantDetails, InitialMessage = InitialMessage, ClientToken = ClientToken, ChatDurationInMinutes = ChatDurationInMinutes, SupportedMessagingContentTypes = SupportedMessagingContentTypes, PersistentChat = PersistentChat, RelatedContactId = RelatedContactId, SegmentAttributes = SegmentAttributes)
  output <- .connect$start_chat_contact_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$start_chat_contact <- connect_start_chat_contact

#' Starts an empty evaluation in the specified Amazon Connect instance,
#' using the given evaluation form for the particular contact
#'
#' @description
#' Starts an empty evaluation in the specified Amazon Connect instance, using the given evaluation form for the particular contact. The evaluation form version used for the contact evaluation corresponds to the currently activated version. If no version is activated for the evaluation form, the contact evaluation cannot be started.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_start_contact_evaluation/](https://www.paws-r-sdk.com/docs/connect_start_contact_evaluation/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param ContactId &#91;required&#93; The identifier of the contact in this instance of Amazon Connect.
#' @param EvaluationFormId &#91;required&#93; The unique identifier for the evaluation form.
#' @param ClientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If not provided, the Amazon Web Services SDK
#' populates this field. For more information about idempotency, see
#' [Making retries safe with idempotent
#' APIs](https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
#'
#' @keywords internal
#'
#' @rdname connect_start_contact_evaluation
connect_start_contact_evaluation <- function(InstanceId, ContactId, EvaluationFormId, ClientToken = NULL) {
  op <- new_operation(
    name = "StartContactEvaluation",
    http_method = "PUT",
    http_path = "/contact-evaluations/{InstanceId}",
    paginator = list()
  )
  input <- .connect$start_contact_evaluation_input(InstanceId = InstanceId, ContactId = ContactId, EvaluationFormId = EvaluationFormId, ClientToken = ClientToken)
  output <- .connect$start_contact_evaluation_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$start_contact_evaluation <- connect_start_contact_evaluation

#' Starts recording the contact:
#'
#' @description
#' Starts recording the contact:
#'
#' See [https://www.paws-r-sdk.com/docs/connect_start_contact_recording/](https://www.paws-r-sdk.com/docs/connect_start_contact_recording/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param ContactId &#91;required&#93; The identifier of the contact.
#' @param InitialContactId &#91;required&#93; The identifier of the contact. This is the identifier of the contact
#' associated with the first interaction with the contact center.
#' @param VoiceRecordingConfiguration &#91;required&#93; The person being recorded.
#'
#' @keywords internal
#'
#' @rdname connect_start_contact_recording
connect_start_contact_recording <- function(InstanceId, ContactId, InitialContactId, VoiceRecordingConfiguration) {
  op <- new_operation(
    name = "StartContactRecording",
    http_method = "POST",
    http_path = "/contact/start-recording",
    paginator = list()
  )
  input <- .connect$start_contact_recording_input(InstanceId = InstanceId, ContactId = ContactId, InitialContactId = InitialContactId, VoiceRecordingConfiguration = VoiceRecordingConfiguration)
  output <- .connect$start_contact_recording_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$start_contact_recording <- connect_start_contact_recording

#' Initiates real-time message streaming for a new chat contact
#'
#' @description
#' Initiates real-time message streaming for a new chat contact.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_start_contact_streaming/](https://www.paws-r-sdk.com/docs/connect_start_contact_streaming/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param ContactId &#91;required&#93; The identifier of the contact. This is the identifier of the contact
#' associated with the first interaction with the contact center.
#' @param ChatStreamingConfiguration &#91;required&#93; The streaming configuration, such as the Amazon SNS streaming endpoint.
#' @param ClientToken &#91;required&#93; A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If not provided, the Amazon Web Services SDK
#' populates this field. For more information about idempotency, see
#' [Making retries safe with idempotent
#' APIs](https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
#'
#' @keywords internal
#'
#' @rdname connect_start_contact_streaming
connect_start_contact_streaming <- function(InstanceId, ContactId, ChatStreamingConfiguration, ClientToken) {
  op <- new_operation(
    name = "StartContactStreaming",
    http_method = "POST",
    http_path = "/contact/start-streaming",
    paginator = list()
  )
  input <- .connect$start_contact_streaming_input(InstanceId = InstanceId, ContactId = ContactId, ChatStreamingConfiguration = ChatStreamingConfiguration, ClientToken = ClientToken)
  output <- .connect$start_contact_streaming_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$start_contact_streaming <- connect_start_contact_streaming

#' Places an outbound call to a contact, and then initiates the flow
#'
#' @description
#' Places an outbound call to a contact, and then initiates the flow. It performs the actions in the flow that's specified (in `ContactFlowId`).
#'
#' See [https://www.paws-r-sdk.com/docs/connect_start_outbound_voice_contact/](https://www.paws-r-sdk.com/docs/connect_start_outbound_voice_contact/) for full documentation.
#'
#' @param Name The name of a voice contact that is shown to an agent in the Contact
#' Control Panel (CCP).
#' @param Description A description of the voice contact that is shown to an agent in the
#' Contact Control Panel (CCP).
#' @param References A formatted URL that is shown to an agent in the Contact Control Panel
#' (CCP). Contacts can have the following reference types at the time of
#' creation: `URL` | `NUMBER` | `STRING` | `DATE` | `EMAIL`. `ATTACHMENT`
#' is not a supported reference type during voice contact creation.
#' @param RelatedContactId The `contactId` that is related to this contact. Linking voice, task, or
#' chat by using `RelatedContactID` copies over contact attributes from the
#' related contact to the new contact. All updates to user-defined
#' attributes in the new contact are limited to the individual contact ID.
#' There are no limits to the number of contacts that can be linked by
#' using `RelatedContactId`.
#' @param DestinationPhoneNumber &#91;required&#93; The phone number of the customer, in E.164 format.
#' @param ContactFlowId &#91;required&#93; The identifier of the flow for the outbound call. To see the
#' ContactFlowId in the Amazon Connect admin website, on the navigation
#' menu go to **Routing**, **Contact Flows**. Choose the flow. On the flow
#' page, under the name of the flow, choose **Show additional flow
#' information**. The ContactFlowId is the last part of the ARN, shown here
#' in bold:
#' 
#' arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/**846ec553-a005-41c0-8341-xxxxxxxxxxxx**
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param ClientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If not provided, the Amazon Web Services SDK
#' populates this field. For more information about idempotency, see
#' [Making retries safe with idempotent
#' APIs](https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
#' The token is valid for 7 days after creation. If a contact is already
#' started, the contact ID is returned.
#' @param SourcePhoneNumber The phone number associated with the Amazon Connect instance, in E.164
#' format. If you do not specify a source phone number, you must specify a
#' queue.
#' @param QueueId The queue for the call. If you specify a queue, the phone displayed for
#' caller ID is the phone number specified in the queue. If you do not
#' specify a queue, the queue defined in the flow is used. If you do not
#' specify a queue, you must specify a source phone number.
#' @param Attributes A custom key-value pair using an attribute map. The attributes are
#' standard Amazon Connect attributes, and can be accessed in flows just
#' like any other contact attributes.
#' 
#' There can be up to 32,768 UTF-8 bytes across all key-value pairs per
#' contact. Attribute keys can include only alphanumeric, dash, and
#' underscore characters.
#' @param AnswerMachineDetectionConfig Configuration of the answering machine detection for this outbound call.
#' @param CampaignId The campaign identifier of the outbound communication.
#' @param TrafficType Denotes the class of traffic. Calls with different traffic types are
#' handled differently by Amazon Connect. The default value is `GENERAL`.
#' Use `CAMPAIGN` if `EnableAnswerMachineDetection` is set to `true`. For
#' all other cases, use `GENERAL`.
#'
#' @keywords internal
#'
#' @rdname connect_start_outbound_voice_contact
connect_start_outbound_voice_contact <- function(Name = NULL, Description = NULL, References = NULL, RelatedContactId = NULL, DestinationPhoneNumber, ContactFlowId, InstanceId, ClientToken = NULL, SourcePhoneNumber = NULL, QueueId = NULL, Attributes = NULL, AnswerMachineDetectionConfig = NULL, CampaignId = NULL, TrafficType = NULL) {
  op <- new_operation(
    name = "StartOutboundVoiceContact",
    http_method = "PUT",
    http_path = "/contact/outbound-voice",
    paginator = list()
  )
  input <- .connect$start_outbound_voice_contact_input(Name = Name, Description = Description, References = References, RelatedContactId = RelatedContactId, DestinationPhoneNumber = DestinationPhoneNumber, ContactFlowId = ContactFlowId, InstanceId = InstanceId, ClientToken = ClientToken, SourcePhoneNumber = SourcePhoneNumber, QueueId = QueueId, Attributes = Attributes, AnswerMachineDetectionConfig = AnswerMachineDetectionConfig, CampaignId = CampaignId, TrafficType = TrafficType)
  output <- .connect$start_outbound_voice_contact_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$start_outbound_voice_contact <- connect_start_outbound_voice_contact

#' Initiates a flow to start a new task contact
#'
#' @description
#' Initiates a flow to start a new task contact. For more information about task contacts, see [Concepts: Tasks in Amazon Connect](https://docs.aws.amazon.com/connect/latest/adminguide/tasks.html) in the *Amazon Connect Administrator Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_start_task_contact/](https://www.paws-r-sdk.com/docs/connect_start_task_contact/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param PreviousContactId The identifier of the previous chat, voice, or task contact. Any updates
#' to user-defined attributes to task contacts linked using the same
#' `PreviousContactID` will affect every contact in the chain. There can be
#' a maximum of 12 linked task contacts in a chain.
#' @param ContactFlowId The identifier of the flow for initiating the tasks. To see the
#' ContactFlowId in the Amazon Connect admin website, on the navigation
#' menu go to **Routing**, **Contact Flows**. Choose the flow. On the flow
#' page, under the name of the flow, choose **Show additional flow
#' information**. The ContactFlowId is the last part of the ARN, shown here
#' in bold:
#' 
#' arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/**846ec553-a005-41c0-8341-xxxxxxxxxxxx**
#' @param Attributes A custom key-value pair using an attribute map. The attributes are
#' standard Amazon Connect attributes, and can be accessed in flows just
#' like any other contact attributes.
#' 
#' There can be up to 32,768 UTF-8 bytes across all key-value pairs per
#' contact. Attribute keys can include only alphanumeric, dash, and
#' underscore characters.
#' @param Name &#91;required&#93; The name of a task that is shown to an agent in the Contact Control
#' Panel (CCP).
#' @param References A formatted URL that is shown to an agent in the Contact Control Panel
#' (CCP). Tasks can have the following reference types at the time of
#' creation: `URL` | `NUMBER` | `STRING` | `DATE` | `EMAIL`. `ATTACHMENT`
#' is not a supported reference type during task creation.
#' @param Description A description of the task that is shown to an agent in the Contact
#' Control Panel (CCP).
#' @param ClientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If not provided, the Amazon Web Services SDK
#' populates this field. For more information about idempotency, see
#' [Making retries safe with idempotent
#' APIs](https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
#' @param ScheduledTime The timestamp, in Unix Epoch seconds format, at which to start running
#' the inbound flow. The scheduled time cannot be in the past. It must be
#' within up to 6 days in future.
#' @param TaskTemplateId A unique identifier for the task template. For more information about
#' task templates, see [Create task
#' templates](https://docs.aws.amazon.com/connect/latest/adminguide/task-templates.html)
#' in the *Amazon Connect Administrator Guide*.
#' @param QuickConnectId The identifier for the quick connect. Tasks that are created by using
#' `QuickConnectId` will use the flow that is defined on agent or queue
#' quick connect. For more information about quick connects, see [Create
#' quick
#' connects](https://docs.aws.amazon.com/connect/latest/adminguide/quick-connects.html).
#' @param RelatedContactId The contactId that is
#' [related](https://docs.aws.amazon.com/connect/latest/adminguide/tasks.html#linked-tasks)
#' to this contact. Linking tasks together by using `RelatedContactID`
#' copies over contact attributes from the related task contact to the new
#' task contact. All updates to user-defined attributes in the new task
#' contact are limited to the individual contact ID, unlike what happens
#' when tasks are linked by using `PreviousContactID`. There are no limits
#' to the number of contacts that can be linked by using
#' `RelatedContactId`.
#'
#' @keywords internal
#'
#' @rdname connect_start_task_contact
connect_start_task_contact <- function(InstanceId, PreviousContactId = NULL, ContactFlowId = NULL, Attributes = NULL, Name, References = NULL, Description = NULL, ClientToken = NULL, ScheduledTime = NULL, TaskTemplateId = NULL, QuickConnectId = NULL, RelatedContactId = NULL) {
  op <- new_operation(
    name = "StartTaskContact",
    http_method = "PUT",
    http_path = "/contact/task",
    paginator = list()
  )
  input <- .connect$start_task_contact_input(InstanceId = InstanceId, PreviousContactId = PreviousContactId, ContactFlowId = ContactFlowId, Attributes = Attributes, Name = Name, References = References, Description = Description, ClientToken = ClientToken, ScheduledTime = ScheduledTime, TaskTemplateId = TaskTemplateId, QuickConnectId = QuickConnectId, RelatedContactId = RelatedContactId)
  output <- .connect$start_task_contact_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$start_task_contact <- connect_start_task_contact

#' Places an inbound in-app, web, or video call to a contact, and then
#' initiates the flow
#'
#' @description
#' Places an inbound in-app, web, or video call to a contact, and then initiates the flow. It performs the actions in the flow that are specified (in ContactFlowId) and present in the Amazon Connect instance (specified as InstanceId).
#'
#' See [https://www.paws-r-sdk.com/docs/connect_start_web_rtc_contact/](https://www.paws-r-sdk.com/docs/connect_start_web_rtc_contact/) for full documentation.
#'
#' @param Attributes A custom key-value pair using an attribute map. The attributes are
#' standard Amazon Connect attributes, and can be accessed in flows just
#' like any other contact attributes.
#' 
#' There can be up to 32,768 UTF-8 bytes across all key-value pairs per
#' contact. Attribute keys can include only alphanumeric, -, and _
#' characters.
#' @param ClientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If not provided, the Amazon Web Services SDK
#' populates this field. For more information about idempotency, see
#' [Making retries safe with idempotent
#' APIs](https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
#' 
#' The token is valid for 7 days after creation. If a contact is already
#' started, the contact ID is returned.
#' @param ContactFlowId &#91;required&#93; The identifier of the flow for the call. To see the ContactFlowId in the
#' Amazon Connect admin website, on the navigation menu go to **Routing**,
#' **Contact Flows**. Choose the flow. On the flow page, under the name of
#' the flow, choose **Show additional flow information**. The ContactFlowId
#' is the last part of the ARN, shown here in bold:
#' 
#' arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/**846ec553-a005-41c0-8341-xxxxxxxxxxxx**
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param AllowedCapabilities Information about the video sharing capabilities of the participants
#' (customer, agent).
#' @param ParticipantDetails &#91;required&#93; 
#' @param RelatedContactId The unique identifier for an Amazon Connect contact. This identifier is
#' related to the contact starting.
#' @param References A formatted URL that is shown to an agent in the Contact Control Panel
#' (CCP). Tasks can have the following reference types at the time of
#' creation: `URL` | `NUMBER` | `STRING` | `DATE` | `EMAIL`. `ATTACHMENT`
#' is not a supported reference type during task creation.
#' @param Description A description of the task that is shown to an agent in the Contact
#' Control Panel (CCP).
#'
#' @keywords internal
#'
#' @rdname connect_start_web_rtc_contact
connect_start_web_rtc_contact <- function(Attributes = NULL, ClientToken = NULL, ContactFlowId, InstanceId, AllowedCapabilities = NULL, ParticipantDetails, RelatedContactId = NULL, References = NULL, Description = NULL) {
  op <- new_operation(
    name = "StartWebRTCContact",
    http_method = "PUT",
    http_path = "/contact/webrtc",
    paginator = list()
  )
  input <- .connect$start_web_rtc_contact_input(Attributes = Attributes, ClientToken = ClientToken, ContactFlowId = ContactFlowId, InstanceId = InstanceId, AllowedCapabilities = AllowedCapabilities, ParticipantDetails = ParticipantDetails, RelatedContactId = RelatedContactId, References = References, Description = Description)
  output <- .connect$start_web_rtc_contact_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$start_web_rtc_contact <- connect_start_web_rtc_contact

#' Ends the specified contact
#'
#' @description
#' Ends the specified contact. Use this API to stop queued callbacks. It does not work for voice contacts that use the following initiation methods:
#'
#' See [https://www.paws-r-sdk.com/docs/connect_stop_contact/](https://www.paws-r-sdk.com/docs/connect_stop_contact/) for full documentation.
#'
#' @param ContactId &#91;required&#93; The ID of the contact.
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param DisconnectReason The reason a contact can be disconnected. Only Amazon Connect outbound
#' campaigns can provide this field.
#'
#' @keywords internal
#'
#' @rdname connect_stop_contact
connect_stop_contact <- function(ContactId, InstanceId, DisconnectReason = NULL) {
  op <- new_operation(
    name = "StopContact",
    http_method = "POST",
    http_path = "/contact/stop",
    paginator = list()
  )
  input <- .connect$stop_contact_input(ContactId = ContactId, InstanceId = InstanceId, DisconnectReason = DisconnectReason)
  output <- .connect$stop_contact_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$stop_contact <- connect_stop_contact

#' Stops recording a call when a contact is being recorded
#'
#' @description
#' Stops recording a call when a contact is being recorded. StopContactRecording is a one-time action. If you use StopContactRecording to stop recording an ongoing call, you can't use StartContactRecording to restart it. For scenarios where the recording has started and you want to suspend it for sensitive information (for example, to collect a credit card number), and then restart it, use SuspendContactRecording and ResumeContactRecording.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_stop_contact_recording/](https://www.paws-r-sdk.com/docs/connect_stop_contact_recording/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param ContactId &#91;required&#93; The identifier of the contact.
#' @param InitialContactId &#91;required&#93; The identifier of the contact. This is the identifier of the contact
#' associated with the first interaction with the contact center.
#'
#' @keywords internal
#'
#' @rdname connect_stop_contact_recording
connect_stop_contact_recording <- function(InstanceId, ContactId, InitialContactId) {
  op <- new_operation(
    name = "StopContactRecording",
    http_method = "POST",
    http_path = "/contact/stop-recording",
    paginator = list()
  )
  input <- .connect$stop_contact_recording_input(InstanceId = InstanceId, ContactId = ContactId, InitialContactId = InitialContactId)
  output <- .connect$stop_contact_recording_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$stop_contact_recording <- connect_stop_contact_recording

#' Ends message streaming on a specified contact
#'
#' @description
#' Ends message streaming on a specified contact. To restart message streaming on that contact, call the [`start_contact_streaming`][connect_start_contact_streaming] API.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_stop_contact_streaming/](https://www.paws-r-sdk.com/docs/connect_stop_contact_streaming/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param ContactId &#91;required&#93; The identifier of the contact. This is the identifier of the contact
#' that is associated with the first interaction with the contact center.
#' @param StreamingId &#91;required&#93; The identifier of the streaming configuration enabled.
#'
#' @keywords internal
#'
#' @rdname connect_stop_contact_streaming
connect_stop_contact_streaming <- function(InstanceId, ContactId, StreamingId) {
  op <- new_operation(
    name = "StopContactStreaming",
    http_method = "POST",
    http_path = "/contact/stop-streaming",
    paginator = list()
  )
  input <- .connect$stop_contact_streaming_input(InstanceId = InstanceId, ContactId = ContactId, StreamingId = StreamingId)
  output <- .connect$stop_contact_streaming_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$stop_contact_streaming <- connect_stop_contact_streaming

#' Submits a contact evaluation in the specified Amazon Connect instance
#'
#' @description
#' Submits a contact evaluation in the specified Amazon Connect instance. Answers included in the request are merged with existing answers for the given evaluation. If no answers or notes are passed, the evaluation is submitted with the existing answers and notes. You can delete an answer or note by passing an empty object (`{}`) to the question identifier.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_submit_contact_evaluation/](https://www.paws-r-sdk.com/docs/connect_submit_contact_evaluation/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param EvaluationId &#91;required&#93; A unique identifier for the contact evaluation.
#' @param Answers A map of question identifiers to answer value.
#' @param Notes A map of question identifiers to note value.
#'
#' @keywords internal
#'
#' @rdname connect_submit_contact_evaluation
connect_submit_contact_evaluation <- function(InstanceId, EvaluationId, Answers = NULL, Notes = NULL) {
  op <- new_operation(
    name = "SubmitContactEvaluation",
    http_method = "POST",
    http_path = "/contact-evaluations/{InstanceId}/{EvaluationId}/submit",
    paginator = list()
  )
  input <- .connect$submit_contact_evaluation_input(InstanceId = InstanceId, EvaluationId = EvaluationId, Answers = Answers, Notes = Notes)
  output <- .connect$submit_contact_evaluation_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$submit_contact_evaluation <- connect_submit_contact_evaluation

#' When a contact is being recorded, this API suspends recording whatever
#' is selected in the flow configuration: call, screen, or both
#'
#' @description
#' When a contact is being recorded, this API suspends recording whatever is selected in the flow configuration: call, screen, or both. If only call recording or only screen recording is enabled, then it would be suspended. For example, you might suspend the screen recording while collecting sensitive information, such as a credit card number. Then use ResumeContactRecording to restart recording the screen.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_suspend_contact_recording/](https://www.paws-r-sdk.com/docs/connect_suspend_contact_recording/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param ContactId &#91;required&#93; The identifier of the contact.
#' @param InitialContactId &#91;required&#93; The identifier of the contact. This is the identifier of the contact
#' associated with the first interaction with the contact center.
#'
#' @keywords internal
#'
#' @rdname connect_suspend_contact_recording
connect_suspend_contact_recording <- function(InstanceId, ContactId, InitialContactId) {
  op <- new_operation(
    name = "SuspendContactRecording",
    http_method = "POST",
    http_path = "/contact/suspend-recording",
    paginator = list()
  )
  input <- .connect$suspend_contact_recording_input(InstanceId = InstanceId, ContactId = ContactId, InitialContactId = InitialContactId)
  output <- .connect$suspend_contact_recording_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$suspend_contact_recording <- connect_suspend_contact_recording

#' Adds the specified tags to the contact resource
#'
#' @description
#' Adds the specified tags to the contact resource. For more information about this API is used, see [Set up granular billing for a detailed view of your Amazon Connect usage](https://docs.aws.amazon.com/connect/latest/adminguide/granular-billing.html).
#'
#' See [https://www.paws-r-sdk.com/docs/connect_tag_contact/](https://www.paws-r-sdk.com/docs/connect_tag_contact/) for full documentation.
#'
#' @param ContactId &#91;required&#93; The identifier of the contact in this instance of Amazon Connect.
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param Tags &#91;required&#93; The tags to be assigned to the contact resource. For example, \{
#' "Tags": \{"key1":"value1", "key2":"value2"\} \}.
#' 
#' Authorization is not supported by this tag.
#'
#' @keywords internal
#'
#' @rdname connect_tag_contact
connect_tag_contact <- function(ContactId, InstanceId, Tags) {
  op <- new_operation(
    name = "TagContact",
    http_method = "POST",
    http_path = "/contact/tags",
    paginator = list()
  )
  input <- .connect$tag_contact_input(ContactId = ContactId, InstanceId = InstanceId, Tags = Tags)
  output <- .connect$tag_contact_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$tag_contact <- connect_tag_contact

#' Adds the specified tags to the specified resource
#'
#' @description
#' Adds the specified tags to the specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_tag_resource/](https://www.paws-r-sdk.com/docs/connect_tag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource.
#' @param tags &#91;required&#93; The tags used to organize, track, or control access for this resource.
#' For example, \{ "Tags": \{"key1":"value1", "key2":"value2"\} \}.
#'
#' @keywords internal
#'
#' @rdname connect_tag_resource
connect_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .connect$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .connect$tag_resource_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$tag_resource <- connect_tag_resource

#' Transfers contacts from one agent or queue to another agent or queue at
#' any point after a contact is created
#'
#' @description
#' Transfers contacts from one agent or queue to another agent or queue at any point after a contact is created. You can transfer a contact to another queue by providing the flow which orchestrates the contact to the destination queue. This gives you more control over contact handling and helps you adhere to the service level agreement (SLA) guaranteed to your customers.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_transfer_contact/](https://www.paws-r-sdk.com/docs/connect_transfer_contact/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param ContactId &#91;required&#93; The identifier of the contact in this instance of Amazon Connect.
#' @param QueueId The identifier for the queue.
#' @param UserId The identifier for the user. This can be the ID or the ARN of the user.
#' @param ContactFlowId &#91;required&#93; The identifier of the flow.
#' @param ClientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If not provided, the Amazon Web Services SDK
#' populates this field. For more information about idempotency, see
#' [Making retries safe with idempotent
#' APIs](https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
#'
#' @keywords internal
#'
#' @rdname connect_transfer_contact
connect_transfer_contact <- function(InstanceId, ContactId, QueueId = NULL, UserId = NULL, ContactFlowId, ClientToken = NULL) {
  op <- new_operation(
    name = "TransferContact",
    http_method = "POST",
    http_path = "/contact/transfer",
    paginator = list()
  )
  input <- .connect$transfer_contact_input(InstanceId = InstanceId, ContactId = ContactId, QueueId = QueueId, UserId = UserId, ContactFlowId = ContactFlowId, ClientToken = ClientToken)
  output <- .connect$transfer_contact_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$transfer_contact <- connect_transfer_contact

#' Removes the specified tags from the contact resource
#'
#' @description
#' Removes the specified tags from the contact resource. For more information about this API is used, see [Set up granular billing for a detailed view of your Amazon Connect usage](https://docs.aws.amazon.com/connect/latest/adminguide/granular-billing.html).
#'
#' See [https://www.paws-r-sdk.com/docs/connect_untag_contact/](https://www.paws-r-sdk.com/docs/connect_untag_contact/) for full documentation.
#'
#' @param ContactId &#91;required&#93; The identifier of the contact in this instance of Amazon Connect.
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param TagKeys &#91;required&#93; A list of tag keys. Existing tags on the contact whose keys are members
#' of this list will be removed.
#'
#' @keywords internal
#'
#' @rdname connect_untag_contact
connect_untag_contact <- function(ContactId, InstanceId, TagKeys) {
  op <- new_operation(
    name = "UntagContact",
    http_method = "DELETE",
    http_path = "/contact/tags/{InstanceId}/{ContactId}",
    paginator = list()
  )
  input <- .connect$untag_contact_input(ContactId = ContactId, InstanceId = InstanceId, TagKeys = TagKeys)
  output <- .connect$untag_contact_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$untag_contact <- connect_untag_contact

#' Removes the specified tags from the specified resource
#'
#' @description
#' Removes the specified tags from the specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_untag_resource/](https://www.paws-r-sdk.com/docs/connect_untag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource.
#' @param tagKeys &#91;required&#93; The tag keys.
#'
#' @keywords internal
#'
#' @rdname connect_untag_resource
connect_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .connect$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .connect$untag_resource_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$untag_resource <- connect_untag_resource

#' This API is in preview release for Amazon Connect and is subject to
#' change
#'
#' @description
#' This API is in preview release for Amazon Connect and is subject to change.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_update_agent_status/](https://www.paws-r-sdk.com/docs/connect_update_agent_status/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param AgentStatusId &#91;required&#93; The identifier of the agent status.
#' @param Name The name of the agent status.
#' @param Description The description of the agent status.
#' @param State The state of the agent status.
#' @param DisplayOrder The display order of the agent status.
#' @param ResetOrderNumber A number indicating the reset order of the agent status.
#'
#' @keywords internal
#'
#' @rdname connect_update_agent_status
connect_update_agent_status <- function(InstanceId, AgentStatusId, Name = NULL, Description = NULL, State = NULL, DisplayOrder = NULL, ResetOrderNumber = NULL) {
  op <- new_operation(
    name = "UpdateAgentStatus",
    http_method = "POST",
    http_path = "/agent-status/{InstanceId}/{AgentStatusId}",
    paginator = list()
  )
  input <- .connect$update_agent_status_input(InstanceId = InstanceId, AgentStatusId = AgentStatusId, Name = Name, Description = Description, State = State, DisplayOrder = DisplayOrder, ResetOrderNumber = ResetOrderNumber)
  output <- .connect$update_agent_status_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$update_agent_status <- connect_update_agent_status

#' This API is in preview release for Amazon Connect and is subject to
#' change
#'
#' @description
#' This API is in preview release for Amazon Connect and is subject to change.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_update_contact/](https://www.paws-r-sdk.com/docs/connect_update_contact/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param ContactId &#91;required&#93; The identifier of the contact. This is the identifier of the contact
#' associated with the first interaction with your contact center.
#' @param Name The name of the contact.
#' @param Description The description of the contact.
#' @param References Well-formed data on contact, shown to agents on Contact Control Panel
#' (CCP).
#'
#' @keywords internal
#'
#' @rdname connect_update_contact
connect_update_contact <- function(InstanceId, ContactId, Name = NULL, Description = NULL, References = NULL) {
  op <- new_operation(
    name = "UpdateContact",
    http_method = "POST",
    http_path = "/contacts/{InstanceId}/{ContactId}",
    paginator = list()
  )
  input <- .connect$update_contact_input(InstanceId = InstanceId, ContactId = ContactId, Name = Name, Description = Description, References = References)
  output <- .connect$update_contact_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$update_contact <- connect_update_contact

#' Creates or updates user-defined contact attributes associated with the
#' specified contact
#'
#' @description
#' Creates or updates user-defined contact attributes associated with the specified contact.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_update_contact_attributes/](https://www.paws-r-sdk.com/docs/connect_update_contact_attributes/) for full documentation.
#'
#' @param InitialContactId &#91;required&#93; The identifier of the contact. This is the identifier of the contact
#' associated with the first interaction with the contact center.
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param Attributes &#91;required&#93; The Amazon Connect attributes. These attributes can be accessed in flows
#' just like any other contact attributes.
#' 
#' You can have up to 32,768 UTF-8 bytes across all attributes for a
#' contact. Attribute keys can include only alphanumeric, dash, and
#' underscore characters.
#'
#' @keywords internal
#'
#' @rdname connect_update_contact_attributes
connect_update_contact_attributes <- function(InitialContactId, InstanceId, Attributes) {
  op <- new_operation(
    name = "UpdateContactAttributes",
    http_method = "POST",
    http_path = "/contact/attributes",
    paginator = list()
  )
  input <- .connect$update_contact_attributes_input(InitialContactId = InitialContactId, InstanceId = InstanceId, Attributes = Attributes)
  output <- .connect$update_contact_attributes_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$update_contact_attributes <- connect_update_contact_attributes

#' Updates details about a contact evaluation in the specified Amazon
#' Connect instance
#'
#' @description
#' Updates details about a contact evaluation in the specified Amazon Connect instance. A contact evaluation must be in draft state. Answers included in the request are merged with existing answers for the given evaluation. An answer or note can be deleted by passing an empty object (`{}`) to the question identifier.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_update_contact_evaluation/](https://www.paws-r-sdk.com/docs/connect_update_contact_evaluation/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param EvaluationId &#91;required&#93; A unique identifier for the contact evaluation.
#' @param Answers A map of question identifiers to answer value.
#' @param Notes A map of question identifiers to note value.
#'
#' @keywords internal
#'
#' @rdname connect_update_contact_evaluation
connect_update_contact_evaluation <- function(InstanceId, EvaluationId, Answers = NULL, Notes = NULL) {
  op <- new_operation(
    name = "UpdateContactEvaluation",
    http_method = "POST",
    http_path = "/contact-evaluations/{InstanceId}/{EvaluationId}",
    paginator = list()
  )
  input <- .connect$update_contact_evaluation_input(InstanceId = InstanceId, EvaluationId = EvaluationId, Answers = Answers, Notes = Notes)
  output <- .connect$update_contact_evaluation_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$update_contact_evaluation <- connect_update_contact_evaluation

#' Updates the specified flow
#'
#' @description
#' Updates the specified flow.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_update_contact_flow_content/](https://www.paws-r-sdk.com/docs/connect_update_contact_flow_content/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance.
#' @param ContactFlowId &#91;required&#93; The identifier of the flow.
#' @param Content &#91;required&#93; The JSON string that represents the content of the flow. For an example,
#' see [Example flow in Amazon Connect Flow
#' language](https://docs.aws.amazon.com/connect/latest/APIReference/flow-language-example.html).
#' 
#' Length Constraints: Minimum length of 1. Maximum length of 256000.
#'
#' @keywords internal
#'
#' @rdname connect_update_contact_flow_content
connect_update_contact_flow_content <- function(InstanceId, ContactFlowId, Content) {
  op <- new_operation(
    name = "UpdateContactFlowContent",
    http_method = "POST",
    http_path = "/contact-flows/{InstanceId}/{ContactFlowId}/content",
    paginator = list()
  )
  input <- .connect$update_contact_flow_content_input(InstanceId = InstanceId, ContactFlowId = ContactFlowId, Content = Content)
  output <- .connect$update_contact_flow_content_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$update_contact_flow_content <- connect_update_contact_flow_content

#' Updates metadata about specified flow
#'
#' @description
#' Updates metadata about specified flow.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_update_contact_flow_metadata/](https://www.paws-r-sdk.com/docs/connect_update_contact_flow_metadata/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param ContactFlowId &#91;required&#93; The identifier of the flow.
#' @param Name The name of the flow.
#' @param Description The description of the flow.
#' @param ContactFlowState The state of flow.
#'
#' @keywords internal
#'
#' @rdname connect_update_contact_flow_metadata
connect_update_contact_flow_metadata <- function(InstanceId, ContactFlowId, Name = NULL, Description = NULL, ContactFlowState = NULL) {
  op <- new_operation(
    name = "UpdateContactFlowMetadata",
    http_method = "POST",
    http_path = "/contact-flows/{InstanceId}/{ContactFlowId}/metadata",
    paginator = list()
  )
  input <- .connect$update_contact_flow_metadata_input(InstanceId = InstanceId, ContactFlowId = ContactFlowId, Name = Name, Description = Description, ContactFlowState = ContactFlowState)
  output <- .connect$update_contact_flow_metadata_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$update_contact_flow_metadata <- connect_update_contact_flow_metadata

#' Updates specified flow module for the specified Amazon Connect instance
#'
#' @description
#' Updates specified flow module for the specified Amazon Connect instance.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_update_contact_flow_module_content/](https://www.paws-r-sdk.com/docs/connect_update_contact_flow_module_content/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param ContactFlowModuleId &#91;required&#93; The identifier of the flow module.
#' @param Content &#91;required&#93; The JSON string that represents the content of the flow. For an example,
#' see [Example flow in Amazon Connect Flow
#' language](https://docs.aws.amazon.com/connect/latest/APIReference/flow-language-example.html).
#'
#' @keywords internal
#'
#' @rdname connect_update_contact_flow_module_content
connect_update_contact_flow_module_content <- function(InstanceId, ContactFlowModuleId, Content) {
  op <- new_operation(
    name = "UpdateContactFlowModuleContent",
    http_method = "POST",
    http_path = "/contact-flow-modules/{InstanceId}/{ContactFlowModuleId}/content",
    paginator = list()
  )
  input <- .connect$update_contact_flow_module_content_input(InstanceId = InstanceId, ContactFlowModuleId = ContactFlowModuleId, Content = Content)
  output <- .connect$update_contact_flow_module_content_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$update_contact_flow_module_content <- connect_update_contact_flow_module_content

#' Updates metadata about specified flow module
#'
#' @description
#' Updates metadata about specified flow module.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_update_contact_flow_module_metadata/](https://www.paws-r-sdk.com/docs/connect_update_contact_flow_module_metadata/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param ContactFlowModuleId &#91;required&#93; The identifier of the flow module.
#' @param Name The name of the flow module.
#' @param Description The description of the flow module.
#' @param State The state of flow module.
#'
#' @keywords internal
#'
#' @rdname connect_update_contact_flow_module_metadata
connect_update_contact_flow_module_metadata <- function(InstanceId, ContactFlowModuleId, Name = NULL, Description = NULL, State = NULL) {
  op <- new_operation(
    name = "UpdateContactFlowModuleMetadata",
    http_method = "POST",
    http_path = "/contact-flow-modules/{InstanceId}/{ContactFlowModuleId}/metadata",
    paginator = list()
  )
  input <- .connect$update_contact_flow_module_metadata_input(InstanceId = InstanceId, ContactFlowModuleId = ContactFlowModuleId, Name = Name, Description = Description, State = State)
  output <- .connect$update_contact_flow_module_metadata_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$update_contact_flow_module_metadata <- connect_update_contact_flow_module_metadata

#' The name of the flow
#'
#' @description
#' The name of the flow.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_update_contact_flow_name/](https://www.paws-r-sdk.com/docs/connect_update_contact_flow_name/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance.
#' @param ContactFlowId &#91;required&#93; The identifier of the flow.
#' @param Name The name of the flow.
#' @param Description The description of the flow.
#'
#' @keywords internal
#'
#' @rdname connect_update_contact_flow_name
connect_update_contact_flow_name <- function(InstanceId, ContactFlowId, Name = NULL, Description = NULL) {
  op <- new_operation(
    name = "UpdateContactFlowName",
    http_method = "POST",
    http_path = "/contact-flows/{InstanceId}/{ContactFlowId}/name",
    paginator = list()
  )
  input <- .connect$update_contact_flow_name_input(InstanceId = InstanceId, ContactFlowId = ContactFlowId, Name = Name, Description = Description)
  output <- .connect$update_contact_flow_name_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$update_contact_flow_name <- connect_update_contact_flow_name

#' This API is in preview release for Amazon Connect and is subject to
#' change
#'
#' @description
#' This API is in preview release for Amazon Connect and is subject to change.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_update_contact_routing_data/](https://www.paws-r-sdk.com/docs/connect_update_contact_routing_data/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param ContactId &#91;required&#93; The identifier of the contact in this instance of Amazon Connect.
#' @param QueueTimeAdjustmentSeconds The number of seconds to add or subtract from the contact's routing age.
#' Contacts are routed to agents on a first-come, first-serve basis. This
#' means that changing their amount of time in queue compared to others
#' also changes their position in queue.
#' @param QueuePriority Priority of the contact in the queue. The default priority for new
#' contacts is 5. You can raise the priority of a contact compared to other
#' contacts in the queue by assigning them a higher priority, such as 1 or
#' 2.
#'
#' @keywords internal
#'
#' @rdname connect_update_contact_routing_data
connect_update_contact_routing_data <- function(InstanceId, ContactId, QueueTimeAdjustmentSeconds = NULL, QueuePriority = NULL) {
  op <- new_operation(
    name = "UpdateContactRoutingData",
    http_method = "POST",
    http_path = "/contacts/{InstanceId}/{ContactId}/routing-data",
    paginator = list()
  )
  input <- .connect$update_contact_routing_data_input(InstanceId = InstanceId, ContactId = ContactId, QueueTimeAdjustmentSeconds = QueueTimeAdjustmentSeconds, QueuePriority = QueuePriority)
  output <- .connect$update_contact_routing_data_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$update_contact_routing_data <- connect_update_contact_routing_data

#' Updates the scheduled time of a task contact that is already scheduled
#'
#' @description
#' Updates the scheduled time of a task contact that is already scheduled.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_update_contact_schedule/](https://www.paws-r-sdk.com/docs/connect_update_contact_schedule/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param ContactId &#91;required&#93; The identifier of the contact.
#' @param ScheduledTime &#91;required&#93; The timestamp, in Unix Epoch seconds format, at which to start running
#' the inbound flow. The scheduled time cannot be in the past. It must be
#' within up to 6 days in future.
#'
#' @keywords internal
#'
#' @rdname connect_update_contact_schedule
connect_update_contact_schedule <- function(InstanceId, ContactId, ScheduledTime) {
  op <- new_operation(
    name = "UpdateContactSchedule",
    http_method = "POST",
    http_path = "/contact/schedule",
    paginator = list()
  )
  input <- .connect$update_contact_schedule_input(InstanceId = InstanceId, ContactId = ContactId, ScheduledTime = ScheduledTime)
  output <- .connect$update_contact_schedule_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$update_contact_schedule <- connect_update_contact_schedule

#' Updates details about a specific evaluation form version in the
#' specified Amazon Connect instance
#'
#' @description
#' Updates details about a specific evaluation form version in the specified Amazon Connect instance. Question and section identifiers cannot be duplicated within the same evaluation form.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_update_evaluation_form/](https://www.paws-r-sdk.com/docs/connect_update_evaluation_form/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param EvaluationFormId &#91;required&#93; The unique identifier for the evaluation form.
#' @param EvaluationFormVersion &#91;required&#93; A version of the evaluation form to update.
#' @param CreateNewVersion A flag indicating whether the operation must create a new version.
#' @param Title &#91;required&#93; A title of the evaluation form.
#' @param Description The description of the evaluation form.
#' @param Items &#91;required&#93; Items that are part of the evaluation form. The total number of sections
#' and questions must not exceed 100 each. Questions must be contained in a
#' section.
#' @param ScoringStrategy A scoring strategy of the evaluation form.
#' @param ClientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If not provided, the Amazon Web Services SDK
#' populates this field. For more information about idempotency, see
#' [Making retries safe with idempotent
#' APIs](https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
#'
#' @keywords internal
#'
#' @rdname connect_update_evaluation_form
connect_update_evaluation_form <- function(InstanceId, EvaluationFormId, EvaluationFormVersion, CreateNewVersion = NULL, Title, Description = NULL, Items, ScoringStrategy = NULL, ClientToken = NULL) {
  op <- new_operation(
    name = "UpdateEvaluationForm",
    http_method = "PUT",
    http_path = "/evaluation-forms/{InstanceId}/{EvaluationFormId}",
    paginator = list()
  )
  input <- .connect$update_evaluation_form_input(InstanceId = InstanceId, EvaluationFormId = EvaluationFormId, EvaluationFormVersion = EvaluationFormVersion, CreateNewVersion = CreateNewVersion, Title = Title, Description = Description, Items = Items, ScoringStrategy = ScoringStrategy, ClientToken = ClientToken)
  output <- .connect$update_evaluation_form_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$update_evaluation_form <- connect_update_evaluation_form

#' This API is in preview release for Amazon Connect and is subject to
#' change
#'
#' @description
#' This API is in preview release for Amazon Connect and is subject to change.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_update_hours_of_operation/](https://www.paws-r-sdk.com/docs/connect_update_hours_of_operation/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param HoursOfOperationId &#91;required&#93; The identifier of the hours of operation.
#' @param Name The name of the hours of operation.
#' @param Description The description of the hours of operation.
#' @param TimeZone The time zone of the hours of operation.
#' @param Config Configuration information of the hours of operation.
#'
#' @keywords internal
#'
#' @rdname connect_update_hours_of_operation
connect_update_hours_of_operation <- function(InstanceId, HoursOfOperationId, Name = NULL, Description = NULL, TimeZone = NULL, Config = NULL) {
  op <- new_operation(
    name = "UpdateHoursOfOperation",
    http_method = "POST",
    http_path = "/hours-of-operations/{InstanceId}/{HoursOfOperationId}",
    paginator = list()
  )
  input <- .connect$update_hours_of_operation_input(InstanceId = InstanceId, HoursOfOperationId = HoursOfOperationId, Name = Name, Description = Description, TimeZone = TimeZone, Config = Config)
  output <- .connect$update_hours_of_operation_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$update_hours_of_operation <- connect_update_hours_of_operation

#' This API is in preview release for Amazon Connect and is subject to
#' change
#'
#' @description
#' This API is in preview release for Amazon Connect and is subject to change.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_update_instance_attribute/](https://www.paws-r-sdk.com/docs/connect_update_instance_attribute/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param AttributeType &#91;required&#93; The type of attribute.
#' 
#' Only allowlisted customers can consume USE_CUSTOM_TTS_VOICES. To access
#' this feature, contact Amazon Web Services Support for allowlisting.
#' @param Value &#91;required&#93; The value for the attribute. Maximum character limit is 100.
#'
#' @keywords internal
#'
#' @rdname connect_update_instance_attribute
connect_update_instance_attribute <- function(InstanceId, AttributeType, Value) {
  op <- new_operation(
    name = "UpdateInstanceAttribute",
    http_method = "POST",
    http_path = "/instance/{InstanceId}/attribute/{AttributeType}",
    paginator = list()
  )
  input <- .connect$update_instance_attribute_input(InstanceId = InstanceId, AttributeType = AttributeType, Value = Value)
  output <- .connect$update_instance_attribute_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$update_instance_attribute <- connect_update_instance_attribute

#' This API is in preview release for Amazon Connect and is subject to
#' change
#'
#' @description
#' This API is in preview release for Amazon Connect and is subject to change.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_update_instance_storage_config/](https://www.paws-r-sdk.com/docs/connect_update_instance_storage_config/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param AssociationId &#91;required&#93; The existing association identifier that uniquely identifies the
#' resource type and storage config for the given instance ID.
#' @param ResourceType &#91;required&#93; A valid resource type.
#' @param StorageConfig &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname connect_update_instance_storage_config
connect_update_instance_storage_config <- function(InstanceId, AssociationId, ResourceType, StorageConfig) {
  op <- new_operation(
    name = "UpdateInstanceStorageConfig",
    http_method = "POST",
    http_path = "/instance/{InstanceId}/storage-config/{AssociationId}",
    paginator = list()
  )
  input <- .connect$update_instance_storage_config_input(InstanceId = InstanceId, AssociationId = AssociationId, ResourceType = ResourceType, StorageConfig = StorageConfig)
  output <- .connect$update_instance_storage_config_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$update_instance_storage_config <- connect_update_instance_storage_config

#' Updates timeouts for when human chat participants are to be considered
#' idle, and when agents are automatically disconnected from a chat due to
#' idleness
#'
#' @description
#' Updates timeouts for when human chat participants are to be considered idle, and when agents are automatically disconnected from a chat due to idleness. You can set four timers:
#'
#' See [https://www.paws-r-sdk.com/docs/connect_update_participant_role_config/](https://www.paws-r-sdk.com/docs/connect_update_participant_role_config/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param ContactId &#91;required&#93; The identifier of the contact in this instance of Amazon Connect.
#' @param ChannelConfiguration &#91;required&#93; The Amazon Connect channel you want to configure.
#'
#' @keywords internal
#'
#' @rdname connect_update_participant_role_config
connect_update_participant_role_config <- function(InstanceId, ContactId, ChannelConfiguration) {
  op <- new_operation(
    name = "UpdateParticipantRoleConfig",
    http_method = "PUT",
    http_path = "/contact/participant-role-config/{InstanceId}/{ContactId}",
    paginator = list()
  )
  input <- .connect$update_participant_role_config_input(InstanceId = InstanceId, ContactId = ContactId, ChannelConfiguration = ChannelConfiguration)
  output <- .connect$update_participant_role_config_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$update_participant_role_config <- connect_update_participant_role_config

#' Updates your claimed phone number from its current Amazon Connect
#' instance or traffic distribution group to another Amazon Connect
#' instance or traffic distribution group in the same Amazon Web Services
#' Region
#'
#' @description
#' Updates your claimed phone number from its current Amazon Connect instance or traffic distribution group to another Amazon Connect instance or traffic distribution group in the same Amazon Web Services Region.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_update_phone_number/](https://www.paws-r-sdk.com/docs/connect_update_phone_number/) for full documentation.
#'
#' @param PhoneNumberId &#91;required&#93; A unique identifier for the phone number.
#' @param TargetArn The Amazon Resource Name (ARN) for Amazon Connect instances or traffic
#' distribution groups that phone number inbound traffic is routed through.
#' You must enter `InstanceId` or `TargetArn`.
#' @param InstanceId The identifier of the Amazon Connect instance that phone numbers are
#' claimed to. You can [find the instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance. You must enter
#' `InstanceId` or `TargetArn`.
#' @param ClientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If not provided, the Amazon Web Services SDK
#' populates this field. For more information about idempotency, see
#' [Making retries safe with idempotent
#' APIs](https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
#'
#' @keywords internal
#'
#' @rdname connect_update_phone_number
connect_update_phone_number <- function(PhoneNumberId, TargetArn = NULL, InstanceId = NULL, ClientToken = NULL) {
  op <- new_operation(
    name = "UpdatePhoneNumber",
    http_method = "PUT",
    http_path = "/phone-number/{PhoneNumberId}",
    paginator = list()
  )
  input <- .connect$update_phone_number_input(PhoneNumberId = PhoneNumberId, TargetArn = TargetArn, InstanceId = InstanceId, ClientToken = ClientToken)
  output <- .connect$update_phone_number_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$update_phone_number <- connect_update_phone_number

#' Updates a phone number’s metadata
#'
#' @description
#' Updates a phone number’s metadata.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_update_phone_number_metadata/](https://www.paws-r-sdk.com/docs/connect_update_phone_number_metadata/) for full documentation.
#'
#' @param PhoneNumberId &#91;required&#93; The Amazon Resource Name (ARN) or resource ID of the phone number.
#' @param PhoneNumberDescription The description of the phone number.
#' @param ClientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If not provided, the Amazon Web Services SDK
#' populates this field. For more information about idempotency, see
#' [Making retries safe with idempotent
#' APIs](https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
#'
#' @keywords internal
#'
#' @rdname connect_update_phone_number_metadata
connect_update_phone_number_metadata <- function(PhoneNumberId, PhoneNumberDescription = NULL, ClientToken = NULL) {
  op <- new_operation(
    name = "UpdatePhoneNumberMetadata",
    http_method = "PUT",
    http_path = "/phone-number/{PhoneNumberId}/metadata",
    paginator = list()
  )
  input <- .connect$update_phone_number_metadata_input(PhoneNumberId = PhoneNumberId, PhoneNumberDescription = PhoneNumberDescription, ClientToken = ClientToken)
  output <- .connect$update_phone_number_metadata_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$update_phone_number_metadata <- connect_update_phone_number_metadata

#' Updates a predefined attribute for the specified Amazon Connect instance
#'
#' @description
#' Updates a predefined attribute for the specified Amazon Connect instance.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_update_predefined_attribute/](https://www.paws-r-sdk.com/docs/connect_update_predefined_attribute/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can find the instance
#' ID in the Amazon Resource Name (ARN) of the instance.
#' @param Name &#91;required&#93; The name of the predefined attribute.
#' @param Values The values of the predefined attribute.
#'
#' @keywords internal
#'
#' @rdname connect_update_predefined_attribute
connect_update_predefined_attribute <- function(InstanceId, Name, Values = NULL) {
  op <- new_operation(
    name = "UpdatePredefinedAttribute",
    http_method = "POST",
    http_path = "/predefined-attributes/{InstanceId}/{Name}",
    paginator = list()
  )
  input <- .connect$update_predefined_attribute_input(InstanceId = InstanceId, Name = Name, Values = Values)
  output <- .connect$update_predefined_attribute_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$update_predefined_attribute <- connect_update_predefined_attribute

#' Updates a prompt
#'
#' @description
#' Updates a prompt.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_update_prompt/](https://www.paws-r-sdk.com/docs/connect_update_prompt/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param PromptId &#91;required&#93; A unique identifier for the prompt.
#' @param Name The name of the prompt.
#' @param Description A description of the prompt.
#' @param S3Uri The URI for the S3 bucket where the prompt is stored. You can provide S3
#' pre-signed URLs returned by the
#' [`get_prompt_file`][connect_get_prompt_file] API instead of providing S3
#' URIs.
#'
#' @keywords internal
#'
#' @rdname connect_update_prompt
connect_update_prompt <- function(InstanceId, PromptId, Name = NULL, Description = NULL, S3Uri = NULL) {
  op <- new_operation(
    name = "UpdatePrompt",
    http_method = "POST",
    http_path = "/prompts/{InstanceId}/{PromptId}",
    paginator = list()
  )
  input <- .connect$update_prompt_input(InstanceId = InstanceId, PromptId = PromptId, Name = Name, Description = Description, S3Uri = S3Uri)
  output <- .connect$update_prompt_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$update_prompt <- connect_update_prompt

#' This API is in preview release for Amazon Connect and is subject to
#' change
#'
#' @description
#' This API is in preview release for Amazon Connect and is subject to change.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_update_queue_hours_of_operation/](https://www.paws-r-sdk.com/docs/connect_update_queue_hours_of_operation/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param QueueId &#91;required&#93; The identifier for the queue.
#' @param HoursOfOperationId &#91;required&#93; The identifier for the hours of operation.
#'
#' @keywords internal
#'
#' @rdname connect_update_queue_hours_of_operation
connect_update_queue_hours_of_operation <- function(InstanceId, QueueId, HoursOfOperationId) {
  op <- new_operation(
    name = "UpdateQueueHoursOfOperation",
    http_method = "POST",
    http_path = "/queues/{InstanceId}/{QueueId}/hours-of-operation",
    paginator = list()
  )
  input <- .connect$update_queue_hours_of_operation_input(InstanceId = InstanceId, QueueId = QueueId, HoursOfOperationId = HoursOfOperationId)
  output <- .connect$update_queue_hours_of_operation_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$update_queue_hours_of_operation <- connect_update_queue_hours_of_operation

#' This API is in preview release for Amazon Connect and is subject to
#' change
#'
#' @description
#' This API is in preview release for Amazon Connect and is subject to change.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_update_queue_max_contacts/](https://www.paws-r-sdk.com/docs/connect_update_queue_max_contacts/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param QueueId &#91;required&#93; The identifier for the queue.
#' @param MaxContacts The maximum number of contacts that can be in the queue before it is
#' considered full.
#'
#' @keywords internal
#'
#' @rdname connect_update_queue_max_contacts
connect_update_queue_max_contacts <- function(InstanceId, QueueId, MaxContacts = NULL) {
  op <- new_operation(
    name = "UpdateQueueMaxContacts",
    http_method = "POST",
    http_path = "/queues/{InstanceId}/{QueueId}/max-contacts",
    paginator = list()
  )
  input <- .connect$update_queue_max_contacts_input(InstanceId = InstanceId, QueueId = QueueId, MaxContacts = MaxContacts)
  output <- .connect$update_queue_max_contacts_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$update_queue_max_contacts <- connect_update_queue_max_contacts

#' This API is in preview release for Amazon Connect and is subject to
#' change
#'
#' @description
#' This API is in preview release for Amazon Connect and is subject to change.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_update_queue_name/](https://www.paws-r-sdk.com/docs/connect_update_queue_name/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param QueueId &#91;required&#93; The identifier for the queue.
#' @param Name The name of the queue.
#' @param Description The description of the queue.
#'
#' @keywords internal
#'
#' @rdname connect_update_queue_name
connect_update_queue_name <- function(InstanceId, QueueId, Name = NULL, Description = NULL) {
  op <- new_operation(
    name = "UpdateQueueName",
    http_method = "POST",
    http_path = "/queues/{InstanceId}/{QueueId}/name",
    paginator = list()
  )
  input <- .connect$update_queue_name_input(InstanceId = InstanceId, QueueId = QueueId, Name = Name, Description = Description)
  output <- .connect$update_queue_name_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$update_queue_name <- connect_update_queue_name

#' This API is in preview release for Amazon Connect and is subject to
#' change
#'
#' @description
#' This API is in preview release for Amazon Connect and is subject to change.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_update_queue_outbound_caller_config/](https://www.paws-r-sdk.com/docs/connect_update_queue_outbound_caller_config/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param QueueId &#91;required&#93; The identifier for the queue.
#' @param OutboundCallerConfig &#91;required&#93; The outbound caller ID name, number, and outbound whisper flow.
#'
#' @keywords internal
#'
#' @rdname connect_update_queue_outbound_caller_config
connect_update_queue_outbound_caller_config <- function(InstanceId, QueueId, OutboundCallerConfig) {
  op <- new_operation(
    name = "UpdateQueueOutboundCallerConfig",
    http_method = "POST",
    http_path = "/queues/{InstanceId}/{QueueId}/outbound-caller-config",
    paginator = list()
  )
  input <- .connect$update_queue_outbound_caller_config_input(InstanceId = InstanceId, QueueId = QueueId, OutboundCallerConfig = OutboundCallerConfig)
  output <- .connect$update_queue_outbound_caller_config_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$update_queue_outbound_caller_config <- connect_update_queue_outbound_caller_config

#' This API is in preview release for Amazon Connect and is subject to
#' change
#'
#' @description
#' This API is in preview release for Amazon Connect and is subject to change.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_update_queue_status/](https://www.paws-r-sdk.com/docs/connect_update_queue_status/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param QueueId &#91;required&#93; The identifier for the queue.
#' @param Status &#91;required&#93; The status of the queue.
#'
#' @keywords internal
#'
#' @rdname connect_update_queue_status
connect_update_queue_status <- function(InstanceId, QueueId, Status) {
  op <- new_operation(
    name = "UpdateQueueStatus",
    http_method = "POST",
    http_path = "/queues/{InstanceId}/{QueueId}/status",
    paginator = list()
  )
  input <- .connect$update_queue_status_input(InstanceId = InstanceId, QueueId = QueueId, Status = Status)
  output <- .connect$update_queue_status_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$update_queue_status <- connect_update_queue_status

#' Updates the configuration settings for the specified quick connect
#'
#' @description
#' Updates the configuration settings for the specified quick connect.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_update_quick_connect_config/](https://www.paws-r-sdk.com/docs/connect_update_quick_connect_config/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param QuickConnectId &#91;required&#93; The identifier for the quick connect.
#' @param QuickConnectConfig &#91;required&#93; Information about the configuration settings for the quick connect.
#'
#' @keywords internal
#'
#' @rdname connect_update_quick_connect_config
connect_update_quick_connect_config <- function(InstanceId, QuickConnectId, QuickConnectConfig) {
  op <- new_operation(
    name = "UpdateQuickConnectConfig",
    http_method = "POST",
    http_path = "/quick-connects/{InstanceId}/{QuickConnectId}/config",
    paginator = list()
  )
  input <- .connect$update_quick_connect_config_input(InstanceId = InstanceId, QuickConnectId = QuickConnectId, QuickConnectConfig = QuickConnectConfig)
  output <- .connect$update_quick_connect_config_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$update_quick_connect_config <- connect_update_quick_connect_config

#' Updates the name and description of a quick connect
#'
#' @description
#' Updates the name and description of a quick connect. The request accepts the following data in JSON format. At least `Name` or `Description` must be provided.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_update_quick_connect_name/](https://www.paws-r-sdk.com/docs/connect_update_quick_connect_name/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param QuickConnectId &#91;required&#93; The identifier for the quick connect.
#' @param Name The name of the quick connect.
#' @param Description The description of the quick connect.
#'
#' @keywords internal
#'
#' @rdname connect_update_quick_connect_name
connect_update_quick_connect_name <- function(InstanceId, QuickConnectId, Name = NULL, Description = NULL) {
  op <- new_operation(
    name = "UpdateQuickConnectName",
    http_method = "POST",
    http_path = "/quick-connects/{InstanceId}/{QuickConnectId}/name",
    paginator = list()
  )
  input <- .connect$update_quick_connect_name_input(InstanceId = InstanceId, QuickConnectId = QuickConnectId, Name = Name, Description = Description)
  output <- .connect$update_quick_connect_name_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$update_quick_connect_name <- connect_update_quick_connect_name

#' Whether agents with this routing profile will have their routing order
#' calculated based on time since their last inbound contact or longest
#' idle time
#'
#' @description
#' Whether agents with this routing profile will have their routing order calculated based on *time since their last inbound contact* or *longest idle time*.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_update_routing_profile_agent_availability_timer/](https://www.paws-r-sdk.com/docs/connect_update_routing_profile_agent_availability_timer/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param RoutingProfileId &#91;required&#93; The identifier of the routing profile.
#' @param AgentAvailabilityTimer &#91;required&#93; Whether agents with this routing profile will have their routing order
#' calculated based on *time since their last inbound contact* or *longest
#' idle time*.
#'
#' @keywords internal
#'
#' @rdname connect_update_routing_profile_agent_availability_timer
connect_update_routing_profile_agent_availability_timer <- function(InstanceId, RoutingProfileId, AgentAvailabilityTimer) {
  op <- new_operation(
    name = "UpdateRoutingProfileAgentAvailabilityTimer",
    http_method = "POST",
    http_path = "/routing-profiles/{InstanceId}/{RoutingProfileId}/agent-availability-timer",
    paginator = list()
  )
  input <- .connect$update_routing_profile_agent_availability_timer_input(InstanceId = InstanceId, RoutingProfileId = RoutingProfileId, AgentAvailabilityTimer = AgentAvailabilityTimer)
  output <- .connect$update_routing_profile_agent_availability_timer_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$update_routing_profile_agent_availability_timer <- connect_update_routing_profile_agent_availability_timer

#' Updates the channels that agents can handle in the Contact Control Panel
#' (CCP) for a routing profile
#'
#' @description
#' Updates the channels that agents can handle in the Contact Control Panel (CCP) for a routing profile.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_update_routing_profile_concurrency/](https://www.paws-r-sdk.com/docs/connect_update_routing_profile_concurrency/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param RoutingProfileId &#91;required&#93; The identifier of the routing profile.
#' @param MediaConcurrencies &#91;required&#93; The channels that agents can handle in the Contact Control Panel (CCP).
#'
#' @keywords internal
#'
#' @rdname connect_update_routing_profile_concurrency
connect_update_routing_profile_concurrency <- function(InstanceId, RoutingProfileId, MediaConcurrencies) {
  op <- new_operation(
    name = "UpdateRoutingProfileConcurrency",
    http_method = "POST",
    http_path = "/routing-profiles/{InstanceId}/{RoutingProfileId}/concurrency",
    paginator = list()
  )
  input <- .connect$update_routing_profile_concurrency_input(InstanceId = InstanceId, RoutingProfileId = RoutingProfileId, MediaConcurrencies = MediaConcurrencies)
  output <- .connect$update_routing_profile_concurrency_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$update_routing_profile_concurrency <- connect_update_routing_profile_concurrency

#' Updates the default outbound queue of a routing profile
#'
#' @description
#' Updates the default outbound queue of a routing profile.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_update_routing_profile_default_outbound_queue/](https://www.paws-r-sdk.com/docs/connect_update_routing_profile_default_outbound_queue/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param RoutingProfileId &#91;required&#93; The identifier of the routing profile.
#' @param DefaultOutboundQueueId &#91;required&#93; The identifier for the default outbound queue.
#'
#' @keywords internal
#'
#' @rdname connect_update_routing_profile_default_outbound_queue
connect_update_routing_profile_default_outbound_queue <- function(InstanceId, RoutingProfileId, DefaultOutboundQueueId) {
  op <- new_operation(
    name = "UpdateRoutingProfileDefaultOutboundQueue",
    http_method = "POST",
    http_path = "/routing-profiles/{InstanceId}/{RoutingProfileId}/default-outbound-queue",
    paginator = list()
  )
  input <- .connect$update_routing_profile_default_outbound_queue_input(InstanceId = InstanceId, RoutingProfileId = RoutingProfileId, DefaultOutboundQueueId = DefaultOutboundQueueId)
  output <- .connect$update_routing_profile_default_outbound_queue_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$update_routing_profile_default_outbound_queue <- connect_update_routing_profile_default_outbound_queue

#' Updates the name and description of a routing profile
#'
#' @description
#' Updates the name and description of a routing profile. The request accepts the following data in JSON format. At least `Name` or `Description` must be provided.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_update_routing_profile_name/](https://www.paws-r-sdk.com/docs/connect_update_routing_profile_name/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param RoutingProfileId &#91;required&#93; The identifier of the routing profile.
#' @param Name The name of the routing profile. Must not be more than 127 characters.
#' @param Description The description of the routing profile. Must not be more than 250
#' characters.
#'
#' @keywords internal
#'
#' @rdname connect_update_routing_profile_name
connect_update_routing_profile_name <- function(InstanceId, RoutingProfileId, Name = NULL, Description = NULL) {
  op <- new_operation(
    name = "UpdateRoutingProfileName",
    http_method = "POST",
    http_path = "/routing-profiles/{InstanceId}/{RoutingProfileId}/name",
    paginator = list()
  )
  input <- .connect$update_routing_profile_name_input(InstanceId = InstanceId, RoutingProfileId = RoutingProfileId, Name = Name, Description = Description)
  output <- .connect$update_routing_profile_name_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$update_routing_profile_name <- connect_update_routing_profile_name

#' Updates the properties associated with a set of queues for a routing
#' profile
#'
#' @description
#' Updates the properties associated with a set of queues for a routing profile.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_update_routing_profile_queues/](https://www.paws-r-sdk.com/docs/connect_update_routing_profile_queues/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param RoutingProfileId &#91;required&#93; The identifier of the routing profile.
#' @param QueueConfigs &#91;required&#93; The queues to be updated for this routing profile. Queues must first be
#' associated to the routing profile. You can do this using
#' AssociateRoutingProfileQueues.
#'
#' @keywords internal
#'
#' @rdname connect_update_routing_profile_queues
connect_update_routing_profile_queues <- function(InstanceId, RoutingProfileId, QueueConfigs) {
  op <- new_operation(
    name = "UpdateRoutingProfileQueues",
    http_method = "POST",
    http_path = "/routing-profiles/{InstanceId}/{RoutingProfileId}/queues",
    paginator = list()
  )
  input <- .connect$update_routing_profile_queues_input(InstanceId = InstanceId, RoutingProfileId = RoutingProfileId, QueueConfigs = QueueConfigs)
  output <- .connect$update_routing_profile_queues_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$update_routing_profile_queues <- connect_update_routing_profile_queues

#' Updates a rule for the specified Amazon Connect instance
#'
#' @description
#' Updates a rule for the specified Amazon Connect instance.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_update_rule/](https://www.paws-r-sdk.com/docs/connect_update_rule/) for full documentation.
#'
#' @param RuleId &#91;required&#93; A unique identifier for the rule.
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param Name &#91;required&#93; The name of the rule. You can change the name only if
#' `TriggerEventSource` is one of the following values:
#' `OnZendeskTicketCreate` | `OnZendeskTicketStatusUpdate` |
#' `OnSalesforceCaseCreate`
#' @param Function &#91;required&#93; The conditions of the rule.
#' @param Actions &#91;required&#93; A list of actions to be run when the rule is triggered.
#' @param PublishStatus &#91;required&#93; The publish status of the rule.
#'
#' @keywords internal
#'
#' @rdname connect_update_rule
connect_update_rule <- function(RuleId, InstanceId, Name, Function, Actions, PublishStatus) {
  op <- new_operation(
    name = "UpdateRule",
    http_method = "PUT",
    http_path = "/rules/{InstanceId}/{RuleId}",
    paginator = list()
  )
  input <- .connect$update_rule_input(RuleId = RuleId, InstanceId = InstanceId, Name = Name, Function = Function, Actions = Actions, PublishStatus = PublishStatus)
  output <- .connect$update_rule_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$update_rule <- connect_update_rule

#' Updates a security profile
#'
#' @description
#' Updates a security profile.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_update_security_profile/](https://www.paws-r-sdk.com/docs/connect_update_security_profile/) for full documentation.
#'
#' @param Description The description of the security profile.
#' @param Permissions The permissions granted to a security profile. For a list of valid
#' permissions, see [List of security profile
#' permissions](https://docs.aws.amazon.com/connect/latest/adminguide/security-profile-list.html).
#' @param SecurityProfileId &#91;required&#93; The identifier for the security profle.
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param AllowedAccessControlTags The list of tags that a security profile uses to restrict access to
#' resources in Amazon Connect.
#' @param TagRestrictedResources The list of resources that a security profile applies tag restrictions
#' to in Amazon Connect.
#' @param Applications A list of the third-party application's metadata.
#' @param HierarchyRestrictedResources The list of resources that a security profile applies hierarchy
#' restrictions to in Amazon Connect. Following are acceptable
#' ResourceNames: `User`.
#' @param AllowedAccessControlHierarchyGroupId The identifier of the hierarchy group that a security profile uses to
#' restrict access to resources in Amazon Connect.
#'
#' @keywords internal
#'
#' @rdname connect_update_security_profile
connect_update_security_profile <- function(Description = NULL, Permissions = NULL, SecurityProfileId, InstanceId, AllowedAccessControlTags = NULL, TagRestrictedResources = NULL, Applications = NULL, HierarchyRestrictedResources = NULL, AllowedAccessControlHierarchyGroupId = NULL) {
  op <- new_operation(
    name = "UpdateSecurityProfile",
    http_method = "POST",
    http_path = "/security-profiles/{InstanceId}/{SecurityProfileId}",
    paginator = list()
  )
  input <- .connect$update_security_profile_input(Description = Description, Permissions = Permissions, SecurityProfileId = SecurityProfileId, InstanceId = InstanceId, AllowedAccessControlTags = AllowedAccessControlTags, TagRestrictedResources = TagRestrictedResources, Applications = Applications, HierarchyRestrictedResources = HierarchyRestrictedResources, AllowedAccessControlHierarchyGroupId = AllowedAccessControlHierarchyGroupId)
  output <- .connect$update_security_profile_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$update_security_profile <- connect_update_security_profile

#' Updates details about a specific task template in the specified Amazon
#' Connect instance
#'
#' @description
#' Updates details about a specific task template in the specified Amazon Connect instance. This operation does not support partial updates. Instead it does a full update of template content.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_update_task_template/](https://www.paws-r-sdk.com/docs/connect_update_task_template/) for full documentation.
#'
#' @param TaskTemplateId &#91;required&#93; A unique identifier for the task template.
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#' @param Name The name of the task template.
#' @param Description The description of the task template.
#' @param ContactFlowId The identifier of the flow that runs by default when a task is created
#' by referencing this template.
#' @param Constraints Constraints that are applicable to the fields listed.
#' @param Defaults The default values for fields when a task is created by referencing this
#' template.
#' @param Status Marks a template as `ACTIVE` or `INACTIVE` for a task to refer to it.
#' Tasks can only be created from `ACTIVE` templates. If a template is
#' marked as `INACTIVE`, then a task that refers to this template cannot be
#' created.
#' @param Fields Fields that are part of the template.
#'
#' @keywords internal
#'
#' @rdname connect_update_task_template
connect_update_task_template <- function(TaskTemplateId, InstanceId, Name = NULL, Description = NULL, ContactFlowId = NULL, Constraints = NULL, Defaults = NULL, Status = NULL, Fields = NULL) {
  op <- new_operation(
    name = "UpdateTaskTemplate",
    http_method = "POST",
    http_path = "/instance/{InstanceId}/task/template/{TaskTemplateId}",
    paginator = list()
  )
  input <- .connect$update_task_template_input(TaskTemplateId = TaskTemplateId, InstanceId = InstanceId, Name = Name, Description = Description, ContactFlowId = ContactFlowId, Constraints = Constraints, Defaults = Defaults, Status = Status, Fields = Fields)
  output <- .connect$update_task_template_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$update_task_template <- connect_update_task_template

#' Updates the traffic distribution for a given traffic distribution group
#'
#' @description
#' Updates the traffic distribution for a given traffic distribution group.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_update_traffic_distribution/](https://www.paws-r-sdk.com/docs/connect_update_traffic_distribution/) for full documentation.
#'
#' @param Id &#91;required&#93; The identifier of the traffic distribution group. This can be the ID or
#' the ARN if the API is being called in the Region where the traffic
#' distribution group was created. The ARN must be provided if the call is
#' from the replicated Region.
#' @param TelephonyConfig The distribution of traffic between the instance and its replica(s).
#' @param SignInConfig The distribution that determines which Amazon Web Services Regions
#' should be used to sign in agents in to both the instance and its
#' replica(s).
#' @param AgentConfig The distribution of agents between the instance and its replica(s).
#'
#' @keywords internal
#'
#' @rdname connect_update_traffic_distribution
connect_update_traffic_distribution <- function(Id, TelephonyConfig = NULL, SignInConfig = NULL, AgentConfig = NULL) {
  op <- new_operation(
    name = "UpdateTrafficDistribution",
    http_method = "PUT",
    http_path = "/traffic-distribution/{Id}",
    paginator = list()
  )
  input <- .connect$update_traffic_distribution_input(Id = Id, TelephonyConfig = TelephonyConfig, SignInConfig = SignInConfig, AgentConfig = AgentConfig)
  output <- .connect$update_traffic_distribution_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$update_traffic_distribution <- connect_update_traffic_distribution

#' Assigns the specified hierarchy group to the specified user
#'
#' @description
#' Assigns the specified hierarchy group to the specified user.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_update_user_hierarchy/](https://www.paws-r-sdk.com/docs/connect_update_user_hierarchy/) for full documentation.
#'
#' @param HierarchyGroupId The identifier of the hierarchy group.
#' @param UserId &#91;required&#93; The identifier of the user account.
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#'
#' @keywords internal
#'
#' @rdname connect_update_user_hierarchy
connect_update_user_hierarchy <- function(HierarchyGroupId = NULL, UserId, InstanceId) {
  op <- new_operation(
    name = "UpdateUserHierarchy",
    http_method = "POST",
    http_path = "/users/{InstanceId}/{UserId}/hierarchy",
    paginator = list()
  )
  input <- .connect$update_user_hierarchy_input(HierarchyGroupId = HierarchyGroupId, UserId = UserId, InstanceId = InstanceId)
  output <- .connect$update_user_hierarchy_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$update_user_hierarchy <- connect_update_user_hierarchy

#' Updates the name of the user hierarchy group
#'
#' @description
#' Updates the name of the user hierarchy group.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_update_user_hierarchy_group_name/](https://www.paws-r-sdk.com/docs/connect_update_user_hierarchy_group_name/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the hierarchy group. Must not be more than 100 characters.
#' @param HierarchyGroupId &#91;required&#93; The identifier of the hierarchy group.
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#'
#' @keywords internal
#'
#' @rdname connect_update_user_hierarchy_group_name
connect_update_user_hierarchy_group_name <- function(Name, HierarchyGroupId, InstanceId) {
  op <- new_operation(
    name = "UpdateUserHierarchyGroupName",
    http_method = "POST",
    http_path = "/user-hierarchy-groups/{InstanceId}/{HierarchyGroupId}/name",
    paginator = list()
  )
  input <- .connect$update_user_hierarchy_group_name_input(Name = Name, HierarchyGroupId = HierarchyGroupId, InstanceId = InstanceId)
  output <- .connect$update_user_hierarchy_group_name_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$update_user_hierarchy_group_name <- connect_update_user_hierarchy_group_name

#' Updates the user hierarchy structure: add, remove, and rename user
#' hierarchy levels
#'
#' @description
#' Updates the user hierarchy structure: add, remove, and rename user hierarchy levels.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_update_user_hierarchy_structure/](https://www.paws-r-sdk.com/docs/connect_update_user_hierarchy_structure/) for full documentation.
#'
#' @param HierarchyStructure &#91;required&#93; The hierarchy levels to update.
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#'
#' @keywords internal
#'
#' @rdname connect_update_user_hierarchy_structure
connect_update_user_hierarchy_structure <- function(HierarchyStructure, InstanceId) {
  op <- new_operation(
    name = "UpdateUserHierarchyStructure",
    http_method = "POST",
    http_path = "/user-hierarchy-structure/{InstanceId}",
    paginator = list()
  )
  input <- .connect$update_user_hierarchy_structure_input(HierarchyStructure = HierarchyStructure, InstanceId = InstanceId)
  output <- .connect$update_user_hierarchy_structure_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$update_user_hierarchy_structure <- connect_update_user_hierarchy_structure

#' Updates the identity information for the specified user
#'
#' @description
#' Updates the identity information for the specified user.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_update_user_identity_info/](https://www.paws-r-sdk.com/docs/connect_update_user_identity_info/) for full documentation.
#'
#' @param IdentityInfo &#91;required&#93; The identity information for the user.
#' @param UserId &#91;required&#93; The identifier of the user account.
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#'
#' @keywords internal
#'
#' @rdname connect_update_user_identity_info
connect_update_user_identity_info <- function(IdentityInfo, UserId, InstanceId) {
  op <- new_operation(
    name = "UpdateUserIdentityInfo",
    http_method = "POST",
    http_path = "/users/{InstanceId}/{UserId}/identity-info",
    paginator = list()
  )
  input <- .connect$update_user_identity_info_input(IdentityInfo = IdentityInfo, UserId = UserId, InstanceId = InstanceId)
  output <- .connect$update_user_identity_info_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$update_user_identity_info <- connect_update_user_identity_info

#' Updates the phone configuration settings for the specified user
#'
#' @description
#' Updates the phone configuration settings for the specified user.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_update_user_phone_config/](https://www.paws-r-sdk.com/docs/connect_update_user_phone_config/) for full documentation.
#'
#' @param PhoneConfig &#91;required&#93; Information about phone configuration settings for the user.
#' @param UserId &#91;required&#93; The identifier of the user account.
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#'
#' @keywords internal
#'
#' @rdname connect_update_user_phone_config
connect_update_user_phone_config <- function(PhoneConfig, UserId, InstanceId) {
  op <- new_operation(
    name = "UpdateUserPhoneConfig",
    http_method = "POST",
    http_path = "/users/{InstanceId}/{UserId}/phone-config",
    paginator = list()
  )
  input <- .connect$update_user_phone_config_input(PhoneConfig = PhoneConfig, UserId = UserId, InstanceId = InstanceId)
  output <- .connect$update_user_phone_config_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$update_user_phone_config <- connect_update_user_phone_config

#' Updates the properties associated with the proficiencies of a user
#'
#' @description
#' Updates the properties associated with the proficiencies of a user.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_update_user_proficiencies/](https://www.paws-r-sdk.com/docs/connect_update_user_proficiencies/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can find the instance
#' ID in the Amazon Resource Name (ARN) of the instance.
#' @param UserId &#91;required&#93; The identifier of the user account.
#' @param UserProficiencies &#91;required&#93; The proficiencies to be updated for the user. Proficiencies must first
#' be associated to the user. You can do this using
#' AssociateUserProficiencies API.
#'
#' @keywords internal
#'
#' @rdname connect_update_user_proficiencies
connect_update_user_proficiencies <- function(InstanceId, UserId, UserProficiencies) {
  op <- new_operation(
    name = "UpdateUserProficiencies",
    http_method = "POST",
    http_path = "/users/{InstanceId}/{UserId}/proficiencies",
    paginator = list()
  )
  input <- .connect$update_user_proficiencies_input(InstanceId = InstanceId, UserId = UserId, UserProficiencies = UserProficiencies)
  output <- .connect$update_user_proficiencies_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$update_user_proficiencies <- connect_update_user_proficiencies

#' Assigns the specified routing profile to the specified user
#'
#' @description
#' Assigns the specified routing profile to the specified user.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_update_user_routing_profile/](https://www.paws-r-sdk.com/docs/connect_update_user_routing_profile/) for full documentation.
#'
#' @param RoutingProfileId &#91;required&#93; The identifier of the routing profile for the user.
#' @param UserId &#91;required&#93; The identifier of the user account.
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#'
#' @keywords internal
#'
#' @rdname connect_update_user_routing_profile
connect_update_user_routing_profile <- function(RoutingProfileId, UserId, InstanceId) {
  op <- new_operation(
    name = "UpdateUserRoutingProfile",
    http_method = "POST",
    http_path = "/users/{InstanceId}/{UserId}/routing-profile",
    paginator = list()
  )
  input <- .connect$update_user_routing_profile_input(RoutingProfileId = RoutingProfileId, UserId = UserId, InstanceId = InstanceId)
  output <- .connect$update_user_routing_profile_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$update_user_routing_profile <- connect_update_user_routing_profile

#' Assigns the specified security profiles to the specified user
#'
#' @description
#' Assigns the specified security profiles to the specified user.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_update_user_security_profiles/](https://www.paws-r-sdk.com/docs/connect_update_user_security_profiles/) for full documentation.
#'
#' @param SecurityProfileIds &#91;required&#93; The identifiers of the security profiles for the user.
#' @param UserId &#91;required&#93; The identifier of the user account.
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can [find the
#' instance
#' ID](https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
#' in the Amazon Resource Name (ARN) of the instance.
#'
#' @keywords internal
#'
#' @rdname connect_update_user_security_profiles
connect_update_user_security_profiles <- function(SecurityProfileIds, UserId, InstanceId) {
  op <- new_operation(
    name = "UpdateUserSecurityProfiles",
    http_method = "POST",
    http_path = "/users/{InstanceId}/{UserId}/security-profiles",
    paginator = list()
  )
  input <- .connect$update_user_security_profiles_input(SecurityProfileIds = SecurityProfileIds, UserId = UserId, InstanceId = InstanceId)
  output <- .connect$update_user_security_profiles_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$update_user_security_profiles <- connect_update_user_security_profiles

#' Updates the view content of the given view identifier in the specified
#' Amazon Connect instance
#'
#' @description
#' Updates the view content of the given view identifier in the specified Amazon Connect instance.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_update_view_content/](https://www.paws-r-sdk.com/docs/connect_update_view_content/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can find the
#' instanceId in the ARN of the instance.
#' @param ViewId &#91;required&#93; The identifier of the view. Both `ViewArn` and `ViewId` can be used.
#' @param Status &#91;required&#93; Indicates the view status as either `SAVED` or `PUBLISHED`. The
#' `PUBLISHED` status will initiate validation on the content.
#' @param Content &#91;required&#93; View content containing all content necessary to render a view except
#' for runtime input data and the runtime input schema, which is
#' auto-generated by this operation.
#' 
#' The total uncompressed content has a maximum file size of 400kB.
#'
#' @keywords internal
#'
#' @rdname connect_update_view_content
connect_update_view_content <- function(InstanceId, ViewId, Status, Content) {
  op <- new_operation(
    name = "UpdateViewContent",
    http_method = "POST",
    http_path = "/views/{InstanceId}/{ViewId}",
    paginator = list()
  )
  input <- .connect$update_view_content_input(InstanceId = InstanceId, ViewId = ViewId, Status = Status, Content = Content)
  output <- .connect$update_view_content_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$update_view_content <- connect_update_view_content

#' Updates the view metadata
#'
#' @description
#' Updates the view metadata. Note that either `Name` or `Description` must be provided.
#'
#' See [https://www.paws-r-sdk.com/docs/connect_update_view_metadata/](https://www.paws-r-sdk.com/docs/connect_update_view_metadata/) for full documentation.
#'
#' @param InstanceId &#91;required&#93; The identifier of the Amazon Connect instance. You can find the
#' instanceId in the ARN of the instance.
#' @param ViewId &#91;required&#93; The identifier of the view. Both `ViewArn` and `ViewId` can be used.
#' @param Name The name of the view.
#' @param Description The description of the view.
#'
#' @keywords internal
#'
#' @rdname connect_update_view_metadata
connect_update_view_metadata <- function(InstanceId, ViewId, Name = NULL, Description = NULL) {
  op <- new_operation(
    name = "UpdateViewMetadata",
    http_method = "POST",
    http_path = "/views/{InstanceId}/{ViewId}/metadata",
    paginator = list()
  )
  input <- .connect$update_view_metadata_input(InstanceId = InstanceId, ViewId = ViewId, Name = Name, Description = Description)
  output <- .connect$update_view_metadata_output()
  config <- get_config()
  svc <- .connect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connect$operations$update_view_metadata <- connect_update_view_metadata
