% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ses_operations.R
\name{ses_reorder_receipt_rule_set}
\alias{ses_reorder_receipt_rule_set}
\title{Reorders the receipt rules within a receipt rule set}
\usage{
ses_reorder_receipt_rule_set(RuleSetName, RuleNames)
}
\arguments{
\item{RuleSetName}{[required] The name of the receipt rule set to reorder.}

\item{RuleNames}{[required] A list of the specified receipt rule set\'s receipt rules in the order
that you want to put them.}
}
\description{
Reorders the receipt rules within a receipt rule set.
}
\details{
All of the rules in the rule set must be represented in this request.
That is, this API will return an error if the reorder request doesn\'t
explicitly position all of the rules.

For information about managing receipt rule sets, see the \href{https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rule-sets.html}{Amazon SES Developer Guide}.

You can execute this operation no more than once per second.
}
\section{Request syntax}{
\preformatted{svc$reorder_receipt_rule_set(
  RuleSetName = "string",
  RuleNames = list(
    "string"
  )
)
}
}

\examples{
\dontrun{
# The following example reorders the receipt rules within a receipt rule
# set:
svc$reorder_receipt_rule_set(
  RuleNames = list(
    "MyRule",
    "MyOtherRule"
  ),
  RuleSetName = "MyRuleSet"
)
}

}
\keyword{internal}
