% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ses_operations.R
\name{ses_describe_configuration_set}
\alias{ses_describe_configuration_set}
\title{Returns the details of the specified configuration set}
\usage{
ses_describe_configuration_set(ConfigurationSetName,
  ConfigurationSetAttributeNames)
}
\arguments{
\item{ConfigurationSetName}{[required] The name of the configuration set to describe.}

\item{ConfigurationSetAttributeNames}{A list of configuration set attributes to return.}
}
\description{
Returns the details of the specified configuration set. For information
about using configuration sets, see the \href{https://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html}{Amazon SES Developer Guide}.

You can execute this operation no more than once per second.
}
\section{Request syntax}{
\preformatted{svc$describe_configuration_set(
  ConfigurationSetName = "string",
  ConfigurationSetAttributeNames = list(
    "eventDestinations"|"trackingOptions"|"deliveryOptions"|"reputationOptions"
  )
)
}
}

\keyword{internal}
