% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_reserved_instances_modifications}
\alias{ec2_describe_reserved_instances_modifications}
\title{Describes the modifications made to your Reserved Instances}
\usage{
ec2_describe_reserved_instances_modifications(
  Filters = NULL,
  ReservedInstancesModificationIds = NULL,
  NextToken = NULL
)
}
\arguments{
\item{Filters}{One or more filters.
\itemize{
\item \code{client-token} - The idempotency token for the modification request.
\item \code{create-date} - The time when the modification request was created.
\item \code{effective-date} - The time when the modification becomes effective.
\item \code{modification-result.reserved-instances-id} - The ID for the
Reserved Instances created as part of the modification request. This
ID is only available when the status of the modification is
\code{fulfilled}.
\item \code{modification-result.target-configuration.availability-zone} - The
Availability Zone for the new Reserved Instances.
\item \code{modification-result.target-configuration.instance-count } - The
number of new Reserved Instances.
\item \code{modification-result.target-configuration.instance-type} - The
instance type of the new Reserved Instances.
\item \code{reserved-instances-id} - The ID of the Reserved Instances modified.
\item \code{reserved-instances-modification-id} - The ID of the modification
request.
\item \code{status} - The status of the Reserved Instances modification request
(\code{processing} | \code{fulfilled} | \code{failed}).
\item \code{status-message} - The reason for the status.
\item \code{update-date} - The time when the modification request was last
updated.
}}

\item{ReservedInstancesModificationIds}{IDs for the submitted modification request.}

\item{NextToken}{The token to retrieve the next page of results.}
}
\description{
Describes the modifications made to your Reserved Instances. If no parameter is specified, information about all your Reserved Instances modification requests is returned. If a modification ID is specified, only information about the specific modification is returned.

See \url{https://www.paws-r-sdk.com/docs/ec2_describe_reserved_instances_modifications/} for full documentation.
}
\keyword{internal}
