# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include ecs_service.R
NULL

#' Creates a new capacity provider
#'
#' @description
#' Creates a new capacity provider. Capacity providers are associated with an Amazon ECS cluster and are used in capacity provider strategies to facilitate cluster auto scaling.
#'
#' See [https://paws-r.github.io/docs/ecs/create_capacity_provider.html](https://paws-r.github.io/docs/ecs/create_capacity_provider.html) for full documentation.
#'
#' @param name &#91;required&#93; The name of the capacity provider. Up to 255 characters are allowed.
#' They include letters (both upper and lowercase letters), numbers,
#' underscores (_), and hyphens (-). The name can't be prefixed with
#' "`aws`", "`ecs`", or "`fargate`".
#' @param autoScalingGroupProvider &#91;required&#93; The details of the Auto Scaling group for the capacity provider.
#' @param tags The metadata that you apply to the capacity provider to categorize and
#' organize them more conveniently. Each tag consists of a key and an
#' optional value. You define both of them.
#' 
#' The following basic restrictions apply to tags:
#' 
#' -   Maximum number of tags per resource - 50
#' 
#' -   For each resource, each tag key must be unique, and each tag key can
#'     have only one value.
#' 
#' -   Maximum key length - 128 Unicode characters in UTF-8
#' 
#' -   Maximum value length - 256 Unicode characters in UTF-8
#' 
#' -   If your tagging schema is used across multiple services and
#'     resources, remember that other services may have restrictions on
#'     allowed characters. Generally allowed characters are: letters,
#'     numbers, and spaces representable in UTF-8, and the following
#'     characters: + - = . _ : / @@.
#' 
#' -   Tag keys and values are case-sensitive.
#' 
#' -   Do not use `aws:`, `AWS:`, or any upper or lowercase combination of
#'     such as a prefix for either keys or values as it is reserved for
#'     Amazon Web Services use. You cannot edit or delete tag keys or
#'     values with this prefix. Tags with this prefix do not count against
#'     your tags per resource limit.
#'
#' @keywords internal
#'
#' @rdname ecs_create_capacity_provider
ecs_create_capacity_provider <- function(name, autoScalingGroupProvider, tags = NULL) {
  op <- new_operation(
    name = "CreateCapacityProvider",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecs$create_capacity_provider_input(name = name, autoScalingGroupProvider = autoScalingGroupProvider, tags = tags)
  output <- .ecs$create_capacity_provider_output()
  config <- get_config()
  svc <- .ecs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecs$operations$create_capacity_provider <- ecs_create_capacity_provider

#' Creates a new Amazon ECS cluster
#'
#' @description
#' Creates a new Amazon ECS cluster. By default, your account receives a `default` cluster when you launch your first container instance. However, you can create your own cluster with a unique name with the [`create_cluster`][ecs_create_cluster] action.
#'
#' See [https://paws-r.github.io/docs/ecs/create_cluster.html](https://paws-r.github.io/docs/ecs/create_cluster.html) for full documentation.
#'
#' @param clusterName The name of your cluster. If you don't specify a name for your cluster,
#' you create a cluster that's named `default`. Up to 255 letters
#' (uppercase and lowercase), numbers, underscores, and hyphens are
#' allowed.
#' @param tags The metadata that you apply to the cluster to help you categorize and
#' organize them. Each tag consists of a key and an optional value. You
#' define both.
#' 
#' The following basic restrictions apply to tags:
#' 
#' -   Maximum number of tags per resource - 50
#' 
#' -   For each resource, each tag key must be unique, and each tag key can
#'     have only one value.
#' 
#' -   Maximum key length - 128 Unicode characters in UTF-8
#' 
#' -   Maximum value length - 256 Unicode characters in UTF-8
#' 
#' -   If your tagging schema is used across multiple services and
#'     resources, remember that other services may have restrictions on
#'     allowed characters. Generally allowed characters are: letters,
#'     numbers, and spaces representable in UTF-8, and the following
#'     characters: + - = . _ : / @@.
#' 
#' -   Tag keys and values are case-sensitive.
#' 
#' -   Do not use `aws:`, `AWS:`, or any upper or lowercase combination of
#'     such as a prefix for either keys or values as it is reserved for
#'     Amazon Web Services use. You cannot edit or delete tag keys or
#'     values with this prefix. Tags with this prefix do not count against
#'     your tags per resource limit.
#' @param settings The setting to use when creating a cluster. This parameter is used to
#' turn on CloudWatch Container Insights for a cluster. If this value is
#' specified, it overrides the `containerInsights` value set with
#' [`put_account_setting`][ecs_put_account_setting] or
#' [`put_account_setting_default`][ecs_put_account_setting_default].
#' @param configuration The `execute` command configuration for the cluster.
#' @param capacityProviders The short name of one or more capacity providers to associate with the
#' cluster. A capacity provider must be associated with a cluster before it
#' can be included as part of the default capacity provider strategy of the
#' cluster or used in a capacity provider strategy when calling the
#' [`create_service`][ecs_create_service] or [`run_task`][ecs_run_task]
#' actions.
#' 
#' If specifying a capacity provider that uses an Auto Scaling group, the
#' capacity provider must be created but not associated with another
#' cluster. New Auto Scaling group capacity providers can be created with
#' the [`create_capacity_provider`][ecs_create_capacity_provider] API
#' operation.
#' 
#' To use a Fargate capacity provider, specify either the `FARGATE` or
#' `FARGATE_SPOT` capacity providers. The Fargate capacity providers are
#' available to all accounts and only need to be associated with a cluster
#' to be used.
#' 
#' The
#' [`put_cluster_capacity_providers`][ecs_put_cluster_capacity_providers]
#' API operation is used to update the list of available capacity providers
#' for a cluster after the cluster is created.
#' @param defaultCapacityProviderStrategy The capacity provider strategy to set as the default for the cluster.
#' After a default capacity provider strategy is set for a cluster, when
#' you call the [`run_task`][ecs_run_task] or
#' [`create_service`][ecs_create_service] APIs with no capacity provider
#' strategy or launch type specified, the default capacity provider
#' strategy for the cluster is used.
#' 
#' If a default capacity provider strategy isn't defined for a cluster when
#' it was created, it can be defined later with the
#' [`put_cluster_capacity_providers`][ecs_put_cluster_capacity_providers]
#' API operation.
#'
#' @keywords internal
#'
#' @rdname ecs_create_cluster
ecs_create_cluster <- function(clusterName = NULL, tags = NULL, settings = NULL, configuration = NULL, capacityProviders = NULL, defaultCapacityProviderStrategy = NULL) {
  op <- new_operation(
    name = "CreateCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecs$create_cluster_input(clusterName = clusterName, tags = tags, settings = settings, configuration = configuration, capacityProviders = capacityProviders, defaultCapacityProviderStrategy = defaultCapacityProviderStrategy)
  output <- .ecs$create_cluster_output()
  config <- get_config()
  svc <- .ecs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecs$operations$create_cluster <- ecs_create_cluster

#' Runs and maintains your desired number of tasks from a specified task
#' definition
#'
#' @description
#' Runs and maintains your desired number of tasks from a specified task definition. If the number of tasks running in a service drops below the `desiredCount`, Amazon ECS runs another copy of the task in the specified cluster. To update an existing service, see the [`update_service`][ecs_update_service] action.
#'
#' See [https://paws-r.github.io/docs/ecs/create_service.html](https://paws-r.github.io/docs/ecs/create_service.html) for full documentation.
#'
#' @param cluster The short name or full Amazon Resource Name (ARN) of the cluster that
#' you run your service on. If you do not specify a cluster, the default
#' cluster is assumed.
#' @param serviceName &#91;required&#93; The name of your service. Up to 255 letters (uppercase and lowercase),
#' numbers, underscores, and hyphens are allowed. Service names must be
#' unique within a cluster, but you can have similarly named services in
#' multiple clusters within a Region or across multiple Regions.
#' @param taskDefinition The `family` and `revision` (`family:revision`) or full ARN of the task
#' definition to run in your service. If a `revision` isn't specified, the
#' latest `ACTIVE` revision is used.
#' 
#' A task definition must be specified if the service uses either the `ECS`
#' or `CODE_DEPLOY` deployment controllers.
#' @param loadBalancers A load balancer object representing the load balancers to use with your
#' service. For more information, see [Service load
#' balancing](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-load-balancing.html)
#' in the *Amazon Elastic Container Service Developer Guide*.
#' 
#' If the service uses the rolling update (`ECS`) deployment controller and
#' using either an Application Load Balancer or Network Load Balancer, you
#' must specify one or more target group ARNs to attach to the service. The
#' service-linked role is required for services that use multiple target
#' groups. For more information, see [Using service-linked roles for Amazon
#' ECS](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using-service-linked-roles.html)
#' in the *Amazon Elastic Container Service Developer Guide*.
#' 
#' If the service uses the `CODE_DEPLOY` deployment controller, the service
#' is required to use either an Application Load Balancer or Network Load
#' Balancer. When creating an CodeDeploy deployment group, you specify two
#' target groups (referred to as a `targetGroupPair`). During a deployment,
#' CodeDeploy determines which task set in your service has the status
#' `PRIMARY`, and it associates one target group with it. Then, it also
#' associates the other target group with the replacement task set. The
#' load balancer can also have up to two listeners: a required listener for
#' production traffic and an optional listener that you can use to perform
#' validation tests with Lambda functions before routing production traffic
#' to it.
#' 
#' If you use the `CODE_DEPLOY` deployment controller, these values can be
#' changed when updating the service.
#' 
#' For Application Load Balancers and Network Load Balancers, this object
#' must contain the load balancer target group ARN, the container name, and
#' the container port to access from the load balancer. The container name
#' must be as it appears in a container definition. The load balancer name
#' parameter must be omitted. When a task from this service is placed on a
#' container instance, the container instance and port combination is
#' registered as a target in the target group that's specified here.
#' 
#' For Classic Load Balancers, this object must contain the load balancer
#' name, the container name , and the container port to access from the
#' load balancer. The container name must be as it appears in a container
#' definition. The target group ARN parameter must be omitted. When a task
#' from this service is placed on a container instance, the container
#' instance is registered with the load balancer that's specified here.
#' 
#' Services with tasks that use the `awsvpc` network mode (for example,
#' those with the Fargate launch type) only support Application Load
#' Balancers and Network Load Balancers. Classic Load Balancers aren't
#' supported. Also, when you create any target groups for these services,
#' you must choose `ip` as the target type, not `instance`. This is because
#' tasks that use the `awsvpc` network mode are associated with an elastic
#' network interface, not an Amazon EC2 instance.
#' @param serviceRegistries The details of the service discovery registry to associate with this
#' service. For more information, see [Service
#' discovery](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html).
#' 
#' Each service may be associated with one service registry. Multiple
#' service registries for each service isn't supported.
#' @param desiredCount The number of instantiations of the specified task definition to place
#' and keep running on your cluster.
#' 
#' This is required if `schedulingStrategy` is `REPLICA` or isn't
#' specified. If `schedulingStrategy` is `DAEMON` then this isn't required.
#' @param clientToken An identifier that you provide to ensure the idempotency of the request.
#' It must be unique and is case sensitive. Up to 32 ASCII characters are
#' allowed.
#' @param launchType The infrastructure that you run your service on. For more information,
#' see [Amazon ECS launch
#' types](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html)
#' in the *Amazon Elastic Container Service Developer Guide*.
#' 
#' The `FARGATE` launch type runs your tasks on Fargate On-Demand
#' infrastructure.
#' 
#' Fargate Spot infrastructure is available for use but a capacity provider
#' strategy must be used. For more information, see [Fargate capacity
#' providers](https://docs.aws.amazon.com/AmazonECS/latest/userguide/fargate-capacity-providers.html)
#' in the *Amazon ECS User Guide for Fargate*.
#' 
#' The `EC2` launch type runs your tasks on Amazon EC2 instances registered
#' to your cluster.
#' 
#' The `EXTERNAL` launch type runs your tasks on your on-premises server or
#' virtual machine (VM) capacity registered to your cluster.
#' 
#' A service can use either a launch type or a capacity provider strategy.
#' If a `launchType` is specified, the `capacityProviderStrategy` parameter
#' must be omitted.
#' @param capacityProviderStrategy The capacity provider strategy to use for the service.
#' 
#' If a `capacityProviderStrategy` is specified, the `launchType` parameter
#' must be omitted. If no `capacityProviderStrategy` or `launchType` is
#' specified, the `defaultCapacityProviderStrategy` for the cluster is
#' used.
#' 
#' A capacity provider strategy may contain a maximum of 6 capacity
#' providers.
#' @param platformVersion The platform version that your tasks in the service are running on. A
#' platform version is specified only for tasks using the Fargate launch
#' type. If one isn't specified, the `LATEST` platform version is used. For
#' more information, see [Fargate platform
#' versions](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html)
#' in the *Amazon Elastic Container Service Developer Guide*.
#' @param role The name or full Amazon Resource Name (ARN) of the IAM role that allows
#' Amazon ECS to make calls to your load balancer on your behalf. This
#' parameter is only permitted if you are using a load balancer with your
#' service and your task definition doesn't use the `awsvpc` network mode.
#' If you specify the `role` parameter, you must also specify a load
#' balancer object with the `loadBalancers` parameter.
#' 
#' If your account has already created the Amazon ECS service-linked role,
#' that role is used for your service unless you specify a role here. The
#' service-linked role is required if your task definition uses the
#' `awsvpc` network mode or if the service is configured to use service
#' discovery, an external deployment controller, multiple target groups, or
#' Elastic Inference accelerators in which case you don't specify a role
#' here. For more information, see [Using service-linked roles for Amazon
#' ECS](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using-service-linked-roles.html)
#' in the *Amazon Elastic Container Service Developer Guide*.
#' 
#' If your specified role has a path other than `/`, then you must either
#' specify the full role ARN (this is recommended) or prefix the role name
#' with the path. For example, if a role with the name `bar` has a path of
#' `/foo/` then you would specify `/foo/bar` as the role name. For more
#' information, see [Friendly names and
#' paths](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-friendly-names)
#' in the *IAM User Guide*.
#' @param deploymentConfiguration Optional deployment parameters that control how many tasks run during
#' the deployment and the ordering of stopping and starting tasks.
#' @param placementConstraints An array of placement constraint objects to use for tasks in your
#' service. You can specify a maximum of 10 constraints for each task. This
#' limit includes constraints in the task definition and those specified at
#' runtime.
#' @param placementStrategy The placement strategy objects to use for tasks in your service. You can
#' specify a maximum of 5 strategy rules for each service.
#' @param networkConfiguration The network configuration for the service. This parameter is required
#' for task definitions that use the `awsvpc` network mode to receive their
#' own elastic network interface, and it isn't supported for other network
#' modes. For more information, see [Task
#' networking](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html)
#' in the *Amazon Elastic Container Service Developer Guide*.
#' @param healthCheckGracePeriodSeconds The period of time, in seconds, that the Amazon ECS service scheduler
#' ignores unhealthy Elastic Load Balancing target health checks after a
#' task has first started. This is only used when your service is
#' configured to use a load balancer. If your service has a load balancer
#' defined and you don't specify a health check grace period value, the
#' default value of `0` is used.
#' 
#' If you do not use an Elastic Load Balancing, we recomend that you use
#' the `startPeriod` in the task definition healtch check parameters. For
#' more information, see [Health
#' check](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_HealthCheck.html).
#' 
#' If your service's tasks take a while to start and respond to Elastic
#' Load Balancing health checks, you can specify a health check grace
#' period of up to 2,147,483,647 seconds (about 69 years). During that
#' time, the Amazon ECS service scheduler ignores health check status. This
#' grace period can prevent the service scheduler from marking tasks as
#' unhealthy and stopping them before they have time to come up.
#' @param schedulingStrategy The scheduling strategy to use for the service. For more information,
#' see
#' [Services](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html).
#' 
#' There are two service scheduler strategies available:
#' 
#' -   `REPLICA`-The replica scheduling strategy places and maintains the
#'     desired number of tasks across your cluster. By default, the service
#'     scheduler spreads tasks across Availability Zones. You can use task
#'     placement strategies and constraints to customize task placement
#'     decisions. This scheduler strategy is required if the service uses
#'     the `CODE_DEPLOY` or `EXTERNAL` deployment controller types.
#' 
#' -   `DAEMON`-The daemon scheduling strategy deploys exactly one task on
#'     each active container instance that meets all of the task placement
#'     constraints that you specify in your cluster. The service scheduler
#'     also evaluates the task placement constraints for running tasks and
#'     will stop tasks that don't meet the placement constraints. When
#'     you're using this strategy, you don't need to specify a desired
#'     number of tasks, a task placement strategy, or use Service Auto
#'     Scaling policies.
#' 
#'     Tasks using the Fargate launch type or the `CODE_DEPLOY` or
#'     `EXTERNAL` deployment controller types don't support the `DAEMON`
#'     scheduling strategy.
#' @param deploymentController The deployment controller to use for the service. If no deployment
#' controller is specified, the default value of `ECS` is used.
#' @param tags The metadata that you apply to the service to help you categorize and
#' organize them. Each tag consists of a key and an optional value, both of
#' which you define. When a service is deleted, the tags are deleted as
#' well.
#' 
#' The following basic restrictions apply to tags:
#' 
#' -   Maximum number of tags per resource - 50
#' 
#' -   For each resource, each tag key must be unique, and each tag key can
#'     have only one value.
#' 
#' -   Maximum key length - 128 Unicode characters in UTF-8
#' 
#' -   Maximum value length - 256 Unicode characters in UTF-8
#' 
#' -   If your tagging schema is used across multiple services and
#'     resources, remember that other services may have restrictions on
#'     allowed characters. Generally allowed characters are: letters,
#'     numbers, and spaces representable in UTF-8, and the following
#'     characters: + - = . _ : / @@.
#' 
#' -   Tag keys and values are case-sensitive.
#' 
#' -   Do not use `aws:`, `AWS:`, or any upper or lowercase combination of
#'     such as a prefix for either keys or values as it is reserved for
#'     Amazon Web Services use. You cannot edit or delete tag keys or
#'     values with this prefix. Tags with this prefix do not count against
#'     your tags per resource limit.
#' @param enableECSManagedTags Specifies whether to turn on Amazon ECS managed tags for the tasks
#' within the service. For more information, see [Tagging your Amazon ECS
#' resources](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html)
#' in the *Amazon Elastic Container Service Developer Guide*.
#' @param propagateTags Specifies whether to propagate the tags from the task definition to the
#' task. If no value is specified, the tags aren't propagated. Tags can
#' only be propagated to the task during task creation. To add tags to a
#' task after task creation, use the [`tag_resource`][ecs_tag_resource] API
#' action.
#' @param enableExecuteCommand Determines whether the execute command functionality is enabled for the
#' service. If `true`, this enables execute command functionality on all
#' containers in the service tasks.
#'
#' @keywords internal
#'
#' @rdname ecs_create_service
ecs_create_service <- function(cluster = NULL, serviceName, taskDefinition = NULL, loadBalancers = NULL, serviceRegistries = NULL, desiredCount = NULL, clientToken = NULL, launchType = NULL, capacityProviderStrategy = NULL, platformVersion = NULL, role = NULL, deploymentConfiguration = NULL, placementConstraints = NULL, placementStrategy = NULL, networkConfiguration = NULL, healthCheckGracePeriodSeconds = NULL, schedulingStrategy = NULL, deploymentController = NULL, tags = NULL, enableECSManagedTags = NULL, propagateTags = NULL, enableExecuteCommand = NULL) {
  op <- new_operation(
    name = "CreateService",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecs$create_service_input(cluster = cluster, serviceName = serviceName, taskDefinition = taskDefinition, loadBalancers = loadBalancers, serviceRegistries = serviceRegistries, desiredCount = desiredCount, clientToken = clientToken, launchType = launchType, capacityProviderStrategy = capacityProviderStrategy, platformVersion = platformVersion, role = role, deploymentConfiguration = deploymentConfiguration, placementConstraints = placementConstraints, placementStrategy = placementStrategy, networkConfiguration = networkConfiguration, healthCheckGracePeriodSeconds = healthCheckGracePeriodSeconds, schedulingStrategy = schedulingStrategy, deploymentController = deploymentController, tags = tags, enableECSManagedTags = enableECSManagedTags, propagateTags = propagateTags, enableExecuteCommand = enableExecuteCommand)
  output <- .ecs$create_service_output()
  config <- get_config()
  svc <- .ecs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecs$operations$create_service <- ecs_create_service

#' Create a task set in the specified cluster and service
#'
#' @description
#' Create a task set in the specified cluster and service. This is used when a service uses the `EXTERNAL` deployment controller type. For more information, see [Amazon ECS deployment types](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html) in the *Amazon Elastic Container Service Developer Guide*.
#'
#' See [https://paws-r.github.io/docs/ecs/create_task_set.html](https://paws-r.github.io/docs/ecs/create_task_set.html) for full documentation.
#'
#' @param service &#91;required&#93; The short name or full Amazon Resource Name (ARN) of the service to
#' create the task set in.
#' @param cluster &#91;required&#93; The short name or full Amazon Resource Name (ARN) of the cluster that
#' hosts the service to create the task set in.
#' @param externalId An optional non-unique tag that identifies this task set in external
#' systems. If the task set is associated with a service discovery
#' registry, the tasks in this task set will have the
#' `ECS_TASK_SET_EXTERNAL_ID` Cloud Map attribute set to the provided
#' value.
#' @param taskDefinition &#91;required&#93; The task definition for the tasks in the task set to use.
#' @param networkConfiguration An object representing the network configuration for a task set.
#' @param loadBalancers A load balancer object representing the load balancer to use with the
#' task set. The supported load balancer types are either an Application
#' Load Balancer or a Network Load Balancer.
#' @param serviceRegistries The details of the service discovery registries to assign to this task
#' set. For more information, see [Service
#' discovery](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html).
#' @param launchType The launch type that new tasks in the task set uses. For more
#' information, see [Amazon ECS launch
#' types](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html)
#' in the *Amazon Elastic Container Service Developer Guide*.
#' 
#' If a `launchType` is specified, the `capacityProviderStrategy` parameter
#' must be omitted.
#' @param capacityProviderStrategy The capacity provider strategy to use for the task set.
#' 
#' A capacity provider strategy consists of one or more capacity providers
#' along with the `base` and `weight` to assign to them. A capacity
#' provider must be associated with the cluster to be used in a capacity
#' provider strategy. The
#' [`put_cluster_capacity_providers`][ecs_put_cluster_capacity_providers]
#' API is used to associate a capacity provider with a cluster. Only
#' capacity providers with an `ACTIVE` or `UPDATING` status can be used.
#' 
#' If a `capacityProviderStrategy` is specified, the `launchType` parameter
#' must be omitted. If no `capacityProviderStrategy` or `launchType` is
#' specified, the `defaultCapacityProviderStrategy` for the cluster is
#' used.
#' 
#' If specifying a capacity provider that uses an Auto Scaling group, the
#' capacity provider must already be created. New capacity providers can be
#' created with the
#' [`create_capacity_provider`][ecs_create_capacity_provider] API
#' operation.
#' 
#' To use a Fargate capacity provider, specify either the `FARGATE` or
#' `FARGATE_SPOT` capacity providers. The Fargate capacity providers are
#' available to all accounts and only need to be associated with a cluster
#' to be used.
#' 
#' The
#' [`put_cluster_capacity_providers`][ecs_put_cluster_capacity_providers]
#' API operation is used to update the list of available capacity providers
#' for a cluster after the cluster is created.
#' @param platformVersion The platform version that the tasks in the task set uses. A platform
#' version is specified only for tasks using the Fargate launch type. If
#' one isn't specified, the `LATEST` platform version is used.
#' @param scale A floating-point percentage of the desired number of tasks to place and
#' keep running in the task set.
#' @param clientToken The identifier that you provide to ensure the idempotency of the
#' request. It's case sensitive and must be unique. It can be up to 32
#' ASCII characters are allowed.
#' @param tags The metadata that you apply to the task set to help you categorize and
#' organize them. Each tag consists of a key and an optional value. You
#' define both. When a service is deleted, the tags are deleted.
#' 
#' The following basic restrictions apply to tags:
#' 
#' -   Maximum number of tags per resource - 50
#' 
#' -   For each resource, each tag key must be unique, and each tag key can
#'     have only one value.
#' 
#' -   Maximum key length - 128 Unicode characters in UTF-8
#' 
#' -   Maximum value length - 256 Unicode characters in UTF-8
#' 
#' -   If your tagging schema is used across multiple services and
#'     resources, remember that other services may have restrictions on
#'     allowed characters. Generally allowed characters are: letters,
#'     numbers, and spaces representable in UTF-8, and the following
#'     characters: + - = . _ : / @@.
#' 
#' -   Tag keys and values are case-sensitive.
#' 
#' -   Do not use `aws:`, `AWS:`, or any upper or lowercase combination of
#'     such as a prefix for either keys or values as it is reserved for
#'     Amazon Web Services use. You cannot edit or delete tag keys or
#'     values with this prefix. Tags with this prefix do not count against
#'     your tags per resource limit.
#'
#' @keywords internal
#'
#' @rdname ecs_create_task_set
ecs_create_task_set <- function(service, cluster, externalId = NULL, taskDefinition, networkConfiguration = NULL, loadBalancers = NULL, serviceRegistries = NULL, launchType = NULL, capacityProviderStrategy = NULL, platformVersion = NULL, scale = NULL, clientToken = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateTaskSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecs$create_task_set_input(service = service, cluster = cluster, externalId = externalId, taskDefinition = taskDefinition, networkConfiguration = networkConfiguration, loadBalancers = loadBalancers, serviceRegistries = serviceRegistries, launchType = launchType, capacityProviderStrategy = capacityProviderStrategy, platformVersion = platformVersion, scale = scale, clientToken = clientToken, tags = tags)
  output <- .ecs$create_task_set_output()
  config <- get_config()
  svc <- .ecs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecs$operations$create_task_set <- ecs_create_task_set

#' Disables an account setting for a specified IAM user, IAM role, or the
#' root user for an account
#'
#' @description
#' Disables an account setting for a specified IAM user, IAM role, or the root user for an account.
#'
#' See [https://paws-r.github.io/docs/ecs/delete_account_setting.html](https://paws-r.github.io/docs/ecs/delete_account_setting.html) for full documentation.
#'
#' @param name &#91;required&#93; The resource name to disable the account setting for. If
#' `serviceLongArnFormat` is specified, the ARN for your Amazon ECS
#' services is affected. If `taskLongArnFormat` is specified, the ARN and
#' resource ID for your Amazon ECS tasks is affected. If
#' `containerInstanceLongArnFormat` is specified, the ARN and resource ID
#' for your Amazon ECS container instances is affected. If `awsvpcTrunking`
#' is specified, the ENI limit for your Amazon ECS container instances is
#' affected.
#' @param principalArn The Amazon Resource Name (ARN) of the principal. It can be an IAM user,
#' IAM role, or the root user. If you specify the root user, it disables
#' the account setting for all IAM users, IAM roles, and the root user of
#' the account unless an IAM user or role explicitly overrides these
#' settings. If this field is omitted, the setting is changed only for the
#' authenticated user.
#'
#' @keywords internal
#'
#' @rdname ecs_delete_account_setting
ecs_delete_account_setting <- function(name, principalArn = NULL) {
  op <- new_operation(
    name = "DeleteAccountSetting",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecs$delete_account_setting_input(name = name, principalArn = principalArn)
  output <- .ecs$delete_account_setting_output()
  config <- get_config()
  svc <- .ecs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecs$operations$delete_account_setting <- ecs_delete_account_setting

#' Deletes one or more custom attributes from an Amazon ECS resource
#'
#' @description
#' Deletes one or more custom attributes from an Amazon ECS resource.
#'
#' See [https://paws-r.github.io/docs/ecs/delete_attributes.html](https://paws-r.github.io/docs/ecs/delete_attributes.html) for full documentation.
#'
#' @param cluster The short name or full Amazon Resource Name (ARN) of the cluster that
#' contains the resource to delete attributes. If you do not specify a
#' cluster, the default cluster is assumed.
#' @param attributes &#91;required&#93; The attributes to delete from your resource. You can specify up to 10
#' attributes for each request. For custom attributes, specify the
#' attribute name and target ID, but don't specify the value. If you
#' specify the target ID using the short form, you must also specify the
#' target type.
#'
#' @keywords internal
#'
#' @rdname ecs_delete_attributes
ecs_delete_attributes <- function(cluster = NULL, attributes) {
  op <- new_operation(
    name = "DeleteAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecs$delete_attributes_input(cluster = cluster, attributes = attributes)
  output <- .ecs$delete_attributes_output()
  config <- get_config()
  svc <- .ecs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecs$operations$delete_attributes <- ecs_delete_attributes

#' Deletes the specified capacity provider
#'
#' @description
#' Deletes the specified capacity provider.
#'
#' See [https://paws-r.github.io/docs/ecs/delete_capacity_provider.html](https://paws-r.github.io/docs/ecs/delete_capacity_provider.html) for full documentation.
#'
#' @param capacityProvider &#91;required&#93; The short name or full Amazon Resource Name (ARN) of the capacity
#' provider to delete.
#'
#' @keywords internal
#'
#' @rdname ecs_delete_capacity_provider
ecs_delete_capacity_provider <- function(capacityProvider) {
  op <- new_operation(
    name = "DeleteCapacityProvider",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecs$delete_capacity_provider_input(capacityProvider = capacityProvider)
  output <- .ecs$delete_capacity_provider_output()
  config <- get_config()
  svc <- .ecs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecs$operations$delete_capacity_provider <- ecs_delete_capacity_provider

#' Deletes the specified cluster
#'
#' @description
#' Deletes the specified cluster. The cluster transitions to the `INACTIVE` state. Clusters with an `INACTIVE` status might remain discoverable in your account for a period of time. However, this behavior is subject to change in the future. We don't recommend that you rely on `INACTIVE` clusters persisting.
#'
#' See [https://paws-r.github.io/docs/ecs/delete_cluster.html](https://paws-r.github.io/docs/ecs/delete_cluster.html) for full documentation.
#'
#' @param cluster &#91;required&#93; The short name or full Amazon Resource Name (ARN) of the cluster to
#' delete.
#'
#' @keywords internal
#'
#' @rdname ecs_delete_cluster
ecs_delete_cluster <- function(cluster) {
  op <- new_operation(
    name = "DeleteCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecs$delete_cluster_input(cluster = cluster)
  output <- .ecs$delete_cluster_output()
  config <- get_config()
  svc <- .ecs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecs$operations$delete_cluster <- ecs_delete_cluster

#' Deletes a specified service within a cluster
#'
#' @description
#' Deletes a specified service within a cluster. You can delete a service if you have no running tasks in it and the desired task count is zero. If the service is actively maintaining tasks, you can't delete it, and you must update the service to a desired task count of zero. For more information, see [`update_service`][ecs_update_service].
#'
#' See [https://paws-r.github.io/docs/ecs/delete_service.html](https://paws-r.github.io/docs/ecs/delete_service.html) for full documentation.
#'
#' @param cluster The short name or full Amazon Resource Name (ARN) of the cluster that
#' hosts the service to delete. If you do not specify a cluster, the
#' default cluster is assumed.
#' @param service &#91;required&#93; The name of the service to delete.
#' @param force If `true`, allows you to delete a service even if it wasn't scaled down
#' to zero tasks. It's only necessary to use this if the service uses the
#' `REPLICA` scheduling strategy.
#'
#' @keywords internal
#'
#' @rdname ecs_delete_service
ecs_delete_service <- function(cluster = NULL, service, force = NULL) {
  op <- new_operation(
    name = "DeleteService",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecs$delete_service_input(cluster = cluster, service = service, force = force)
  output <- .ecs$delete_service_output()
  config <- get_config()
  svc <- .ecs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecs$operations$delete_service <- ecs_delete_service

#' Deletes a specified task set within a service
#'
#' @description
#' Deletes a specified task set within a service. This is used when a service uses the `EXTERNAL` deployment controller type. For more information, see [Amazon ECS deployment types](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html) in the *Amazon Elastic Container Service Developer Guide*.
#'
#' See [https://paws-r.github.io/docs/ecs/delete_task_set.html](https://paws-r.github.io/docs/ecs/delete_task_set.html) for full documentation.
#'
#' @param cluster &#91;required&#93; The short name or full Amazon Resource Name (ARN) of the cluster that
#' hosts the service that the task set found in to delete.
#' @param service &#91;required&#93; The short name or full Amazon Resource Name (ARN) of the service that
#' hosts the task set to delete.
#' @param taskSet &#91;required&#93; The task set ID or full Amazon Resource Name (ARN) of the task set to
#' delete.
#' @param force If `true`, you can delete a task set even if it hasn't been scaled down
#' to zero.
#'
#' @keywords internal
#'
#' @rdname ecs_delete_task_set
ecs_delete_task_set <- function(cluster, service, taskSet, force = NULL) {
  op <- new_operation(
    name = "DeleteTaskSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecs$delete_task_set_input(cluster = cluster, service = service, taskSet = taskSet, force = force)
  output <- .ecs$delete_task_set_output()
  config <- get_config()
  svc <- .ecs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecs$operations$delete_task_set <- ecs_delete_task_set

#' Deregisters an Amazon ECS container instance from the specified cluster
#'
#' @description
#' Deregisters an Amazon ECS container instance from the specified cluster. This instance is no longer available to run tasks.
#'
#' See [https://paws-r.github.io/docs/ecs/deregister_container_instance.html](https://paws-r.github.io/docs/ecs/deregister_container_instance.html) for full documentation.
#'
#' @param cluster The short name or full Amazon Resource Name (ARN) of the cluster that
#' hosts the container instance to deregister. If you do not specify a
#' cluster, the default cluster is assumed.
#' @param containerInstance &#91;required&#93; The container instance ID or full ARN of the container instance to
#' deregister. For more information about the ARN format, see [Amazon
#' Resource Name
#' (ARN)](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-account-settings.html#ecs-resource-ids)
#' in the *Amazon ECS Developer Guide*.
#' @param force Forces the container instance to be deregistered. If you have tasks
#' running on the container instance when you deregister it with the
#' `force` option, these tasks remain running until you terminate the
#' instance or the tasks stop through some other means, but they're
#' orphaned (no longer monitored or accounted for by Amazon ECS). If an
#' orphaned task on your container instance is part of an Amazon ECS
#' service, then the service scheduler starts another copy of that task, on
#' a different container instance if possible.
#' 
#' Any containers in orphaned service tasks that are registered with a
#' Classic Load Balancer or an Application Load Balancer target group are
#' deregistered. They begin connection draining according to the settings
#' on the load balancer or target group.
#'
#' @keywords internal
#'
#' @rdname ecs_deregister_container_instance
ecs_deregister_container_instance <- function(cluster = NULL, containerInstance, force = NULL) {
  op <- new_operation(
    name = "DeregisterContainerInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecs$deregister_container_instance_input(cluster = cluster, containerInstance = containerInstance, force = force)
  output <- .ecs$deregister_container_instance_output()
  config <- get_config()
  svc <- .ecs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecs$operations$deregister_container_instance <- ecs_deregister_container_instance

#' Deregisters the specified task definition by family and revision
#'
#' @description
#' Deregisters the specified task definition by family and revision. Upon deregistration, the task definition is marked as `INACTIVE`. Existing tasks and services that reference an `INACTIVE` task definition continue to run without disruption. Existing services that reference an `INACTIVE` task definition can still scale up or down by modifying the service's desired count.
#'
#' See [https://paws-r.github.io/docs/ecs/deregister_task_definition.html](https://paws-r.github.io/docs/ecs/deregister_task_definition.html) for full documentation.
#'
#' @param taskDefinition &#91;required&#93; The `family` and `revision` (`family:revision`) or full Amazon Resource
#' Name (ARN) of the task definition to deregister. You must specify a
#' `revision`.
#'
#' @keywords internal
#'
#' @rdname ecs_deregister_task_definition
ecs_deregister_task_definition <- function(taskDefinition) {
  op <- new_operation(
    name = "DeregisterTaskDefinition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecs$deregister_task_definition_input(taskDefinition = taskDefinition)
  output <- .ecs$deregister_task_definition_output()
  config <- get_config()
  svc <- .ecs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecs$operations$deregister_task_definition <- ecs_deregister_task_definition

#' Describes one or more of your capacity providers
#'
#' @description
#' Describes one or more of your capacity providers.
#'
#' See [https://paws-r.github.io/docs/ecs/describe_capacity_providers.html](https://paws-r.github.io/docs/ecs/describe_capacity_providers.html) for full documentation.
#'
#' @param capacityProviders The short name or full Amazon Resource Name (ARN) of one or more
#' capacity providers. Up to `100` capacity providers can be described in
#' an action.
#' @param include Specifies whether or not you want to see the resource tags for the
#' capacity provider. If `TAGS` is specified, the tags are included in the
#' response. If this field is omitted, tags aren't included in the
#' response.
#' @param maxResults The maximum number of account setting results returned by
#' [`describe_capacity_providers`][ecs_describe_capacity_providers] in
#' paginated output. When this parameter is used,
#' [`describe_capacity_providers`][ecs_describe_capacity_providers] only
#' returns `maxResults` results in a single page along with a `nextToken`
#' response element. The remaining results of the initial request can be
#' seen by sending another
#' [`describe_capacity_providers`][ecs_describe_capacity_providers] request
#' with the returned `nextToken` value. This value can be between 1 and 10.
#' If this parameter is not used, then
#' [`describe_capacity_providers`][ecs_describe_capacity_providers] returns
#' up to 10 results and a `nextToken` value if applicable.
#' @param nextToken The `nextToken` value returned from a previous paginated
#' [`describe_capacity_providers`][ecs_describe_capacity_providers] request
#' where `maxResults` was used and the results exceeded the value of that
#' parameter. Pagination continues from the end of the previous results
#' that returned the `nextToken` value.
#' 
#' This token should be treated as an opaque identifier that is only used
#' to retrieve the next items in a list and not for other programmatic
#' purposes.
#'
#' @keywords internal
#'
#' @rdname ecs_describe_capacity_providers
ecs_describe_capacity_providers <- function(capacityProviders = NULL, include = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "DescribeCapacityProviders",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecs$describe_capacity_providers_input(capacityProviders = capacityProviders, include = include, maxResults = maxResults, nextToken = nextToken)
  output <- .ecs$describe_capacity_providers_output()
  config <- get_config()
  svc <- .ecs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecs$operations$describe_capacity_providers <- ecs_describe_capacity_providers

#' Describes one or more of your clusters
#'
#' @description
#' Describes one or more of your clusters.
#'
#' See [https://paws-r.github.io/docs/ecs/describe_clusters.html](https://paws-r.github.io/docs/ecs/describe_clusters.html) for full documentation.
#'
#' @param clusters A list of up to 100 cluster names or full cluster Amazon Resource Name
#' (ARN) entries. If you do not specify a cluster, the default cluster is
#' assumed.
#' @param include Determines whether to include additional information about the clusters
#' in the response. If this field is omitted, this information isn't
#' included.
#' 
#' If `ATTACHMENTS` is specified, the attachments for the container
#' instances or tasks within the cluster are included.
#' 
#' If `SETTINGS` is specified, the settings for the cluster are included.
#' 
#' If `CONFIGURATIONS` is specified, the configuration for the cluster is
#' included.
#' 
#' If `STATISTICS` is specified, the task and service count is included,
#' separated by launch type.
#' 
#' If `TAGS` is specified, the metadata tags associated with the cluster
#' are included.
#'
#' @keywords internal
#'
#' @rdname ecs_describe_clusters
ecs_describe_clusters <- function(clusters = NULL, include = NULL) {
  op <- new_operation(
    name = "DescribeClusters",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecs$describe_clusters_input(clusters = clusters, include = include)
  output <- .ecs$describe_clusters_output()
  config <- get_config()
  svc <- .ecs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecs$operations$describe_clusters <- ecs_describe_clusters

#' Describes one or more container instances
#'
#' @description
#' Describes one or more container instances. Returns metadata about each container instance requested.
#'
#' See [https://paws-r.github.io/docs/ecs/describe_container_instances.html](https://paws-r.github.io/docs/ecs/describe_container_instances.html) for full documentation.
#'
#' @param cluster The short name or full Amazon Resource Name (ARN) of the cluster that
#' hosts the container instances to describe. If you do not specify a
#' cluster, the default cluster is assumed. This parameter is required if
#' the container instance or container instances you are describing were
#' launched in any cluster other than the default cluster.
#' @param containerInstances &#91;required&#93; A list of up to 100 container instance IDs or full Amazon Resource Name
#' (ARN) entries.
#' @param include Specifies whether you want to see the resource tags for the container
#' instance. If `TAGS` is specified, the tags are included in the response.
#' If `CONTAINER_INSTANCE_HEALTH` is specified, the container instance
#' health is included in the response. If this field is omitted, tags and
#' container instance health status aren't included in the response.
#'
#' @keywords internal
#'
#' @rdname ecs_describe_container_instances
ecs_describe_container_instances <- function(cluster = NULL, containerInstances, include = NULL) {
  op <- new_operation(
    name = "DescribeContainerInstances",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecs$describe_container_instances_input(cluster = cluster, containerInstances = containerInstances, include = include)
  output <- .ecs$describe_container_instances_output()
  config <- get_config()
  svc <- .ecs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecs$operations$describe_container_instances <- ecs_describe_container_instances

#' Describes the specified services running in your cluster
#'
#' @description
#' Describes the specified services running in your cluster.
#'
#' See [https://paws-r.github.io/docs/ecs/describe_services.html](https://paws-r.github.io/docs/ecs/describe_services.html) for full documentation.
#'
#' @param cluster The short name or full Amazon Resource Name (ARN)the cluster that hosts
#' the service to describe. If you do not specify a cluster, the default
#' cluster is assumed. This parameter is required if the service or
#' services you are describing were launched in any cluster other than the
#' default cluster.
#' @param services &#91;required&#93; A list of services to describe. You may specify up to 10 services to
#' describe in a single operation.
#' @param include Determines whether you want to see the resource tags for the service. If
#' `TAGS` is specified, the tags are included in the response. If this
#' field is omitted, tags aren't included in the response.
#'
#' @keywords internal
#'
#' @rdname ecs_describe_services
ecs_describe_services <- function(cluster = NULL, services, include = NULL) {
  op <- new_operation(
    name = "DescribeServices",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecs$describe_services_input(cluster = cluster, services = services, include = include)
  output <- .ecs$describe_services_output()
  config <- get_config()
  svc <- .ecs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecs$operations$describe_services <- ecs_describe_services

#' Describes a task definition
#'
#' @description
#' Describes a task definition. You can specify a `family` and `revision` to find information about a specific task definition, or you can simply specify the family to find the latest `ACTIVE` revision in that family.
#'
#' See [https://paws-r.github.io/docs/ecs/describe_task_definition.html](https://paws-r.github.io/docs/ecs/describe_task_definition.html) for full documentation.
#'
#' @param taskDefinition &#91;required&#93; The `family` for the latest `ACTIVE` revision, `family` and `revision`
#' (`family:revision`) for a specific revision in the family, or full
#' Amazon Resource Name (ARN) of the task definition to describe.
#' @param include Determines whether to see the resource tags for the task definition. If
#' `TAGS` is specified, the tags are included in the response. If this
#' field is omitted, tags aren't included in the response.
#'
#' @keywords internal
#'
#' @rdname ecs_describe_task_definition
ecs_describe_task_definition <- function(taskDefinition, include = NULL) {
  op <- new_operation(
    name = "DescribeTaskDefinition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecs$describe_task_definition_input(taskDefinition = taskDefinition, include = include)
  output <- .ecs$describe_task_definition_output()
  config <- get_config()
  svc <- .ecs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecs$operations$describe_task_definition <- ecs_describe_task_definition

#' Describes the task sets in the specified cluster and service
#'
#' @description
#' Describes the task sets in the specified cluster and service. This is used when a service uses the `EXTERNAL` deployment controller type. For more information, see [Amazon ECS Deployment Types](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html) in the *Amazon Elastic Container Service Developer Guide*.
#'
#' See [https://paws-r.github.io/docs/ecs/describe_task_sets.html](https://paws-r.github.io/docs/ecs/describe_task_sets.html) for full documentation.
#'
#' @param cluster &#91;required&#93; The short name or full Amazon Resource Name (ARN) of the cluster that
#' hosts the service that the task sets exist in.
#' @param service &#91;required&#93; The short name or full Amazon Resource Name (ARN) of the service that
#' the task sets exist in.
#' @param taskSets The ID or full Amazon Resource Name (ARN) of task sets to describe.
#' @param include Specifies whether to see the resource tags for the task set. If `TAGS`
#' is specified, the tags are included in the response. If this field is
#' omitted, tags aren't included in the response.
#'
#' @keywords internal
#'
#' @rdname ecs_describe_task_sets
ecs_describe_task_sets <- function(cluster, service, taskSets = NULL, include = NULL) {
  op <- new_operation(
    name = "DescribeTaskSets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecs$describe_task_sets_input(cluster = cluster, service = service, taskSets = taskSets, include = include)
  output <- .ecs$describe_task_sets_output()
  config <- get_config()
  svc <- .ecs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecs$operations$describe_task_sets <- ecs_describe_task_sets

#' Describes a specified task or tasks
#'
#' @description
#' Describes a specified task or tasks.
#'
#' See [https://paws-r.github.io/docs/ecs/describe_tasks.html](https://paws-r.github.io/docs/ecs/describe_tasks.html) for full documentation.
#'
#' @param cluster The short name or full Amazon Resource Name (ARN) of the cluster that
#' hosts the task or tasks to describe. If you do not specify a cluster,
#' the default cluster is assumed. This parameter is required if the task
#' or tasks you are describing were launched in any cluster other than the
#' default cluster.
#' @param tasks &#91;required&#93; A list of up to 100 task IDs or full ARN entries.
#' @param include Specifies whether you want to see the resource tags for the task. If
#' `TAGS` is specified, the tags are included in the response. If this
#' field is omitted, tags aren't included in the response.
#'
#' @keywords internal
#'
#' @rdname ecs_describe_tasks
ecs_describe_tasks <- function(cluster = NULL, tasks, include = NULL) {
  op <- new_operation(
    name = "DescribeTasks",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecs$describe_tasks_input(cluster = cluster, tasks = tasks, include = include)
  output <- .ecs$describe_tasks_output()
  config <- get_config()
  svc <- .ecs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecs$operations$describe_tasks <- ecs_describe_tasks

#' This action is only used by the Amazon ECS agent, and it is not intended
#' for use outside of the agent
#'
#' @description
#' This action is only used by the Amazon ECS agent, and it is not intended for use outside of the agent.
#'
#' See [https://paws-r.github.io/docs/ecs/discover_poll_endpoint.html](https://paws-r.github.io/docs/ecs/discover_poll_endpoint.html) for full documentation.
#'
#' @param containerInstance The container instance ID or full ARN of the container instance. For
#' more information about the ARN format, see [Amazon Resource Name
#' (ARN)](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-account-settings.html#ecs-resource-ids)
#' in the *Amazon ECS Developer Guide*.
#' @param cluster The short name or full Amazon Resource Name (ARN) of the cluster that
#' the container instance belongs to.
#'
#' @keywords internal
#'
#' @rdname ecs_discover_poll_endpoint
ecs_discover_poll_endpoint <- function(containerInstance = NULL, cluster = NULL) {
  op <- new_operation(
    name = "DiscoverPollEndpoint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecs$discover_poll_endpoint_input(containerInstance = containerInstance, cluster = cluster)
  output <- .ecs$discover_poll_endpoint_output()
  config <- get_config()
  svc <- .ecs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecs$operations$discover_poll_endpoint <- ecs_discover_poll_endpoint

#' Runs a command remotely on a container within a task
#'
#' @description
#' Runs a command remotely on a container within a task.
#'
#' See [https://paws-r.github.io/docs/ecs/execute_command.html](https://paws-r.github.io/docs/ecs/execute_command.html) for full documentation.
#'
#' @param cluster The Amazon Resource Name (ARN) or short name of the cluster the task is
#' running in. If you do not specify a cluster, the default cluster is
#' assumed.
#' @param container The name of the container to execute the command on. A container name
#' only needs to be specified for tasks containing multiple containers.
#' @param command &#91;required&#93; The command to run on the container.
#' @param interactive &#91;required&#93; Use this flag to run your command in interactive mode.
#' @param task &#91;required&#93; The Amazon Resource Name (ARN) or ID of the task the container is part
#' of.
#'
#' @keywords internal
#'
#' @rdname ecs_execute_command
ecs_execute_command <- function(cluster = NULL, container = NULL, command, interactive, task) {
  op <- new_operation(
    name = "ExecuteCommand",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecs$execute_command_input(cluster = cluster, container = container, command = command, interactive = interactive, task = task)
  output <- .ecs$execute_command_output()
  config <- get_config()
  svc <- .ecs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecs$operations$execute_command <- ecs_execute_command

#' Lists the account settings for a specified principal
#'
#' @description
#' Lists the account settings for a specified principal.
#'
#' See [https://paws-r.github.io/docs/ecs/list_account_settings.html](https://paws-r.github.io/docs/ecs/list_account_settings.html) for full documentation.
#'
#' @param name The name of the account setting you want to list the settings for.
#' @param value The value of the account settings to filter results with. You must also
#' specify an account setting name to use this parameter.
#' @param principalArn The ARN of the principal, which can be an IAM user, IAM role, or the
#' root user. If this field is omitted, the account settings are listed
#' only for the authenticated user.
#' 
#' Federated users assume the account setting of the root user and can't
#' have explicit account settings set for them.
#' @param effectiveSettings Determines whether to return the effective settings. If `true`, the
#' account settings for the root user or the default setting for the
#' `principalArn` are returned. If `false`, the account settings for the
#' `principalArn` are returned if they're set. Otherwise, no account
#' settings are returned.
#' @param nextToken The `nextToken` value returned from a
#' [`list_account_settings`][ecs_list_account_settings] request indicating
#' that more results are available to fulfill the request and further calls
#' will be needed. If `maxResults` was provided, it's possible the number
#' of results to be fewer than `maxResults`.
#' 
#' This token should be treated as an opaque identifier that is only used
#' to retrieve the next items in a list and not for other programmatic
#' purposes.
#' @param maxResults The maximum number of account setting results returned by
#' [`list_account_settings`][ecs_list_account_settings] in paginated
#' output. When this parameter is used,
#' [`list_account_settings`][ecs_list_account_settings] only returns
#' `maxResults` results in a single page along with a `nextToken` response
#' element. The remaining results of the initial request can be seen by
#' sending another [`list_account_settings`][ecs_list_account_settings]
#' request with the returned `nextToken` value. This value can be between 1
#' and 10. If this parameter isn't used, then
#' [`list_account_settings`][ecs_list_account_settings] returns up to 10
#' results and a `nextToken` value if applicable.
#'
#' @keywords internal
#'
#' @rdname ecs_list_account_settings
ecs_list_account_settings <- function(name = NULL, value = NULL, principalArn = NULL, effectiveSettings = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListAccountSettings",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecs$list_account_settings_input(name = name, value = value, principalArn = principalArn, effectiveSettings = effectiveSettings, nextToken = nextToken, maxResults = maxResults)
  output <- .ecs$list_account_settings_output()
  config <- get_config()
  svc <- .ecs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecs$operations$list_account_settings <- ecs_list_account_settings

#' Lists the attributes for Amazon ECS resources within a specified target
#' type and cluster
#'
#' @description
#' Lists the attributes for Amazon ECS resources within a specified target type and cluster. When you specify a target type and cluster, [`list_attributes`][ecs_list_attributes] returns a list of attribute objects, one for each attribute on each resource. You can filter the list of results to a single attribute name to only return results that have that name. You can also filter the results by attribute name and value. You can do this, for example, to see which container instances in a cluster are running a Linux AMI (`ecs.os-type=linux`).
#'
#' See [https://paws-r.github.io/docs/ecs/list_attributes.html](https://paws-r.github.io/docs/ecs/list_attributes.html) for full documentation.
#'
#' @param cluster The short name or full Amazon Resource Name (ARN) of the cluster to list
#' attributes. If you do not specify a cluster, the default cluster is
#' assumed.
#' @param targetType &#91;required&#93; The type of the target to list attributes with.
#' @param attributeName The name of the attribute to filter the results with.
#' @param attributeValue The value of the attribute to filter results with. You must also specify
#' an attribute name to use this parameter.
#' @param nextToken The `nextToken` value returned from a
#' [`list_attributes`][ecs_list_attributes] request indicating that more
#' results are available to fulfill the request and further calls are
#' needed. If `maxResults` was provided, it's possible the number of
#' results to be fewer than `maxResults`.
#' 
#' This token should be treated as an opaque identifier that is only used
#' to retrieve the next items in a list and not for other programmatic
#' purposes.
#' @param maxResults The maximum number of cluster results that
#' [`list_attributes`][ecs_list_attributes] returned in paginated output.
#' When this parameter is used, [`list_attributes`][ecs_list_attributes]
#' only returns `maxResults` results in a single page along with a
#' `nextToken` response element. The remaining results of the initial
#' request can be seen by sending another
#' [`list_attributes`][ecs_list_attributes] request with the returned
#' `nextToken` value. This value can be between 1 and 100. If this
#' parameter isn't used, then [`list_attributes`][ecs_list_attributes]
#' returns up to 100 results and a `nextToken` value if applicable.
#'
#' @keywords internal
#'
#' @rdname ecs_list_attributes
ecs_list_attributes <- function(cluster = NULL, targetType, attributeName = NULL, attributeValue = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecs$list_attributes_input(cluster = cluster, targetType = targetType, attributeName = attributeName, attributeValue = attributeValue, nextToken = nextToken, maxResults = maxResults)
  output <- .ecs$list_attributes_output()
  config <- get_config()
  svc <- .ecs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecs$operations$list_attributes <- ecs_list_attributes

#' Returns a list of existing clusters
#'
#' @description
#' Returns a list of existing clusters.
#'
#' See [https://paws-r.github.io/docs/ecs/list_clusters.html](https://paws-r.github.io/docs/ecs/list_clusters.html) for full documentation.
#'
#' @param nextToken The `nextToken` value returned from a
#' [`list_clusters`][ecs_list_clusters] request indicating that more
#' results are available to fulfill the request and further calls are
#' needed. If `maxResults` was provided, it's possible the number of
#' results to be fewer than `maxResults`.
#' 
#' This token should be treated as an opaque identifier that is only used
#' to retrieve the next items in a list and not for other programmatic
#' purposes.
#' @param maxResults The maximum number of cluster results that
#' [`list_clusters`][ecs_list_clusters] returned in paginated output. When
#' this parameter is used, [`list_clusters`][ecs_list_clusters] only
#' returns `maxResults` results in a single page along with a `nextToken`
#' response element. The remaining results of the initial request can be
#' seen by sending another [`list_clusters`][ecs_list_clusters] request
#' with the returned `nextToken` value. This value can be between 1 and
#' 100. If this parameter isn't used, then
#' [`list_clusters`][ecs_list_clusters] returns up to 100 results and a
#' `nextToken` value if applicable.
#'
#' @keywords internal
#'
#' @rdname ecs_list_clusters
ecs_list_clusters <- function(nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListClusters",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecs$list_clusters_input(nextToken = nextToken, maxResults = maxResults)
  output <- .ecs$list_clusters_output()
  config <- get_config()
  svc <- .ecs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecs$operations$list_clusters <- ecs_list_clusters

#' Returns a list of container instances in a specified cluster
#'
#' @description
#' Returns a list of container instances in a specified cluster. You can filter the results of a [`list_container_instances`][ecs_list_container_instances] operation with cluster query language statements inside the `filter` parameter. For more information, see [Cluster Query Language](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html) in the *Amazon Elastic Container Service Developer Guide*.
#'
#' See [https://paws-r.github.io/docs/ecs/list_container_instances.html](https://paws-r.github.io/docs/ecs/list_container_instances.html) for full documentation.
#'
#' @param cluster The short name or full Amazon Resource Name (ARN) of the cluster that
#' hosts the container instances to list. If you do not specify a cluster,
#' the default cluster is assumed.
#' @param filter You can filter the results of a
#' [`list_container_instances`][ecs_list_container_instances] operation
#' with cluster query language statements. For more information, see
#' [Cluster Query
#' Language](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html)
#' in the *Amazon Elastic Container Service Developer Guide*.
#' @param nextToken The `nextToken` value returned from a
#' [`list_container_instances`][ecs_list_container_instances] request
#' indicating that more results are available to fulfill the request and
#' further calls are needed. If `maxResults` was provided, it's possible
#' the number of results to be fewer than `maxResults`.
#' 
#' This token should be treated as an opaque identifier that is only used
#' to retrieve the next items in a list and not for other programmatic
#' purposes.
#' @param maxResults The maximum number of container instance results that
#' [`list_container_instances`][ecs_list_container_instances] returned in
#' paginated output. When this parameter is used,
#' [`list_container_instances`][ecs_list_container_instances] only returns
#' `maxResults` results in a single page along with a `nextToken` response
#' element. The remaining results of the initial request can be seen by
#' sending another
#' [`list_container_instances`][ecs_list_container_instances] request with
#' the returned `nextToken` value. This value can be between 1 and 100. If
#' this parameter isn't used, then
#' [`list_container_instances`][ecs_list_container_instances] returns up to
#' 100 results and a `nextToken` value if applicable.
#' @param status Filters the container instances by status. For example, if you specify
#' the `DRAINING` status, the results include only container instances that
#' have been set to `DRAINING` using
#' [`update_container_instances_state`][ecs_update_container_instances_state].
#' If you don't specify this parameter, the default is to include container
#' instances set to all states other than `INACTIVE`.
#'
#' @keywords internal
#'
#' @rdname ecs_list_container_instances
ecs_list_container_instances <- function(cluster = NULL, filter = NULL, nextToken = NULL, maxResults = NULL, status = NULL) {
  op <- new_operation(
    name = "ListContainerInstances",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecs$list_container_instances_input(cluster = cluster, filter = filter, nextToken = nextToken, maxResults = maxResults, status = status)
  output <- .ecs$list_container_instances_output()
  config <- get_config()
  svc <- .ecs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecs$operations$list_container_instances <- ecs_list_container_instances

#' Returns a list of services
#'
#' @description
#' Returns a list of services. You can filter the results by cluster, launch type, and scheduling strategy.
#'
#' See [https://paws-r.github.io/docs/ecs/list_services.html](https://paws-r.github.io/docs/ecs/list_services.html) for full documentation.
#'
#' @param cluster The short name or full Amazon Resource Name (ARN) of the cluster to use
#' when filtering the [`list_services`][ecs_list_services] results. If you
#' do not specify a cluster, the default cluster is assumed.
#' @param nextToken The `nextToken` value returned from a
#' [`list_services`][ecs_list_services] request indicating that more
#' results are available to fulfill the request and further calls will be
#' needed. If `maxResults` was provided, it is possible the number of
#' results to be fewer than `maxResults`.
#' 
#' This token should be treated as an opaque identifier that is only used
#' to retrieve the next items in a list and not for other programmatic
#' purposes.
#' @param maxResults The maximum number of service results that
#' [`list_services`][ecs_list_services] returned in paginated output. When
#' this parameter is used, [`list_services`][ecs_list_services] only
#' returns `maxResults` results in a single page along with a `nextToken`
#' response element. The remaining results of the initial request can be
#' seen by sending another [`list_services`][ecs_list_services] request
#' with the returned `nextToken` value. This value can be between 1 and
#' 100. If this parameter isn't used, then
#' [`list_services`][ecs_list_services] returns up to 10 results and a
#' `nextToken` value if applicable.
#' @param launchType The launch type to use when filtering the
#' [`list_services`][ecs_list_services] results.
#' @param schedulingStrategy The scheduling strategy to use when filtering the
#' [`list_services`][ecs_list_services] results.
#'
#' @keywords internal
#'
#' @rdname ecs_list_services
ecs_list_services <- function(cluster = NULL, nextToken = NULL, maxResults = NULL, launchType = NULL, schedulingStrategy = NULL) {
  op <- new_operation(
    name = "ListServices",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecs$list_services_input(cluster = cluster, nextToken = nextToken, maxResults = maxResults, launchType = launchType, schedulingStrategy = schedulingStrategy)
  output <- .ecs$list_services_output()
  config <- get_config()
  svc <- .ecs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecs$operations$list_services <- ecs_list_services

#' List the tags for an Amazon ECS resource
#'
#' @description
#' List the tags for an Amazon ECS resource.
#'
#' See [https://paws-r.github.io/docs/ecs/list_tags_for_resource.html](https://paws-r.github.io/docs/ecs/list_tags_for_resource.html) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) that identifies the resource to list the
#' tags for. Currently, the supported resources are Amazon ECS tasks,
#' services, task definitions, clusters, and container instances.
#'
#' @keywords internal
#'
#' @rdname ecs_list_tags_for_resource
ecs_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecs$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .ecs$list_tags_for_resource_output()
  config <- get_config()
  svc <- .ecs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecs$operations$list_tags_for_resource <- ecs_list_tags_for_resource

#' Returns a list of task definition families that are registered to your
#' account
#'
#' @description
#' Returns a list of task definition families that are registered to your account. This list includes task definition families that no longer have any `ACTIVE` task definition revisions.
#'
#' See [https://paws-r.github.io/docs/ecs/list_task_definition_families.html](https://paws-r.github.io/docs/ecs/list_task_definition_families.html) for full documentation.
#'
#' @param familyPrefix The `familyPrefix` is a string that's used to filter the results of
#' [`list_task_definition_families`][ecs_list_task_definition_families]. If
#' you specify a `familyPrefix`, only task definition family names that
#' begin with the `familyPrefix` string are returned.
#' @param status The task definition family status to filter the
#' [`list_task_definition_families`][ecs_list_task_definition_families]
#' results with. By default, both `ACTIVE` and `INACTIVE` task definition
#' families are listed. If this parameter is set to `ACTIVE`, only task
#' definition families that have an `ACTIVE` task definition revision are
#' returned. If this parameter is set to `INACTIVE`, only task definition
#' families that do not have any `ACTIVE` task definition revisions are
#' returned. If you paginate the resulting output, be sure to keep the
#' `status` value constant in each subsequent request.
#' @param nextToken The `nextToken` value returned from a
#' [`list_task_definition_families`][ecs_list_task_definition_families]
#' request indicating that more results are available to fulfill the
#' request and further calls will be needed. If `maxResults` was provided,
#' it is possible the number of results to be fewer than `maxResults`.
#' 
#' This token should be treated as an opaque identifier that is only used
#' to retrieve the next items in a list and not for other programmatic
#' purposes.
#' @param maxResults The maximum number of task definition family results that
#' [`list_task_definition_families`][ecs_list_task_definition_families]
#' returned in paginated output. When this parameter is used,
#' [`list_task_definitions`][ecs_list_task_definitions] only returns
#' `maxResults` results in a single page along with a `nextToken` response
#' element. The remaining results of the initial request can be seen by
#' sending another
#' [`list_task_definition_families`][ecs_list_task_definition_families]
#' request with the returned `nextToken` value. This value can be between 1
#' and 100. If this parameter isn't used, then
#' [`list_task_definition_families`][ecs_list_task_definition_families]
#' returns up to 100 results and a `nextToken` value if applicable.
#'
#' @keywords internal
#'
#' @rdname ecs_list_task_definition_families
ecs_list_task_definition_families <- function(familyPrefix = NULL, status = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListTaskDefinitionFamilies",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecs$list_task_definition_families_input(familyPrefix = familyPrefix, status = status, nextToken = nextToken, maxResults = maxResults)
  output <- .ecs$list_task_definition_families_output()
  config <- get_config()
  svc <- .ecs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecs$operations$list_task_definition_families <- ecs_list_task_definition_families

#' Returns a list of task definitions that are registered to your account
#'
#' @description
#' Returns a list of task definitions that are registered to your account. You can filter the results by family name with the `familyPrefix` parameter or by status with the `status` parameter.
#'
#' See [https://paws-r.github.io/docs/ecs/list_task_definitions.html](https://paws-r.github.io/docs/ecs/list_task_definitions.html) for full documentation.
#'
#' @param familyPrefix The full family name to filter the
#' [`list_task_definitions`][ecs_list_task_definitions] results with.
#' Specifying a `familyPrefix` limits the listed task definitions to task
#' definition revisions that belong to that family.
#' @param status The task definition status to filter the
#' [`list_task_definitions`][ecs_list_task_definitions] results with. By
#' default, only `ACTIVE` task definitions are listed. By setting this
#' parameter to `INACTIVE`, you can view task definitions that are
#' `INACTIVE` as long as an active task or service still references them.
#' If you paginate the resulting output, be sure to keep the `status` value
#' constant in each subsequent request.
#' @param sort The order to sort the results in. Valid values are `ASC` and `DESC`. By
#' default, (`ASC`) task definitions are listed lexicographically by family
#' name and in ascending numerical order by revision so that the newest
#' task definitions in a family are listed last. Setting this parameter to
#' `DESC` reverses the sort order on family name and revision. This is so
#' that the newest task definitions in a family are listed first.
#' @param nextToken The `nextToken` value returned from a
#' [`list_task_definitions`][ecs_list_task_definitions] request indicating
#' that more results are available to fulfill the request and further calls
#' will be needed. If `maxResults` was provided, it is possible the number
#' of results to be fewer than `maxResults`.
#' 
#' This token should be treated as an opaque identifier that is only used
#' to retrieve the next items in a list and not for other programmatic
#' purposes.
#' @param maxResults The maximum number of task definition results that
#' [`list_task_definitions`][ecs_list_task_definitions] returned in
#' paginated output. When this parameter is used,
#' [`list_task_definitions`][ecs_list_task_definitions] only returns
#' `maxResults` results in a single page along with a `nextToken` response
#' element. The remaining results of the initial request can be seen by
#' sending another [`list_task_definitions`][ecs_list_task_definitions]
#' request with the returned `nextToken` value. This value can be between 1
#' and 100. If this parameter isn't used, then
#' [`list_task_definitions`][ecs_list_task_definitions] returns up to 100
#' results and a `nextToken` value if applicable.
#'
#' @keywords internal
#'
#' @rdname ecs_list_task_definitions
ecs_list_task_definitions <- function(familyPrefix = NULL, status = NULL, sort = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListTaskDefinitions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecs$list_task_definitions_input(familyPrefix = familyPrefix, status = status, sort = sort, nextToken = nextToken, maxResults = maxResults)
  output <- .ecs$list_task_definitions_output()
  config <- get_config()
  svc <- .ecs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecs$operations$list_task_definitions <- ecs_list_task_definitions

#' Returns a list of tasks
#'
#' @description
#' Returns a list of tasks. You can filter the results by cluster, task definition family, container instance, launch type, what IAM principal started the task, or by the desired status of the task.
#'
#' See [https://paws-r.github.io/docs/ecs/list_tasks.html](https://paws-r.github.io/docs/ecs/list_tasks.html) for full documentation.
#'
#' @param cluster The short name or full Amazon Resource Name (ARN) of the cluster to use
#' when filtering the [`list_tasks`][ecs_list_tasks] results. If you do not
#' specify a cluster, the default cluster is assumed.
#' @param containerInstance The container instance ID or full ARN of the container instance to use
#' when filtering the [`list_tasks`][ecs_list_tasks] results. Specifying a
#' `containerInstance` limits the results to tasks that belong to that
#' container instance.
#' @param family The name of the task definition family to use when filtering the
#' [`list_tasks`][ecs_list_tasks] results. Specifying a `family` limits the
#' results to tasks that belong to that family.
#' @param nextToken The `nextToken` value returned from a [`list_tasks`][ecs_list_tasks]
#' request indicating that more results are available to fulfill the
#' request and further calls will be needed. If `maxResults` was provided,
#' it's possible the number of results to be fewer than `maxResults`.
#' 
#' This token should be treated as an opaque identifier that is only used
#' to retrieve the next items in a list and not for other programmatic
#' purposes.
#' @param maxResults The maximum number of task results that [`list_tasks`][ecs_list_tasks]
#' returned in paginated output. When this parameter is used,
#' [`list_tasks`][ecs_list_tasks] only returns `maxResults` results in a
#' single page along with a `nextToken` response element. The remaining
#' results of the initial request can be seen by sending another
#' [`list_tasks`][ecs_list_tasks] request with the returned `nextToken`
#' value. This value can be between 1 and 100. If this parameter isn't
#' used, then [`list_tasks`][ecs_list_tasks] returns up to 100 results and
#' a `nextToken` value if applicable.
#' @param startedBy The `startedBy` value to filter the task results with. Specifying a
#' `startedBy` value limits the results to tasks that were started with
#' that value.
#' @param serviceName The name of the service to use when filtering the
#' [`list_tasks`][ecs_list_tasks] results. Specifying a `serviceName`
#' limits the results to tasks that belong to that service.
#' @param desiredStatus The task desired status to use when filtering the
#' [`list_tasks`][ecs_list_tasks] results. Specifying a `desiredStatus` of
#' `STOPPED` limits the results to tasks that Amazon ECS has set the
#' desired status to `STOPPED`. This can be useful for debugging tasks that
#' aren't starting properly or have died or finished. The default status
#' filter is `RUNNING`, which shows tasks that Amazon ECS has set the
#' desired status to `RUNNING`.
#' 
#' Although you can filter results based on a desired status of `PENDING`,
#' this doesn't return any results. Amazon ECS never sets the desired
#' status of a task to that value (only a task's `lastStatus` may have a
#' value of `PENDING`).
#' @param launchType The launch type to use when filtering the [`list_tasks`][ecs_list_tasks]
#' results.
#'
#' @keywords internal
#'
#' @rdname ecs_list_tasks
ecs_list_tasks <- function(cluster = NULL, containerInstance = NULL, family = NULL, nextToken = NULL, maxResults = NULL, startedBy = NULL, serviceName = NULL, desiredStatus = NULL, launchType = NULL) {
  op <- new_operation(
    name = "ListTasks",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecs$list_tasks_input(cluster = cluster, containerInstance = containerInstance, family = family, nextToken = nextToken, maxResults = maxResults, startedBy = startedBy, serviceName = serviceName, desiredStatus = desiredStatus, launchType = launchType)
  output <- .ecs$list_tasks_output()
  config <- get_config()
  svc <- .ecs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecs$operations$list_tasks <- ecs_list_tasks

#' Modifies an account setting
#'
#' @description
#' Modifies an account setting. Account settings are set on a per-Region basis.
#'
#' See [https://paws-r.github.io/docs/ecs/put_account_setting.html](https://paws-r.github.io/docs/ecs/put_account_setting.html) for full documentation.
#'
#' @param name &#91;required&#93; The Amazon ECS resource name for which to modify the account setting. If
#' `serviceLongArnFormat` is specified, the ARN for your Amazon ECS
#' services is affected. If `taskLongArnFormat` is specified, the ARN and
#' resource ID for your Amazon ECS tasks is affected. If
#' `containerInstanceLongArnFormat` is specified, the ARN and resource ID
#' for your Amazon ECS container instances is affected. If `awsvpcTrunking`
#' is specified, the elastic network interface (ENI) limit for your Amazon
#' ECS container instances is affected. If `containerInsights` is
#' specified, the default setting for CloudWatch Container Insights for
#' your clusters is affected.
#' @param value &#91;required&#93; The account setting value for the specified principal ARN. Accepted
#' values are `enabled` and `disabled`.
#' @param principalArn The ARN of the principal, which can be an IAM user, IAM role, or the
#' root user. If you specify the root user, it modifies the account setting
#' for all IAM users, IAM roles, and the root user of the account unless an
#' IAM user or role explicitly overrides these settings. If this field is
#' omitted, the setting is changed only for the authenticated user.
#' 
#' Federated users assume the account setting of the root user and can't
#' have explicit account settings set for them.
#'
#' @keywords internal
#'
#' @rdname ecs_put_account_setting
ecs_put_account_setting <- function(name, value, principalArn = NULL) {
  op <- new_operation(
    name = "PutAccountSetting",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecs$put_account_setting_input(name = name, value = value, principalArn = principalArn)
  output <- .ecs$put_account_setting_output()
  config <- get_config()
  svc <- .ecs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecs$operations$put_account_setting <- ecs_put_account_setting

#' Modifies an account setting for all IAM users on an account for whom no
#' individual account setting has been specified
#'
#' @description
#' Modifies an account setting for all IAM users on an account for whom no individual account setting has been specified. Account settings are set on a per-Region basis.
#'
#' See [https://paws-r.github.io/docs/ecs/put_account_setting_default.html](https://paws-r.github.io/docs/ecs/put_account_setting_default.html) for full documentation.
#'
#' @param name &#91;required&#93; The resource name for which to modify the account setting. If
#' `serviceLongArnFormat` is specified, the ARN for your Amazon ECS
#' services is affected. If `taskLongArnFormat` is specified, the ARN and
#' resource ID for your Amazon ECS tasks is affected. If
#' `containerInstanceLongArnFormat` is specified, the ARN and resource ID
#' for your Amazon ECS container instances is affected. If `awsvpcTrunking`
#' is specified, the ENI limit for your Amazon ECS container instances is
#' affected. If `containerInsights` is specified, the default setting for
#' CloudWatch Container Insights for your clusters is affected.
#' @param value &#91;required&#93; The account setting value for the specified principal ARN. Accepted
#' values are `enabled` and `disabled`.
#'
#' @keywords internal
#'
#' @rdname ecs_put_account_setting_default
ecs_put_account_setting_default <- function(name, value) {
  op <- new_operation(
    name = "PutAccountSettingDefault",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecs$put_account_setting_default_input(name = name, value = value)
  output <- .ecs$put_account_setting_default_output()
  config <- get_config()
  svc <- .ecs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecs$operations$put_account_setting_default <- ecs_put_account_setting_default

#' Create or update an attribute on an Amazon ECS resource
#'
#' @description
#' Create or update an attribute on an Amazon ECS resource. If the attribute doesn't exist, it's created. If the attribute exists, its value is replaced with the specified value. To delete an attribute, use [`delete_attributes`][ecs_delete_attributes]. For more information, see [Attributes](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-constraints.html#attributes) in the *Amazon Elastic Container Service Developer Guide*.
#'
#' See [https://paws-r.github.io/docs/ecs/put_attributes.html](https://paws-r.github.io/docs/ecs/put_attributes.html) for full documentation.
#'
#' @param cluster The short name or full Amazon Resource Name (ARN) of the cluster that
#' contains the resource to apply attributes. If you do not specify a
#' cluster, the default cluster is assumed.
#' @param attributes &#91;required&#93; The attributes to apply to your resource. You can specify up to 10
#' custom attributes for each resource. You can specify up to 10 attributes
#' in a single call.
#'
#' @keywords internal
#'
#' @rdname ecs_put_attributes
ecs_put_attributes <- function(cluster = NULL, attributes) {
  op <- new_operation(
    name = "PutAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecs$put_attributes_input(cluster = cluster, attributes = attributes)
  output <- .ecs$put_attributes_output()
  config <- get_config()
  svc <- .ecs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecs$operations$put_attributes <- ecs_put_attributes

#' Modifies the available capacity providers and the default capacity
#' provider strategy for a cluster
#'
#' @description
#' Modifies the available capacity providers and the default capacity provider strategy for a cluster.
#'
#' See [https://paws-r.github.io/docs/ecs/put_cluster_capacity_providers.html](https://paws-r.github.io/docs/ecs/put_cluster_capacity_providers.html) for full documentation.
#'
#' @param cluster &#91;required&#93; The short name or full Amazon Resource Name (ARN) of the cluster to
#' modify the capacity provider settings for. If you don't specify a
#' cluster, the default cluster is assumed.
#' @param capacityProviders &#91;required&#93; The name of one or more capacity providers to associate with the
#' cluster.
#' 
#' If specifying a capacity provider that uses an Auto Scaling group, the
#' capacity provider must already be created. New capacity providers can be
#' created with the
#' [`create_capacity_provider`][ecs_create_capacity_provider] API
#' operation.
#' 
#' To use a Fargate capacity provider, specify either the `FARGATE` or
#' `FARGATE_SPOT` capacity providers. The Fargate capacity providers are
#' available to all accounts and only need to be associated with a cluster
#' to be used.
#' @param defaultCapacityProviderStrategy &#91;required&#93; The capacity provider strategy to use by default for the cluster.
#' 
#' When creating a service or running a task on a cluster, if no capacity
#' provider or launch type is specified then the default capacity provider
#' strategy for the cluster is used.
#' 
#' A capacity provider strategy consists of one or more capacity providers
#' along with the `base` and `weight` to assign to them. A capacity
#' provider must be associated with the cluster to be used in a capacity
#' provider strategy. The
#' [`put_cluster_capacity_providers`][ecs_put_cluster_capacity_providers]
#' API is used to associate a capacity provider with a cluster. Only
#' capacity providers with an `ACTIVE` or `UPDATING` status can be used.
#' 
#' If specifying a capacity provider that uses an Auto Scaling group, the
#' capacity provider must already be created. New capacity providers can be
#' created with the
#' [`create_capacity_provider`][ecs_create_capacity_provider] API
#' operation.
#' 
#' To use a Fargate capacity provider, specify either the `FARGATE` or
#' `FARGATE_SPOT` capacity providers. The Fargate capacity providers are
#' available to all accounts and only need to be associated with a cluster
#' to be used.
#'
#' @keywords internal
#'
#' @rdname ecs_put_cluster_capacity_providers
ecs_put_cluster_capacity_providers <- function(cluster, capacityProviders, defaultCapacityProviderStrategy) {
  op <- new_operation(
    name = "PutClusterCapacityProviders",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecs$put_cluster_capacity_providers_input(cluster = cluster, capacityProviders = capacityProviders, defaultCapacityProviderStrategy = defaultCapacityProviderStrategy)
  output <- .ecs$put_cluster_capacity_providers_output()
  config <- get_config()
  svc <- .ecs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecs$operations$put_cluster_capacity_providers <- ecs_put_cluster_capacity_providers

#' This action is only used by the Amazon ECS agent, and it is not intended
#' for use outside of the agent
#'
#' @description
#' This action is only used by the Amazon ECS agent, and it is not intended for use outside of the agent.
#'
#' See [https://paws-r.github.io/docs/ecs/register_container_instance.html](https://paws-r.github.io/docs/ecs/register_container_instance.html) for full documentation.
#'
#' @param cluster The short name or full Amazon Resource Name (ARN) of the cluster to
#' register your container instance with. If you do not specify a cluster,
#' the default cluster is assumed.
#' @param instanceIdentityDocument The instance identity document for the EC2 instance to register. This
#' document can be found by running the following command from the
#' instance:
#' `curl http://169.254.169.254/latest/dynamic/instance-identity/document/`
#' @param instanceIdentityDocumentSignature The instance identity document signature for the EC2 instance to
#' register. This signature can be found by running the following command
#' from the instance:
#' `curl http://169.254.169.254/latest/dynamic/instance-identity/signature/`
#' @param totalResources The resources available on the instance.
#' @param versionInfo The version information for the Amazon ECS container agent and Docker
#' daemon that runs on the container instance.
#' @param containerInstanceArn The ARN of the container instance (if it was previously registered).
#' @param attributes The container instance attributes that this container instance supports.
#' @param platformDevices The devices that are available on the container instance. The only
#' supported device type is a GPU.
#' @param tags The metadata that you apply to the container instance to help you
#' categorize and organize them. Each tag consists of a key and an optional
#' value. You define both.
#' 
#' The following basic restrictions apply to tags:
#' 
#' -   Maximum number of tags per resource - 50
#' 
#' -   For each resource, each tag key must be unique, and each tag key can
#'     have only one value.
#' 
#' -   Maximum key length - 128 Unicode characters in UTF-8
#' 
#' -   Maximum value length - 256 Unicode characters in UTF-8
#' 
#' -   If your tagging schema is used across multiple services and
#'     resources, remember that other services may have restrictions on
#'     allowed characters. Generally allowed characters are: letters,
#'     numbers, and spaces representable in UTF-8, and the following
#'     characters: + - = . _ : / @@.
#' 
#' -   Tag keys and values are case-sensitive.
#' 
#' -   Do not use `aws:`, `AWS:`, or any upper or lowercase combination of
#'     such as a prefix for either keys or values as it is reserved for
#'     Amazon Web Services use. You cannot edit or delete tag keys or
#'     values with this prefix. Tags with this prefix do not count against
#'     your tags per resource limit.
#'
#' @keywords internal
#'
#' @rdname ecs_register_container_instance
ecs_register_container_instance <- function(cluster = NULL, instanceIdentityDocument = NULL, instanceIdentityDocumentSignature = NULL, totalResources = NULL, versionInfo = NULL, containerInstanceArn = NULL, attributes = NULL, platformDevices = NULL, tags = NULL) {
  op <- new_operation(
    name = "RegisterContainerInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecs$register_container_instance_input(cluster = cluster, instanceIdentityDocument = instanceIdentityDocument, instanceIdentityDocumentSignature = instanceIdentityDocumentSignature, totalResources = totalResources, versionInfo = versionInfo, containerInstanceArn = containerInstanceArn, attributes = attributes, platformDevices = platformDevices, tags = tags)
  output <- .ecs$register_container_instance_output()
  config <- get_config()
  svc <- .ecs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecs$operations$register_container_instance <- ecs_register_container_instance

#' Registers a new task definition from the supplied family and
#' containerDefinitions
#'
#' @description
#' Registers a new task definition from the supplied `family` and `containerDefinitions`. Optionally, you can add data volumes to your containers with the `volumes` parameter. For more information about task definition parameters and defaults, see [Amazon ECS Task Definitions](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definitions.html) in the *Amazon Elastic Container Service Developer Guide*.
#'
#' See [https://paws-r.github.io/docs/ecs/register_task_definition.html](https://paws-r.github.io/docs/ecs/register_task_definition.html) for full documentation.
#'
#' @param family &#91;required&#93; You must specify a `family` for a task definition. You can use it track
#' multiple versions of the same task definition. The `family` is used as a
#' name for your task definition. Up to 255 letters (uppercase and
#' lowercase), numbers, underscores, and hyphens are allowed.
#' @param taskRoleArn The short name or full Amazon Resource Name (ARN) of the IAM role that
#' containers in this task can assume. All containers in this task are
#' granted the permissions that are specified in this role. For more
#' information, see [IAM Roles for
#' Tasks](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html)
#' in the *Amazon Elastic Container Service Developer Guide*.
#' @param executionRoleArn The Amazon Resource Name (ARN) of the task execution role that grants
#' the Amazon ECS container agent permission to make Amazon Web Services
#' API calls on your behalf. The task execution IAM role is required
#' depending on the requirements of your task. For more information, see
#' [Amazon ECS task execution IAM
#' role](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_execution_IAM_role.html)
#' in the *Amazon Elastic Container Service Developer Guide*.
#' @param networkMode The Docker networking mode to use for the containers in the task. The
#' valid values are `none`, `bridge`, `awsvpc`, and `host`. If no network
#' mode is specified, the default is `bridge`.
#' 
#' For Amazon ECS tasks on Fargate, the `awsvpc` network mode is required.
#' For Amazon ECS tasks on Amazon EC2 Linux instances, any network mode can
#' be used. For Amazon ECS tasks on Amazon EC2 Windows instances,
#' `<default>` or `awsvpc` can be used. If the network mode is set to
#' `none`, you cannot specify port mappings in your container definitions,
#' and the tasks containers do not have external connectivity. The `host`
#' and `awsvpc` network modes offer the highest networking performance for
#' containers because they use the EC2 network stack instead of the
#' virtualized network stack provided by the `bridge` mode.
#' 
#' With the `host` and `awsvpc` network modes, exposed container ports are
#' mapped directly to the corresponding host port (for the `host` network
#' mode) or the attached elastic network interface port (for the `awsvpc`
#' network mode), so you cannot take advantage of dynamic host port
#' mappings.
#' 
#' When using the `host` network mode, you should not run containers using
#' the root user (UID 0). It is considered best practice to use a non-root
#' user.
#' 
#' If the network mode is `awsvpc`, the task is allocated an elastic
#' network interface, and you must specify a NetworkConfiguration value
#' when you create a service or run a task with the task definition. For
#' more information, see [Task
#' Networking](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html)
#' in the *Amazon Elastic Container Service Developer Guide*.
#' 
#' If the network mode is `host`, you cannot run multiple instantiations of
#' the same task on a single container instance when port mappings are
#' used.
#' 
#' For more information, see [Network
#' settings](https://docs.docker.com/engine/reference/run/#network-settings)
#' in the *Docker run reference*.
#' @param containerDefinitions &#91;required&#93; A list of container definitions in JSON format that describe the
#' different containers that make up your task.
#' @param volumes A list of volume definitions in JSON format that containers in your task
#' might use.
#' @param placementConstraints An array of placement constraint objects to use for the task. You can
#' specify a maximum of 10 constraints for each task. This limit includes
#' constraints in the task definition and those specified at runtime.
#' @param requiresCompatibilities The task launch type that Amazon ECS validates the task definition
#' against. A client exception is returned if the task definition doesn't
#' validate against the compatibilities specified. If no value is
#' specified, the parameter is omitted from the response.
#' @param cpu The number of CPU units used by the task. It can be expressed as an
#' integer using CPU units (for example, `1024`) or as a string using vCPUs
#' (for example, `1 vCPU` or `1 vcpu`) in a task definition. String values
#' are converted to an integer indicating the CPU units when the task
#' definition is registered.
#' 
#' Task-level CPU and memory parameters are ignored for Windows containers.
#' We recommend specifying container-level resources for Windows
#' containers.
#' 
#' If you're using the EC2 launch type, this field is optional. Supported
#' values are between `128` CPU units (`0.125` vCPUs) and `10240` CPU units
#' (`10` vCPUs).
#' 
#' If you're using the Fargate launch type, this field is required and you
#' must use one of the following values, which determines your range of
#' supported values for the `memory` parameter:
#' 
#' The CPU units cannot be less than 1 vCPU when you use Windows containers
#' on Fargate.
#' 
#' -   256 (.25 vCPU) - Available `memory` values: 512 (0.5 GB), 1024 (1
#'     GB), 2048 (2 GB)
#' 
#' -   512 (.5 vCPU) - Available `memory` values: 1024 (1 GB), 2048 (2 GB),
#'     3072 (3 GB), 4096 (4 GB)
#' 
#' -   1024 (1 vCPU) - Available `memory` values: 2048 (2 GB), 3072 (3 GB),
#'     4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB)
#' 
#' -   2048 (2 vCPU) - Available `memory` values: Between 4096 (4 GB) and
#'     16384 (16 GB) in increments of 1024 (1 GB)
#' 
#' -   4096 (4 vCPU) - Available `memory` values: Between 8192 (8 GB) and
#'     30720 (30 GB) in increments of 1024 (1 GB)
#' @param memory The amount of memory (in MiB) used by the task. It can be expressed as
#' an integer using MiB (for example ,`1024`) or as a string using GB (for
#' example, `1GB` or `1 GB`) in a task definition. String values are
#' converted to an integer indicating the MiB when the task definition is
#' registered.
#' 
#' Task-level CPU and memory parameters are ignored for Windows containers.
#' We recommend specifying container-level resources for Windows
#' containers.
#' 
#' If using the EC2 launch type, this field is optional.
#' 
#' If using the Fargate launch type, this field is required and you must
#' use one of the following values. This determines your range of supported
#' values for the `cpu` parameter.
#' 
#' The CPU units cannot be less than 1 vCPU when you use Windows containers
#' on Fargate.
#' 
#' -   512 (0.5 GB), 1024 (1 GB), 2048 (2 GB) - Available `cpu` values: 256
#'     (.25 vCPU)
#' 
#' -   1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB) - Available `cpu`
#'     values: 512 (.5 vCPU)
#' 
#' -   2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB),
#'     7168 (7 GB), 8192 (8 GB) - Available `cpu` values: 1024 (1 vCPU)
#' 
#' -   Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB) -
#'     Available `cpu` values: 2048 (2 vCPU)
#' 
#' -   Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB) -
#'     Available `cpu` values: 4096 (4 vCPU)
#' @param tags The metadata that you apply to the task definition to help you
#' categorize and organize them. Each tag consists of a key and an optional
#' value. You define both of them.
#' 
#' The following basic restrictions apply to tags:
#' 
#' -   Maximum number of tags per resource - 50
#' 
#' -   For each resource, each tag key must be unique, and each tag key can
#'     have only one value.
#' 
#' -   Maximum key length - 128 Unicode characters in UTF-8
#' 
#' -   Maximum value length - 256 Unicode characters in UTF-8
#' 
#' -   If your tagging schema is used across multiple services and
#'     resources, remember that other services may have restrictions on
#'     allowed characters. Generally allowed characters are: letters,
#'     numbers, and spaces representable in UTF-8, and the following
#'     characters: + - = . _ : / @@.
#' 
#' -   Tag keys and values are case-sensitive.
#' 
#' -   Do not use `aws:`, `AWS:`, or any upper or lowercase combination of
#'     such as a prefix for either keys or values as it is reserved for
#'     Amazon Web Services use. You cannot edit or delete tag keys or
#'     values with this prefix. Tags with this prefix do not count against
#'     your tags per resource limit.
#' @param pidMode The process namespace to use for the containers in the task. The valid
#' values are `host` or `task`. If `host` is specified, then all containers
#' within the tasks that specified the `host` PID mode on the same
#' container instance share the same process namespace with the host Amazon
#' EC2 instance. If `task` is specified, all containers within the
#' specified task share the same process namespace. If no value is
#' specified, the default is a private namespace. For more information, see
#' [PID
#' settings](https://docs.docker.com/engine/reference/run/#pid-settings---pid)
#' in the *Docker run reference*.
#' 
#' If the `host` PID mode is used, be aware that there is a heightened risk
#' of undesired process namespace expose. For more information, see [Docker
#' security](https://docs.docker.com/engine/security/).
#' 
#' This parameter is not supported for Windows containers or tasks run on
#' Fargate.
#' @param ipcMode The IPC resource namespace to use for the containers in the task. The
#' valid values are `host`, `task`, or `none`. If `host` is specified, then
#' all containers within the tasks that specified the `host` IPC mode on
#' the same container instance share the same IPC resources with the host
#' Amazon EC2 instance. If `task` is specified, all containers within the
#' specified task share the same IPC resources. If `none` is specified,
#' then IPC resources within the containers of a task are private and not
#' shared with other containers in a task or on the container instance. If
#' no value is specified, then the IPC resource namespace sharing depends
#' on the Docker daemon setting on the container instance. For more
#' information, see [IPC
#' settings](https://docs.docker.com/engine/reference/run/#ipc-settings---ipc)
#' in the *Docker run reference*.
#' 
#' If the `host` IPC mode is used, be aware that there is a heightened risk
#' of undesired IPC namespace expose. For more information, see [Docker
#' security](https://docs.docker.com/engine/security/).
#' 
#' If you are setting namespaced kernel parameters using `systemControls`
#' for the containers in the task, the following will apply to your IPC
#' resource namespace. For more information, see [System
#' Controls](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html)
#' in the *Amazon Elastic Container Service Developer Guide*.
#' 
#' -   For tasks that use the `host` IPC mode, IPC namespace related
#'     `systemControls` are not supported.
#' 
#' -   For tasks that use the `task` IPC mode, IPC namespace related
#'     `systemControls` will apply to all containers within a task.
#' 
#' This parameter is not supported for Windows containers or tasks run on
#' Fargate.
#' @param proxyConfiguration The configuration details for the App Mesh proxy.
#' 
#' For tasks hosted on Amazon EC2 instances, the container instances
#' require at least version `1.26.0` of the container agent and at least
#' version `1.26.0-1` of the `ecs-init` package to use a proxy
#' configuration. If your container instances are launched from the Amazon
#' ECS-optimized AMI version `20190301` or later, then they contain the
#' required versions of the container agent and `ecs-init`. For more
#' information, see [Amazon ECS-optimized AMI
#' versions](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-ami-versions.html)
#' in the *Amazon Elastic Container Service Developer Guide*.
#' @param inferenceAccelerators The Elastic Inference accelerators to use for the containers in the
#' task.
#' @param ephemeralStorage The amount of ephemeral storage to allocate for the task. This parameter
#' is used to expand the total amount of ephemeral storage available,
#' beyond the default amount, for tasks hosted on Fargate. For more
#' information, see [Fargate task
#' storage](https://docs.aws.amazon.com/AmazonECS/latest/userguide/using_data_volumes.html)
#' in the *Amazon ECS User Guide for Fargate*.
#' 
#' This parameter is only supported for tasks hosted on Fargate using the
#' following platform versions:
#' 
#' -   Linux platform version `1.4.0` or later.
#' 
#' -   Windows platform version `1.0.0` or later.
#' @param runtimePlatform The operating system that your tasks definitions run on. A platform
#' family is specified only for tasks using the Fargate launch type.
#' 
#' When you specify a task definition in a service, this value must match
#' the `runtimePlatform` value of the service.
#'
#' @keywords internal
#'
#' @rdname ecs_register_task_definition
ecs_register_task_definition <- function(family, taskRoleArn = NULL, executionRoleArn = NULL, networkMode = NULL, containerDefinitions, volumes = NULL, placementConstraints = NULL, requiresCompatibilities = NULL, cpu = NULL, memory = NULL, tags = NULL, pidMode = NULL, ipcMode = NULL, proxyConfiguration = NULL, inferenceAccelerators = NULL, ephemeralStorage = NULL, runtimePlatform = NULL) {
  op <- new_operation(
    name = "RegisterTaskDefinition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecs$register_task_definition_input(family = family, taskRoleArn = taskRoleArn, executionRoleArn = executionRoleArn, networkMode = networkMode, containerDefinitions = containerDefinitions, volumes = volumes, placementConstraints = placementConstraints, requiresCompatibilities = requiresCompatibilities, cpu = cpu, memory = memory, tags = tags, pidMode = pidMode, ipcMode = ipcMode, proxyConfiguration = proxyConfiguration, inferenceAccelerators = inferenceAccelerators, ephemeralStorage = ephemeralStorage, runtimePlatform = runtimePlatform)
  output <- .ecs$register_task_definition_output()
  config <- get_config()
  svc <- .ecs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecs$operations$register_task_definition <- ecs_register_task_definition

#' Starts a new task using the specified task definition
#'
#' @description
#' Starts a new task using the specified task definition.
#'
#' See [https://paws-r.github.io/docs/ecs/run_task.html](https://paws-r.github.io/docs/ecs/run_task.html) for full documentation.
#'
#' @param capacityProviderStrategy The capacity provider strategy to use for the task.
#' 
#' If a `capacityProviderStrategy` is specified, the `launchType` parameter
#' must be omitted. If no `capacityProviderStrategy` or `launchType` is
#' specified, the `defaultCapacityProviderStrategy` for the cluster is
#' used.
#' 
#' When you use cluster auto scaling, you must specify
#' `capacityProviderStrategy` and not `launchType`.
#' 
#' A capacity provider strategy may contain a maximum of 6 capacity
#' providers.
#' @param cluster The short name or full Amazon Resource Name (ARN) of the cluster to run
#' your task on. If you do not specify a cluster, the default cluster is
#' assumed.
#' @param count The number of instantiations of the specified task to place on your
#' cluster. You can specify up to 10 tasks for each call.
#' @param enableECSManagedTags Specifies whether to use Amazon ECS managed tags for the task. For more
#' information, see [Tagging Your Amazon ECS
#' Resources](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html)
#' in the *Amazon Elastic Container Service Developer Guide*.
#' @param enableExecuteCommand Determines whether to use the execute command functionality for the
#' containers in this task. If `true`, this enables execute command
#' functionality on all containers in the task.
#' 
#' If `true`, then the task definition must have a task role, or you must
#' provide one as an override.
#' @param group The name of the task group to associate with the task. The default value
#' is the family name of the task definition (for example,
#' `family:my-family-name`).
#' @param launchType The infrastructure to run your standalone task on. For more information,
#' see [Amazon ECS launch
#' types](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html)
#' in the *Amazon Elastic Container Service Developer Guide*.
#' 
#' The `FARGATE` launch type runs your tasks on Fargate On-Demand
#' infrastructure.
#' 
#' Fargate Spot infrastructure is available for use but a capacity provider
#' strategy must be used. For more information, see [Fargate capacity
#' providers](https://docs.aws.amazon.com/AmazonECS/latest/userguide/fargate-capacity-providers.html)
#' in the *Amazon ECS User Guide for Fargate*.
#' 
#' The `EC2` launch type runs your tasks on Amazon EC2 instances registered
#' to your cluster.
#' 
#' The `EXTERNAL` launch type runs your tasks on your on-premises server or
#' virtual machine (VM) capacity registered to your cluster.
#' 
#' A task can use either a launch type or a capacity provider strategy. If
#' a `launchType` is specified, the `capacityProviderStrategy` parameter
#' must be omitted.
#' 
#' When you use cluster auto scaling, you must specify
#' `capacityProviderStrategy` and not `launchType`.
#' @param networkConfiguration The network configuration for the task. This parameter is required for
#' task definitions that use the `awsvpc` network mode to receive their own
#' elastic network interface, and it isn't supported for other network
#' modes. For more information, see [Task
#' networking](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html)
#' in the *Amazon Elastic Container Service Developer Guide*.
#' @param overrides A list of container overrides in JSON format that specify the name of a
#' container in the specified task definition and the overrides it should
#' receive. You can override the default command for a container (that's
#' specified in the task definition or Docker image) with a `command`
#' override. You can also override existing environment variables (that are
#' specified in the task definition or Docker image) on a container or add
#' new environment variables to it with an `environment` override.
#' 
#' A total of 8192 characters are allowed for overrides. This limit
#' includes the JSON formatting characters of the override structure.
#' @param placementConstraints An array of placement constraint objects to use for the task. You can
#' specify up to 10 constraints for each task (including constraints in the
#' task definition and those specified at runtime).
#' @param placementStrategy The placement strategy objects to use for the task. You can specify a
#' maximum of 5 strategy rules for each task.
#' @param platformVersion The platform version the task uses. A platform version is only specified
#' for tasks hosted on Fargate. If one isn't specified, the `LATEST`
#' platform version is used. For more information, see [Fargate platform
#' versions](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html)
#' in the *Amazon Elastic Container Service Developer Guide*.
#' @param propagateTags Specifies whether to propagate the tags from the task definition to the
#' task. If no value is specified, the tags aren't propagated. Tags can
#' only be propagated to the task during task creation. To add tags to a
#' task after task creation, use the [`tag_resource`][ecs_tag_resource] API
#' action.
#' 
#' An error will be received if you specify the `SERVICE` option when
#' running a task.
#' @param referenceId The reference ID to use for the task. The reference ID can have a
#' maximum length of 1024 characters.
#' @param startedBy An optional tag specified when a task is started. For example, if you
#' automatically trigger a task to run a batch process job, you could apply
#' a unique identifier for that job to your task with the `startedBy`
#' parameter. You can then identify which tasks belong to that job by
#' filtering the results of a [`list_tasks`][ecs_list_tasks] call with the
#' `startedBy` value. Up to 36 letters (uppercase and lowercase), numbers,
#' hyphens (-), and underscores (_) are allowed.
#' 
#' If a task is started by an Amazon ECS service, then the `startedBy`
#' parameter contains the deployment ID of the service that starts it.
#' @param tags The metadata that you apply to the task to help you categorize and
#' organize them. Each tag consists of a key and an optional value, both of
#' which you define.
#' 
#' The following basic restrictions apply to tags:
#' 
#' -   Maximum number of tags per resource - 50
#' 
#' -   For each resource, each tag key must be unique, and each tag key can
#'     have only one value.
#' 
#' -   Maximum key length - 128 Unicode characters in UTF-8
#' 
#' -   Maximum value length - 256 Unicode characters in UTF-8
#' 
#' -   If your tagging schema is used across multiple services and
#'     resources, remember that other services may have restrictions on
#'     allowed characters. Generally allowed characters are: letters,
#'     numbers, and spaces representable in UTF-8, and the following
#'     characters: + - = . _ : / @@.
#' 
#' -   Tag keys and values are case-sensitive.
#' 
#' -   Do not use `aws:`, `AWS:`, or any upper or lowercase combination of
#'     such as a prefix for either keys or values as it is reserved for
#'     Amazon Web Services use. You cannot edit or delete tag keys or
#'     values with this prefix. Tags with this prefix do not count against
#'     your tags per resource limit.
#' @param taskDefinition &#91;required&#93; The `family` and `revision` (`family:revision`) or full ARN of the task
#' definition to run. If a `revision` isn't specified, the latest `ACTIVE`
#' revision is used.
#' 
#' When you create an IAM policy for run-task, you can set the resource to
#' be the latest task definition revision, or a specific revision.
#' 
#' The full ARN value must match the value that you specified as the
#' `Resource` of the IAM principal's permissions policy.
#' 
#' When you specify the policy resource as the latest task definition
#' version (by setting the `Resource` in the policy to
#' `arn:aws:ecs:us-east-1:111122223333:task-definition/TaskFamilyName`),
#' then set this value to
#' `arn:aws:ecs:us-east-1:111122223333:task-definition/TaskFamilyName`.
#' 
#' When you specify the policy resource as a specific task definition
#' version (by setting the `Resource` in the policy to
#' `arn:aws:ecs:us-east-1:111122223333:task-definition/TaskFamilyName:1` or
#' `arn:aws:ecs:us-east-1:111122223333:task-definition/TaskFamilyName:*`),
#' then set this value to
#' `arn:aws:ecs:us-east-1:111122223333:task-definition/TaskFamilyName:1`.
#' 
#' For more information, see [Policy Resources for Amazon
#' ECS](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/security_iam_service-with-iam.html#security_iam_service-with-iam-id-based-policies-resources)
#' in the Amazon Elastic Container Service developer Guide.
#'
#' @keywords internal
#'
#' @rdname ecs_run_task
ecs_run_task <- function(capacityProviderStrategy = NULL, cluster = NULL, count = NULL, enableECSManagedTags = NULL, enableExecuteCommand = NULL, group = NULL, launchType = NULL, networkConfiguration = NULL, overrides = NULL, placementConstraints = NULL, placementStrategy = NULL, platformVersion = NULL, propagateTags = NULL, referenceId = NULL, startedBy = NULL, tags = NULL, taskDefinition) {
  op <- new_operation(
    name = "RunTask",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecs$run_task_input(capacityProviderStrategy = capacityProviderStrategy, cluster = cluster, count = count, enableECSManagedTags = enableECSManagedTags, enableExecuteCommand = enableExecuteCommand, group = group, launchType = launchType, networkConfiguration = networkConfiguration, overrides = overrides, placementConstraints = placementConstraints, placementStrategy = placementStrategy, platformVersion = platformVersion, propagateTags = propagateTags, referenceId = referenceId, startedBy = startedBy, tags = tags, taskDefinition = taskDefinition)
  output <- .ecs$run_task_output()
  config <- get_config()
  svc <- .ecs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecs$operations$run_task <- ecs_run_task

#' Starts a new task from the specified task definition on the specified
#' container instance or instances
#'
#' @description
#' Starts a new task from the specified task definition on the specified container instance or instances.
#'
#' See [https://paws-r.github.io/docs/ecs/start_task.html](https://paws-r.github.io/docs/ecs/start_task.html) for full documentation.
#'
#' @param cluster The short name or full Amazon Resource Name (ARN) of the cluster where
#' to start your task. If you do not specify a cluster, the default cluster
#' is assumed.
#' @param containerInstances &#91;required&#93; The container instance IDs or full ARN entries for the container
#' instances where you would like to place your task. You can specify up to
#' 10 container instances.
#' @param enableECSManagedTags Specifies whether to use Amazon ECS managed tags for the task. For more
#' information, see [Tagging Your Amazon ECS
#' Resources](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html)
#' in the *Amazon Elastic Container Service Developer Guide*.
#' @param enableExecuteCommand Whether or not the execute command functionality is enabled for the
#' task. If `true`, this enables execute command functionality on all
#' containers in the task.
#' @param group The name of the task group to associate with the task. The default value
#' is the family name of the task definition (for example,
#' family:my-family-name).
#' @param networkConfiguration The VPC subnet and security group configuration for tasks that receive
#' their own elastic network interface by using the `awsvpc` networking
#' mode.
#' @param overrides A list of container overrides in JSON format that specify the name of a
#' container in the specified task definition and the overrides it
#' receives. You can override the default command for a container (that's
#' specified in the task definition or Docker image) with a `command`
#' override. You can also override existing environment variables (that are
#' specified in the task definition or Docker image) on a container or add
#' new environment variables to it with an `environment` override.
#' 
#' A total of 8192 characters are allowed for overrides. This limit
#' includes the JSON formatting characters of the override structure.
#' @param propagateTags Specifies whether to propagate the tags from the task definition or the
#' service to the task. If no value is specified, the tags aren't
#' propagated.
#' @param referenceId The reference ID to use for the task.
#' @param startedBy An optional tag specified when a task is started. For example, if you
#' automatically trigger a task to run a batch process job, you could apply
#' a unique identifier for that job to your task with the `startedBy`
#' parameter. You can then identify which tasks belong to that job by
#' filtering the results of a [`list_tasks`][ecs_list_tasks] call with the
#' `startedBy` value. Up to 36 letters (uppercase and lowercase), numbers,
#' hyphens (-), and underscores (_) are allowed.
#' 
#' If a task is started by an Amazon ECS service, the `startedBy` parameter
#' contains the deployment ID of the service that starts it.
#' @param tags The metadata that you apply to the task to help you categorize and
#' organize them. Each tag consists of a key and an optional value, both of
#' which you define.
#' 
#' The following basic restrictions apply to tags:
#' 
#' -   Maximum number of tags per resource - 50
#' 
#' -   For each resource, each tag key must be unique, and each tag key can
#'     have only one value.
#' 
#' -   Maximum key length - 128 Unicode characters in UTF-8
#' 
#' -   Maximum value length - 256 Unicode characters in UTF-8
#' 
#' -   If your tagging schema is used across multiple services and
#'     resources, remember that other services may have restrictions on
#'     allowed characters. Generally allowed characters are: letters,
#'     numbers, and spaces representable in UTF-8, and the following
#'     characters: + - = . _ : / @@.
#' 
#' -   Tag keys and values are case-sensitive.
#' 
#' -   Do not use `aws:`, `AWS:`, or any upper or lowercase combination of
#'     such as a prefix for either keys or values as it is reserved for
#'     Amazon Web Services use. You cannot edit or delete tag keys or
#'     values with this prefix. Tags with this prefix do not count against
#'     your tags per resource limit.
#' @param taskDefinition &#91;required&#93; The `family` and `revision` (`family:revision`) or full ARN of the task
#' definition to start. If a `revision` isn't specified, the latest
#' `ACTIVE` revision is used.
#'
#' @keywords internal
#'
#' @rdname ecs_start_task
ecs_start_task <- function(cluster = NULL, containerInstances, enableECSManagedTags = NULL, enableExecuteCommand = NULL, group = NULL, networkConfiguration = NULL, overrides = NULL, propagateTags = NULL, referenceId = NULL, startedBy = NULL, tags = NULL, taskDefinition) {
  op <- new_operation(
    name = "StartTask",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecs$start_task_input(cluster = cluster, containerInstances = containerInstances, enableECSManagedTags = enableECSManagedTags, enableExecuteCommand = enableExecuteCommand, group = group, networkConfiguration = networkConfiguration, overrides = overrides, propagateTags = propagateTags, referenceId = referenceId, startedBy = startedBy, tags = tags, taskDefinition = taskDefinition)
  output <- .ecs$start_task_output()
  config <- get_config()
  svc <- .ecs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecs$operations$start_task <- ecs_start_task

#' Stops a running task
#'
#' @description
#' Stops a running task. Any tags associated with the task will be deleted.
#'
#' See [https://paws-r.github.io/docs/ecs/stop_task.html](https://paws-r.github.io/docs/ecs/stop_task.html) for full documentation.
#'
#' @param cluster The short name or full Amazon Resource Name (ARN) of the cluster that
#' hosts the task to stop. If you do not specify a cluster, the default
#' cluster is assumed.
#' @param task &#91;required&#93; The task ID or full Amazon Resource Name (ARN) of the task to stop.
#' @param reason An optional message specified when a task is stopped. For example, if
#' you're using a custom scheduler, you can use this parameter to specify
#' the reason for stopping the task here, and the message appears in
#' subsequent [`describe_tasks`][ecs_describe_tasks] API operations on this
#' task. Up to 255 characters are allowed in this message.
#'
#' @keywords internal
#'
#' @rdname ecs_stop_task
ecs_stop_task <- function(cluster = NULL, task, reason = NULL) {
  op <- new_operation(
    name = "StopTask",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecs$stop_task_input(cluster = cluster, task = task, reason = reason)
  output <- .ecs$stop_task_output()
  config <- get_config()
  svc <- .ecs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecs$operations$stop_task <- ecs_stop_task

#' This action is only used by the Amazon ECS agent, and it is not intended
#' for use outside of the agent
#'
#' @description
#' This action is only used by the Amazon ECS agent, and it is not intended for use outside of the agent.
#'
#' See [https://paws-r.github.io/docs/ecs/submit_attachment_state_changes.html](https://paws-r.github.io/docs/ecs/submit_attachment_state_changes.html) for full documentation.
#'
#' @param cluster The short name or full ARN of the cluster that hosts the container
#' instance the attachment belongs to.
#' @param attachments &#91;required&#93; Any attachments associated with the state change request.
#'
#' @keywords internal
#'
#' @rdname ecs_submit_attachment_state_changes
ecs_submit_attachment_state_changes <- function(cluster = NULL, attachments) {
  op <- new_operation(
    name = "SubmitAttachmentStateChanges",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecs$submit_attachment_state_changes_input(cluster = cluster, attachments = attachments)
  output <- .ecs$submit_attachment_state_changes_output()
  config <- get_config()
  svc <- .ecs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecs$operations$submit_attachment_state_changes <- ecs_submit_attachment_state_changes

#' This action is only used by the Amazon ECS agent, and it is not intended
#' for use outside of the agent
#'
#' @description
#' This action is only used by the Amazon ECS agent, and it is not intended for use outside of the agent.
#'
#' See [https://paws-r.github.io/docs/ecs/submit_container_state_change.html](https://paws-r.github.io/docs/ecs/submit_container_state_change.html) for full documentation.
#'
#' @param cluster The short name or full ARN of the cluster that hosts the container.
#' @param task The task ID or full Amazon Resource Name (ARN) of the task that hosts
#' the container.
#' @param containerName The name of the container.
#' @param runtimeId The ID of the Docker container.
#' @param status The status of the state change request.
#' @param exitCode The exit code that's returned for the state change request.
#' @param reason The reason for the state change request.
#' @param networkBindings The network bindings of the container.
#'
#' @keywords internal
#'
#' @rdname ecs_submit_container_state_change
ecs_submit_container_state_change <- function(cluster = NULL, task = NULL, containerName = NULL, runtimeId = NULL, status = NULL, exitCode = NULL, reason = NULL, networkBindings = NULL) {
  op <- new_operation(
    name = "SubmitContainerStateChange",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecs$submit_container_state_change_input(cluster = cluster, task = task, containerName = containerName, runtimeId = runtimeId, status = status, exitCode = exitCode, reason = reason, networkBindings = networkBindings)
  output <- .ecs$submit_container_state_change_output()
  config <- get_config()
  svc <- .ecs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecs$operations$submit_container_state_change <- ecs_submit_container_state_change

#' This action is only used by the Amazon ECS agent, and it is not intended
#' for use outside of the agent
#'
#' @description
#' This action is only used by the Amazon ECS agent, and it is not intended for use outside of the agent.
#'
#' See [https://paws-r.github.io/docs/ecs/submit_task_state_change.html](https://paws-r.github.io/docs/ecs/submit_task_state_change.html) for full documentation.
#'
#' @param cluster The short name or full Amazon Resource Name (ARN) of the cluster that
#' hosts the task.
#' @param task The task ID or full ARN of the task in the state change request.
#' @param status The status of the state change request.
#' @param reason The reason for the state change request.
#' @param containers Any containers that's associated with the state change request.
#' @param attachments Any attachments associated with the state change request.
#' @param managedAgents The details for the managed agent that's associated with the task.
#' @param pullStartedAt The Unix timestamp for the time when the container image pull started.
#' @param pullStoppedAt The Unix timestamp for the time when the container image pull completed.
#' @param executionStoppedAt The Unix timestamp for the time when the task execution stopped.
#'
#' @keywords internal
#'
#' @rdname ecs_submit_task_state_change
ecs_submit_task_state_change <- function(cluster = NULL, task = NULL, status = NULL, reason = NULL, containers = NULL, attachments = NULL, managedAgents = NULL, pullStartedAt = NULL, pullStoppedAt = NULL, executionStoppedAt = NULL) {
  op <- new_operation(
    name = "SubmitTaskStateChange",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecs$submit_task_state_change_input(cluster = cluster, task = task, status = status, reason = reason, containers = containers, attachments = attachments, managedAgents = managedAgents, pullStartedAt = pullStartedAt, pullStoppedAt = pullStoppedAt, executionStoppedAt = executionStoppedAt)
  output <- .ecs$submit_task_state_change_output()
  config <- get_config()
  svc <- .ecs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecs$operations$submit_task_state_change <- ecs_submit_task_state_change

#' Associates the specified tags to a resource with the specified
#' resourceArn
#'
#' @description
#' Associates the specified tags to a resource with the specified `resourceArn`. If existing tags on a resource aren't specified in the request parameters, they aren't changed. When a resource is deleted, the tags that are associated with that resource are deleted as well.
#'
#' See [https://paws-r.github.io/docs/ecs/tag_resource.html](https://paws-r.github.io/docs/ecs/tag_resource.html) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource to add tags to.
#' Currently, the supported resources are Amazon ECS capacity providers,
#' tasks, services, task definitions, clusters, and container instances.
#' @param tags &#91;required&#93; The tags to add to the resource. A tag is an array of key-value pairs.
#' 
#' The following basic restrictions apply to tags:
#' 
#' -   Maximum number of tags per resource - 50
#' 
#' -   For each resource, each tag key must be unique, and each tag key can
#'     have only one value.
#' 
#' -   Maximum key length - 128 Unicode characters in UTF-8
#' 
#' -   Maximum value length - 256 Unicode characters in UTF-8
#' 
#' -   If your tagging schema is used across multiple services and
#'     resources, remember that other services may have restrictions on
#'     allowed characters. Generally allowed characters are: letters,
#'     numbers, and spaces representable in UTF-8, and the following
#'     characters: + - = . _ : / @@.
#' 
#' -   Tag keys and values are case-sensitive.
#' 
#' -   Do not use `aws:`, `AWS:`, or any upper or lowercase combination of
#'     such as a prefix for either keys or values as it is reserved for
#'     Amazon Web Services use. You cannot edit or delete tag keys or
#'     values with this prefix. Tags with this prefix do not count against
#'     your tags per resource limit.
#'
#' @keywords internal
#'
#' @rdname ecs_tag_resource
ecs_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecs$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .ecs$tag_resource_output()
  config <- get_config()
  svc <- .ecs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecs$operations$tag_resource <- ecs_tag_resource

#' Deletes specified tags from a resource
#'
#' @description
#' Deletes specified tags from a resource.
#'
#' See [https://paws-r.github.io/docs/ecs/untag_resource.html](https://paws-r.github.io/docs/ecs/untag_resource.html) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource to delete tags from.
#' Currently, the supported resources are Amazon ECS capacity providers,
#' tasks, services, task definitions, clusters, and container instances.
#' @param tagKeys &#91;required&#93; The keys of the tags to be removed.
#'
#' @keywords internal
#'
#' @rdname ecs_untag_resource
ecs_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecs$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .ecs$untag_resource_output()
  config <- get_config()
  svc <- .ecs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecs$operations$untag_resource <- ecs_untag_resource

#' Modifies the parameters for a capacity provider
#'
#' @description
#' Modifies the parameters for a capacity provider.
#'
#' See [https://paws-r.github.io/docs/ecs/update_capacity_provider.html](https://paws-r.github.io/docs/ecs/update_capacity_provider.html) for full documentation.
#'
#' @param name &#91;required&#93; The name of the capacity provider to update.
#' @param autoScalingGroupProvider &#91;required&#93; An object that represent the parameters to update for the Auto Scaling
#' group capacity provider.
#'
#' @keywords internal
#'
#' @rdname ecs_update_capacity_provider
ecs_update_capacity_provider <- function(name, autoScalingGroupProvider) {
  op <- new_operation(
    name = "UpdateCapacityProvider",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecs$update_capacity_provider_input(name = name, autoScalingGroupProvider = autoScalingGroupProvider)
  output <- .ecs$update_capacity_provider_output()
  config <- get_config()
  svc <- .ecs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecs$operations$update_capacity_provider <- ecs_update_capacity_provider

#' Updates the cluster
#'
#' @description
#' Updates the cluster.
#'
#' See [https://paws-r.github.io/docs/ecs/update_cluster.html](https://paws-r.github.io/docs/ecs/update_cluster.html) for full documentation.
#'
#' @param cluster &#91;required&#93; The name of the cluster to modify the settings for.
#' @param settings The cluster settings for your cluster.
#' @param configuration The execute command configuration for the cluster.
#'
#' @keywords internal
#'
#' @rdname ecs_update_cluster
ecs_update_cluster <- function(cluster, settings = NULL, configuration = NULL) {
  op <- new_operation(
    name = "UpdateCluster",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecs$update_cluster_input(cluster = cluster, settings = settings, configuration = configuration)
  output <- .ecs$update_cluster_output()
  config <- get_config()
  svc <- .ecs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecs$operations$update_cluster <- ecs_update_cluster

#' Modifies the settings to use for a cluster
#'
#' @description
#' Modifies the settings to use for a cluster.
#'
#' See [https://paws-r.github.io/docs/ecs/update_cluster_settings.html](https://paws-r.github.io/docs/ecs/update_cluster_settings.html) for full documentation.
#'
#' @param cluster &#91;required&#93; The name of the cluster to modify the settings for.
#' @param settings &#91;required&#93; The setting to use by default for a cluster. This parameter is used to
#' turn on CloudWatch Container Insights for a cluster. If this value is
#' specified, it overrides the `containerInsights` value set with
#' [`put_account_setting`][ecs_put_account_setting] or
#' [`put_account_setting_default`][ecs_put_account_setting_default].
#'
#' @keywords internal
#'
#' @rdname ecs_update_cluster_settings
ecs_update_cluster_settings <- function(cluster, settings) {
  op <- new_operation(
    name = "UpdateClusterSettings",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecs$update_cluster_settings_input(cluster = cluster, settings = settings)
  output <- .ecs$update_cluster_settings_output()
  config <- get_config()
  svc <- .ecs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecs$operations$update_cluster_settings <- ecs_update_cluster_settings

#' Updates the Amazon ECS container agent on a specified container instance
#'
#' @description
#' Updates the Amazon ECS container agent on a specified container instance. Updating the Amazon ECS container agent doesn't interrupt running tasks or services on the container instance. The process for updating the agent differs depending on whether your container instance was launched with the Amazon ECS-optimized AMI or another operating system.
#'
#' See [https://paws-r.github.io/docs/ecs/update_container_agent.html](https://paws-r.github.io/docs/ecs/update_container_agent.html) for full documentation.
#'
#' @param cluster The short name or full Amazon Resource Name (ARN) of the cluster that
#' your container instance is running on. If you do not specify a cluster,
#' the default cluster is assumed.
#' @param containerInstance &#91;required&#93; The container instance ID or full ARN entries for the container instance
#' where you would like to update the Amazon ECS container agent.
#'
#' @keywords internal
#'
#' @rdname ecs_update_container_agent
ecs_update_container_agent <- function(cluster = NULL, containerInstance) {
  op <- new_operation(
    name = "UpdateContainerAgent",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecs$update_container_agent_input(cluster = cluster, containerInstance = containerInstance)
  output <- .ecs$update_container_agent_output()
  config <- get_config()
  svc <- .ecs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecs$operations$update_container_agent <- ecs_update_container_agent

#' Modifies the status of an Amazon ECS container instance
#'
#' @description
#' Modifies the status of an Amazon ECS container instance.
#'
#' See [https://paws-r.github.io/docs/ecs/update_container_instances_state.html](https://paws-r.github.io/docs/ecs/update_container_instances_state.html) for full documentation.
#'
#' @param cluster The short name or full Amazon Resource Name (ARN) of the cluster that
#' hosts the container instance to update. If you do not specify a cluster,
#' the default cluster is assumed.
#' @param containerInstances &#91;required&#93; A list of up to 10 container instance IDs or full ARN entries.
#' @param status &#91;required&#93; The container instance state to update the container instance with. The
#' only valid values for this action are `ACTIVE` and `DRAINING`. A
#' container instance can only be updated to `DRAINING` status once it has
#' reached an `ACTIVE` state. If a container instance is in `REGISTERING`,
#' `DEREGISTERING`, or `REGISTRATION_FAILED` state you can describe the
#' container instance but can't update the container instance state.
#'
#' @keywords internal
#'
#' @rdname ecs_update_container_instances_state
ecs_update_container_instances_state <- function(cluster = NULL, containerInstances, status) {
  op <- new_operation(
    name = "UpdateContainerInstancesState",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecs$update_container_instances_state_input(cluster = cluster, containerInstances = containerInstances, status = status)
  output <- .ecs$update_container_instances_state_output()
  config <- get_config()
  svc <- .ecs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecs$operations$update_container_instances_state <- ecs_update_container_instances_state

#' Modifies the parameters of a service
#'
#' @description
#' Modifies the parameters of a service.
#'
#' See [https://paws-r.github.io/docs/ecs/update_service.html](https://paws-r.github.io/docs/ecs/update_service.html) for full documentation.
#'
#' @param cluster The short name or full Amazon Resource Name (ARN) of the cluster that
#' your service runs on. If you do not specify a cluster, the default
#' cluster is assumed.
#' @param service &#91;required&#93; The name of the service to update.
#' @param desiredCount The number of instantiations of the task to place and keep running in
#' your service.
#' @param taskDefinition The `family` and `revision` (`family:revision`) or full ARN of the task
#' definition to run in your service. If a `revision` is not specified, the
#' latest `ACTIVE` revision is used. If you modify the task definition with
#' [`update_service`][ecs_update_service], Amazon ECS spawns a task with
#' the new version of the task definition and then stops an old task after
#' the new version is running.
#' @param capacityProviderStrategy The capacity provider strategy to update the service to use.
#' 
#' if the service uses the default capacity provider strategy for the
#' cluster, the service can be updated to use one or more capacity
#' providers as opposed to the default capacity provider strategy. However,
#' when a service is using a capacity provider strategy that's not the
#' default capacity provider strategy, the service can't be updated to use
#' the cluster's default capacity provider strategy.
#' 
#' A capacity provider strategy consists of one or more capacity providers
#' along with the `base` and `weight` to assign to them. A capacity
#' provider must be associated with the cluster to be used in a capacity
#' provider strategy. The
#' [`put_cluster_capacity_providers`][ecs_put_cluster_capacity_providers]
#' API is used to associate a capacity provider with a cluster. Only
#' capacity providers with an `ACTIVE` or `UPDATING` status can be used.
#' 
#' If specifying a capacity provider that uses an Auto Scaling group, the
#' capacity provider must already be created. New capacity providers can be
#' created with the
#' [`create_capacity_provider`][ecs_create_capacity_provider] API
#' operation.
#' 
#' To use a Fargate capacity provider, specify either the `FARGATE` or
#' `FARGATE_SPOT` capacity providers. The Fargate capacity providers are
#' available to all accounts and only need to be associated with a cluster
#' to be used.
#' 
#' The
#' [`put_cluster_capacity_providers`][ecs_put_cluster_capacity_providers]
#' API operation is used to update the list of available capacity providers
#' for a cluster after the cluster is created.
#' @param deploymentConfiguration Optional deployment parameters that control how many tasks run during
#' the deployment and the ordering of stopping and starting tasks.
#' @param networkConfiguration An object representing the network configuration for the service.
#' @param placementConstraints An array of task placement constraint objects to update the service to
#' use. If no value is specified, the existing placement constraints for
#' the service will remain unchanged. If this value is specified, it will
#' override any existing placement constraints defined for the service. To
#' remove all existing placement constraints, specify an empty array.
#' 
#' You can specify a maximum of 10 constraints for each task. This limit
#' includes constraints in the task definition and those specified at
#' runtime.
#' @param placementStrategy The task placement strategy objects to update the service to use. If no
#' value is specified, the existing placement strategy for the service will
#' remain unchanged. If this value is specified, it will override the
#' existing placement strategy defined for the service. To remove an
#' existing placement strategy, specify an empty object.
#' 
#' You can specify a maximum of five strategy rules for each service.
#' @param platformVersion The platform version that your tasks in the service run on. A platform
#' version is only specified for tasks using the Fargate launch type. If a
#' platform version is not specified, the `LATEST` platform version is
#' used. For more information, see [Fargate Platform
#' Versions](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html)
#' in the *Amazon Elastic Container Service Developer Guide*.
#' @param forceNewDeployment Determines whether to force a new deployment of the service. By default,
#' deployments aren't forced. You can use this option to start a new
#' deployment with no service definition changes. For example, you can
#' update a service's tasks to use a newer Docker image with the same
#' image/tag combination (`my_image:latest`) or to roll Fargate tasks onto
#' a newer platform version.
#' @param healthCheckGracePeriodSeconds The period of time, in seconds, that the Amazon ECS service scheduler
#' ignores unhealthy Elastic Load Balancing target health checks after a
#' task has first started. This is only valid if your service is configured
#' to use a load balancer. If your service's tasks take a while to start
#' and respond to Elastic Load Balancing health checks, you can specify a
#' health check grace period of up to 2,147,483,647 seconds. During that
#' time, the Amazon ECS service scheduler ignores the Elastic Load
#' Balancing health check status. This grace period can prevent the ECS
#' service scheduler from marking tasks as unhealthy and stopping them
#' before they have time to come up.
#' @param enableExecuteCommand If `true`, this enables execute command functionality on all task
#' containers.
#' 
#' If you do not want to override the value that was set when the service
#' was created, you can set this to `null` when performing this action.
#' @param enableECSManagedTags Determines whether to turn on Amazon ECS managed tags for the tasks in
#' the service. For more information, see [Tagging Your Amazon ECS
#' Resources](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html)
#' in the *Amazon Elastic Container Service Developer Guide*.
#' 
#' Only tasks launched after the update will reflect the update. To update
#' the tags on all tasks, set `forceNewDeployment` to `true`, so that
#' Amazon ECS starts new tasks with the updated tags.
#' @param loadBalancers A list of Elastic Load Balancing load balancer objects. It contains the
#' load balancer name, the container name, and the container port to access
#' from the load balancer. The container name is as it appears in a
#' container definition.
#' 
#' When you add, update, or remove a load balancer configuration, Amazon
#' ECS starts new tasks with the updated Elastic Load Balancing
#' configuration, and then stops the old tasks when the new tasks are
#' running.
#' 
#' For services that use rolling updates, you can add, update, or remove
#' Elastic Load Balancing target groups. You can update from a single
#' target group to multiple target groups and from multiple target groups
#' to a single target group.
#' 
#' For services that use blue/green deployments, you can update Elastic
#' Load Balancing target groups by using ` CreateDeployment ` through
#' CodeDeploy. Note that multiple target groups are not supported for
#' blue/green deployments. For more information see [Register multiple
#' target groups with a
#' service](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/register-multiple-targetgroups.html)
#' in the *Amazon Elastic Container Service Developer Guide*.
#' 
#' For services that use the external deployment controller, you can add,
#' update, or remove load balancers by using
#' [`create_task_set`][ecs_create_task_set]. Note that multiple target
#' groups are not supported for external deployments. For more information
#' see [Register multiple target groups with a
#' service](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/register-multiple-targetgroups.html)
#' in the *Amazon Elastic Container Service Developer Guide*.
#' 
#' You can remove existing `loadBalancers` by passing an empty list.
#' @param propagateTags Determines whether to propagate the tags from the task definition or the
#' service to the task. If no value is specified, the tags aren't
#' propagated.
#' 
#' Only tasks launched after the update will reflect the update. To update
#' the tags on all tasks, set `forceNewDeployment` to `true`, so that
#' Amazon ECS starts new tasks with the updated tags.
#' @param serviceRegistries The details for the service discovery registries to assign to this
#' service. For more information, see [Service
#' Discovery](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html).
#' 
#' When you add, update, or remove the service registries configuration,
#' Amazon ECS starts new tasks with the updated service registries
#' configuration, and then stops the old tasks when the new tasks are
#' running.
#' 
#' You can remove existing `serviceRegistries` by passing an empty list.
#'
#' @keywords internal
#'
#' @rdname ecs_update_service
ecs_update_service <- function(cluster = NULL, service, desiredCount = NULL, taskDefinition = NULL, capacityProviderStrategy = NULL, deploymentConfiguration = NULL, networkConfiguration = NULL, placementConstraints = NULL, placementStrategy = NULL, platformVersion = NULL, forceNewDeployment = NULL, healthCheckGracePeriodSeconds = NULL, enableExecuteCommand = NULL, enableECSManagedTags = NULL, loadBalancers = NULL, propagateTags = NULL, serviceRegistries = NULL) {
  op <- new_operation(
    name = "UpdateService",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecs$update_service_input(cluster = cluster, service = service, desiredCount = desiredCount, taskDefinition = taskDefinition, capacityProviderStrategy = capacityProviderStrategy, deploymentConfiguration = deploymentConfiguration, networkConfiguration = networkConfiguration, placementConstraints = placementConstraints, placementStrategy = placementStrategy, platformVersion = platformVersion, forceNewDeployment = forceNewDeployment, healthCheckGracePeriodSeconds = healthCheckGracePeriodSeconds, enableExecuteCommand = enableExecuteCommand, enableECSManagedTags = enableECSManagedTags, loadBalancers = loadBalancers, propagateTags = propagateTags, serviceRegistries = serviceRegistries)
  output <- .ecs$update_service_output()
  config <- get_config()
  svc <- .ecs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecs$operations$update_service <- ecs_update_service

#' Modifies which task set in a service is the primary task set
#'
#' @description
#' Modifies which task set in a service is the primary task set. Any parameters that are updated on the primary task set in a service will transition to the service. This is used when a service uses the `EXTERNAL` deployment controller type. For more information, see [Amazon ECS Deployment Types](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html) in the *Amazon Elastic Container Service Developer Guide*.
#'
#' See [https://paws-r.github.io/docs/ecs/update_service_primary_task_set.html](https://paws-r.github.io/docs/ecs/update_service_primary_task_set.html) for full documentation.
#'
#' @param cluster &#91;required&#93; The short name or full Amazon Resource Name (ARN) of the cluster that
#' hosts the service that the task set exists in.
#' @param service &#91;required&#93; The short name or full Amazon Resource Name (ARN) of the service that
#' the task set exists in.
#' @param primaryTaskSet &#91;required&#93; The short name or full Amazon Resource Name (ARN) of the task set to set
#' as the primary task set in the deployment.
#'
#' @keywords internal
#'
#' @rdname ecs_update_service_primary_task_set
ecs_update_service_primary_task_set <- function(cluster, service, primaryTaskSet) {
  op <- new_operation(
    name = "UpdateServicePrimaryTaskSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecs$update_service_primary_task_set_input(cluster = cluster, service = service, primaryTaskSet = primaryTaskSet)
  output <- .ecs$update_service_primary_task_set_output()
  config <- get_config()
  svc <- .ecs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecs$operations$update_service_primary_task_set <- ecs_update_service_primary_task_set

#' Modifies a task set
#'
#' @description
#' Modifies a task set. This is used when a service uses the `EXTERNAL` deployment controller type. For more information, see [Amazon ECS Deployment Types](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html) in the *Amazon Elastic Container Service Developer Guide*.
#'
#' See [https://paws-r.github.io/docs/ecs/update_task_set.html](https://paws-r.github.io/docs/ecs/update_task_set.html) for full documentation.
#'
#' @param cluster &#91;required&#93; The short name or full Amazon Resource Name (ARN) of the cluster that
#' hosts the service that the task set is found in.
#' @param service &#91;required&#93; The short name or full Amazon Resource Name (ARN) of the service that
#' the task set is found in.
#' @param taskSet &#91;required&#93; The short name or full Amazon Resource Name (ARN) of the task set to
#' update.
#' @param scale &#91;required&#93; A floating-point percentage of the desired number of tasks to place and
#' keep running in the task set.
#'
#' @keywords internal
#'
#' @rdname ecs_update_task_set
ecs_update_task_set <- function(cluster, service, taskSet, scale) {
  op <- new_operation(
    name = "UpdateTaskSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecs$update_task_set_input(cluster = cluster, service = service, taskSet = taskSet, scale = scale)
  output <- .ecs$update_task_set_output()
  config <- get_config()
  svc <- .ecs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecs$operations$update_task_set <- ecs_update_task_set
