% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_get_instance_access_details}
\alias{lightsail_get_instance_access_details}
\title{Returns temporary SSH keys you can use to connect to a specific virtual
private server, or \emph{instance}}
\usage{
lightsail_get_instance_access_details(instanceName, protocol)
}
\arguments{
\item{instanceName}{[required] The name of the instance to access.}

\item{protocol}{The protocol to use to connect to your instance. Defaults to \code{ssh}.}
}
\description{
Returns temporary SSH keys you can use to connect to a specific virtual
private server, or \emph{instance}.
}
\details{
The \verb{get instance access details} operation supports tag-based access
control via resource tags applied to the resource identified by
\verb{instance name}. For more information, see the \href{https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags}{Lightsail Dev Guide}.
}
\section{Request syntax}{
\preformatted{svc$get_instance_access_details(
  instanceName = "string",
  protocol = "ssh"|"rdp"
)
}
}

\keyword{internal}
