% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs_operations.R
\name{ecs_tag_resource}
\alias{ecs_tag_resource}
\title{Associates the specified tags to a resource with the specified
resourceArn}
\usage{
ecs_tag_resource(resourceArn, tags)
}
\arguments{
\item{resourceArn}{[required] The Amazon Resource Name (ARN) of the resource to which to add tags.
Currently, the supported resources are Amazon ECS capacity providers,
tasks, services, task definitions, clusters, and container instances.}

\item{tags}{[required] The tags to add to the resource. A tag is an array of key-value pairs.

The following basic restrictions apply to tags:
\itemize{
\item Maximum number of tags per resource - 50
\item For each resource, each tag key must be unique, and each tag key can
have only one value.
\item Maximum key length - 128 Unicode characters in UTF-8
\item Maximum value length - 256 Unicode characters in UTF-8
\item If your tagging schema is used across multiple services and
resources, remember that other services may have restrictions on
allowed characters. Generally allowed characters are: letters,
numbers, and spaces representable in UTF-8, and the following
characters: + - = . \\_ : / @.
\item Tag keys and values are case-sensitive.
\item Do not use \verb{aws:}, \verb{AWS:}, or any upper or lowercase combination of
such as a prefix for either keys or values as it is reserved for AWS
use. You cannot edit or delete tag keys or values with this prefix.
Tags with this prefix do not count against your tags per resource
limit.
}}
}
\description{
Associates the specified tags to a resource with the specified
\code{resourceArn}. If existing tags on a resource are not specified in the
request parameters, they are not changed. When a resource is deleted,
the tags associated with that resource are deleted as well.
}
\section{Request syntax}{
\preformatted{svc$tag_resource(
  resourceArn = "string",
  tags = list(
    list(
      key = "string",
      value = "string"
    )
  )
)
}
}

\examples{
\dontrun{
# This example tags the 'dev' cluster with key 'team' and value 'dev'.
svc$tag_resource(
  resourceArn = "arn:aws:ecs:region:aws_account_id:cluster/dev",
  tags = list(
    list(
      key = "team",
      value = "dev"
    )
  )
)
}

}
\keyword{internal}
