% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticbeanstalk_operations.R
\name{elasticbeanstalk_retrieve_environment_info}
\alias{elasticbeanstalk_retrieve_environment_info}
\title{Retrieves the compiled information from a RequestEnvironmentInfo request}
\usage{
elasticbeanstalk_retrieve_environment_info(EnvironmentId,
  EnvironmentName, InfoType)
}
\arguments{
\item{EnvironmentId}{The ID of the data\'s environment.

If no such environment is found, returns an \code{InvalidParameterValue}
error.

Condition: You must specify either this or an EnvironmentName, or both.
If you do not specify either, AWS Elastic Beanstalk returns
\code{MissingRequiredParameter} error.}

\item{EnvironmentName}{The name of the data\'s environment.

If no such environment is found, returns an \code{InvalidParameterValue}
error.

Condition: You must specify either this or an EnvironmentId, or both. If
you do not specify either, AWS Elastic Beanstalk returns
\code{MissingRequiredParameter} error.}

\item{InfoType}{[required] The type of information to retrieve.}
}
\description{
Retrieves the compiled information from a RequestEnvironmentInfo
request.
}
\details{
Related Topics
\itemize{
\item RequestEnvironmentInfo
}
}
\section{Request syntax}{
\preformatted{svc$retrieve_environment_info(
  EnvironmentId = "string",
  EnvironmentName = "string",
  InfoType = "tail"|"bundle"
)
}
}

\examples{
# The following operation retrieves a link to logs from an environment
# named my-env:
\dontrun{svc$retrieve_environment_info(
  EnvironmentName = "my-env",
  InfoType = "tail"
)}

}
\keyword{internal}
