# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service
NULL

#' AWS EC2 Instance Connect
#'
#' @description
#' AWS EC2 Connect Service is a service that enables system administrators
#' to publish temporary SSH keys to their EC2 instances in order to
#' establish connections to their instances without leaving a permanent
#' authentication option.
#'
#' @examples
#' # The following example pushes a sample SSH public key to the EC2 instance
#' # i-abcd1234 in AZ us-west-2b for use by the instance OS user ec2-user.
#' \donttest{svc <- ec2instanceconnect()
#' svc$send_ssh_public_key(
#'   AvailabilityZone = "us-west-2a",
#'   InstanceId = "i-abcd1234",
#'   InstanceOSUser = "ec2-user",
#'   SSHPublicKey = "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQC3FlHqj2eqCdrGHuA6dRjfZXQ4HX5lXEIRHa..."
#' )}
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=ec2instanceconnect_send_ssh_public_key]{send_ssh_public_key} \tab Pushes an SSH public key to a particular OS user on a given EC2 instance for 60 seconds
#' }
#'
#' @rdname ec2instanceconnect
#' @export
ec2instanceconnect <- function() {
  .ec2instanceconnect$operations
}

# Private API objects: metadata, handlers, interfaces, etc.
.ec2instanceconnect <- list()

.ec2instanceconnect$operations <- list()

.ec2instanceconnect$metadata <- list(
  service_name = "ec2instanceconnect",
  endpoints = list("*" = list(endpoint = "ec2instanceconnect.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "ec2instanceconnect.{region}.amazonaws.com.cn", global = FALSE)),
  service_id = "EC2 Instance Connect",
  api_version = "2018-04-02",
  signing_name = NULL,
  json_version = "1.1",
  target_prefix = "AWSEC2InstanceConnectService"
)

.ec2instanceconnect$handlers <- new_handlers("jsonrpc", "v4")

.ec2instanceconnect$service <- function() {
  new_service(.ec2instanceconnect$metadata, .ec2instanceconnect$handlers)
}
