% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_spot_fleet_request_history}
\alias{ec2_describe_spot_fleet_request_history}
\title{Describes the events for the specified Spot Fleet request during the
specified time}
\usage{
ec2_describe_spot_fleet_request_history(DryRun, EventType, MaxResults,
  NextToken, SpotFleetRequestId, StartTime)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{EventType}{The type of events to describe. By default, all events are described.}

\item{MaxResults}{The maximum number of results to return in a single call. Specify a
value between 1 and 1000. The default value is 1000. To retrieve the
remaining results, make another call with the returned \code{NextToken}
value.}

\item{NextToken}{The token for the next set of results.}

\item{SpotFleetRequestId}{[required] The ID of the Spot Fleet request.}

\item{StartTime}{[required] The starting date and time for the events, in UTC format (for example,
\emph{YYYY}-\emph{MM}-\emph{DD}T\emph{HH}:\emph{MM}:\emph{SS}Z).}
}
\value{
A list with the following syntax:\preformatted{list(
  HistoryRecords = list(
    list(
      EventInformation = list(
        EventDescription = "string",
        EventSubType = "string",
        InstanceId = "string"
      ),
      EventType = "instanceChange"|"fleetRequestChange"|"error"|"information",
      Timestamp = as.POSIXct(
        "2015-01-01"
      )
    )
  ),
  LastEvaluatedTime = as.POSIXct(
    "2015-01-01"
  ),
  NextToken = "string",
  SpotFleetRequestId = "string",
  StartTime = as.POSIXct(
    "2015-01-01"
  )
)
}
}
\description{
Describes the events for the specified Spot Fleet request during the
specified time.

Spot Fleet events are delayed by up to 30 seconds before they can be
described. This ensures that you can query by the last evaluated time
and not miss a recorded event. Spot Fleet events are available for 48
hours.
}
\section{Request syntax}{
\preformatted{svc$describe_spot_fleet_request_history(
  DryRun = TRUE|FALSE,
  EventType = "instanceChange"|"fleetRequestChange"|"error"|"information",
  MaxResults = 123,
  NextToken = "string",
  SpotFleetRequestId = "string",
  StartTime = as.POSIXct(
    "2015-01-01"
  )
)
}
}

\examples{
\dontrun{
# This example returns the history for the specified Spot fleet starting
# at the specified time.
svc$describe_spot_fleet_request_history(
  SpotFleetRequestId = "sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE",
  StartTime = "2015-05-26T00:00:00Z"
)
}

}
\keyword{internal}
