% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_accept_vpc_peering_connection}
\alias{ec2_accept_vpc_peering_connection}
\title{Accept a VPC peering connection request}
\usage{
ec2_accept_vpc_peering_connection(DryRun, VpcPeeringConnectionId)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{VpcPeeringConnectionId}{The ID of the VPC peering connection. You must specify this parameter in
the request.}
}
\value{
A list with the following syntax:\preformatted{list(
  VpcPeeringConnection = list(
    AccepterVpcInfo = list(
      CidrBlock = "string",
      Ipv6CidrBlockSet = list(
        list(
          Ipv6CidrBlock = "string"
        )
      ),
      CidrBlockSet = list(
        list(
          CidrBlock = "string"
        )
      ),
      OwnerId = "string",
      PeeringOptions = list(
        AllowDnsResolutionFromRemoteVpc = TRUE|FALSE,
        AllowEgressFromLocalClassicLinkToRemoteVpc = TRUE|FALSE,
        AllowEgressFromLocalVpcToRemoteClassicLink = TRUE|FALSE
      ),
      VpcId = "string",
      Region = "string"
    ),
    ExpirationTime = as.POSIXct(
      "2015-01-01"
    ),
    RequesterVpcInfo = list(
      CidrBlock = "string",
      Ipv6CidrBlockSet = list(
        list(
          Ipv6CidrBlock = "string"
        )
      ),
      CidrBlockSet = list(
        list(
          CidrBlock = "string"
        )
      ),
      OwnerId = "string",
      PeeringOptions = list(
        AllowDnsResolutionFromRemoteVpc = TRUE|FALSE,
        AllowEgressFromLocalClassicLinkToRemoteVpc = TRUE|FALSE,
        AllowEgressFromLocalVpcToRemoteClassicLink = TRUE|FALSE
      ),
      VpcId = "string",
      Region = "string"
    ),
    Status = list(
      Code = "initiating-request"|"pending-acceptance"|"active"|"deleted"|"rejected"|"failed"|"expired"|"provisioning"|"deleting",
      Message = "string"
    ),
    Tags = list(
      list(
        Key = "string",
        Value = "string"
      )
    ),
    VpcPeeringConnectionId = "string"
  )
)
}
}
\description{
Accept a VPC peering connection request. To accept a request, the VPC
peering connection must be in the \code{pending-acceptance} state, and you
must be the owner of the peer VPC. Use
\code{\link[=ec2_describe_vpc_peering_connections]{describe_vpc_peering_connections}}
to view your outstanding VPC peering connection requests.

For an inter-Region VPC peering connection request, you must accept the
VPC peering connection in the Region of the accepter VPC.
}
\section{Request syntax}{
\preformatted{svc$accept_vpc_peering_connection(
  DryRun = TRUE|FALSE,
  VpcPeeringConnectionId = "string"
)
}
}

\keyword{internal}
