% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_update_security_group_rule_descriptions_ingress}
\alias{ec2_update_security_group_rule_descriptions_ingress}
\title{Updates the description of an ingress (inbound) security group rule}
\usage{
ec2_update_security_group_rule_descriptions_ingress(DryRun, GroupId,
  GroupName, IpPermissions)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{GroupId}{The ID of the security group. You must specify either the security group
ID or the security group name in the request. For security groups in a
nondefault VPC, you must specify the security group ID.}

\item{GroupName}{[EC2-Classic, default VPC] The name of the security group. You must
specify either the security group ID or the security group name in the
request.}

\item{IpPermissions}{[required] The IP permissions for the security group rule.}
}
\value{
A list with the following syntax:\preformatted{list(
  Return = TRUE|FALSE
)
}
}
\description{
Updates the description of an ingress (inbound) security group rule. You
can replace an existing description, or add a description to a rule that
did not have one previously.

You specify the description as part of the IP permissions structure. You
can remove a description for a security group rule by omitting the
description parameter in the request.
}
\section{Request syntax}{
\preformatted{svc$update_security_group_rule_descriptions_ingress(
  DryRun = TRUE|FALSE,
  GroupId = "string",
  GroupName = "string",
  IpPermissions = list(
    list(
      FromPort = 123,
      IpProtocol = "string",
      IpRanges = list(
        list(
          CidrIp = "string",
          Description = "string"
        )
      ),
      Ipv6Ranges = list(
        list(
          CidrIpv6 = "string",
          Description = "string"
        )
      ),
      PrefixListIds = list(
        list(
          Description = "string",
          PrefixListId = "string"
        )
      ),
      ToPort = 123,
      UserIdGroupPairs = list(
        list(
          Description = "string",
          GroupId = "string",
          GroupName = "string",
          PeeringStatus = "string",
          UserId = "string",
          VpcId = "string",
          VpcPeeringConnectionId = "string"
        )
      )
    )
  )
)
}
}

\examples{
\dontrun{
# This example updates the description for the specified security group
# rule.
svc$update_security_group_rule_descriptions_ingress(
  GroupId = "sg-123abc12",
  IpPermissions = list(
    list(
      FromPort = 22L,
      IpProtocol = "tcp",
      IpRanges = list(
        list(
          CidrIp = "203.0.113.0/16",
          Description = "SSH access from the LA office"
        )
      ),
      ToPort = 22L
    )
  )
)
}

}
\keyword{internal}
