% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_associate_enclave_certificate_iam_role}
\alias{ec2_associate_enclave_certificate_iam_role}
\title{Associates an AWS Identity and Access Management (IAM) role with an AWS
Certificate Manager (ACM) certificate}
\usage{
ec2_associate_enclave_certificate_iam_role(CertificateArn, RoleArn,
  DryRun)
}
\arguments{
\item{CertificateArn}{The ARN of the ACM certificate with which to associate the IAM role.}

\item{RoleArn}{The ARN of the IAM role to associate with the ACM certificate. You can
associate up to 16 IAM roles with an ACM certificate.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\value{
A list with the following syntax:\preformatted{list(
  CertificateS3BucketName = "string",
  CertificateS3ObjectKey = "string",
  EncryptionKmsKeyId = "string"
)
}
}
\description{
Associates an AWS Identity and Access Management (IAM) role with an AWS
Certificate Manager (ACM) certificate. This enables the certificate to
be used by the ACM for Nitro Enclaves application inside an enclave. For
more information, see \href{https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave-refapp.html}{AWS Certificate Manager for Nitro Enclaves}
in the \emph{AWS Nitro Enclaves User Guide}.

When the IAM role is associated with the ACM certificate, places the
certificate, certificate chain, and encrypted private key in an Amazon
S3 bucket that only the associated IAM role can access. The private key
of the certificate is encrypted with an AWS-managed KMS customer master
(CMK) that has an attached attestation-based CMK policy.

To enable the IAM role to access the Amazon S3 object, you must grant it
permission to call \code{s3:GetObject} on the Amazon S3 bucket returned by
the command. To enable the IAM role to access the AWS KMS CMK, you must
grant it permission to call \code{kms:Decrypt} on AWS KMS CMK returned by the
command. For more information, see \href{https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave-refapp.html#add-policy}{Grant the role permission to access the certificate and encryption key}
in the \emph{AWS Nitro Enclaves User Guide}.
}
\section{Request syntax}{
\preformatted{svc$associate_enclave_certificate_iam_role(
  CertificateArn = "string",
  RoleArn = "string",
  DryRun = TRUE|FALSE
)
}
}

\keyword{internal}
