% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_operations.R
\name{lambda_list_event_source_mappings}
\alias{lambda_list_event_source_mappings}
\title{Lists event source mappings}
\usage{
lambda_list_event_source_mappings(EventSourceArn, FunctionName, Marker,
  MaxItems)
}
\arguments{
\item{EventSourceArn}{The Amazon Resource Name (ARN) of the event source.
\itemize{
\item \strong{Amazon Kinesis} - The ARN of the data stream or a stream
consumer.
\item \strong{Amazon DynamoDB Streams} - The ARN of the stream.
\item \strong{Amazon Simple Queue Service} - The ARN of the queue.
\item \strong{Amazon Managed Streaming for Apache Kafka} - The ARN of the
cluster.
}}

\item{FunctionName}{The name of the Lambda function.

\strong{Name formats}
\itemize{
\item \strong{Function name} - \code{MyFunction}.
\item \strong{Function ARN} -
\verb{arn:aws:lambda:us-west-2:123456789012:function:MyFunction}.
\item \strong{Version or Alias ARN} -
\verb{arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD}.
\item \strong{Partial ARN} - \verb{123456789012:function:MyFunction}.
}

The length constraint applies only to the full ARN. If you specify only
the function name, it's limited to 64 characters in length.}

\item{Marker}{A pagination token returned by a previous call.}

\item{MaxItems}{The maximum number of event source mappings to return.}
}
\value{
A list with the following syntax:\preformatted{list(
  NextMarker = "string",
  EventSourceMappings = list(
    list(
      UUID = "string",
      StartingPosition = "TRIM_HORIZON"|"LATEST"|"AT_TIMESTAMP",
      StartingPositionTimestamp = as.POSIXct(
        "2015-01-01"
      ),
      BatchSize = 123,
      MaximumBatchingWindowInSeconds = 123,
      ParallelizationFactor = 123,
      EventSourceArn = "string",
      FunctionArn = "string",
      LastModified = as.POSIXct(
        "2015-01-01"
      ),
      LastProcessingResult = "string",
      State = "string",
      StateTransitionReason = "string",
      DestinationConfig = list(
        OnSuccess = list(
          Destination = "string"
        ),
        OnFailure = list(
          Destination = "string"
        )
      ),
      Topics = list(
        "string"
      ),
      Queues = list(
        "string"
      ),
      SourceAccessConfigurations = list(
        list(
          Type = "BASIC_AUTH"|"VPC_SUBNET"|"VPC_SECURITY_GROUP"|"SASL_SCRAM_512_AUTH"|"SASL_SCRAM_256_AUTH",
          URI = "string"
        )
      ),
      SelfManagedEventSource = list(
        Endpoints = list(
          list(
            "string"
          )
        )
      ),
      MaximumRecordAgeInSeconds = 123,
      BisectBatchOnFunctionError = TRUE|FALSE,
      MaximumRetryAttempts = 123,
      TumblingWindowInSeconds = 123,
      FunctionResponseTypes = list(
        "ReportBatchItemFailures"
      )
    )
  )
)
}
}
\description{
Lists event source mappings. Specify an \code{EventSourceArn} to only show
event source mappings for a single event source.
}
\section{Request syntax}{
\preformatted{svc$list_event_source_mappings(
  EventSourceArn = "string",
  FunctionName = "string",
  Marker = "string",
  MaxItems = 123
)
}
}

\examples{
\dontrun{
# The following example returns a list of the event source mappings for a
# function named my-function.
svc$list_event_source_mappings(
  FunctionName = "my-function"
)
}

}
\keyword{internal}
