% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticbeanstalk_operations.R
\name{elasticbeanstalk_rebuild_environment}
\alias{elasticbeanstalk_rebuild_environment}
\title{Deletes and recreates all of the AWS resources (for example: the Auto
Scaling group, load balancer, etc}
\usage{
elasticbeanstalk_rebuild_environment(EnvironmentId, EnvironmentName)
}
\arguments{
\item{EnvironmentId}{The ID of the environment to rebuild.

Condition: You must specify either this or an EnvironmentName, or both.
If you do not specify either, AWS Elastic Beanstalk returns
\code{MissingRequiredParameter} error.}

\item{EnvironmentName}{The name of the environment to rebuild.

Condition: You must specify either this or an EnvironmentId, or both. If
you do not specify either, AWS Elastic Beanstalk returns
\code{MissingRequiredParameter} error.}
}
\description{
Deletes and recreates all of the AWS resources (for example: the Auto
Scaling group, load balancer, etc.) for a specified environment and
forces a restart.
}
\section{Request syntax}{
\preformatted{svc$rebuild_environment(
  EnvironmentId = "string",
  EnvironmentName = "string"
)
}
}

\examples{
\dontrun{
# The following operation terminates and recreates the resources in an
# environment named my-env:
svc$rebuild_environment(
  EnvironmentName = "my-env"
)
}

}
\keyword{internal}
