% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_copy_snapshot}
\alias{ec2_copy_snapshot}
\title{Copies a point-in-time snapshot of an EBS volume and stores it in Amazon
S3}
\usage{
ec2_copy_snapshot(Description, DestinationRegion, Encrypted, KmsKeyId,
  PresignedUrl, SourceRegion, SourceSnapshotId, DryRun)
}
\arguments{
\item{Description}{A description for the EBS snapshot.}

\item{DestinationRegion}{The destination Region to use in the \code{PresignedUrl} parameter of a
snapshot copy operation. This parameter is only valid for specifying the
destination Region in a \code{PresignedUrl} parameter, where it is required.

The snapshot copy is sent to the regional endpoint that you sent the
HTTP request to (for example, \code{ec2.us-east-1.amazonaws.com}). With the
AWS CLI, this is specified using the \code{--region} parameter or the default
Region in your AWS configuration file.}

\item{Encrypted}{Specifies whether the destination snapshot should be encrypted. You can
encrypt a copy of an unencrypted snapshot, but you cannot use it to
create an unencrypted copy of an encrypted snapshot. Your default CMK
for EBS is used unless you specify a non-default AWS Key Management
Service (AWS KMS) CMK using \code{KmsKeyId}. For more information, see
\href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html}{Amazon EBS Encryption}
in the \emph{Amazon Elastic Compute Cloud User Guide}.}

\item{KmsKeyId}{An identifier for the AWS Key Management Service (AWS KMS) customer
master key (CMK) to use when creating the encrypted volume. This
parameter is only required if you want to use a non-default CMK; if this
parameter is not specified, the default CMK for EBS is used. If a
\code{KmsKeyId} is specified, the \code{Encrypted} flag must also be set.

The CMK identifier may be provided in any of the following formats:
\itemize{
\item Key ID
\item Key alias
\item ARN using key ID. The ID ARN contains the \code{arn:aws:kms} namespace,
followed by the region of the CMK, the AWS account ID of the CMK
owner, the \code{key} namespace, and then the CMK ID. For example,
arn:aws:kms:\emph{us-east-1}:\emph{012345678910}:key/\emph{abcd1234-a123-456a-a12b-a123b4cd56ef}.
\item ARN using key alias. The alias ARN contains the \code{arn:aws:kms}
namespace, followed by the region of the CMK, the AWS account ID of
the CMK owner, the \code{alias} namespace, and then the CMK alias. For
example,
arn:aws:kms:\emph{us-east-1}:\emph{012345678910}:alias/\emph{ExampleAlias}.
}

AWS parses \code{KmsKeyId} asynchronously, meaning that the action you call
may appear to complete even though you provided an invalid identifier.
The action will eventually fail.}

\item{PresignedUrl}{When you copy an encrypted source snapshot using the Amazon EC2 Query
API, you must supply a pre-signed URL. This parameter is optional for
unencrypted snapshots. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html}{Query Requests}.

The \code{PresignedUrl} should use the snapshot source endpoint, the
\code{CopySnapshot} action, and include the \code{SourceRegion},
\code{SourceSnapshotId}, and \code{DestinationRegion} parameters. The
\code{PresignedUrl} must be signed using AWS Signature Version 4. Because EBS
snapshots are stored in Amazon S3, the signing algorithm for this
parameter uses the same logic that is described in \href{https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html}{Authenticating Requests by Using Query Parameters (AWS Signature Version 4)}
in the \emph{Amazon Simple Storage Service API Reference}. An invalid or
improperly signed \code{PresignedUrl} will cause the copy operation to fail
asynchronously, and the snapshot will move to an \code{error} state.}

\item{SourceRegion}{[required] The ID of the Region that contains the snapshot to be copied.}

\item{SourceSnapshotId}{[required] The ID of the EBS snapshot to copy.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Copies a point-in-time snapshot of an EBS volume and stores it in Amazon
S3. You can copy the snapshot within the same Region or from one Region
to another. You can use the snapshot to create EBS volumes or Amazon
Machine Images (AMIs). The snapshot is copied to the regional endpoint
that you send the HTTP request to.
}
\details{
Copies of encrypted EBS snapshots remain encrypted. Copies of
unencrypted snapshots remain unencrypted, unless the \code{Encrypted} flag is
specified during the snapshot copy operation. By default, encrypted
snapshot copies use the default AWS Key Management Service (AWS KMS)
customer master key (CMK); however, you can specify a non-default CMK
with the \code{KmsKeyId} parameter.

To copy an encrypted snapshot that has been shared from another account,
you must have permissions for the CMK used to encrypt the snapshot.

Snapshots created by copying another snapshot have an arbitrary volume
ID that should not be used for any purpose.

For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-copy-snapshot.html}{Copying an Amazon EBS Snapshot}
in the \emph{Amazon Elastic Compute Cloud User Guide}.
}
\section{Request syntax}{
\preformatted{svc$copy_snapshot(
  Description = "string",
  DestinationRegion = "string",
  Encrypted = TRUE|FALSE,
  KmsKeyId = "string",
  PresignedUrl = "string",
  SourceRegion = "string",
  SourceSnapshotId = "string",
  DryRun = TRUE|FALSE
)
}
}

\examples{
# This example copies a snapshot with the snapshot ID of
# ``snap-066877671789bd71b`` from the ``us-west-2`` region to the
# ``us-east-1`` region and adds a short description to identify the
# snapshot.
\donttest{svc$copy_snapshot(
  Description = "This is my copied snapshot.",
  DestinationRegion = "us-east-1",
  SourceRegion = "us-west-2",
  SourceSnapshotId = "snap-066877671789bd71b"
)}

}
\keyword{internal}
