% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfn_operations.R
\name{sfn_get_activity_task}
\alias{sfn_get_activity_task}
\title{Used by workers to retrieve a task (with the specified activity ARN)
which has been scheduled for execution by a running state machine}
\usage{
sfn_get_activity_task(activityArn, workerName = NULL)
}
\arguments{
\item{activityArn}{[required] The Amazon Resource Name (ARN) of the activity to retrieve tasks from
(assigned when you create the task using
\code{\link[=sfn_create_activity]{create_activity}}.)}

\item{workerName}{You can provide an arbitrary name in order to identify the worker that
the task is assigned to. This name is used when it is logged in the
execution history.}
}
\description{
Used by workers to retrieve a task (with the specified activity ARN) which has been scheduled for execution by a running state machine. This initiates a long poll, where the service holds the HTTP connection open and responds as soon as a task becomes available (i.e. an execution of a task of this type is needed.) The maximum time the service holds on to the request before responding is 60 seconds. If no task is available within 60 seconds, the poll returns a \code{taskToken} with a null string.

See \url{https://www.paws-r-sdk.com/docs/sfn_get_activity_task/} for full documentation.
}
\keyword{internal}
