# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include resourceexplorer_service.R
NULL

#' Sets the specified view as the default for the Amazon Web Services
#' Region in which you call this operation
#'
#' @description
#' Sets the specified view as the default for the Amazon Web Services Region in which you call this operation. When a user performs a [`search`][resourceexplorer_search] that doesn't explicitly specify which view to use, then Amazon Web Services Resource Explorer automatically chooses this default view for searches performed in this Amazon Web Services Region.
#'
#' See [https://www.paws-r-sdk.com/docs/resourceexplorer_associate_default_view/](https://www.paws-r-sdk.com/docs/resourceexplorer_associate_default_view/) for full documentation.
#'
#' @param ViewArn &#91;required&#93; The [Amazon resource name
#' (ARN)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' of the view to set as the default for the Amazon Web Services Region and
#' Amazon Web Services account in which you call this operation. The
#' specified view must already exist in the called Region.
#'
#' @keywords internal
#'
#' @rdname resourceexplorer_associate_default_view
resourceexplorer_associate_default_view <- function(ViewArn) {
  op <- new_operation(
    name = "AssociateDefaultView",
    http_method = "POST",
    http_path = "/AssociateDefaultView",
    host_prefix = "",
    paginator = list()
  )
  input <- .resourceexplorer$associate_default_view_input(ViewArn = ViewArn)
  output <- .resourceexplorer$associate_default_view_output()
  config <- get_config()
  svc <- .resourceexplorer$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resourceexplorer$operations$associate_default_view <- resourceexplorer_associate_default_view

#' Retrieves details about a list of views
#'
#' @description
#' Retrieves details about a list of views.
#'
#' See [https://www.paws-r-sdk.com/docs/resourceexplorer_batch_get_view/](https://www.paws-r-sdk.com/docs/resourceexplorer_batch_get_view/) for full documentation.
#'
#' @param ViewArns A list of [Amazon resource names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' that identify the views you want details for.
#'
#' @keywords internal
#'
#' @rdname resourceexplorer_batch_get_view
resourceexplorer_batch_get_view <- function(ViewArns = NULL) {
  op <- new_operation(
    name = "BatchGetView",
    http_method = "POST",
    http_path = "/BatchGetView",
    host_prefix = "",
    paginator = list()
  )
  input <- .resourceexplorer$batch_get_view_input(ViewArns = ViewArns)
  output <- .resourceexplorer$batch_get_view_output()
  config <- get_config()
  svc <- .resourceexplorer$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resourceexplorer$operations$batch_get_view <- resourceexplorer_batch_get_view

#' Turns on Amazon Web Services Resource Explorer in the Amazon Web
#' Services Region in which you called this operation by creating an index
#'
#' @description
#' Turns on Amazon Web Services Resource Explorer in the Amazon Web Services Region in which you called this operation by creating an index. Resource Explorer begins discovering the resources in this Region and stores the details about the resources in the index so that they can be queried by using the [`search`][resourceexplorer_search] operation. You can create only one index in a Region.
#'
#' See [https://www.paws-r-sdk.com/docs/resourceexplorer_create_index/](https://www.paws-r-sdk.com/docs/resourceexplorer_create_index/) for full documentation.
#'
#' @param ClientToken This value helps ensure idempotency. Resource Explorer uses this value
#' to prevent the accidental creation of duplicate versions. We recommend
#' that you generate a [UUID-type
#' value](https://en.wikipedia.org/wiki/Universally_unique_identifier) to
#' ensure the uniqueness of your index.
#' @param Tags The specified tags are attached only to the index created in this Amazon
#' Web Services Region. The tags aren't attached to any of the resources
#' listed in the index.
#'
#' @keywords internal
#'
#' @rdname resourceexplorer_create_index
resourceexplorer_create_index <- function(ClientToken = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateIndex",
    http_method = "POST",
    http_path = "/CreateIndex",
    host_prefix = "",
    paginator = list()
  )
  input <- .resourceexplorer$create_index_input(ClientToken = ClientToken, Tags = Tags)
  output <- .resourceexplorer$create_index_output()
  config <- get_config()
  svc <- .resourceexplorer$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resourceexplorer$operations$create_index <- resourceexplorer_create_index

#' Creates a view that users can query by using the Search operation
#'
#' @description
#' Creates a view that users can query by using the [`search`][resourceexplorer_search] operation. Results from queries that you make using this view include only resources that match the view's `Filters`. For more information about Amazon Web Services Resource Explorer views, see [Managing views](https://docs.aws.amazon.com/resource-explorer/latest/userguide/manage-views.html) in the *Amazon Web Services Resource Explorer User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/resourceexplorer_create_view/](https://www.paws-r-sdk.com/docs/resourceexplorer_create_view/) for full documentation.
#'
#' @param ClientToken This value helps ensure idempotency. Resource Explorer uses this value
#' to prevent the accidental creation of duplicate versions. We recommend
#' that you generate a [UUID-type
#' value](https://en.wikipedia.org/wiki/Universally_unique_identifier) to
#' ensure the uniqueness of your views.
#' @param Filters An array of strings that specify which resources are included in the
#' results of queries made using this view. When you use this view in a
#' [`search`][resourceexplorer_search] operation, the filter string is
#' combined with the search's `QueryString` parameter using a logical `AND`
#' operator.
#' 
#' For information about the supported syntax, see [Search query reference
#' for Resource
#' Explorer](https://docs.aws.amazon.com/resource-explorer/latest/userguide/using-search-query-syntax.html)
#' in the *Amazon Web Services Resource Explorer User Guide*.
#' 
#' This query string in the context of this operation supports only [filter
#' prefixes](https://docs.aws.amazon.com/resource-explorer/latest/userguide/using-search-query-syntax.html#query-syntax-filters)
#' with optional
#' [operators](https://docs.aws.amazon.com/resource-explorer/latest/userguide/using-search-query-syntax.html#query-syntax-operators).
#' It doesn't support free-form text. For example, the string
#' `region:us* service:ec2 -tag:stage=prod` includes all Amazon EC2
#' resources in any Amazon Web Services Region that begins with the letters
#' `us` and is *not* tagged with a key `Stage` that has the value `prod`.
#' @param IncludedProperties Specifies optional fields that you want included in search results from
#' this view. It is a list of objects that each describe a field to
#' include.
#' 
#' The default is an empty list, with no optional fields included in the
#' results.
#' @param Scope The root ARN of the account, an organizational unit (OU), or an
#' organization ARN. If left empty, the default is account.
#' @param Tags Tag key and value pairs that are attached to the view.
#' @param ViewName &#91;required&#93; The name of the new view. This name appears in the list of views in
#' Resource Explorer.
#' 
#' The name must be no more than 64 characters long, and can include
#' letters, digits, and the dash (-) character. The name must be unique
#' within its Amazon Web Services Region.
#'
#' @keywords internal
#'
#' @rdname resourceexplorer_create_view
resourceexplorer_create_view <- function(ClientToken = NULL, Filters = NULL, IncludedProperties = NULL, Scope = NULL, Tags = NULL, ViewName) {
  op <- new_operation(
    name = "CreateView",
    http_method = "POST",
    http_path = "/CreateView",
    host_prefix = "",
    paginator = list()
  )
  input <- .resourceexplorer$create_view_input(ClientToken = ClientToken, Filters = Filters, IncludedProperties = IncludedProperties, Scope = Scope, Tags = Tags, ViewName = ViewName)
  output <- .resourceexplorer$create_view_output()
  config <- get_config()
  svc <- .resourceexplorer$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resourceexplorer$operations$create_view <- resourceexplorer_create_view

#' Deletes the specified index and turns off Amazon Web Services Resource
#' Explorer in the specified Amazon Web Services Region
#'
#' @description
#' Deletes the specified index and turns off Amazon Web Services Resource Explorer in the specified Amazon Web Services Region. When you delete an index, Resource Explorer stops discovering and indexing resources in that Region. Resource Explorer also deletes all views in that Region. These actions occur as asynchronous background tasks. You can check to see when the actions are complete by using the [`get_index`][resourceexplorer_get_index] operation and checking the `Status` response value.
#'
#' See [https://www.paws-r-sdk.com/docs/resourceexplorer_delete_index/](https://www.paws-r-sdk.com/docs/resourceexplorer_delete_index/) for full documentation.
#'
#' @param Arn &#91;required&#93; The [Amazon resource name
#' (ARN)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' of the index that you want to delete.
#'
#' @keywords internal
#'
#' @rdname resourceexplorer_delete_index
resourceexplorer_delete_index <- function(Arn) {
  op <- new_operation(
    name = "DeleteIndex",
    http_method = "POST",
    http_path = "/DeleteIndex",
    host_prefix = "",
    paginator = list()
  )
  input <- .resourceexplorer$delete_index_input(Arn = Arn)
  output <- .resourceexplorer$delete_index_output()
  config <- get_config()
  svc <- .resourceexplorer$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resourceexplorer$operations$delete_index <- resourceexplorer_delete_index

#' Deletes the specified view
#'
#' @description
#' Deletes the specified view.
#'
#' See [https://www.paws-r-sdk.com/docs/resourceexplorer_delete_view/](https://www.paws-r-sdk.com/docs/resourceexplorer_delete_view/) for full documentation.
#'
#' @param ViewArn &#91;required&#93; The [Amazon resource name
#' (ARN)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' of the view that you want to delete.
#'
#' @keywords internal
#'
#' @rdname resourceexplorer_delete_view
resourceexplorer_delete_view <- function(ViewArn) {
  op <- new_operation(
    name = "DeleteView",
    http_method = "POST",
    http_path = "/DeleteView",
    host_prefix = "",
    paginator = list()
  )
  input <- .resourceexplorer$delete_view_input(ViewArn = ViewArn)
  output <- .resourceexplorer$delete_view_output()
  config <- get_config()
  svc <- .resourceexplorer$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resourceexplorer$operations$delete_view <- resourceexplorer_delete_view

#' After you call this operation, the affected Amazon Web Services Region
#' no longer has a default view
#'
#' @description
#' After you call this operation, the affected Amazon Web Services Region no longer has a default view. All [`search`][resourceexplorer_search] operations in that Region must explicitly specify a view or the operation fails. You can configure a new default by calling the [`associate_default_view`][resourceexplorer_associate_default_view] operation.
#'
#' See [https://www.paws-r-sdk.com/docs/resourceexplorer_disassociate_default_view/](https://www.paws-r-sdk.com/docs/resourceexplorer_disassociate_default_view/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname resourceexplorer_disassociate_default_view
resourceexplorer_disassociate_default_view <- function() {
  op <- new_operation(
    name = "DisassociateDefaultView",
    http_method = "POST",
    http_path = "/DisassociateDefaultView",
    host_prefix = "",
    paginator = list()
  )
  input <- .resourceexplorer$disassociate_default_view_input()
  output <- .resourceexplorer$disassociate_default_view_output()
  config <- get_config()
  svc <- .resourceexplorer$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resourceexplorer$operations$disassociate_default_view <- resourceexplorer_disassociate_default_view

#' Retrieves the status of your account's Amazon Web Services service
#' access, and validates the service linked role required to access the
#' multi-account search feature
#'
#' @description
#' Retrieves the status of your account's Amazon Web Services service access, and validates the service linked role required to access the multi-account search feature. Only the management account or a delegated administrator with service access enabled can invoke this API call.
#'
#' See [https://www.paws-r-sdk.com/docs/resourceexplorer_get_account_level_service_configuration/](https://www.paws-r-sdk.com/docs/resourceexplorer_get_account_level_service_configuration/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname resourceexplorer_get_account_level_service_configuration
resourceexplorer_get_account_level_service_configuration <- function() {
  op <- new_operation(
    name = "GetAccountLevelServiceConfiguration",
    http_method = "POST",
    http_path = "/GetAccountLevelServiceConfiguration",
    host_prefix = "",
    paginator = list()
  )
  input <- .resourceexplorer$get_account_level_service_configuration_input()
  output <- .resourceexplorer$get_account_level_service_configuration_output()
  config <- get_config()
  svc <- .resourceexplorer$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resourceexplorer$operations$get_account_level_service_configuration <- resourceexplorer_get_account_level_service_configuration

#' Retrieves the Amazon Resource Name (ARN) of the view that is the default
#' for the Amazon Web Services Region in which you call this operation
#'
#' @description
#' Retrieves the Amazon Resource Name (ARN) of the view that is the default for the Amazon Web Services Region in which you call this operation. You can then call [`get_view`][resourceexplorer_get_view] to retrieve the details of that view.
#'
#' See [https://www.paws-r-sdk.com/docs/resourceexplorer_get_default_view/](https://www.paws-r-sdk.com/docs/resourceexplorer_get_default_view/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname resourceexplorer_get_default_view
resourceexplorer_get_default_view <- function() {
  op <- new_operation(
    name = "GetDefaultView",
    http_method = "POST",
    http_path = "/GetDefaultView",
    host_prefix = "",
    paginator = list()
  )
  input <- .resourceexplorer$get_default_view_input()
  output <- .resourceexplorer$get_default_view_output()
  config <- get_config()
  svc <- .resourceexplorer$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resourceexplorer$operations$get_default_view <- resourceexplorer_get_default_view

#' Retrieves details about the Amazon Web Services Resource Explorer index
#' in the Amazon Web Services Region in which you invoked the operation
#'
#' @description
#' Retrieves details about the Amazon Web Services Resource Explorer index in the Amazon Web Services Region in which you invoked the operation.
#'
#' See [https://www.paws-r-sdk.com/docs/resourceexplorer_get_index/](https://www.paws-r-sdk.com/docs/resourceexplorer_get_index/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname resourceexplorer_get_index
resourceexplorer_get_index <- function() {
  op <- new_operation(
    name = "GetIndex",
    http_method = "POST",
    http_path = "/GetIndex",
    host_prefix = "",
    paginator = list()
  )
  input <- .resourceexplorer$get_index_input()
  output <- .resourceexplorer$get_index_output()
  config <- get_config()
  svc <- .resourceexplorer$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resourceexplorer$operations$get_index <- resourceexplorer_get_index

#' Retrieves details of the specified view
#'
#' @description
#' Retrieves details of the specified view.
#'
#' See [https://www.paws-r-sdk.com/docs/resourceexplorer_get_view/](https://www.paws-r-sdk.com/docs/resourceexplorer_get_view/) for full documentation.
#'
#' @param ViewArn &#91;required&#93; The [Amazon resource name
#' (ARN)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' of the view that you want information about.
#'
#' @keywords internal
#'
#' @rdname resourceexplorer_get_view
resourceexplorer_get_view <- function(ViewArn) {
  op <- new_operation(
    name = "GetView",
    http_method = "POST",
    http_path = "/GetView",
    host_prefix = "",
    paginator = list()
  )
  input <- .resourceexplorer$get_view_input(ViewArn = ViewArn)
  output <- .resourceexplorer$get_view_output()
  config <- get_config()
  svc <- .resourceexplorer$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resourceexplorer$operations$get_view <- resourceexplorer_get_view

#' Retrieves a list of all of the indexes in Amazon Web Services Regions
#' that are currently collecting resource information for Amazon Web
#' Services Resource Explorer
#'
#' @description
#' Retrieves a list of all of the indexes in Amazon Web Services Regions that are currently collecting resource information for Amazon Web Services Resource Explorer.
#'
#' See [https://www.paws-r-sdk.com/docs/resourceexplorer_list_indexes/](https://www.paws-r-sdk.com/docs/resourceexplorer_list_indexes/) for full documentation.
#'
#' @param MaxResults The maximum number of results that you want included on each page of the
#' response. If you do not include this parameter, it defaults to a value
#' appropriate to the operation. If additional items exist beyond those
#' included in the current response, the `NextToken` response element is
#' present and has a value (is not null). Include that value as the
#' `NextToken` request parameter in the next call to the operation to get
#' the next part of the results.
#' 
#' An API operation can return fewer results than the maximum even when
#' there are more results available. You should check `NextToken` after
#' every operation to ensure that you receive all of the results.
#' @param NextToken The parameter for receiving additional results if you receive a
#' `NextToken` response in a previous request. A `NextToken` response
#' indicates that more output is available. Set this parameter to the value
#' of the previous call's `NextToken` response to indicate where the output
#' should continue from. The pagination tokens expire after 24 hours.
#' @param Regions If specified, limits the response to only information about the index in
#' the specified list of Amazon Web Services Regions.
#' @param Type If specified, limits the output to only indexes of the specified Type,
#' either `LOCAL` or `AGGREGATOR`.
#' 
#' Use this option to discover the aggregator index for your account.
#'
#' @keywords internal
#'
#' @rdname resourceexplorer_list_indexes
resourceexplorer_list_indexes <- function(MaxResults = NULL, NextToken = NULL, Regions = NULL, Type = NULL) {
  op <- new_operation(
    name = "ListIndexes",
    http_method = "POST",
    http_path = "/ListIndexes",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Indexes")
  )
  input <- .resourceexplorer$list_indexes_input(MaxResults = MaxResults, NextToken = NextToken, Regions = Regions, Type = Type)
  output <- .resourceexplorer$list_indexes_output()
  config <- get_config()
  svc <- .resourceexplorer$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resourceexplorer$operations$list_indexes <- resourceexplorer_list_indexes

#' Retrieves a list of a member's indexes in all Amazon Web Services
#' Regions that are currently collecting resource information for Amazon
#' Web Services Resource Explorer
#'
#' @description
#' Retrieves a list of a member's indexes in all Amazon Web Services Regions that are currently collecting resource information for Amazon Web Services Resource Explorer. Only the management account or a delegated administrator with service access enabled can invoke this API call.
#'
#' See [https://www.paws-r-sdk.com/docs/resourceexplorer_list_indexes_for_members/](https://www.paws-r-sdk.com/docs/resourceexplorer_list_indexes_for_members/) for full documentation.
#'
#' @param AccountIdList &#91;required&#93; The account IDs will limit the output to only indexes from these
#' accounts.
#' @param MaxResults The maximum number of results that you want included on each page of the
#' response. If you do not include this parameter, it defaults to a value
#' appropriate to the operation. If additional items exist beyond those
#' included in the current response, the `NextToken` response element is
#' present and has a value (is not null). Include that value as the
#' `NextToken` request parameter in the next call to the operation to get
#' the next part of the results.
#' 
#' An API operation can return fewer results than the maximum even when
#' there are more results available. You should check `NextToken` after
#' every operation to ensure that you receive all of the results.
#' @param NextToken The parameter for receiving additional results if you receive a
#' `NextToken` response in a previous request. A `NextToken` response
#' indicates that more output is available. Set this parameter to the value
#' of the previous call's `NextToken` response to indicate where the output
#' should continue from. The pagination tokens expire after 24 hours.
#'
#' @keywords internal
#'
#' @rdname resourceexplorer_list_indexes_for_members
resourceexplorer_list_indexes_for_members <- function(AccountIdList, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListIndexesForMembers",
    http_method = "POST",
    http_path = "/ListIndexesForMembers",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Indexes")
  )
  input <- .resourceexplorer$list_indexes_for_members_input(AccountIdList = AccountIdList, MaxResults = MaxResults, NextToken = NextToken)
  output <- .resourceexplorer$list_indexes_for_members_output()
  config <- get_config()
  svc <- .resourceexplorer$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resourceexplorer$operations$list_indexes_for_members <- resourceexplorer_list_indexes_for_members

#' Retrieves a list of all resource types currently supported by Amazon Web
#' Services Resource Explorer
#'
#' @description
#' Retrieves a list of all resource types currently supported by Amazon Web Services Resource Explorer.
#'
#' See [https://www.paws-r-sdk.com/docs/resourceexplorer_list_supported_resource_types/](https://www.paws-r-sdk.com/docs/resourceexplorer_list_supported_resource_types/) for full documentation.
#'
#' @param MaxResults The maximum number of results that you want included on each page of the
#' response. If you do not include this parameter, it defaults to a value
#' appropriate to the operation. If additional items exist beyond those
#' included in the current response, the `NextToken` response element is
#' present and has a value (is not null). Include that value as the
#' `NextToken` request parameter in the next call to the operation to get
#' the next part of the results.
#' 
#' An API operation can return fewer results than the maximum even when
#' there are more results available. You should check `NextToken` after
#' every operation to ensure that you receive all of the results.
#' @param NextToken The parameter for receiving additional results if you receive a
#' `NextToken` response in a previous request. A `NextToken` response
#' indicates that more output is available. Set this parameter to the value
#' of the previous call's `NextToken` response to indicate where the output
#' should continue from. The pagination tokens expire after 24 hours.
#'
#' @keywords internal
#'
#' @rdname resourceexplorer_list_supported_resource_types
resourceexplorer_list_supported_resource_types <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListSupportedResourceTypes",
    http_method = "POST",
    http_path = "/ListSupportedResourceTypes",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "ResourceTypes")
  )
  input <- .resourceexplorer$list_supported_resource_types_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .resourceexplorer$list_supported_resource_types_output()
  config <- get_config()
  svc <- .resourceexplorer$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resourceexplorer$operations$list_supported_resource_types <- resourceexplorer_list_supported_resource_types

#' Lists the tags that are attached to the specified resource
#'
#' @description
#' Lists the tags that are attached to the specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/resourceexplorer_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/resourceexplorer_list_tags_for_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The [Amazon resource name
#' (ARN)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' of the view or index that you want to attach tags to.
#'
#' @keywords internal
#'
#' @rdname resourceexplorer_list_tags_for_resource
resourceexplorer_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{resourceArn}",
    host_prefix = "",
    paginator = list()
  )
  input <- .resourceexplorer$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .resourceexplorer$list_tags_for_resource_output()
  config <- get_config()
  svc <- .resourceexplorer$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resourceexplorer$operations$list_tags_for_resource <- resourceexplorer_list_tags_for_resource

#' Lists the Amazon resource names (ARNs) of the views available in the
#' Amazon Web Services Region in which you call this operation
#'
#' @description
#' Lists the [Amazon resource names (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html) of the views available in the Amazon Web Services Region in which you call this operation.
#'
#' See [https://www.paws-r-sdk.com/docs/resourceexplorer_list_views/](https://www.paws-r-sdk.com/docs/resourceexplorer_list_views/) for full documentation.
#'
#' @param MaxResults The maximum number of results that you want included on each page of the
#' response. If you do not include this parameter, it defaults to a value
#' appropriate to the operation. If additional items exist beyond those
#' included in the current response, the `NextToken` response element is
#' present and has a value (is not null). Include that value as the
#' `NextToken` request parameter in the next call to the operation to get
#' the next part of the results.
#' 
#' An API operation can return fewer results than the maximum even when
#' there are more results available. You should check `NextToken` after
#' every operation to ensure that you receive all of the results.
#' @param NextToken The parameter for receiving additional results if you receive a
#' `NextToken` response in a previous request. A `NextToken` response
#' indicates that more output is available. Set this parameter to the value
#' of the previous call's `NextToken` response to indicate where the output
#' should continue from. The pagination tokens expire after 24 hours.
#'
#' @keywords internal
#'
#' @rdname resourceexplorer_list_views
resourceexplorer_list_views <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListViews",
    http_method = "POST",
    http_path = "/ListViews",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Views")
  )
  input <- .resourceexplorer$list_views_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .resourceexplorer$list_views_output()
  config <- get_config()
  svc <- .resourceexplorer$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resourceexplorer$operations$list_views <- resourceexplorer_list_views

#' Searches for resources and displays details about all resources that
#' match the specified criteria
#'
#' @description
#' Searches for resources and displays details about all resources that match the specified criteria. You must specify a query string.
#'
#' See [https://www.paws-r-sdk.com/docs/resourceexplorer_search/](https://www.paws-r-sdk.com/docs/resourceexplorer_search/) for full documentation.
#'
#' @param MaxResults The maximum number of results that you want included on each page of the
#' response. If you do not include this parameter, it defaults to a value
#' appropriate to the operation. If additional items exist beyond those
#' included in the current response, the `NextToken` response element is
#' present and has a value (is not null). Include that value as the
#' `NextToken` request parameter in the next call to the operation to get
#' the next part of the results.
#' 
#' An API operation can return fewer results than the maximum even when
#' there are more results available. You should check `NextToken` after
#' every operation to ensure that you receive all of the results.
#' @param NextToken The parameter for receiving additional results if you receive a
#' `NextToken` response in a previous request. A `NextToken` response
#' indicates that more output is available. Set this parameter to the value
#' of the previous call's `NextToken` response to indicate where the output
#' should continue from. The pagination tokens expire after 24 hours.
#' @param QueryString &#91;required&#93; A string that includes keywords and filters that specify the resources
#' that you want to include in the results.
#' 
#' For the complete syntax supported by the `QueryString` parameter, see
#' [Search query syntax reference for Resource
#' Explorer](https://docs.aws.amazon.com/resource-explorer/latest/userguide/using-search-query-syntax.html).
#' 
#' The search is completely case insensitive. You can specify an empty
#' string to return all results up to the limit of 1,000 total results.
#' 
#' The operation can return only the first 1,000 results. If the resource
#' you want is not included, then use a different value for `QueryString`
#' to refine the results.
#' @param ViewArn Specifies the [Amazon resource name
#' (ARN)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' of the view to use for the query. If you don't specify a value for this
#' parameter, then the operation automatically uses the default view for
#' the Amazon Web Services Region in which you called this operation. If
#' the Region either doesn't have a default view or if you don't have
#' permission to use the default view, then the operation fails with a
#' `401 Unauthorized` exception.
#'
#' @keywords internal
#'
#' @rdname resourceexplorer_search
resourceexplorer_search <- function(MaxResults = NULL, NextToken = NULL, QueryString, ViewArn = NULL) {
  op <- new_operation(
    name = "Search",
    http_method = "POST",
    http_path = "/Search",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Resources")
  )
  input <- .resourceexplorer$search_input(MaxResults = MaxResults, NextToken = NextToken, QueryString = QueryString, ViewArn = ViewArn)
  output <- .resourceexplorer$search_output()
  config <- get_config()
  svc <- .resourceexplorer$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resourceexplorer$operations$search <- resourceexplorer_search

#' Adds one or more tag key and value pairs to an Amazon Web Services
#' Resource Explorer view or index
#'
#' @description
#' Adds one or more tag key and value pairs to an Amazon Web Services Resource Explorer view or index.
#'
#' See [https://www.paws-r-sdk.com/docs/resourceexplorer_tag_resource/](https://www.paws-r-sdk.com/docs/resourceexplorer_tag_resource/) for full documentation.
#'
#' @param Tags A list of tag key and value pairs that you want to attach to the
#' specified view or index.
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the view or index that you want to
#' attach tags to.
#'
#' @keywords internal
#'
#' @rdname resourceexplorer_tag_resource
resourceexplorer_tag_resource <- function(Tags = NULL, resourceArn) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{resourceArn}",
    host_prefix = "",
    paginator = list()
  )
  input <- .resourceexplorer$tag_resource_input(Tags = Tags, resourceArn = resourceArn)
  output <- .resourceexplorer$tag_resource_output()
  config <- get_config()
  svc <- .resourceexplorer$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resourceexplorer$operations$tag_resource <- resourceexplorer_tag_resource

#' Removes one or more tag key and value pairs from an Amazon Web Services
#' Resource Explorer view or index
#'
#' @description
#' Removes one or more tag key and value pairs from an Amazon Web Services Resource Explorer view or index.
#'
#' See [https://www.paws-r-sdk.com/docs/resourceexplorer_untag_resource/](https://www.paws-r-sdk.com/docs/resourceexplorer_untag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the view or index that you want to
#' remove tags from.
#' @param tagKeys &#91;required&#93; A list of the keys for the tags that you want to remove from the
#' specified view or index.
#'
#' @keywords internal
#'
#' @rdname resourceexplorer_untag_resource
resourceexplorer_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{resourceArn}",
    host_prefix = "",
    paginator = list()
  )
  input <- .resourceexplorer$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .resourceexplorer$untag_resource_output()
  config <- get_config()
  svc <- .resourceexplorer$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resourceexplorer$operations$untag_resource <- resourceexplorer_untag_resource

#' Changes the type of the index from one of the following types to the
#' other
#'
#' @description
#' Changes the type of the index from one of the following types to the other. For more information about indexes and the role they perform in Amazon Web Services Resource Explorer, see [Turning on cross-Region search by creating an aggregator index](https://docs.aws.amazon.com/resource-explorer/latest/userguide/manage-aggregator-region.html) in the *Amazon Web Services Resource Explorer User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/resourceexplorer_update_index_type/](https://www.paws-r-sdk.com/docs/resourceexplorer_update_index_type/) for full documentation.
#'
#' @param Arn &#91;required&#93; The [Amazon resource name
#' (ARN)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' of the index that you want to update.
#' @param Type &#91;required&#93; The type of the index. To understand the difference between `LOCAL` and
#' `AGGREGATOR`, see [Turning on cross-Region
#' search](https://docs.aws.amazon.com/resource-explorer/latest/userguide/manage-aggregator-region.html)
#' in the *Amazon Web Services Resource Explorer User Guide*.
#'
#' @keywords internal
#'
#' @rdname resourceexplorer_update_index_type
resourceexplorer_update_index_type <- function(Arn, Type) {
  op <- new_operation(
    name = "UpdateIndexType",
    http_method = "POST",
    http_path = "/UpdateIndexType",
    host_prefix = "",
    paginator = list()
  )
  input <- .resourceexplorer$update_index_type_input(Arn = Arn, Type = Type)
  output <- .resourceexplorer$update_index_type_output()
  config <- get_config()
  svc <- .resourceexplorer$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resourceexplorer$operations$update_index_type <- resourceexplorer_update_index_type

#' Modifies some of the details of a view
#'
#' @description
#' Modifies some of the details of a view. You can change the filter string and the list of included properties. You can't change the name of the view.
#'
#' See [https://www.paws-r-sdk.com/docs/resourceexplorer_update_view/](https://www.paws-r-sdk.com/docs/resourceexplorer_update_view/) for full documentation.
#'
#' @param Filters An array of strings that specify which resources are included in the
#' results of queries made using this view. When you use this view in a
#' [`search`][resourceexplorer_search] operation, the filter string is
#' combined with the search's `QueryString` parameter using a logical `AND`
#' operator.
#' 
#' For information about the supported syntax, see [Search query reference
#' for Resource
#' Explorer](https://docs.aws.amazon.com/resource-explorer/latest/userguide/using-search-query-syntax.html)
#' in the *Amazon Web Services Resource Explorer User Guide*.
#' 
#' This query string in the context of this operation supports only [filter
#' prefixes](https://docs.aws.amazon.com/resource-explorer/latest/userguide/using-search-query-syntax.html#query-syntax-filters)
#' with optional
#' [operators](https://docs.aws.amazon.com/resource-explorer/latest/userguide/using-search-query-syntax.html#query-syntax-operators).
#' It doesn't support free-form text. For example, the string
#' `region:us* service:ec2 -tag:stage=prod` includes all Amazon EC2
#' resources in any Amazon Web Services Region that begins with the letters
#' `us` and is *not* tagged with a key `Stage` that has the value `prod`.
#' @param IncludedProperties Specifies optional fields that you want included in search results from
#' this view. It is a list of objects that each describe a field to
#' include.
#' 
#' The default is an empty list, with no optional fields included in the
#' results.
#' @param ViewArn &#91;required&#93; The [Amazon resource name
#' (ARN)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' of the view that you want to modify.
#'
#' @keywords internal
#'
#' @rdname resourceexplorer_update_view
resourceexplorer_update_view <- function(Filters = NULL, IncludedProperties = NULL, ViewArn) {
  op <- new_operation(
    name = "UpdateView",
    http_method = "POST",
    http_path = "/UpdateView",
    host_prefix = "",
    paginator = list()
  )
  input <- .resourceexplorer$update_view_input(Filters = Filters, IncludedProperties = IncludedProperties, ViewArn = ViewArn)
  output <- .resourceexplorer$update_view_output()
  config <- get_config()
  svc <- .resourceexplorer$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.resourceexplorer$operations$update_view <- resourceexplorer_update_view
