% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sns_operations.R
\name{sns_confirm_subscription}
\alias{sns_confirm_subscription}
\title{Verifies an endpoint owner's intent to receive messages by validating
the token sent to the endpoint by an earlier Subscribe action}
\usage{
sns_confirm_subscription(TopicArn, Token, AuthenticateOnUnsubscribe)
}
\arguments{
\item{TopicArn}{[required] The ARN of the topic for which you wish to confirm a subscription.}

\item{Token}{[required] Short-lived token sent to an endpoint during the \code{Subscribe} action.}

\item{AuthenticateOnUnsubscribe}{Disallows unauthenticated unsubscribes of the subscription. If the value
of this parameter is \code{true} and the request has an AWS signature, then
only the topic owner and the subscription owner can unsubscribe the
endpoint. The unsubscribe action requires AWS authentication.}
}
\description{
Verifies an endpoint owner\'s intent to receive messages by validating
the token sent to the endpoint by an earlier \code{Subscribe} action. If the
token is valid, the action creates a new subscription and returns its
Amazon Resource Name (ARN). This call requires an AWS signature only
when the \code{AuthenticateOnUnsubscribe} flag is set to \"true\".
}
\section{Request syntax}{
\preformatted{svc$confirm_subscription(
  TopicArn = "string",
  Token = "string",
  AuthenticateOnUnsubscribe = "string"
)
}
}

\keyword{internal}
