% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/swf_operations.R
\name{swf_poll_for_decision_task}
\alias{swf_poll_for_decision_task}
\title{Used by deciders to get a DecisionTask from the specified decision
taskList}
\usage{
swf_poll_for_decision_task(domain, taskList, identity, nextPageToken,
  maximumPageSize, reverseOrder)
}
\arguments{
\item{domain}{[required] The name of the domain containing the task lists to poll.}

\item{taskList}{[required] Specifies the task list to poll for decision tasks.

The specified string must not start or end with whitespace. It must not
contain a \code{:} (colon), \code{/} (slash), \code{|} (vertical bar), or any control
characters (\verb{\\u0000-\\u001f} | \verb{\\u007f-\\u009f}). Also, it must not \emph{be}
the literal string \code{arn}.}

\item{identity}{Identity of the decider making the request, which is recorded in the
DecisionTaskStarted event in the workflow history. This enables
diagnostic tracing when problems arise. The form of this identity is
user defined.}

\item{nextPageToken}{If \code{NextPageToken} is returned there are more results available. The
value of \code{NextPageToken} is a unique pagination token for each page.
Make the call again using the returned token to retrieve the next page.
Keep all other arguments unchanged. Each pagination token expires after
60 seconds. Using an expired pagination token will return a \code{400} error:
"\verb{Specified token has exceeded its maximum lifetime}".

The configured \code{maximumPageSize} determines how many results can be
returned in a single call.

The \code{nextPageToken} returned by this action cannot be used with
\code{\link[=swf_get_workflow_execution_history]{get_workflow_execution_history}}
to get the next page. You must call
\code{\link[=swf_poll_for_decision_task]{poll_for_decision_task}} again (with the
\code{nextPageToken}) to retrieve the next page of history records. Calling
\code{\link[=swf_poll_for_decision_task]{poll_for_decision_task}} with a
\code{nextPageToken} doesn't return a new decision task.}

\item{maximumPageSize}{The maximum number of results that are returned per call. Use
\code{nextPageToken} to obtain further pages of results.

This is an upper limit only; the actual number of results returned per
call may be fewer than the specified maximum.}

\item{reverseOrder}{When set to \code{true}, returns the events in reverse order. By default the
results are returned in ascending order of the \code{eventTimestamp} of the
events.}
}
\value{
A list with the following syntax:\preformatted{list(
  taskToken = "string",
  startedEventId = 123,
  workflowExecution = list(
    workflowId = "string",
    runId = "string"
  ),
  workflowType = list(
    name = "string",
    version = "string"
  ),
  events = list(
    list(
      eventTimestamp = as.POSIXct(
        "2015-01-01"
      ),
      eventType = "WorkflowExecutionStarted"|"WorkflowExecutionCancelRequested"|"WorkflowExecutionCompleted"|"CompleteWorkflowExecutionFailed"|"WorkflowExecutionFailed"|"FailWorkflowExecutionFailed"|"WorkflowExecutionTimedOut"|"WorkflowExecutionCanceled"|"CancelWorkflowExecutionFailed"|"WorkflowExecutionContinuedAsNew"|"ContinueAsNewWorkflowExecutionFailed"|"WorkflowExecutionTerminated"|"DecisionTaskScheduled"|"DecisionTaskStarted"|"DecisionTaskCompleted"|"DecisionTaskTimedOut"|"ActivityTaskScheduled"|"ScheduleActivityTaskFailed"|"ActivityTaskStarted"|"ActivityTaskCompleted"|"ActivityTaskFailed"|"ActivityTaskTimedOut"|"ActivityTaskCanceled"|"ActivityTaskCancelRequested"|"RequestCancelActivityTaskFailed"|"WorkflowExecutionSignaled"|"MarkerRecorded"|"RecordMarkerFailed"|"TimerStarted"|"StartTimerFailed"|"TimerFired"|"TimerCanceled"|"CancelTimerFailed"|"StartChildWorkflowExecutionInitiated"|"StartChildWorkflowExecutionFailed"|"ChildWorkflowExecutionStarted"|"ChildWorkflowExecutionCompleted"|"ChildWorkflowExecutionFailed"|"ChildWorkflowExecutionTimedOut"|"ChildWorkflowExecutionCanceled"|"ChildWorkflowExecutionTerminated"|"SignalExternalWorkflowExecutionInitiated"|"SignalExternalWorkflowExecutionFailed"|"ExternalWorkflowExecutionSignaled"|"RequestCancelExternalWorkflowExecutionInitiated"|"RequestCancelExternalWorkflowExecutionFailed"|"ExternalWorkflowExecutionCancelRequested"|"LambdaFunctionScheduled"|"LambdaFunctionStarted"|"LambdaFunctionCompleted"|"LambdaFunctionFailed"|"LambdaFunctionTimedOut"|"ScheduleLambdaFunctionFailed"|"StartLambdaFunctionFailed",
      eventId = 123,
      workflowExecutionStartedEventAttributes = list(
        input = "string",
        executionStartToCloseTimeout = "string",
        taskStartToCloseTimeout = "string",
        childPolicy = "TERMINATE"|"REQUEST_CANCEL"|"ABANDON",
        taskList = list(
          name = "string"
        ),
        taskPriority = "string",
        workflowType = list(
          name = "string",
          version = "string"
        ),
        tagList = list(
          "string"
        ),
        continuedExecutionRunId = "string",
        parentWorkflowExecution = list(
          workflowId = "string",
          runId = "string"
        ),
        parentInitiatedEventId = 123,
        lambdaRole = "string"
      ),
      workflowExecutionCompletedEventAttributes = list(
        result = "string",
        decisionTaskCompletedEventId = 123
      ),
      completeWorkflowExecutionFailedEventAttributes = list(
        cause = "UNHANDLED_DECISION"|"OPERATION_NOT_PERMITTED",
        decisionTaskCompletedEventId = 123
      ),
      workflowExecutionFailedEventAttributes = list(
        reason = "string",
        details = "string",
        decisionTaskCompletedEventId = 123
      ),
      failWorkflowExecutionFailedEventAttributes = list(
        cause = "UNHANDLED_DECISION"|"OPERATION_NOT_PERMITTED",
        decisionTaskCompletedEventId = 123
      ),
      workflowExecutionTimedOutEventAttributes = list(
        timeoutType = "START_TO_CLOSE",
        childPolicy = "TERMINATE"|"REQUEST_CANCEL"|"ABANDON"
      ),
      workflowExecutionCanceledEventAttributes = list(
        details = "string",
        decisionTaskCompletedEventId = 123
      ),
      cancelWorkflowExecutionFailedEventAttributes = list(
        cause = "UNHANDLED_DECISION"|"OPERATION_NOT_PERMITTED",
        decisionTaskCompletedEventId = 123
      ),
      workflowExecutionContinuedAsNewEventAttributes = list(
        input = "string",
        decisionTaskCompletedEventId = 123,
        newExecutionRunId = "string",
        executionStartToCloseTimeout = "string",
        taskList = list(
          name = "string"
        ),
        taskPriority = "string",
        taskStartToCloseTimeout = "string",
        childPolicy = "TERMINATE"|"REQUEST_CANCEL"|"ABANDON",
        tagList = list(
          "string"
        ),
        workflowType = list(
          name = "string",
          version = "string"
        ),
        lambdaRole = "string"
      ),
      continueAsNewWorkflowExecutionFailedEventAttributes = list(
        cause = "UNHANDLED_DECISION"|"WORKFLOW_TYPE_DEPRECATED"|"WORKFLOW_TYPE_DOES_NOT_EXIST"|"DEFAULT_EXECUTION_START_TO_CLOSE_TIMEOUT_UNDEFINED"|"DEFAULT_TASK_START_TO_CLOSE_TIMEOUT_UNDEFINED"|"DEFAULT_TASK_LIST_UNDEFINED"|"DEFAULT_CHILD_POLICY_UNDEFINED"|"CONTINUE_AS_NEW_WORKFLOW_EXECUTION_RATE_EXCEEDED"|"OPERATION_NOT_PERMITTED",
        decisionTaskCompletedEventId = 123
      ),
      workflowExecutionTerminatedEventAttributes = list(
        reason = "string",
        details = "string",
        childPolicy = "TERMINATE"|"REQUEST_CANCEL"|"ABANDON",
        cause = "CHILD_POLICY_APPLIED"|"EVENT_LIMIT_EXCEEDED"|"OPERATOR_INITIATED"
      ),
      workflowExecutionCancelRequestedEventAttributes = list(
        externalWorkflowExecution = list(
          workflowId = "string",
          runId = "string"
        ),
        externalInitiatedEventId = 123,
        cause = "CHILD_POLICY_APPLIED"
      ),
      decisionTaskScheduledEventAttributes = list(
        taskList = list(
          name = "string"
        ),
        taskPriority = "string",
        startToCloseTimeout = "string"
      ),
      decisionTaskStartedEventAttributes = list(
        identity = "string",
        scheduledEventId = 123
      ),
      decisionTaskCompletedEventAttributes = list(
        executionContext = "string",
        scheduledEventId = 123,
        startedEventId = 123
      ),
      decisionTaskTimedOutEventAttributes = list(
        timeoutType = "START_TO_CLOSE",
        scheduledEventId = 123,
        startedEventId = 123
      ),
      activityTaskScheduledEventAttributes = list(
        activityType = list(
          name = "string",
          version = "string"
        ),
        activityId = "string",
        input = "string",
        control = "string",
        scheduleToStartTimeout = "string",
        scheduleToCloseTimeout = "string",
        startToCloseTimeout = "string",
        taskList = list(
          name = "string"
        ),
        taskPriority = "string",
        decisionTaskCompletedEventId = 123,
        heartbeatTimeout = "string"
      ),
      activityTaskStartedEventAttributes = list(
        identity = "string",
        scheduledEventId = 123
      ),
      activityTaskCompletedEventAttributes = list(
        result = "string",
        scheduledEventId = 123,
        startedEventId = 123
      ),
      activityTaskFailedEventAttributes = list(
        reason = "string",
        details = "string",
        scheduledEventId = 123,
        startedEventId = 123
      ),
      activityTaskTimedOutEventAttributes = list(
        timeoutType = "START_TO_CLOSE"|"SCHEDULE_TO_START"|"SCHEDULE_TO_CLOSE"|"HEARTBEAT",
        scheduledEventId = 123,
        startedEventId = 123,
        details = "string"
      ),
      activityTaskCanceledEventAttributes = list(
        details = "string",
        scheduledEventId = 123,
        startedEventId = 123,
        latestCancelRequestedEventId = 123
      ),
      activityTaskCancelRequestedEventAttributes = list(
        decisionTaskCompletedEventId = 123,
        activityId = "string"
      ),
      workflowExecutionSignaledEventAttributes = list(
        signalName = "string",
        input = "string",
        externalWorkflowExecution = list(
          workflowId = "string",
          runId = "string"
        ),
        externalInitiatedEventId = 123
      ),
      markerRecordedEventAttributes = list(
        markerName = "string",
        details = "string",
        decisionTaskCompletedEventId = 123
      ),
      recordMarkerFailedEventAttributes = list(
        markerName = "string",
        cause = "OPERATION_NOT_PERMITTED",
        decisionTaskCompletedEventId = 123
      ),
      timerStartedEventAttributes = list(
        timerId = "string",
        control = "string",
        startToFireTimeout = "string",
        decisionTaskCompletedEventId = 123
      ),
      timerFiredEventAttributes = list(
        timerId = "string",
        startedEventId = 123
      ),
      timerCanceledEventAttributes = list(
        timerId = "string",
        startedEventId = 123,
        decisionTaskCompletedEventId = 123
      ),
      startChildWorkflowExecutionInitiatedEventAttributes = list(
        workflowId = "string",
        workflowType = list(
          name = "string",
          version = "string"
        ),
        control = "string",
        input = "string",
        executionStartToCloseTimeout = "string",
        taskList = list(
          name = "string"
        ),
        taskPriority = "string",
        decisionTaskCompletedEventId = 123,
        childPolicy = "TERMINATE"|"REQUEST_CANCEL"|"ABANDON",
        taskStartToCloseTimeout = "string",
        tagList = list(
          "string"
        ),
        lambdaRole = "string"
      ),
      childWorkflowExecutionStartedEventAttributes = list(
        workflowExecution = list(
          workflowId = "string",
          runId = "string"
        ),
        workflowType = list(
          name = "string",
          version = "string"
        ),
        initiatedEventId = 123
      ),
      childWorkflowExecutionCompletedEventAttributes = list(
        workflowExecution = list(
          workflowId = "string",
          runId = "string"
        ),
        workflowType = list(
          name = "string",
          version = "string"
        ),
        result = "string",
        initiatedEventId = 123,
        startedEventId = 123
      ),
      childWorkflowExecutionFailedEventAttributes = list(
        workflowExecution = list(
          workflowId = "string",
          runId = "string"
        ),
        workflowType = list(
          name = "string",
          version = "string"
        ),
        reason = "string",
        details = "string",
        initiatedEventId = 123,
        startedEventId = 123
      ),
      childWorkflowExecutionTimedOutEventAttributes = list(
        workflowExecution = list(
          workflowId = "string",
          runId = "string"
        ),
        workflowType = list(
          name = "string",
          version = "string"
        ),
        timeoutType = "START_TO_CLOSE",
        initiatedEventId = 123,
        startedEventId = 123
      ),
      childWorkflowExecutionCanceledEventAttributes = list(
        workflowExecution = list(
          workflowId = "string",
          runId = "string"
        ),
        workflowType = list(
          name = "string",
          version = "string"
        ),
        details = "string",
        initiatedEventId = 123,
        startedEventId = 123
      ),
      childWorkflowExecutionTerminatedEventAttributes = list(
        workflowExecution = list(
          workflowId = "string",
          runId = "string"
        ),
        workflowType = list(
          name = "string",
          version = "string"
        ),
        initiatedEventId = 123,
        startedEventId = 123
      ),
      signalExternalWorkflowExecutionInitiatedEventAttributes = list(
        workflowId = "string",
        runId = "string",
        signalName = "string",
        input = "string",
        decisionTaskCompletedEventId = 123,
        control = "string"
      ),
      externalWorkflowExecutionSignaledEventAttributes = list(
        workflowExecution = list(
          workflowId = "string",
          runId = "string"
        ),
        initiatedEventId = 123
      ),
      signalExternalWorkflowExecutionFailedEventAttributes = list(
        workflowId = "string",
        runId = "string",
        cause = "UNKNOWN_EXTERNAL_WORKFLOW_EXECUTION"|"SIGNAL_EXTERNAL_WORKFLOW_EXECUTION_RATE_EXCEEDED"|"OPERATION_NOT_PERMITTED",
        initiatedEventId = 123,
        decisionTaskCompletedEventId = 123,
        control = "string"
      ),
      externalWorkflowExecutionCancelRequestedEventAttributes = list(
        workflowExecution = list(
          workflowId = "string",
          runId = "string"
        ),
        initiatedEventId = 123
      ),
      requestCancelExternalWorkflowExecutionInitiatedEventAttributes = list(
        workflowId = "string",
        runId = "string",
        decisionTaskCompletedEventId = 123,
        control = "string"
      ),
      requestCancelExternalWorkflowExecutionFailedEventAttributes = list(
        workflowId = "string",
        runId = "string",
        cause = "UNKNOWN_EXTERNAL_WORKFLOW_EXECUTION"|"REQUEST_CANCEL_EXTERNAL_WORKFLOW_EXECUTION_RATE_EXCEEDED"|"OPERATION_NOT_PERMITTED",
        initiatedEventId = 123,
        decisionTaskCompletedEventId = 123,
        control = "string"
      ),
      scheduleActivityTaskFailedEventAttributes = list(
        activityType = list(
          name = "string",
          version = "string"
        ),
        activityId = "string",
        cause = "ACTIVITY_TYPE_DEPRECATED"|"ACTIVITY_TYPE_DOES_NOT_EXIST"|"ACTIVITY_ID_ALREADY_IN_USE"|"OPEN_ACTIVITIES_LIMIT_EXCEEDED"|"ACTIVITY_CREATION_RATE_EXCEEDED"|"DEFAULT_SCHEDULE_TO_CLOSE_TIMEOUT_UNDEFINED"|"DEFAULT_TASK_LIST_UNDEFINED"|"DEFAULT_SCHEDULE_TO_START_TIMEOUT_UNDEFINED"|"DEFAULT_START_TO_CLOSE_TIMEOUT_UNDEFINED"|"DEFAULT_HEARTBEAT_TIMEOUT_UNDEFINED"|"OPERATION_NOT_PERMITTED",
        decisionTaskCompletedEventId = 123
      ),
      requestCancelActivityTaskFailedEventAttributes = list(
        activityId = "string",
        cause = "ACTIVITY_ID_UNKNOWN"|"OPERATION_NOT_PERMITTED",
        decisionTaskCompletedEventId = 123
      ),
      startTimerFailedEventAttributes = list(
        timerId = "string",
        cause = "TIMER_ID_ALREADY_IN_USE"|"OPEN_TIMERS_LIMIT_EXCEEDED"|"TIMER_CREATION_RATE_EXCEEDED"|"OPERATION_NOT_PERMITTED",
        decisionTaskCompletedEventId = 123
      ),
      cancelTimerFailedEventAttributes = list(
        timerId = "string",
        cause = "TIMER_ID_UNKNOWN"|"OPERATION_NOT_PERMITTED",
        decisionTaskCompletedEventId = 123
      ),
      startChildWorkflowExecutionFailedEventAttributes = list(
        workflowType = list(
          name = "string",
          version = "string"
        ),
        cause = "WORKFLOW_TYPE_DOES_NOT_EXIST"|"WORKFLOW_TYPE_DEPRECATED"|"OPEN_CHILDREN_LIMIT_EXCEEDED"|"OPEN_WORKFLOWS_LIMIT_EXCEEDED"|"CHILD_CREATION_RATE_EXCEEDED"|"WORKFLOW_ALREADY_RUNNING"|"DEFAULT_EXECUTION_START_TO_CLOSE_TIMEOUT_UNDEFINED"|"DEFAULT_TASK_LIST_UNDEFINED"|"DEFAULT_TASK_START_TO_CLOSE_TIMEOUT_UNDEFINED"|"DEFAULT_CHILD_POLICY_UNDEFINED"|"OPERATION_NOT_PERMITTED",
        workflowId = "string",
        initiatedEventId = 123,
        decisionTaskCompletedEventId = 123,
        control = "string"
      ),
      lambdaFunctionScheduledEventAttributes = list(
        id = "string",
        name = "string",
        control = "string",
        input = "string",
        startToCloseTimeout = "string",
        decisionTaskCompletedEventId = 123
      ),
      lambdaFunctionStartedEventAttributes = list(
        scheduledEventId = 123
      ),
      lambdaFunctionCompletedEventAttributes = list(
        scheduledEventId = 123,
        startedEventId = 123,
        result = "string"
      ),
      lambdaFunctionFailedEventAttributes = list(
        scheduledEventId = 123,
        startedEventId = 123,
        reason = "string",
        details = "string"
      ),
      lambdaFunctionTimedOutEventAttributes = list(
        scheduledEventId = 123,
        startedEventId = 123,
        timeoutType = "START_TO_CLOSE"
      ),
      scheduleLambdaFunctionFailedEventAttributes = list(
        id = "string",
        name = "string",
        cause = "ID_ALREADY_IN_USE"|"OPEN_LAMBDA_FUNCTIONS_LIMIT_EXCEEDED"|"LAMBDA_FUNCTION_CREATION_RATE_EXCEEDED"|"LAMBDA_SERVICE_NOT_AVAILABLE_IN_REGION",
        decisionTaskCompletedEventId = 123
      ),
      startLambdaFunctionFailedEventAttributes = list(
        scheduledEventId = 123,
        cause = "ASSUME_ROLE_FAILED",
        message = "string"
      )
    )
  ),
  nextPageToken = "string",
  previousStartedEventId = 123
)
}
}
\description{
Used by deciders to get a DecisionTask from the specified decision
\code{taskList}. A decision task may be returned for any open workflow
execution that is using the specified task list. The task includes a
paginated view of the history of the workflow execution. The decider
should use the workflow type and the history to determine how to
properly handle the task.

This action initiates a long poll, where the service holds the HTTP
connection open and responds as soon a task becomes available. If no
decision task is available in the specified task list before the timeout
of 60 seconds expires, an empty result is returned. An empty result, in
this context, means that a DecisionTask is returned, but that the value
of taskToken is an empty string.

Deciders should set their client side socket timeout to at least 70
seconds (10 seconds higher than the timeout).

Because the number of workflow history events for a single workflow
execution might be very large, the result returned might be split up
across a number of pages. To retrieve subsequent pages, make additional
calls to \code{\link[=swf_poll_for_decision_task]{poll_for_decision_task}} using
the \code{nextPageToken} returned by the initial call. Note that you do \emph{not}
call
\code{\link[=swf_get_workflow_execution_history]{get_workflow_execution_history}}
with this \code{nextPageToken}. Instead, call
\code{\link[=swf_poll_for_decision_task]{poll_for_decision_task}} again.

\strong{Access Control}

You can use IAM policies to control this action's access to Amazon SWF
resources as follows:
\itemize{
\item Use a \code{Resource} element with the domain name to limit the action to
only specified domains.
\item Use an \code{Action} element to allow or deny permission to call this
action.
\item Constrain the \code{taskList.name} parameter by using a \code{Condition}
element with the \code{swf:taskList.name} key to allow the action to
access only certain task lists.
}

If the caller doesn't have sufficient permissions to invoke the action,
or the parameter values fall outside the specified constraints, the
action fails. The associated event attribute's \code{cause} parameter is set
to \code{OPERATION_NOT_PERMITTED}. For details and example IAM policies, see
\href{https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html}{Using IAM to Manage Access to Amazon SWF Workflows}
in the \emph{Amazon SWF Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$poll_for_decision_task(
  domain = "string",
  taskList = list(
    name = "string"
  ),
  identity = "string",
  nextPageToken = "string",
  maximumPageSize = 123,
  reverseOrder = TRUE|FALSE
)
}
}

\keyword{internal}
