% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfn_operations.R
\name{sfn_describe_execution}
\alias{sfn_describe_execution}
\title{Describes an execution}
\usage{
sfn_describe_execution(executionArn)
}
\arguments{
\item{executionArn}{[required] The Amazon Resource Name (ARN) of the execution to describe.}
}
\value{
A list with the following syntax:\preformatted{list(
  executionArn = "string",
  stateMachineArn = "string",
  name = "string",
  status = "RUNNING"|"SUCCEEDED"|"FAILED"|"TIMED_OUT"|"ABORTED",
  startDate = as.POSIXct(
    "2015-01-01"
  ),
  stopDate = as.POSIXct(
    "2015-01-01"
  ),
  input = "string",
  inputDetails = list(
    included = TRUE|FALSE
  ),
  output = "string",
  outputDetails = list(
    included = TRUE|FALSE
  ),
  traceHeader = "string"
)
}
}
\description{
Describes an execution.

This operation is eventually consistent. The results are best effort and
may not reflect very recent updates and changes.

This API action is not supported by \code{EXPRESS} state machines.
}
\section{Request syntax}{
\preformatted{svc$describe_execution(
  executionArn = "string"
)
}
}

\keyword{internal}
