% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sqs_operations.R
\name{sqs_remove_permission}
\alias{sqs_remove_permission}
\title{Revokes any permissions in the queue policy that matches the specified
Label parameter}
\usage{
sqs_remove_permission(QueueUrl, Label)
}
\arguments{
\item{QueueUrl}{[required] The URL of the Amazon SQS queue from which permissions are removed.

Queue URLs and names are case-sensitive.}

\item{Label}{[required] The identification of the permission to remove. This is the label added
using the \code{<a>AddPermission</a>} action.}
}
\description{
Revokes any permissions in the queue policy that matches the specified
\code{Label} parameter.
}
\details{
Only the owner of a queue can remove permissions from it.

Cross-account permissions don't apply to this action. For more
information, see see \href{http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-customer-managed-policy-examples.html#grant-cross-account-permissions-to-role-and-user-name}{Grant Cross-Account Permissions to a Role and a User Name}
in the \emph{Amazon Simple Queue Service Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$remove_permission(
  QueueUrl = "string",
  Label = "string"
)
}
}

\keyword{internal}
