% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kendra_operations.R
\name{kendra_describe_principal_mapping}
\alias{kendra_describe_principal_mapping}
\title{Describes the processing of PUT and DELETE actions for mapping users to
their groups}
\usage{
kendra_describe_principal_mapping(IndexId, DataSourceId = NULL, GroupId)
}
\arguments{
\item{IndexId}{[required] The identifier of the index required to check the processing of \code{PUT}
and \code{DELETE} actions for mapping users to their groups.}

\item{DataSourceId}{The identifier of the data source to check the processing of \code{PUT} and
\code{DELETE} actions for mapping users to their groups.}

\item{GroupId}{[required] The identifier of the group required to check the processing of \code{PUT}
and \code{DELETE} actions for mapping users to their groups.}
}
\description{
Describes the processing of \code{PUT} and \code{DELETE} actions for mapping users to their groups. This includes information on the status of actions currently processing or yet to be processed, when actions were last updated, when actions were received by Amazon Kendra, the latest action that should process and apply after other actions, and useful error messages if an action could not be processed.

See \url{https://www.paws-r-sdk.com/docs/kendra_describe_principal_mapping/} for full documentation.
}
\keyword{internal}
