% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/entityresolution_operations.R
\name{entityresolution_update_matching_workflow}
\alias{entityresolution_update_matching_workflow}
\title{Updates an existing MatchingWorkflow}
\usage{
entityresolution_update_matching_workflow(
  description = NULL,
  incrementalRunConfig = NULL,
  inputSourceConfig,
  outputSourceConfig,
  resolutionTechniques,
  roleArn,
  workflowName
)
}
\arguments{
\item{description}{A description of the workflow.}

\item{incrementalRunConfig}{An object which defines an incremental run type and has only
\code{incrementalRunType} as a field.}

\item{inputSourceConfig}{[required] A list of \code{InputSource} objects, which have the fields \code{InputSourceARN}
and \code{SchemaName}.}

\item{outputSourceConfig}{[required] A list of \code{OutputSource} objects, each of which contains fields
\code{OutputS3Path}, \code{ApplyNormalization}, and \code{Output}.}

\item{resolutionTechniques}{[required] An object which defines the \code{resolutionType} and the
\code{ruleBasedProperties}.}

\item{roleArn}{[required] The Amazon Resource Name (ARN) of the IAM role. Entity Resolution
assumes this role to create resources on your behalf as part of workflow
execution.}

\item{workflowName}{[required] The name of the workflow to be retrieved.}
}
\description{
Updates an existing \code{MatchingWorkflow}. This method is identical to \code{\link[=entityresolution_create_matching_workflow]{create_matching_workflow}}, except it uses an HTTP \code{PUT} request instead of a \code{POST} request, and the \code{MatchingWorkflow} must already exist for the method to succeed.

See \url{https://www.paws-r-sdk.com/docs/entityresolution_update_matching_workflow/} for full documentation.
}
\keyword{internal}
