% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/athena_operations.R
\name{athena_start_session}
\alias{athena_start_session}
\title{Creates a session for running calculations within a workgroup}
\usage{
athena_start_session(
  Description = NULL,
  WorkGroup,
  EngineConfiguration,
  NotebookVersion = NULL,
  SessionIdleTimeoutInMinutes = NULL,
  ClientRequestToken = NULL
)
}
\arguments{
\item{Description}{The session description.}

\item{WorkGroup}{[required] The workgroup to which the session belongs.}

\item{EngineConfiguration}{[required] Contains engine data processing unit (DPU) configuration settings and
parameter mappings.}

\item{NotebookVersion}{The notebook version. This value is supplied automatically for notebook
sessions in the Athena console and is not required for programmatic
session access. The only valid notebook version is
\verb{Athena notebook version 1}. If you specify a value for
\code{NotebookVersion}, you must also specify a value for \code{NotebookId}. See
EngineConfiguration$AdditionalConfigs.}

\item{SessionIdleTimeoutInMinutes}{The idle timeout in minutes for the session.}

\item{ClientRequestToken}{A unique case-sensitive string used to ensure the request to create the
session is idempotent (executes only once). If another
\code{StartSessionRequest} is received, the same response is returned and
another session is not created. If a parameter has changed, an error is
returned.

This token is listed as not required because Amazon Web Services SDKs
(for example the Amazon Web Services SDK for Java) auto-generate the
token for users. If you are not using the Amazon Web Services SDK or the
Amazon Web Services CLI, you must provide this token or the action will
fail.}
}
\description{
Creates a session for running calculations within a workgroup. The session is ready when it reaches an \code{IDLE} state.

See \url{https://www.paws-r-sdk.com/docs/athena_start_session/} for full documentation.
}
\keyword{internal}
