% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinesisanalyticsv2_operations.R
\name{kinesisanalyticsv2_delete_application_vpc_configuration}
\alias{kinesisanalyticsv2_delete_application_vpc_configuration}
\title{Removes a VPC configuration from a Kinesis Data Analytics application}
\usage{
kinesisanalyticsv2_delete_application_vpc_configuration(
  ApplicationName,
  CurrentApplicationVersionId = NULL,
  VpcConfigurationId,
  ConditionalToken = NULL
)
}
\arguments{
\item{ApplicationName}{[required] The name of an existing application.}

\item{CurrentApplicationVersionId}{The current application version ID. You must provide the
\code{CurrentApplicationVersionId} or the \code{ConditionalToken}. You can
retrieve the application version ID using
\code{\link[=kinesisanalyticsv2_describe_application]{describe_application}}. For
better concurrency support, use the \code{ConditionalToken} parameter instead
of \code{CurrentApplicationVersionId}.}

\item{VpcConfigurationId}{[required] The ID of the VPC configuration to delete.}

\item{ConditionalToken}{A value you use to implement strong concurrency for application updates.
You must provide the \code{CurrentApplicationVersionId} or the
\code{ConditionalToken}. You get the application's current \code{ConditionalToken}
using \code{\link[=kinesisanalyticsv2_describe_application]{describe_application}}.
For better concurrency support, use the \code{ConditionalToken} parameter
instead of \code{CurrentApplicationVersionId}.}
}
\description{
Removes a VPC configuration from a Kinesis Data Analytics application.

See \url{https://www.paws-r-sdk.com/docs/kinesisanalyticsv2_delete_application_vpc_configuration/} for full documentation.
}
\keyword{internal}
