% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datazone_operations.R
\name{datazone_list_data_source_runs}
\alias{datazone_list_data_source_runs}
\title{Lists data source runs in Amazon DataZone}
\usage{
datazone_list_data_source_runs(
  dataSourceIdentifier,
  domainIdentifier,
  maxResults = NULL,
  nextToken = NULL,
  status = NULL
)
}
\arguments{
\item{dataSourceIdentifier}{[required] The identifier of the data source.}

\item{domainIdentifier}{[required] The identifier of the Amazon DataZone domain in which to invoke the
\code{\link[=datazone_list_data_source_runs]{list_data_source_runs}} action.}

\item{maxResults}{The maximum number of runs to return in a single call to
\code{\link[=datazone_list_data_source_runs]{list_data_source_runs}}. When the
number of runs to be listed is greater than the value of \code{MaxResults},
the response contains a \code{NextToken} value that you can use in a
subsequent call to
\code{\link[=datazone_list_data_source_runs]{list_data_source_runs}} to list the
next set of runs.}

\item{nextToken}{When the number of runs is greater than the default value for the
\code{MaxResults} parameter, or if you explicitly specify a value for
\code{MaxResults} that is less than the number of runs, the response includes
a pagination token named \code{NextToken}. You can specify this \code{NextToken}
value in a subsequent call to
\code{\link[=datazone_list_data_source_runs]{list_data_source_runs}} to list the
next set of runs.}

\item{status}{The status of the data source.}
}
\description{
Lists data source runs in Amazon DataZone.

See \url{https://www.paws-r-sdk.com/docs/datazone_list_data_source_runs/} for full documentation.
}
\keyword{internal}
