# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include healthlake_service.R
NULL

#' Creates a Data Store that can ingest and export FHIR formatted data
#'
#' @description
#' Creates a Data Store that can ingest and export FHIR formatted data.
#'
#' See [https://www.paws-r-sdk.com/docs/healthlake_create_fhir_datastore/](https://www.paws-r-sdk.com/docs/healthlake_create_fhir_datastore/) for full documentation.
#'
#' @param DatastoreName The user generated name for the Data Store.
#' @param DatastoreTypeVersion &#91;required&#93; The FHIR version of the Data Store. The only supported version is R4.
#' @param SseConfiguration The server-side encryption key configuration for a customer provided
#' encryption key specified for creating a Data Store.
#' @param PreloadDataConfig Optional parameter to preload data upon creation of the Data Store.
#' Currently, the only supported preloaded data is synthetic data generated
#' from Synthea.
#' @param ClientToken Optional user provided token used for ensuring idempotency.
#' @param Tags Resource tags that are applied to a Data Store when it is created.
#' @param IdentityProviderConfiguration The configuration of the identity provider that you want to use for your
#' Data Store.
#'
#' @keywords internal
#'
#' @rdname healthlake_create_fhir_datastore
healthlake_create_fhir_datastore <- function(DatastoreName = NULL, DatastoreTypeVersion, SseConfiguration = NULL, PreloadDataConfig = NULL, ClientToken = NULL, Tags = NULL, IdentityProviderConfiguration = NULL) {
  op <- new_operation(
    name = "CreateFHIRDatastore",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .healthlake$create_fhir_datastore_input(DatastoreName = DatastoreName, DatastoreTypeVersion = DatastoreTypeVersion, SseConfiguration = SseConfiguration, PreloadDataConfig = PreloadDataConfig, ClientToken = ClientToken, Tags = Tags, IdentityProviderConfiguration = IdentityProviderConfiguration)
  output <- .healthlake$create_fhir_datastore_output()
  config <- get_config()
  svc <- .healthlake$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.healthlake$operations$create_fhir_datastore <- healthlake_create_fhir_datastore

#' Deletes a Data Store
#'
#' @description
#' Deletes a Data Store.
#'
#' See [https://www.paws-r-sdk.com/docs/healthlake_delete_fhir_datastore/](https://www.paws-r-sdk.com/docs/healthlake_delete_fhir_datastore/) for full documentation.
#'
#' @param DatastoreId &#91;required&#93; The AWS-generated ID for the Data Store to be deleted.
#'
#' @keywords internal
#'
#' @rdname healthlake_delete_fhir_datastore
healthlake_delete_fhir_datastore <- function(DatastoreId) {
  op <- new_operation(
    name = "DeleteFHIRDatastore",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .healthlake$delete_fhir_datastore_input(DatastoreId = DatastoreId)
  output <- .healthlake$delete_fhir_datastore_output()
  config <- get_config()
  svc <- .healthlake$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.healthlake$operations$delete_fhir_datastore <- healthlake_delete_fhir_datastore

#' Gets the properties associated with the FHIR Data Store, including the
#' Data Store ID, Data Store ARN, Data Store name, Data Store status,
#' created at, Data Store type version, and Data Store endpoint
#'
#' @description
#' Gets the properties associated with the FHIR Data Store, including the Data Store ID, Data Store ARN, Data Store name, Data Store status, created at, Data Store type version, and Data Store endpoint.
#'
#' See [https://www.paws-r-sdk.com/docs/healthlake_describe_fhir_datastore/](https://www.paws-r-sdk.com/docs/healthlake_describe_fhir_datastore/) for full documentation.
#'
#' @param DatastoreId &#91;required&#93; The AWS-generated Data Store ID.
#'
#' @keywords internal
#'
#' @rdname healthlake_describe_fhir_datastore
healthlake_describe_fhir_datastore <- function(DatastoreId) {
  op <- new_operation(
    name = "DescribeFHIRDatastore",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .healthlake$describe_fhir_datastore_input(DatastoreId = DatastoreId)
  output <- .healthlake$describe_fhir_datastore_output()
  config <- get_config()
  svc <- .healthlake$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.healthlake$operations$describe_fhir_datastore <- healthlake_describe_fhir_datastore

#' Displays the properties of a FHIR export job, including the ID, ARN,
#' name, and the status of the job
#'
#' @description
#' Displays the properties of a FHIR export job, including the ID, ARN, name, and the status of the job.
#'
#' See [https://www.paws-r-sdk.com/docs/healthlake_describe_fhir_export_job/](https://www.paws-r-sdk.com/docs/healthlake_describe_fhir_export_job/) for full documentation.
#'
#' @param DatastoreId &#91;required&#93; The AWS generated ID for the Data Store from which files are being
#' exported from for an export job.
#' @param JobId &#91;required&#93; The AWS generated ID for an export job.
#'
#' @keywords internal
#'
#' @rdname healthlake_describe_fhir_export_job
healthlake_describe_fhir_export_job <- function(DatastoreId, JobId) {
  op <- new_operation(
    name = "DescribeFHIRExportJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .healthlake$describe_fhir_export_job_input(DatastoreId = DatastoreId, JobId = JobId)
  output <- .healthlake$describe_fhir_export_job_output()
  config <- get_config()
  svc <- .healthlake$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.healthlake$operations$describe_fhir_export_job <- healthlake_describe_fhir_export_job

#' Displays the properties of a FHIR import job, including the ID, ARN,
#' name, and the status of the job
#'
#' @description
#' Displays the properties of a FHIR import job, including the ID, ARN, name, and the status of the job.
#'
#' See [https://www.paws-r-sdk.com/docs/healthlake_describe_fhir_import_job/](https://www.paws-r-sdk.com/docs/healthlake_describe_fhir_import_job/) for full documentation.
#'
#' @param DatastoreId &#91;required&#93; The AWS-generated ID of the Data Store.
#' @param JobId &#91;required&#93; The AWS-generated job ID.
#'
#' @keywords internal
#'
#' @rdname healthlake_describe_fhir_import_job
healthlake_describe_fhir_import_job <- function(DatastoreId, JobId) {
  op <- new_operation(
    name = "DescribeFHIRImportJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .healthlake$describe_fhir_import_job_input(DatastoreId = DatastoreId, JobId = JobId)
  output <- .healthlake$describe_fhir_import_job_output()
  config <- get_config()
  svc <- .healthlake$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.healthlake$operations$describe_fhir_import_job <- healthlake_describe_fhir_import_job

#' Lists all FHIR Data Stores that are in the user’s account, regardless of
#' Data Store status
#'
#' @description
#' Lists all FHIR Data Stores that are in the user’s account, regardless of Data Store status.
#'
#' See [https://www.paws-r-sdk.com/docs/healthlake_list_fhir_datastores/](https://www.paws-r-sdk.com/docs/healthlake_list_fhir_datastores/) for full documentation.
#'
#' @param Filter Lists all filters associated with a FHIR Data Store request.
#' @param NextToken Fetches the next page of Data Stores when results are paginated.
#' @param MaxResults The maximum number of Data Stores returned in a single page of a
#' ListFHIRDatastoresRequest call.
#'
#' @keywords internal
#'
#' @rdname healthlake_list_fhir_datastores
healthlake_list_fhir_datastores <- function(Filter = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListFHIRDatastores",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .healthlake$list_fhir_datastores_input(Filter = Filter, NextToken = NextToken, MaxResults = MaxResults)
  output <- .healthlake$list_fhir_datastores_output()
  config <- get_config()
  svc <- .healthlake$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.healthlake$operations$list_fhir_datastores <- healthlake_list_fhir_datastores

#' Lists all FHIR export jobs associated with an account and their statuses
#'
#' @description
#' Lists all FHIR export jobs associated with an account and their statuses.
#'
#' See [https://www.paws-r-sdk.com/docs/healthlake_list_fhir_export_jobs/](https://www.paws-r-sdk.com/docs/healthlake_list_fhir_export_jobs/) for full documentation.
#'
#' @param DatastoreId &#91;required&#93; This parameter limits the response to the export job with the specified
#' Data Store ID.
#' @param NextToken A pagination token used to identify the next page of results to return
#' for a ListFHIRExportJobs query.
#' @param MaxResults This parameter limits the number of results returned for a
#' ListFHIRExportJobs to a maximum quantity specified by the user.
#' @param JobName This parameter limits the response to the export job with the specified
#' job name.
#' @param JobStatus This parameter limits the response to the export jobs with the specified
#' job status.
#' @param SubmittedBefore This parameter limits the response to FHIR export jobs submitted before
#' a user specified date.
#' @param SubmittedAfter This parameter limits the response to FHIR export jobs submitted after a
#' user specified date.
#'
#' @keywords internal
#'
#' @rdname healthlake_list_fhir_export_jobs
healthlake_list_fhir_export_jobs <- function(DatastoreId, NextToken = NULL, MaxResults = NULL, JobName = NULL, JobStatus = NULL, SubmittedBefore = NULL, SubmittedAfter = NULL) {
  op <- new_operation(
    name = "ListFHIRExportJobs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .healthlake$list_fhir_export_jobs_input(DatastoreId = DatastoreId, NextToken = NextToken, MaxResults = MaxResults, JobName = JobName, JobStatus = JobStatus, SubmittedBefore = SubmittedBefore, SubmittedAfter = SubmittedAfter)
  output <- .healthlake$list_fhir_export_jobs_output()
  config <- get_config()
  svc <- .healthlake$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.healthlake$operations$list_fhir_export_jobs <- healthlake_list_fhir_export_jobs

#' Lists all FHIR import jobs associated with an account and their statuses
#'
#' @description
#' Lists all FHIR import jobs associated with an account and their statuses.
#'
#' See [https://www.paws-r-sdk.com/docs/healthlake_list_fhir_import_jobs/](https://www.paws-r-sdk.com/docs/healthlake_list_fhir_import_jobs/) for full documentation.
#'
#' @param DatastoreId &#91;required&#93; This parameter limits the response to the import job with the specified
#' Data Store ID.
#' @param NextToken A pagination token used to identify the next page of results to return
#' for a ListFHIRImportJobs query.
#' @param MaxResults This parameter limits the number of results returned for a
#' ListFHIRImportJobs to a maximum quantity specified by the user.
#' @param JobName This parameter limits the response to the import job with the specified
#' job name.
#' @param JobStatus This parameter limits the response to the import job with the specified
#' job status.
#' @param SubmittedBefore This parameter limits the response to FHIR import jobs submitted before
#' a user specified date.
#' @param SubmittedAfter This parameter limits the response to FHIR import jobs submitted after a
#' user specified date.
#'
#' @keywords internal
#'
#' @rdname healthlake_list_fhir_import_jobs
healthlake_list_fhir_import_jobs <- function(DatastoreId, NextToken = NULL, MaxResults = NULL, JobName = NULL, JobStatus = NULL, SubmittedBefore = NULL, SubmittedAfter = NULL) {
  op <- new_operation(
    name = "ListFHIRImportJobs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .healthlake$list_fhir_import_jobs_input(DatastoreId = DatastoreId, NextToken = NextToken, MaxResults = MaxResults, JobName = JobName, JobStatus = JobStatus, SubmittedBefore = SubmittedBefore, SubmittedAfter = SubmittedAfter)
  output <- .healthlake$list_fhir_import_jobs_output()
  config <- get_config()
  svc <- .healthlake$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.healthlake$operations$list_fhir_import_jobs <- healthlake_list_fhir_import_jobs

#' Returns a list of all existing tags associated with a Data Store
#'
#' @description
#' Returns a list of all existing tags associated with a Data Store.
#'
#' See [https://www.paws-r-sdk.com/docs/healthlake_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/healthlake_list_tags_for_resource/) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; The Amazon Resource Name(ARN) of the Data Store for which tags are being
#' added.
#'
#' @keywords internal
#'
#' @rdname healthlake_list_tags_for_resource
healthlake_list_tags_for_resource <- function(ResourceARN) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .healthlake$list_tags_for_resource_input(ResourceARN = ResourceARN)
  output <- .healthlake$list_tags_for_resource_output()
  config <- get_config()
  svc <- .healthlake$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.healthlake$operations$list_tags_for_resource <- healthlake_list_tags_for_resource

#' Begins a FHIR export job
#'
#' @description
#' Begins a FHIR export job.
#'
#' See [https://www.paws-r-sdk.com/docs/healthlake_start_fhir_export_job/](https://www.paws-r-sdk.com/docs/healthlake_start_fhir_export_job/) for full documentation.
#'
#' @param JobName The user generated name for an export job.
#' @param OutputDataConfig &#91;required&#93; The output data configuration that was supplied when the export job was
#' created.
#' @param DatastoreId &#91;required&#93; The AWS generated ID for the Data Store from which files are being
#' exported for an export job.
#' @param DataAccessRoleArn &#91;required&#93; The Amazon Resource Name used during the initiation of the job.
#' @param ClientToken &#91;required&#93; An optional user provided token used for ensuring idempotency.
#'
#' @keywords internal
#'
#' @rdname healthlake_start_fhir_export_job
healthlake_start_fhir_export_job <- function(JobName = NULL, OutputDataConfig, DatastoreId, DataAccessRoleArn, ClientToken) {
  op <- new_operation(
    name = "StartFHIRExportJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .healthlake$start_fhir_export_job_input(JobName = JobName, OutputDataConfig = OutputDataConfig, DatastoreId = DatastoreId, DataAccessRoleArn = DataAccessRoleArn, ClientToken = ClientToken)
  output <- .healthlake$start_fhir_export_job_output()
  config <- get_config()
  svc <- .healthlake$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.healthlake$operations$start_fhir_export_job <- healthlake_start_fhir_export_job

#' Begins a FHIR Import job
#'
#' @description
#' Begins a FHIR Import job.
#'
#' See [https://www.paws-r-sdk.com/docs/healthlake_start_fhir_import_job/](https://www.paws-r-sdk.com/docs/healthlake_start_fhir_import_job/) for full documentation.
#'
#' @param JobName The name of the FHIR Import job in the StartFHIRImport job request.
#' @param InputDataConfig &#91;required&#93; The input properties of the FHIR Import job in the StartFHIRImport job
#' request.
#' @param JobOutputDataConfig &#91;required&#93; 
#' @param DatastoreId &#91;required&#93; The AWS-generated Data Store ID.
#' @param DataAccessRoleArn &#91;required&#93; The Amazon Resource Name (ARN) that gives Amazon HealthLake access
#' permission.
#' @param ClientToken &#91;required&#93; Optional user provided token used for ensuring idempotency.
#'
#' @keywords internal
#'
#' @rdname healthlake_start_fhir_import_job
healthlake_start_fhir_import_job <- function(JobName = NULL, InputDataConfig, JobOutputDataConfig, DatastoreId, DataAccessRoleArn, ClientToken) {
  op <- new_operation(
    name = "StartFHIRImportJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .healthlake$start_fhir_import_job_input(JobName = JobName, InputDataConfig = InputDataConfig, JobOutputDataConfig = JobOutputDataConfig, DatastoreId = DatastoreId, DataAccessRoleArn = DataAccessRoleArn, ClientToken = ClientToken)
  output <- .healthlake$start_fhir_import_job_output()
  config <- get_config()
  svc <- .healthlake$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.healthlake$operations$start_fhir_import_job <- healthlake_start_fhir_import_job

#' Adds a user specified key and value tag to a Data Store
#'
#' @description
#' Adds a user specified key and value tag to a Data Store.
#'
#' See [https://www.paws-r-sdk.com/docs/healthlake_tag_resource/](https://www.paws-r-sdk.com/docs/healthlake_tag_resource/) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; The Amazon Resource Name(ARN)that gives Amazon HealthLake access to the
#' Data Store which tags are being added to.
#' @param Tags &#91;required&#93; The user specified key and value pair tags being added to a Data Store.
#'
#' @keywords internal
#'
#' @rdname healthlake_tag_resource
healthlake_tag_resource <- function(ResourceARN, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .healthlake$tag_resource_input(ResourceARN = ResourceARN, Tags = Tags)
  output <- .healthlake$tag_resource_output()
  config <- get_config()
  svc <- .healthlake$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.healthlake$operations$tag_resource <- healthlake_tag_resource

#' Removes tags from a Data Store
#'
#' @description
#' Removes tags from a Data Store.
#'
#' See [https://www.paws-r-sdk.com/docs/healthlake_untag_resource/](https://www.paws-r-sdk.com/docs/healthlake_untag_resource/) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; "The Amazon Resource Name(ARN) of the Data Store for which tags are
#' being removed
#' @param TagKeys &#91;required&#93; The keys for the tags to be removed from the Healthlake Data Store.
#'
#' @keywords internal
#'
#' @rdname healthlake_untag_resource
healthlake_untag_resource <- function(ResourceARN, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .healthlake$untag_resource_input(ResourceARN = ResourceARN, TagKeys = TagKeys)
  output <- .healthlake$untag_resource_output()
  config <- get_config()
  svc <- .healthlake$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.healthlake$operations$untag_resource <- healthlake_untag_resource
